<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once( 'class.HTMLElement.php' );
include_once( 'class.FormElement.php' );
include_once( 'class.InputHiddenElement.php' );
include_once( 'class.CompoundElement.php' );
include_once( 'class.OneLineTableElement.php' );
include_once( 'class.ButtonURLElement.php' );
include_once( 'class.AElement.php' );
include_once( 'class.TRElement.php' );
include_once( 'class.SelectElement.php' );
include_once( 'class.OptionElement.php' );


class PagedFormElement extends FormElement {

	var $moBodyElement;
	var $moSearchElement;
	var $moStepsElement;
	var $moPrevNextElement;
	var $moInfoElement;
	var $moGroupActionElement;

	var $maParameters;
	var $maSteps;
	var $miFormIndex;

	function PagedFormElement( $paFormAttributes, $poBodyElement = NULL,
	$paParams=NULL,  $poSearchElement = NULL, $paTableAttributes= array() ) {

		global $DEBUG;
		global $confixx_interface_version;

		/*
		if($DEBUG){
		echo "PagedFormElement::PagedFormElement confixx_interface_version: $confixx_interface_version<br><pre>\n";
		print_r(func_get_args());
		echo "</pre><hr>\n";
		}
		*/

		$this->moBodyElement = NULL;
		$this->moSearchElement = NULL;
		$this->moGroupActionElement = NULL;

		$this->maParameters = array( 'start_index' => 0,
		'page_size' => 0,
		'total_number' => 0,
		'action' => '' );
		$this->maHiddens = array();

		$this->FormElement( $paFormAttributes ); ## call parent constructor

		$this->setBodyElement( $this->makeBodyElement( $poBodyElement ) );

		if( is_object( $paParams ) ) {
			$poSearchElement = $paParams;
			$paParams = NULL;
		}

		$this->setSearchElement( $poSearchElement );
		$this->Steps( array( 5=>'5', 10=>'10', 25=>'25', 50=>'50' ) );

		$this->initParameters( $paParams );

		$this->setStepsElement( $this->makeStepsElement() );
		$this->setInfoElement( $this->makeInfoElement() );

		if( $confixx_interface_version == 'powp' ) {
			$this->setPrevNextElement( $this->makePageNavigationElement() );

		} else {
			$this->setPrevNextElement( $this->makePrevNextElement() );
		}

		$this->updateContent( $paTableAttributes );
		$this->miFormIndex = 0;
	}

	/*
	*   Properties
	*/

	function &FormIndex( $piFormIndex = NULL ){
		if( !is_null( $piFormIndex ) ) {
			$this->miFormIndex = $piFormIndex;
			$this->updateContent();
		}
		return $this->miFormIndex;
	}

	function &Parameters( $paParams = NULL ) {
		if( is_array( $paParams ) ) {
			foreach( array( 'start_index', 'page_size', 'total_number', 'action' ) as $lcKey ) {
				if( !array_key_exists( $lcKey, $paParams ) ) {
					$paParams[$lcKey] = $this->maParameters[$lcKey];
				}
			}
			$this->maParameters = $paParams;
		}
		return $this->maParameters;
	}

	function Parameter( $lcKey, $luValue = NULL ) {
		global $DEBUG;
		if( !is_null( $luValue ) ) {
			$this->maParameters[$lcKey] = $luValue;
		}

		return $this->maParameters[$lcKey];
	}

	function &Steps( $paSteps = NULL ) {
		if( is_array( $paSteps ) ) {
			$this->maSteps = $paSteps;
		}
		return $this->maSteps;
	}

	function &StepsElement( $poStepsElement = NULL ) {
		if( is_object( $poStepsElement ) ) {
			$this->moStepsElement = $poStepsElement;
			$this->updateContent();
		}
		return $this->moStepsElement;
	}

	function &BodyElement( $poBodyElement = NULL ) {
		if( is_object( $poBodyElement ) ) {
			$this->moBodyElement = $poBodyElement;
			$this->updateContent();
		}
		return $this->moBodyElement;
	}


	function &PrevNextElement( $poPrevNextElement = NULL ){
		if( is_object( $poPrevNextElement ) ) {
			$this->moPrevNextElement = $poPrevNextElement;
			$this->updateContent();
		}
		return $this->moPrevNextElement;
	}

	function &SearchElement( $poSearchElement = NULL ) {
		global $DEBUG;

		if( is_object( $poSearchElement ) ) {
			$this->moSearchElement = $poSearchElement;
			$this->updateContent();
		}
		return $this->moSearchElement;
	}

	function &GroupActionElement( $poElement = NULL ) {
		global $DEBUG;

		if( is_object( $poElement ) ) {
			$this->moGroupActionElement = $poElement;
			$this->updateContent();
		}
		return $this->moGroupActionElement;
	}

	function &InfoElement( $loInfoElement = NULL){
		if( is_object( $loInfoElement ) ) {
			$this->moInfoElement = $poInfoElement;
			$this->updateContent();
		}
		return $this->moInfoElement;
	}

	/*
	*    end properties
	*/


	/*
	* set/get methods
	*/

	function &setPrevNextElement( &$poPrevNextElement ){
		if( !is_null( $poPrevNextElement ) ) {
			$this->moPrevNextElement =& $poPrevNextElement;
		}
		return $this->moPrevNextElement;
	}

	function &setGroupActionElement( &$poElement  ) {
		global $DEBUG;

		if( is_object( $poElement ) ) {
			$this->moGroupActionElement = $poElement;
		}

		return $this->moGroupActionElement;
	}


	function &setBodyElement( &$poBodyElement ){
		if( !is_null( $poBodyElement ) ) {
			$this->moBodyElement =& $poBodyElement;
			$this->updateContent();
		}
		return $this->moBodyElement;
	}

	function &setSearchElement( &$poSearchElement ){
		if( !is_null( $poSearchElement ) ) {
			$this->moSearchElement =& $poSearchElement;
		}
		return $this->moSearchElement;
	}

	function &setStepsElement( &$poStepsElement ){
		if( !is_null( $poStepsElement ) ) {
			$this->moStepsElement =& $poStepsElement;
		}
		return $this->moStepsElement;
	}

	function &setInfoElement( &$poInfoElement ){
		if( !is_null( $poInfoElement ) ) {
			$this->moInfoElement =& $poInfoElement;
		}
		return $this->moInfoElement;
	}


	function getStep( $paSteps = NULL){
		if( !is_array( $paSteps ) ) {
			$paSteps =& $this->Steps();
		}
		$liStep = $this->maParameters['page_size'];
		if(array_key_exists( $liStep, $paSteps ) ) {
			return $liStep;
		} else {
			$liMin = 0;
			foreach( array_keys( $paSteps ) as $liKey ) {
				if( $liMin < $liKey ) {
					$liMin = $liKey;
				}
				if ( $liKey >= $liStep) {
					return  $liKey;
				}
			}
			return $liMin;
		}
	}

	/*
	* end set/get methods
	*/


	function &appendToParameters ( &$paParams ) {
		if( is_array( $paParams ) ) {
			$this->maParameters = array_merge( $this->maParameters, $paParams );
		}
		return $this->maParameters;
	}


	function initParameters( $paParams = NULL ){
		if(!is_array($paParams)){
			$paParams =& $_GLOBAL;
		}
		foreach( array_keys($this->maParameters) as $lcKey ) {
			if( array_key_exists( $lcKey, $paParams ) ) {
				$this->maParameters[$lcKey] = $paParams[$lcKey];
			}
		}
	}


	/*
	*  make-methods
	*/

	function &makeStepsElement( $paSteps = NULL ){
		if( !is_array( $paSteps ) ){
			$paSteps =& $this->Steps();
		}
		$loStepsElement = new CompoundElement();
		$loStepsElement->SetSeparator('&nbsp;&nbsp;');
		$loStepsElement->AppendToContent( new HTMLElement( ltext( 'll_perpage' ) ) );
		$liCurrentStep = $this->getStep( $paSteps );

		$laSteps = array_keys($paSteps);
		sort( $laSteps, SORT_NUMERIC );

		if( $laSteps[0] >= $this->Parameter('total_number') ) {
			$this->Parameter( 'page_size', $laSteps[0] );
			$loStepsElement = NULL;

		} else {

			$this->Parameter( 'page_size', $liCurrentStep ); /* save new value of the page size*/

			$liFormIndex =& $this->FormIndex();

			foreach ( $paSteps as $liStep => $lcLabel ) {
				if( $liCurrentStep == $liStep ){
					$loStepsElement->AppendToContent( new HTMLElement($lcLabel) );
				} else {
					$loLink = new AElement( array( 'href' => $liFormIndex ?
					"javascript:setValue('start_index',1);submitForm( 'page_size', $liStep, $liFormIndex )" :
					"javascript:setValue('start_index',1);submitForm( 'page_size', $liStep )" ),
					new HTMLElement($lcLabel));
					$loStepsElement->AppendToContent( $loLink );
				}
			}
		}
		return $loStepsElement;
	}

	function &makePageNavigationElement( $paSteps = NULL, $paParams = NULL ) {

		global $DEBUG;
		/*
		if($DEBUG){
		echo "PagedFormElement::makePageNavigationElement<br>\n";
		}
		*/
		if( !is_array( $paSteps ) ){
			$paSteps =& $this->Steps();
		}
		if( !is_array( $paParams ) ){
			$paParams =& $this->Parameters();
		}
		$liCurrentStep = $this->getStep( $paSteps );

		$this->Parameter( 'page_size', $liCurrentStep ); /* save new value of the page size*/

		$laPages = array();
		$liTotalPage = 0;
		$liCurrPage = 0;
		for( $liStart = 1; $liStart <= $paParams['total_number']; $liStart += $liCurrentStep ) {
			$liTotalPage++;
			$liStop = $liStart + $liCurrentStep - 1;

			$laPages[$liTotalPage] = $liStart;
			if ( ( $liStart <= $paParams['start_index'] ) && ( $paParams['start_index'] <= $liStop ) ) {
				$liCurrPage = $liTotalPage;
			}
		}
		/*
		if($DEBUG){
		echo "PagedFormElement::makePageNavigationElement: liCurrPage: $liCurrPage<br><pre>\n";
		print_r( $laPages);
		echo "</pre><hr>\n";
		}
		*/
		$liFormIndex =& $this->FormIndex();
		if( $liTotalPage > 1 ) {
			$loPrevNextElement = new CompoundElement();
			$loPrevNextElement->SetSeparator('&nbsp;&nbsp;');
			$loPrevNextElement->AppendToContent( new HTMLElement( ltext( 'll_pages' ) ) );

			if ( $liCurrPage > 1 ) {
				$liNewStart = $laPages[1];
				$loLink = new AElement( array( 'href' => $liFormIndex ?
				"javascript:submitForm( 'start_index', $liNewStart, $liFormIndex )" :
				"javascript:submitForm( 'start_index', $liNewStart )" ),
				new HTMLElement( ltext('ll_first_page' ) ) );
				$loPrevNextElement->AppendToContent( $loLink );

				$liNewStart = $laPages[$liCurrPage - 1];

				$loLink = new AElement( array( 'href' => $liFormIndex ?
				"javascript:submitForm( 'start_index', $liNewStart, $liFormIndex )":
				"javascript:submitForm( 'start_index', $liNewStart )",
				'title' => ltext('ll_prev') ),
				new HTMLElement( '&lt;&lt;' ) );
				$loPrevNextElement->AppendToContent( $loLink );
			}

			$liStartPage = $liCurrPage - 3;
			$liStopPage =  $liCurrPage + 3;

			if($liStartPage < 1){
				$liStopPage += ( 1 - $liStartPage );
				$liStartPage = 1;
			}
			if( $liStopPage > $liTotalPage ){
				$liStartPage -= ( $liStopPage - $liTotalPage );
				$liStopPage = $liTotalPage;
				if($liStartPage < 1){
					$liStartPage = 1;
				}
			}

			for( $i = $liStartPage; $i <= $liStopPage; $i++ ){

				if( $i == $liCurrPage ){
					$loLink = new HTMLElement( $i );

				} else {
					$liNewStart = $laPages[$i];

					$loLink = new AElement( array( 'href' => $liFormIndex ?
					"javascript:submitForm( 'start_index', $liNewStart, $liFormIndex )" :
					"javascript:submitForm( 'start_index', $liNewStart )" ),
					new HTMLElement( $i ) );
				}
				$loPrevNextElement->AppendToContent( $loLink );

			}

			if ( $liCurrPage < $liTotalPage ) {
				$liNewStart = $laPages[$liCurrPage + 1];

				$loLink = new AElement( array( 'href' => $liFormIndex ?
				"javascript:submitForm( 'start_index', $liNewStart, $liFormIndex )" :
				"javascript:submitForm( 'start_index', $liNewStart )",
				'title' => ltext('ll_next') ),
				new HTMLElement( '&gt;&gt;' ) );
				$loPrevNextElement->AppendToContent( $loLink );

				$liNewStart = $laPages[$liTotalPage];
				$loLink = new AElement( array( 'href' => $liFormIndex ?
				"javascript:submitForm( 'start_index', $liNewStart, $liFormIndex )" :
				"javascript:submitForm( 'start_index', $liNewStart )" ),
				new HTMLElement( ltext('ll_last_page' ) ) );
				$loPrevNextElement->AppendToContent( $loLink );
			}

		} else{
			$loPrevNextElement = new HtMLElement( '' );

		}

		/*
		if($DEBUG){
		echo "PagedFormElement::makePageNavigationElement<br><pre>\n";
		print_r($loPrevNextElement);
		echo "</pre><hr>\n";
		}
		*/
		return $loPrevNextElement;
	}

	function &makePrevNextElement( $paSteps = NULL, $paParams = NULL ) {
		global $DEBUG;

		if( !is_array( $paSteps ) ){
			$paSteps =& $this->Steps();
		}
		if( !is_array( $paParams ) ){
			$paParams =& $this->Parameters();
		}
		$liCurrentStep = $this->getStep( $paSteps );

		$this->Parameter( 'page_size', $liCurrentStep ); /* save new value of the page size*/

		$laArguments = array();

		$loPrevNextTable = new TableElement( $laArguments );
		$loRow =& $loPrevNextTable->AppendRow( $laArguments );

		$liFormIndex =& $this->FormIndex();
		if ( $paParams['start_index'] > 1) {
			$liNewStart = $paParams['start_index'] - $liCurrentStep;
			if( $liNewStart < 1 ) {
				$liNewStart = 1;
			}
			$loRow->AppendCell( $laArguments, '', new ButtonURLElement( '&lt;&lt;',
			$liFormIndex?
			"javascript:submitForm('start_index',$liNewStart, $liFormIndex)":
			"javascript:submitForm('start_index',$liNewStart)"));
		}

		$liNewStart = $paParams['start_index'] + $liCurrentStep;
		if( $liNewStart <= $paParams['total_number'] ) {
			$loRow->AppendCell( $laArguments, '', new ButtonURLElement( '&gt;&gt;',
			$liFormIndex?
			"javascript:submitForm('start_index',$liNewStart,$liFormIndex)":
			"javascript:submitForm('start_index',$liNewStart)"));
		}

//		if( $loRow->CountContent() > 0) {
		if( ( $paParams['total_number'] - $liCurrentStep) > 0) {
			$loSel = new SelectElement( array('onChange' => $liFormIndex?
			"javascript:submitForm( 'start_index', this.value, $liFormIndex)":
			"javascript:submitForm( 'start_index', this.value)"));
			for( $i=0; $i<$paParams['total_number']; $i += $liCurrentStep ) {
				$liStart = $i + 1;
				$liStop = $i + $liCurrentStep;
				if( $liStop > $paParams['total_number'] ){
					$liStop = $paParams['total_number'];
				}
				$lsPrompt = sprintf("%4d - %4d",$liStart,$liStop );
				$lsPrompt = str_replace(' ','&nbsp;',$lsPrompt );
				$laAttrs = array( 'value' => $liStart);
				if ( ( $liStart <= $paParams['start_index'] ) && ( $paParams['start_index'] <= $liStop ) ) {
					$laAttrs['selected'] = NULL;
				}

				$loSel->AppendToContent( new OptionElement( $laAttrs, $lsPrompt ) );
			}
			$loRow->AppendCell( $laArguments, '', $loSel);
		}

		return $loPrevNextTable;
	}

	function &makeBodyElement( $poSrc = NULL ){
		if( is_object( $poSrc ) ) {
			return $poSrc;
		} else {
			return new TableElement( array( 'class' => 'PagedInfoTable', 'width' => '100%' ) );
		}
	}


	function &makeInfoElement( $paParams = NULL ){
		if( !is_array( $paParams ) ){
			$paParams =& $this->Parameters();
		}
		$start_index = $paParams['start_index'];
		$total_number = $paParams['total_number'];
		$stop_index = $start_index +  $paParams['page_size'] - 1;
		if( $stop_index > $total_number ){
			$stop_index = $total_number;
		}

		return new HTMLElement( ltext('ll_total',array($start_index,$stop_index,$total_number)) );
	}

	/*
	*  end make-methods
	*/

	function updateContent( $paTableAttributes = NULL ) {
		global $confixx_interface_version;
		global $DEBUG;

		/*
		if($DEBUG){
		echo "PagedFormElement::updateContent: confixx_interface_version: $confixx_interface_version<br>\n";
		}
		*/
		if( $confixx_interface_version == 'powp' ) {
			$this->updatePowpContent( $paTableAttributes );

		} else {
			$this->updateSimpleContent( $paTableAttributes );
		}
	}

	function updateSimpleContent( $paTableAttributes = NULL ) {

		global $DEBUG;

		if(is_array($paTableAttributes)){
			if(!array_key_exists('class',$paTableAttributes)){
				$paTableAttributes['class'] = 'FormatPagedTable';
			}
		}else{
			$paTableAttributes = array( 'class' => 'FormatPagedTable');
		}

		$laEmptyAttr = array();

		$this->ClearContent();

		$loTable = new TableElement( $paTableAttributes );


		$loObj =& $this->SearchElement();
		if( is_object( $loObj ) ) {
			$loRow =& $loTable->AppendRow( $laEmptyAttr );
			$loRow->AppendCell( array( 'align' => 'left', 'colspan'=>2), '', $loObj );
		}


		$loObj =& $this->StepsElement();
		if( is_object( $loObj ) ) {
			$loRow =& $loTable->AppendRow( $laEmptyAttr );
			$loRow->AppendCell( array( 'align' => 'right','colspan'=>2), '', $loObj );
		}

		$loRow =& $loTable->AppendRow( $laEmptyAttr );
		$loCell =& $loRow->AppendCell(  array('colspan'=>2), '', $this->BodyElement() );

		$loObj =& $this->PrevNextElement();
		$loGroupObj =& $this->GroupActionElement();
		if( is_object( $loObj ) || is_object( $loGroupObj )) {
			$loRow =& $loTable->AppendRow( $laEmptyAttr );
			if( is_object( $loObj ) ) {
				$loRow->AppendCell( array( 'align' => 'left'), '', $loObj );
			}else{
				$loRow->AppendCell( $laEmptyAttr, '', '' );
			}

			if( is_object( $loGroupObj ) ) {
				$loRow->AppendCell( array( 'align' => 'right'), '', $loGroupObj );
			}else{
				$loRow->AppendCell( $laEmptyAttr, '', '' );
			}
		}

		$this->AppendToContent( $loTable );

		foreach ( $this->Parameters() as $lcKey => $lcValue ) {
			$this->AppendToContent( new InputHiddenElement( array( 'name' => $lcKey, 'value'=> $lcValue, 'id' => $lcKey ) ) );
		}
	}

	function updatePowpContent( $paTableAttributes = NULL ) {

		global $DEBUG;

		if(!is_array($paTableAttributes)){
			$paTableAttributes = array( 'class' => 'PagedTable', 'width' => '100%');
		}

		$laEmptyAttr = array();

		$this->ClearContent();

		$loTable = new TableElement( $paTableAttributes );

		$loSearcObj =& $this->SearchElement();
		$loGroupObj =& $this->GroupActionElement();

		/*
		echo "PagedFormElement::updatePowpContent<br><pre>\n";
		print_r($loGroupObj);
		echo "</pre><hr>\n";
		*/

		if( is_object( $loSearcObj ) || is_object($loGroupObj) ) {

			$loRow =& $loTable->AppendRow( $laEmptyAttr );

			if(is_object($loSearcObj)){
				if(is_object($loGroupObj)){
					$loToolsTable = new TableElement(array('width'=>'100%'));
					$loToolsRow =& $loToolsTable->AppendRow( $laEmptyAttr );
					$loToolsRow->AppendCell( array( 'align' => 'left' ), '', $loSearcObj );
					$loToolsRow->AppendCell( array( 'align' => 'right' ), '', $loGroupObj );

					/*
					echo "<br><pre>\n";
					print_r( $loToolsRow );
					echo "</pre><hr>\n";
					*/

					$loRow->AppendCell( array(  'align' => 'left', 'colspan' => 3 ), '', $loToolsTable );

				} else {
					$loRow->AppendCell( array( 'align' => 'left', 'colspan' => 3 ), '', $loSearcObj );
				}
			} else {
				$loRow->AppendCell( array( 'align' => 'right', 'colspan' => 3 ), '', $loGroupObj );
			}
		}

		$loControlRow = new TRElement( array( 'class' => 'PagingControl' ) );
		$loCell =& $loControlRow->AppendCell( array('align' => 'left' ) );
		$loObj =& $this->InfoElement();

		if( is_object( $loObj )&& $this->maParameters['total_number']>0 ) {
			$loCell->AppendToContent( $loObj );
		}

		$loCell =& $loControlRow->AppendCell( array( 'align' => 'center' ) );
		$loObj =& $this->PrevNextElement();
		if( is_object( $loObj ) ) {
			$loCell->AppendToContent( $loObj );
		}

		$loCell =& $loControlRow->AppendCell( array( 'align' => 'right' ) );
		$loObj =& $this->StepsElement();
		if( is_object( $loObj ) ) {
			$loCell->AppendToContent( $loObj );
		}

		/*
		if($DEBUG){
		echo "PagedFormElement::updatePowpContent<br><pre>\n";
		print_r($loControlRow);
		echo "</pre><hr>\n";
		}
		*/

		$loTable->AppendToContent( $loControlRow ); // top control

		$loRow =& $loTable->AppendRow( $laEmptyAttr );
		$loCell =& $loRow->AppendCell(  array( 'colspan' => 3 ), '', $this->BodyElement() );

		$loTable->AppendToContent( $loControlRow ); // bottom control


		$this->AppendToContent( $loTable );

		foreach ( $this->Parameters() as $lcKey => $lcValue ) {
			$this->AppendToContent( new InputHiddenElement( array( 'name' => $lcKey, 'value'=> $lcValue, 'id' => $lcKey ) ) );
		}
	}


}
?>