<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/class.AElement.php" );
include_once( dirname(__FILE__) . "/class.TextElement.php" );
include_once( dirname(__FILE__) . "/class.HTMLElement.php" );
include_once( dirname(__FILE__) . "/class.PElement.php" );





class PathElement extends CompoundElement {

	/* -------------------- Constructor -------------------- */
	function PathElement( $ps_URL, $ps_Parameter, $ps_Path ) {
		$this->CompoundElement();
		if( $ps_Path=="" )
			return;
		$this->CompoundElement( ltext("current_path") );
		if( $ps_Path == "/" )
			$this->AppendToContent( new TextElement("/") );
		else {
			$ls_Path = "";
			$la_Save = $la_Directories = explode( "/", $ps_Path );
			array_pop( $la_Directories );
			array_shift( $la_Directories );
			$this->AppendToContent( new AElement( array( "href"=>$ps_URL."?".urlencode($ps_Parameter)."=/" ), "/" ),
					new HTMLElement("&nbsp;") );
			$ls_NeedSeparator = FALSE;
			foreach( $la_Directories as $ls_Directory ) {
				if( $ls_NeedSeparator )
					$this->AppendToContent( new HTMLElement("&nbsp;/&nbsp;") );
				$ls_NeedSeparator = TRUE;
				$ls_Path .= "/" . $ls_Directory;
				$this->AppendToContent( new AElement( array( "href"=>$ps_URL."?".urlencode($ps_Parameter)."=".
								urlencode($ls_Path) ), new TextElement($ls_Directory) ) );
			}
			if( $ls_NeedSeparator )
				$this->AppendToContent( new HTMLElement("&nbsp;/&nbsp;") );
			$this->AppendToContent( new TextElement(array_pop($la_Save)) );
		}
		$this->AppendToContent( new PElement( array() ) );
	}
	/* -------------------- end Constructor -------------------- */

}
?>
