<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once('class.TableElement.php');

class SimpleSearchElement extends TableElement {

	var $moRow;

	function SimpleSearchElement( $paAttrs ) {
		global $confixx_interface_version;
		global $DEBUG;
		if( !array_key_exists( 'class',  $paAttrs ) ){
			if( $confixx_interface_version == 'powp' ) {
				$paAttrs['class'] = 'buttons';
			} else {
				$paAttrs['class'] = 'formArea';
			}
		}
		$this->TableElement( $paAttrs );

		$laParams = array();


		$this->moRow =& $this->AppendRow( $laParams );

		$laArgunets = func_get_args();
		array_shift( $laArgunets ); /* first argument is already prepared */
		foreach ( $laArgunets as $loCell ) {
			$this->moRow->AppendCell( $laParams, NULL, $loCell );
		}
	}

	function appendCell( $paAttributes, $loCell = NULL ){
		if ( !is_array( $paAttributes ) ) {
			if( is_object( $paAttributes ) ) {
				$loCell = $paAttributes;
			}
			$paAttributes = array();
		}
		$this->moRow->AppendCell( $paAttributes, NULL, $loCell );
	}

	function appendElement( $loCell ){
		$this->appendCell( array(), $loCell );
	}


	function setDataSource( &$loDS, $laParams = array() ){
		global $DEBUG;
		if ( !is_a( $loDS, 'CompoundValue')){
			if( $DEBUG ){
				echo "SimpleSearchElement::setDataSource : wrong type of argument (should be 'CompondValue')<br>\n";
			}
			return FALSE;
		}

		/*
		echo "SimpleSearchElement::setDataSource <br><pre>\n";
		print_r($loDS);
		echo "</pre><hr><pre>\n";
		print_r($laParams);
		echo "</pre><hr>\n";
		*/

		$liCount = $this->moRow->CountContent();
		$loIter = $loDS->getFirstIterator();

		for ( $i=0; $i<$liCount; $i++){
			$loDataItem =& $loIter->getNext();
			if ( $loDataItem ) {
				$loTDElement =& $this->moRow->GetContent($i);
				$loElement =& $loTDElement->GetContent(0);

				if( is_a( $loElement, 'ButtonURLElement' ) ){
					$loElement->SetLabel( $loDataItem->Value() );

				} elseif( is_a( $loElement, 'PPButtonElement' ) ){
					$lcLabel  = $loDataItem->Value();
					$loElement->setLabel( $lcLabel );
					$loElement->setTitle( $lcLabel );

				} elseif( is_a( $loElement, 'SelectElement' ) ){
					$laAttrs = $loElement->GetAttributes();
					$lcName = $laAttrs['name'];
					$luValue = $laParams[$lcName];

					$loElement->ClearContent();

					$loSelectIter =& $loDataItem->getFirstIterator();
					while( $loSelItem =& $loSelectIter->getNext()){

						$loSelValue =& $loSelItem->Value(0);
						$loSelLabel =& $loSelItem->Value(1);
						if(!$loSelLabel){
							$loSelLabel =& $loSelValue;
						}

						if ( $loSelValue->Key() == $lcName ) {

							$luSelValue =& $loSelValue->Value();
							$laAttrs = array( 'value' => $luSelValue );
							if ( $luSelValue == $luValue ) {
								$laAttrs['selected'] = NULL;
							}

							$loSelLabel =& $loSelItem->Value(1);
							$loElement->AppendToContent( new OptionElement( $laAttrs, $loSelLabel->Value() ) );
						}
					}

				} elseif( is_a( $loElement, 'HTMLElement' ) )  {
					$loElement->SetHTML( $loDataItem->Value() );
					
				} elseif( is_a( $loElement, 'InputCheckboxElement' ) ) {
					$lcName = (isset($laAttrs['name'])&&!empty($laAttrs['name']))?$laAttrs['name']:'';
					if(array_key_exists( $lcName, $laParams ) ) {
						$luValue = $laParams[$lcName];
					} else {
						$luValue = $loDataItem->Value();
					}

					/*
					echo "SimpleSearchElement::setDataSource : value = $luValue<br>\n";
					*/

					if( $luValue ){
						$loElement->SetAttribute( 'checked', NULL );
					}else{
						$loElement->UnsetAttribute( 'checked' );
					}

				} elseif( is_a($loElement, 'InputTextElement')){
				$lcName = (isset($laAttrs['name'])&&!empty($laAttrs['name']))?$laAttrs['name']:'';
					if(array_key_exists( $lcName, $laParams ) ) {
						$luValue = $laParams[$lcName];
					} else {
						$luValue = $loDataItem->Value();
					}
					$loElement->SetAttribute( 'value', $luValue );
					
				}
			} else {
				if($DEBUG){
					echo "SimpleSearchElement::setDataSource : data source is too small<br>\n";
				}
			}
		}
	}
}
?>