<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( dirname(__FILE__) . "/../data/class.SetOfRowsData.php" );
include_once( dirname(__FILE__) . "/../data/class.TextLimit.php" );
include_once( dirname(__FILE__) . "/../data/class.TrafficLimit.php" );

define( "cc_ShowLimit", 0x1 );
define( "cc_ShowHard", 0x2 );
define( "cc_ShowUnlimited", 0x4 );
define( "cc_ShowAssigned", 0x8 );
define( "cc_ShowUsed", 0x10 );
define( "cc_IncludeLimits", 0x20 );
define( "cc_IncludeStorage", 0x40 );
define( "cc_IncludeTraffic", 0x80 );
define( "cc_StorageDetailsMore", 0x100 );
define( "cc_StorageDetailsMost", 0x200 );
define( "cc_TrafficDetailsMore", 0x400 );
define( "cc_TrafficDetailsMost", 0x800 );
define( "cc_SeparateColumns", 0x1000 );
define( "cc_UseMBGBNames", 0x2000 );
define( "cc_UseMBGBTraffic", 0x4000 );
define( "cc_TrafficDetailsDate", 0x8000 );


class LimitsData extends SetOfRowsData {

	var $miResellerMode;
	var $miFormIndex;

  /**
   * Constructor 
   * 
   * Pass $pa_Admin if you are logged in as admin
   * Pass $pa_Admin & $pa_Reseller if you are logged in as reseller
   * Pass $pa_Admin & $pa_Reseller & $pa_User if you are logged in as user
   */
	function LimitsData( $ps_Flags, $pa_Admin, $pa_Reseller=array(), $pa_User=array(), $pa_Limits=array(),
											 $pa_Assigned=array(), $pa_Used=array(), $pi_FormIndex = 0 ) {

		global $DEBUG;
		if ($DEBUG){
			/*	
			 echo "LimitsData::LimitsData<br>admin:<br>\n";
			print_r($pa_Admin);
			echo "<hr>reseller:<br>\n";
			print_r($pa_Reseller);
			echo "<hr>user:<br>\n";
			print_r($pa_User);
			echo "<hr>\n";
			*/
		}

		$this->miFormIndex = 0;
		$this->FormIndex( $pi_FormIndex );
		$this->miResellerMode = count( $pa_Reseller ) ? 0: 1;
		$this->SetOfRowsData();

		//		$this->AppendRow( new HTMLDataField("<sup class=required>*</sup> - ".ltext("fp_required_fields")));
    
    if( $this->CanDo( "maxkunden", 1, $this->miResellerMode, array() ) )
			$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_users"), "maxkunden", "maxkundenlimit", $pa_Limits,
					$pa_Assigned, $pa_Used );

		if( $this->FlagSet( $ps_Flags, cc_IncludeStorage ) && $this->CanDo( "maxkb", 1, $pa_Reseller, $pa_User ) ) {
			if( $this->FlagSet( $ps_Flags, cc_StorageDetailsMore ) ) {
				$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowAssigned, ltext("ldf_limit_storage_assigned"),
						"maxkb", "maxkblimit", $this->FlagSet( $ps_Flags, cc_UseMBGBNames ) ? "maxkb_mbgb" : "kbtyp",
						$pa_Limits, $pa_Assigned, $pa_Used );
				$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowUsed, ltext("ldf_limit_storage_used"), "maxkb",
						"maxkblimit", $this->FlagSet( $ps_Flags, cc_UseMBGBNames ) ? "maxkb_mbgb" : "kbtyp", $pa_Limits,
						$pa_Assigned, $pa_Used );
			}
			elseif( $this->FlagSet( $ps_Flags, cc_StorageDetailsMost ) ) {
				$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowAssigned, ltext("ldf_limit_storage_assigned"),
						"maxkb", "maxkblimit", $this->FlagSet( $ps_Flags, cc_UseMBGBNames ) ? "maxkb_mbgb" : "kbtyp",
						$pa_Limits, $pa_Assigned, $pa_Used );
				$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowUsed, ltext("ldf_limit_storage_used"), "maxkb",
						"maxkblimit", $this->FlagSet( $ps_Flags, cc_UseMBGBNames ) ? "maxkb_mbgb" : "kbtyp", $pa_Limits,
						$pa_Assigned, $pa_Used );
				$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowUsed, ltext("ldf_limit_storage_files"), "maxkbfiles",
						"maxkblimit", $this->FlagSet( $ps_Flags, cc_UseMBGBNames ) ? "maxkb_mbgb" : "kbtyp", $pa_Limits,
						$pa_Assigned, $pa_Used );
				$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowUsed, ltext("ldf_limit_storage_db"), "maxkbdb",
						"maxkblimit", $this->FlagSet( $ps_Flags, cc_UseMBGBNames ) ? "maxkb_mbgb" : "kbtyp", $pa_Limits,
						$pa_Assigned, $pa_Used );
			}
			else
				$this->AppendKBLimit( $ps_Flags, ltext("ldf_limit_storage")."<sup class=required>*</sup>", "maxkb", "maxkblimit",
						$this->FlagSet( $ps_Flags, cc_UseMBGBNames ) ? "maxkb_mbgb" : "kbtyp", $pa_Limits, $pa_Assigned,
						$pa_Used );
    }


    /**
     *  Mail space
     */
    if( $this->FlagSet( $ps_Flags, cc_IncludeStorage )
      && $this->CanDo( "popmaxkb", $pa_Admin["quota"], $pa_Reseller, $pa_User ) ){
  
  
      if( $this->FlagSet( $ps_Flags, cc_StorageDetailsMost ) ){

        $this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowAssigned, ltext("ldf_limit_mailspace_assigned"),
					  "popmaxkb", "popmaxkblimit", $this->FlagSet( $ps_Flags, cc_UseMBGBNames ) ? "popmaxkb_mbgb" : "popkbtyp",
						$pa_Limits, $pa_Assigned, $pa_Used );

        $this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowUsed, ltext("ldf_limit_mailspace_used")."<sup class=required>*</sup>", 
                            "popmaxkb", "popmaxkblimit", $this->FlagSet( $ps_Flags, cc_UseMBGBNames ) 
                                                         ? "popmaxkb_mbgb" 
                                                         : "popkbtyp", $pa_Limits, $pa_Assigned,
                          $pa_Used );
      }else{
        
        $this->AppendKBLimit( $ps_Flags, ltext( 'uc_popmaxkb' ).'<sup class=required>*</sup>', 
                            'popmaxkb', 'popmaxkblimit', $this->FlagSet( $ps_Flags, cc_UseMBGBNames ) 
                                                         ? 'popmaxkb_mbgb' 
                                                         : 'popkbtyp', $pa_Limits, $pa_Assigned,
                              $pa_Used );
      }
    }     
		if( $this->FlagSet( $ps_Flags, cc_IncludeLimits ) ) {
			if( $this->CanDo( "maxpop", $pa_Admin["pop"], $pa_Reseller, $pa_User ) )
				$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_pop3"), "maxpop", "maxpoplimit", $pa_Limits,
						$pa_Assigned, $pa_Used );
			if( $this->CanDo( "maxemail", $pa_Admin["email"], $pa_Reseller, $pa_User ) )
				$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_email"), "maxemail", "maxemaillimit", $pa_Limits,
						$pa_Assigned, $pa_Used );
			if( $this->CanDo( "maxautoresponder", $pa_Admin["autoresponder"], $pa_Reseller, $pa_User ) )
				$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_auto"), "maxautoresponder", "maxautoresponderlimit",
						$pa_Limits, $pa_Assigned, $pa_Used );
			if( $this->CanDo( "maxftp", $pa_Admin["ftp"], $pa_Reseller, $pa_User ) )
				$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_ftp"), "maxftp", "maxftplimit", $pa_Limits,
						$pa_Assigned, $pa_Used );
		}
		if ($this->FlagSet( $ps_Flags, cc_IncludeTraffic ) && $this->CanDo( "maxtransfer", 1, $pa_Reseller, $pa_User)) {
			$ls_Name = $this->FlagSet( $ps_Flags, cc_UseMBGBTraffic ) ? "maxtransfer_mbgb" : NULL;
			if( $this->FlagSet( $ps_Flags, cc_TrafficDetailsMost ) ) {
				global $show_emailtransfer;
				$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowAssigned, ltext("ldf_limit_traffic"), "maxtransfer",
						NULL, $ls_Name, $pa_Limits, $pa_Assigned, $pa_Used, FALSE );
				$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowUsed, ltext("ldf_limit_traffic_used"), "maxtransfer",
						NULL, $ls_Name, $pa_Limits, $pa_Assigned, $pa_Used, TRUE );
				$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowUsed, ltext("ldf_limit_traffic_ftp"),
						"maxtransferftp", NULL, $ls_Name, $pa_Limits, $pa_Assigned, $pa_Used, TRUE );
				$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowUsed, ltext("ldf_limit_traffic_web"),
						"maxtransferweb", NULL, $ls_Name, $pa_Limits, $pa_Assigned, $pa_Used, TRUE );
				if( $show_emailtransfer )
					$this->AppendKBLimit( ($ps_Flags&cc_ShowLimit)|cc_ShowUsed, ltext("ldf_limit_traffic_email"),
							"maxtransferemail", NULL, $ls_Name, $pa_Limits, $pa_Assigned, $pa_Used, FALSE );
			} elseif ($this->FlagSet( $ps_Flags, cc_TrafficDetailsDate )) {
					$jahr     = date("Y");
					$monat    = date("n"); 
					$monatstr = ltext('lang_months_'.$monat);
					
					$this->AppendKBLimit( $ps_Flags, ltext("ldf_limit_traffic")." $monatstr $jahr", 
														 "maxtransfer", NULL, $ls_Name, $pa_Limits,	$pa_Assigned, $pa_Used, FALSE );
			}
			else
				$this->AppendKBLimit( $ps_Flags, ltext("ldf_limit_traffic")."<sup class=required>*</sup>", 
														 "maxtransfer", NULL, $ls_Name, $pa_Limits,	$pa_Assigned, $pa_Used, FALSE );
		}
    if( $this->FlagSet( $ps_Flags, cc_IncludeLimits ) ) {

			if( $this->CanDo( "maxdomains", 1, !count($pa_Reseller), $pa_User ) )
				$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_domains"), "maxdomains", "maxdomainslimit", $pa_Limits,
          $pa_Assigned, $pa_Used );
      
      if( $this->CanDo( 'maxshareddomains', $pa_Admin['shareddomains'], $this->miResellerMode, array() ) )
				$this->AppendTextLimit( $ps_Flags,
																ltext("ldf_limit_shareddomains"),
																'maxshareddomains',
																'maxshareddomainslimit',
																$pa_Limits,
																$pa_Assigned,
																$pa_Used,
																count($pa_Reseller) ? 1 : -1 );

			if( $this->CanDo( "maxsubdomains", $pa_Admin["subdomains"], $pa_Reseller, $pa_User ) )
				$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_subdomains"), "maxsubdomains", "maxsubdomainslimit",
						$pa_Limits, $pa_Assigned, $pa_Used, count($pa_Reseller) ? 0 : -1 );
			// name of wildcard column is different for user & reseller
			// add if( count($pa_User) ) when needed
			if( count($pa_Reseller) ) {
				if( $this->CanDo( "maxwildcards", $pa_Admin["subdomains"], $pa_Reseller["maxwildcards"], $pa_User ) )
					$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_wildcard"), "maxwildcards", "wildcardlimit",
							$pa_Limits, $pa_Assigned, $pa_Used, -1 );
			}
			else {
				if( $this->CanDo( "maxwildcards", $pa_Admin["subdomains"], $pa_Reseller, $pa_User ) )
					$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_wildcard"), "maxwildcards", "maxwildcardslimit",
							$pa_Limits, $pa_Assigned, $pa_Used, -1 );
			}
			if( $this->CanDo( "maxatdomains", $pa_Admin["subdomains"], $pa_Reseller, $pa_User ) )
				$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_atdomains"), "maxatdomains", "maxatdomainslimit",
						$pa_Limits, $pa_Assigned, $pa_Used, 0 );

			if( $this->CanDo( "maxcronjobs", $pa_Admin["cronjobs"], $pa_Reseller, $pa_User ) )
				$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_cron"), "maxcronjobs", "maxcronjobslimit", $pa_Limits,
						$pa_Assigned, $pa_Used, count($pa_Reseller) ? 0 : -1 );
			if( $this->CanDo( "maxmaillist", $pa_Admin["majordomo"], $pa_Reseller, $pa_User ) )
				$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_maillist"), "maxmaillist", "maxmaillistlimit",
						$pa_Limits, $pa_Assigned, $pa_Used, 0 );
			if( $this->CanDo( "maxmysql", $pa_Admin["mysql"], $pa_Reseller, $pa_User ) )
				$this->AppendTextLimit( $ps_Flags, ltext("ldf_limit_mysql"), "maxmysql", "maxmysqllimit", $pa_Limits,
						$pa_Assigned, $pa_Used, count($pa_Reseller) ? 1 : -1 );

			if( $this->CanDo( 'maxwebapp', $pa_Admin['webapp'], $pa_Reseller, $pa_User ) )
				$this->AppendTextLimit( $ps_Flags,
																ltext("ldf_limit_webapp"),
																'maxwebapp',
																'maxwebapplimit',
																$pa_Limits,
																$pa_Assigned,
																$pa_Used,
                                count($pa_Reseller) ? 1 : -1 );
  

		}
	}

	function FormIndex( $piFormIndex = NULL ) {
		if( is_numeric( $piFormIndex ) ) {
			$this->miFormIndex = $piFormIndex;
		}
		return $this->miFormIndex;
	}


	/* -------------------- different methods (internal use only) -------------------- */
	function FlagSet( $ps_Flags, $ps_Test ) {
		return $ps_Flags & $ps_Test;
	}

	function CanDo( $ps_What, $pm_Admin, $pm_Reseller=array(), $pm_User=array() ) {
		if( is_array($pm_Admin) ? !array_key_exists( $ps_What, $pm_Admin ) || !$pm_Admin[$ps_What] : !$pm_Admin )
			return FALSE;
		if( is_array($pm_Reseller) ? count($pm_Reseller) && ( !array_key_exists( $ps_What, $pm_Reseller ) ||
					!$pm_Reseller[$ps_What] ) : !$pm_Reseller )
			return FALSE;
		if( is_array($pm_User) ? count($pm_User) && ( !array_key_exists( $ps_What, $pm_User ) || !$pm_User[$ps_What] ) :
				!$pm_User )
			return FALSE;
		return TRUE;
	}

	function AppendTextLimit( $ps_Flags, $ps_Label, $ps_Name, $ps_HardName, $pa_Limits, $pa_Assigned, $pa_Used,
			$ps_Default = "-1" ) {
		$la_Fields = array();
		$la_Data = $pa_Limits;
		if( ! array_key_exists( $ps_Name, $pa_Limits ) )
			$la_Data[$ps_Name] = $ps_Default;
		if( $this->FlagSet( $ps_Flags, cc_ShowAssigned ) ) {
			$lo_Limit = new TextLimit( $ps_Name, $ps_HardName );

			$lo_Limit->FormIndex( $this->FormIndex());## pass form's index

			$lo_Limit->SetFromArray( $pa_Assigned );
			$la_Fields[] = $lo_Limit->GetField();
		}
		if( $this->FlagSet( $ps_Flags, cc_ShowUsed ) ) {
			$lo_Limit = new TextLimit( $ps_Name, $ps_HardName );

			$lo_Limit->FormIndex( $this->FormIndex());## pass form's index

			$lo_Limit->SetFromArray( $pa_Used );
			$la_Fields[] = $lo_Limit->GetField();
		}
		if( $this->FlagSet( $ps_Flags, cc_ShowLimit ) ) {
			$ls_Need = ( $this->FlagSet( $ps_Flags, cc_ShowAssigned ) || $this->FlagSet( $ps_Flags, cc_ShowUsed ) ) &&
				! $this->FlagSet( $ps_Flags, cc_SeparateColumns );
			$lo_Field = new CompoundDataField();
			$lo_Field->SetSeparator("");
			if( $ls_Need )
				$lo_Field->AppendToContent( new HTMLDataField( "(" ) );
			$lo_Limit = new TextLimit( $ps_Name, $ps_HardName );
			
			$lo_Limit->FormIndex( $this->FormIndex());## pass form's index

			$lo_Limit->SetFromArray( $la_Data );
			$lo_Field->AppendToContent( $lo_Limit->GetField() );
			if( $ls_Need )
				$lo_Field->AppendToContent( new HTMLDataField( ")" ) );
			$la_Fields[] = $lo_Field;
		}
		$lo_Limit = new TextLimit( $ps_Name, $ps_HardName );

		$lo_Limit->FormIndex( $this->FormIndex());## pass form's index

		$lo_Limit->SetFromArray( $la_Data );
		if( $this->FlagSet( $ps_Flags, cc_ShowHard ) )
			$la_Fields[] = $lo_Limit->GetHardLimitField();
		if( $this->FlagSet( $ps_Flags, cc_ShowUnlimited ) )
			$la_Fields[] = $lo_Limit->GetUnlimitedField();
		if( $this->FlagSet( $ps_Flags, cc_SeparateColumns ) ) {
			array_unshift( $la_Fields, new HTMLDataField( $ps_Label ) );
			call_user_func_array( array( &$this, "AppendRow" ), $la_Fields );
		}
		else {
			$lo_Field = new CompoundDataField();
			$lo_Field->SetSeparator( " " );
			call_user_func_array( array( &$lo_Field, "AppendToContent" ), $la_Fields );
			$this->AppendRow( new HTMLDataField( $ps_Label ), $lo_Field );
		}
	}

	function AppendKBLimit( $ps_Flags, $ps_Label, $ps_Name, $ps_HardName, $ps_KBName, $pa_Limits, $pa_Assigned, $pa_Used,
			$ps_KBLimit = TRUE ) {

		global $DEBUG;

		$la_Fields = array();
		if( $this->FlagSet( $ps_Flags, cc_ShowAssigned ) ) {
			$lo_Limit = $ps_KBLimit ? new KBLimit( $ps_Name, $ps_HardName, $ps_KBName ) : new TrafficLimit( $ps_Name, "",
					$ps_KBName );
			$lo_Limit->SetFromArray( $pa_Assigned );
			$la_Fields[] = $lo_Limit->GetField();
		}
		if( $this->FlagSet( $ps_Flags, cc_ShowUsed ) ) {
			$lo_Limit = $ps_KBLimit ? new KBLimit( $ps_Name, $ps_HardName, $ps_KBName ) : new TrafficLimit( $ps_Name, "",
					$ps_KBName );

			$lo_Limit->FormIndex( $this->FormIndex() ); ## pass form's index

			$lo_Limit->SetFromArray( $pa_Used );
			$la_Fields[] = $lo_Limit->GetField();
		}
		if( $this->FlagSet( $ps_Flags, cc_ShowLimit ) ) {
			$ls_Need = ( $this->FlagSet( $ps_Flags, cc_ShowAssigned ) || $this->FlagSet( $ps_Flags, cc_ShowUsed ) ) &&
				! $this->FlagSet( $ps_Flags, cc_SeparateColumns );
			$lo_Field = new CompoundDataField();
			$lo_Field->SetSeparator("");
			if( $ls_Need )
				$lo_Field->AppendToContent( new HTMLDataField( "(" ) );
			$lo_Limit = $ps_KBLimit ? new KBLimit( $ps_Name, $ps_HardName, $ps_KBName ) : new TrafficLimit( $ps_Name, "",
					$ps_KBName );

			$lo_Limit->FormIndex( $this->FormIndex() ); ## pass form's index
	
			$lo_Limit->SetFromArray( $pa_Limits );

			if($DEBUG){
				/*
				echo "LimitsData::AppendKBLimit (limit)<br><pre>\n";
				print_r($lo_Limit);
				echo "<hr>\n";
				*/
			}

			$fld = $lo_Limit->GetField();
			if($DEBUG){
				/*
				echo "LimitsData::AppendKBLimit (GetField)<br><pre>\n";
				print_r($fld);
				echo "<hr>\n";
				*/
			}


			$lo_Field->AppendToContent( $lo_Limit->GetField() );
			if( $ls_Need )
				$lo_Field->AppendToContent( new HTMLDataField( ")" ) );

			if($DEBUG){
				/*
				echo "LimitsData::AppendKBLimit (field)<br><pre>\n";
				print_r($lo_Field);
				echo "<hr>\n";
				*/
			}


			$la_Fields[] = $lo_Field;
		}
		$lo_Limit = $ps_KBLimit ? new KBLimit( $ps_Name, $ps_HardName, $ps_KBName ) : new TrafficLimit( $ps_Name, "",
				$ps_KBName );

		$lo_Limit->FormIndex( $this->FormIndex() ); ## pass form's index

		$lo_Limit->SetFromArray( $pa_Limits );

		if($DEBUG){
			/*
			echo "LimitsData::AppendKBLimit (limit)<br><pre>\n";
			print_r($lo_Limit);
			echo "<hr>\n";
			*/
		}


		if( $this->FlagSet( $ps_Flags, cc_ShowHard ) )
			$la_Fields[] = $lo_Limit->GetHardLimitField();

		if( $this->FlagSet( $ps_Flags, cc_ShowUnlimited ) )
			$la_Fields[] = $lo_Limit->GetUnlimitedField();

		if( $this->FlagSet( $ps_Flags, cc_SeparateColumns ) ) {
			array_unshift( $la_Fields, new HTMLDataField( $ps_Label ) );
			call_user_func_array( array( &$this, "AppendRow" ), $la_Fields );
		}
		else {
			$lo_Field = new CompoundDataField();
			$lo_Field->SetSeparator( " " );
			call_user_func_array( array( &$lo_Field, "AppendToContent" ), $la_Fields );
			$this->AppendRow( new HTMLDataField( $ps_Label ), $lo_Field );
			
		}
	}
	/* -------------------- end different methods (internal use only) -------------------- */

	function &GetHiddenPresentation() {

		global $DEBUG;

		$lo_Result = new CompoundElement();

		foreach( $this->GetRows() as $lo_Row ) {

			foreach( $lo_Row->GetFields() as $lo_Field ) {

				if ( is_a($lo_Field,'CompoundDataField') ) {

					$hid = NULL;
					foreach ( $lo_Field->GetContent() as $lo_Entry ) {
						if ( is_a( $lo_Entry, 'KBLimitDataField' ) ) {

							$hid = $lo_Entry->GetHiddenPresentation();

							break;
						}elseif( is_a( $lo_Entry, 'TextLimitDataField' ) ) {
							$hid = $lo_Entry->GetHiddenPresentation();

							break;
						}
					}
					if($hid) {
						if ($DEBUG){
							/*
							echo "hidden:<br><pre>\n";
							print_r($hid);
							echo "</pre><hr>\n";
							*/
						}
						
						$lo_Result->AppendToContent( $hid );
					}
				}
			}
		}

		foreach( $this->GetHidden() as $lo_Hidden )
			$lo_Result->AppendHidden( $lo_Hidden->GetHiddenPresentation() );

		return $lo_Result;

	}

	function &GetLimits() {
		global $DEBUG;

		$lo_Result = array();

		foreach( $this->GetRows() as $lo_Row ) {
			if($DEBUG){
				/*
				echo "LimitsData::GetLimits (row)<br><pre>\n";
				print_r($lo_Row);
				echo "</pre><hr>\n";
				*/
			}
			foreach( $lo_Row->GetFields() as $lo_Field ) {
				if ( is_a($lo_Field,'CompoundDataField') ) {
					if($DEBUG){
						/*					
						 echo "LimitsData::GetLimits (field)<br><pre>\n";
						print_r($lo_Field);
						echo "</pre><hr>\n";
						*/
					}

					foreach ( $lo_Field->GetContent() as $lo_Entry ) {
						if ( is_a( $lo_Entry, 'KBLimitDataField' ) ) {
							$lo_Result[] = $lo_Entry;
							if($DEBUG){
								/*
								echo "LimitsData::GetLimits found KBLimitDataField<br><pre>\n";
								print_r( $lo_Result );
								echo "</pre><hr>\n";
								*/
							}

							break;
						}elseif( is_a( $lo_Entry, 'TextLimitDataField' ) ) {
							$lo_Result[] = $lo_Entry;
							if($DEBUG){
								/*
								echo "LimitsData::GetLimits found TextLimitDataField<br><pre>\n";
								print_r( $lo_Result );
								echo "</pre><hr>\n";
								*/
							}
							break;
						}
					}
				}
			}
		}
		if($DEBUG){
			/*
			echo "LimitsData::GetLimits (result)<br><pre>\n";
			print_r( $lo_Result );
			echo "</pre><hr>\n";
			*/
		}
		return $lo_Result;
	}

}
?>
