<?
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####


function save_idn_alias( $domain_id, $idn_name, $id, $server_id = NULL) {
	
	global $ServerID;
	global $DEBUG;

	if($DEBUG){
		echo "save_idn_alias( $domain_id, $idn_name, $id, $server_id )<br>\n";
	}

	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	include_once( 'class.Data.php' );

	$nl = new SQLDataRow('idn_aliases', false, 'id');

	$nl->setValue( 'idn_name', $idn_name );
	$nl->setValue( 'domain_id', $domain_id );
	$nl->setValue( 'server_id', $server_id );

	if( $id ){
		$id = (int)$id;
/*		
		if (!$this->checkId($id))
		{
			return false;
		}
*/
		$nl->setValue( 'id', $id );
		return $nl->update();
	} else {
		return $nl->insert();
	}
}

function get_html_idn_name( $domain_name, $server_id = NULL ) {
  global $ServerID;
	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	
	$res = safe_query2( "SELECT d.domain, i.idn_name FROM domains d, idn_aliases i"
											." WHERE d.server_id=? AND i.server_id=d.server_id AND d.id = i.domain_id AND d.domain = '$domain_name'",
											new SQLString( $server_id ),
											new SQLString( $domain_name ) 
											);
	if( db_num_rows( $res ) != 1) {
		db_free_query( $res );
		return false;
	}
	$row = db_fetch_array( $res );
	db_free_query( $res );

	include_once( 'class.InputDecode.php' );

	return InputDecode::utf8ToUnicodeEntities( $row['idn_name'] );

}

// $ls_DomainTranslated - in utf8
function translate_name_to_idn( $ls_DomainTranslated ){

	global $bindir, $iconv_utf8, $fehlertext;
	global $DEBUG;

	$ls_DomainName = escapeshellarg($ls_DomainTranslated);

	if( !( isset( $iconv_utf8 ) && $iconv_utf8 ) ) {
		$iconv_utf8 = 'UTF-8';
	}
	$exec = "$bindir/idn_translate.pl $iconv_utf8 $ls_DomainName";

	if( $DEBUG ){
		echo "translate_name_to_idn: $exec<br>\n";
	}

	$list = array();
	exec( $exec, $list, $return);

	if($DEBUG){
		echo "<br><pre>\n";
		print_r( $list );
		echo "</pre><hr>\n";
	}

	if( $return != 0 ){
		if( $DEBUG ){
			$fehlertext .= "<p><b>Error:</b> idn_translate.pl returned with non-zero status:<pre>".implode("\n", $list)."</pre></p>";
		}
		return false;
	}

	if( sizeof($list) < 1) {
		// error
		if( $DEBUG ){
			$fehlertext .= "<p><b>Error:</b> idn_translate.pl returned with empty output:<pre>".implode("\n", $list)."</pre></p>";
		}
		return false;
	}

	$matches = array(); 

	if( ! preg_match("/^to_idn:\s+([a-zA-Z0-9\._-]+)$/", $list[0], $matches ) ){
		// error
		if( $DEBUG ){
			$fehlertext .= "<p><b>Error:</b> Can not parse output of the idn_translate.pl utility:<pre>".implode("\n", $list)."</p>";
		}

		return false;
	} 

	return $matches[1]; 
}

?>
