<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

/**
 * Class for manage of IMAP folders
 * @todo: need to transfer folder's actions from scripts here.
 * 
 */
class ImapFolders {

	var $moEmailConnect;
	var $mbStatusFlag;
	var $maFolders;

	/**
  * Constructor
  * @param object EmailConnect
  */
	function ImapFolders( &$loEmailConnect ){

		$this->moEmailConnect = $loEmailConnect;
		$this->mbStatusFlag   = false;
    $this->maFolders = array();
	}
	
  /**
   * Checks if system imap folders such as Sent, Trash exists.
   * Return array of folders.
   * @return array $laFolders
   */
	function &getFolders( ){
	  global $imapSystemFolders;
    $laOut     = array();
    $laFolders = array();
    $i = 0;
        
		$laFolders = imap_list( $this->moEmailConnect->MBox(), 
		                       '{'.$this->moEmailConnect->Host().':'.$this->moEmailConnect->Port().'}', "*" );

     foreach( $imapSystemFolders as $lcSystemFolder ){
      // think than INBOX always exists
      if( strtolower( $lcSystemFolder ) == 'inbox' ){
        continue;
      }
        
      $lcNewFolder = imap_utf7_encode( "{".$this->moEmailConnect->Host().":".$this->moEmailConnect->Port()."}".
	                   $this->moEmailConnect->fullFolderPrefix()."$lcSystemFolder" );
                        
			if( ! in_array( $lcSystemFolder, $laFolders ) ){
				if( @imap_createmailbox( $this->moEmailConnect->MBox(), $lcNewFolder ) ){
          array_push( $laFolders, $lcNewFolder );
        }
			}
		}
 
		foreach( $laFolders as $key => $value ){
      if( $this->mbStatusFlag ){
  			$loCounts = imap_status( $this->moEmailConnect->MBox(), $value, SA_ALL );	
      	$laOut[$i]['unseen'] = $loCounts->unseen;  
      	$laOut[$i]['total'] = $loCounts->messages;  
			}                     
    	
		  $laOut[$i]['name'] = str_replace( $this->moEmailConnect->fullFolderPrefix(),'', 
			                     $laOut[$i]['fullname'] =  preg_replace( '/{.+}/i', '', imap_utf7_decode( $value ) ) );
			                     	
      $i++;			
		}
    $this->maFolders = $laOut;
    return $this->maFolders;
	}
	
	/**
   * Set flag - need we check count of messages while process folders
   * @param  bool $pbSatus
   * @return bool mbStatusFlag
   */
   function &StatusFlag( $pbSatus = false ){
  		if ( is_bool( $pbSatus ) ){
  			$this->mbStatusFlag = $pbSatus;
  		}
  		return $this->mbStatusFlag;
	  }


	  function &getFolderByName( $pcName, $pbIgnoreCase = true ){
      foreach( $this->maFolders as $value ){
        $cond = $pbIgnoreCase 
                ? ( strtolower( $value['name'] ) == strtolower( $pcName ) ) 
                : ( $value['name']  == $pcName );
        if( $cond ){
          return $value;
        }
      }
      return false;
    }
}


?>
