<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.Pager.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.InputTextColumn.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.InputCheckboxColumn.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.PostValuesSource.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "module.Informer.php" );





class IPRestrictionPager extends Pager {

	/* -------------------- Members -------------------- */
	var $ms_InConfirm; // TRUE if edit confirmation page is shown
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function IPRestrictionPager ( &$po_Source ) {
		$this->Pager ( $po_Source );
		$this->setText ( "noresults", ltext("ipr_norestrictions") );
		$this->ms_InConfirm = FALSE;
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function ShouldShowSummary() {
		return FALSE;
	}

	function ShouldShowAddForm() {
		return !$this->ms_InConfirm;
	}

	function ShouldShowSearchForm() {
		return $this->ms_InConfirm ? FALSE : Pager::ShouldShowSearchForm();
	}

	function GetSummary() {
		return "";
	}

	function GetAddColumns() {
		return array( new InputTextColumn( "ip", ltext("ipr_ipaddress"), "", array( "style"=>"width: 100%" ), "80%" ),
				new InputCheckboxColumn( "accept", "rest", ltext("ipr_accept"), "accept", array(), "10%" ) );
	}

	function GetBrowseColumns() {
		$la_Result = array( new InputTextColumn( "ip", ltext("ipr_ipaddress"), "", array( "style"=>"width: 100%" ), "80%" ),
				new InputCheckboxColumn( "accept", "rest", ltext("ipr_accept"), "", array(), "10%" ) );
		$la_Result[0]->SetSortable (TRUE);
		$la_Result[1]->SetSortable (TRUE);
		return $la_Result;
	}

	function GetSearchColumns() {
		return array(
				new InputTextColumn( "ipsearch", ltext("ipr_ipaddress"), "", array( "style"=>"width: 100%" ), "90%" ) );
	}

	function GetHiddenFields() {
		return array();
	}
	/* -------------------- end definitions of "abstract" methods -------------------- */





	/* -------------------- AddElement & related -------------------- */
	function AddElement() {
		if (!$this->isIP( $_POST["ip"] )) {
			message ( WARN, ltext( "ipr_incorrectip", array(htmlspecialchars($_POST["ip"])) ) );
			$showform = 1;
		}
		if ( $this->MyIP( $_POST["ip"] ) && ( !array_key_exists("rest",$_POST) || $_POST["rest"] != "accept" )
				&& ( !array_key_exists("force",$_POST) || $_POST["force"]!="Y" ) ) {
			message ( WARN, ltext( "ipr_yourip", array($_POST["ip"]) ) );
			$showform = 1;
		}
			
		if ($showform) {
			$lo_Add = new SetOfRowsData();
			foreach( $this->ma_ErrorColumns as $lo_Column )
				$lo_Add->AppendRow( $lo_Column->GetLabelDataField(), $lo_Column->GetDataField() );
			$lo_Add->AppendButton( $this->texts["cancel"], "javascript:return parent.openHeadMenuItem ('iprestriction.php?menu_node_id=iprestriction&cur_page=iprestriction.php&head_text=IP+restrictions', 'ver_pp_help.php%3Fhelp_head_key%3Dipr_help_head%26help_text_key%3Dipr_help_text');" );
			$lo_Add->AppendButton( $this->texts["add"], "javascript:document.forms['addform'].submit()", cc_IDOk );
			$lo_Add->AppendHidden( new TextDataField( "Y", "ListAdd" ) );
			$lo_Add->AppendHidden( new TextDataField( "Y", "force" ) );
			for( $i=0; $i < count( $this->ma_HiddenFields ); $i++ )
				$lo_Add->AppendHidden( $this->ma_HiddenFields[$i]->GetDataField() );
			$lo_Page = new MainPageElement( $lo_Add->GetInputPresentation( array( "action"=>$this->CurrentURL( array() ),
							"method"=>"post", "name"=>"addform" ), $this->texts["add"] ) );
			$lo_Page->OutputHTML();
			exit;
			
		}
		Pager::AddElement();
	}

	function MyIP( $ps_IP ) {
		if (!$this->isIP( $ps_IP )) return 0;
		$ls_Pattern = str_replace ( ".", "\.", $ps_IP );
		$ls_Pattern = str_replace ( "*", ".+", $ls_Pattern );
		return preg_match ( "/^$ls_Pattern$/", $_SERVER["REMOTE_ADDR"] );
	}
	/* -------------------- end AddElement & related -------------------- */





	/* -------------------- EditElements & related -------------------- */
	function EditElements() {
		$ls_Matching = "";
		$ls_Matches = 0;
		$this->mo_Source->LockEdit();
		if ( ! array_key_exists ( "force", $_POST ) || $_POST["force"] != "Y" )
			foreach ( $_POST["ip"] as $ls_ID => $ls_IP )
				if ( $this->MyIP( $ls_IP ) && ( !array_key_exists("rest",$_POST) ||
							!array_key_exists($ls_ID,$_POST["rest"]) || $_POST["rest"][$ls_ID] != "accept" ) &&
						$this->mo_Source->NewDeny($ls_ID,$ls_IP) ) {
					$ls_Matching .= ", $ls_IP";
					$ls_Matches++;
				}

		if ( $ls_Matches ) {
			$this->mo_Source->UnLock();
			$this->ms_InConfirm = TRUE;
			$ls_Matching = substr( $ls_Matching, 2 );
			$this->mo_Source = $this->GetPostSource ( $this->GetBrowseColumns() );
			message ( WARN, ltext( $ls_Matches==1 ? "ipr_yourip" : "ipr_yourips", array($ls_Matching) ) );
			$lo_Data = new SetOfRowsData();
			$lo_Data->AppendHeaderRow();
			foreach( $this->ma_BrowseColumns as $lo_Column )
				$lo_Data->AppendFields( $lo_Column->GetLabelDataField() );
			$lo_Source =& $this->mo_Source;
			for( $lo_Source->Start( $this->ma_SearchColumns ); $la_Element = $lo_Source->NextElement(); ) {
				$lo_Source->UpdateColumns ( $this->ma_BrowseColumns, $la_Element );
				$lo_Data->AppendRow();
				$ls_ID = $la_Element[ $lo_Source->GetIDName() ];
				$lo_Data->SetRowID( $ls_ID );
				foreach( $this->ma_BrowseColumns as $lo_Column )
					$lo_Data->AppendFields( $lo_Column->GetDataField() );
			}
			$lo_Data->AppendHidden( new TextDataField( "Y", "ListEdit" ) );
			$lo_Data->AppendHidden( new TextDataField( "Y", "force" ) );
			for( $i=0; $i < count( $this->ma_HiddenFields ); $i++ )
				$lo_Data->AppendHidden( $this->ma_HiddenFields[$i]->GetDataField() );
			$lo_Data->AppendButton( $this->texts["cancel"], "javascript:location.href=location.href" );
			$lo_Data->AppendButton( $this->texts["confirm"], "javascript:document.forms['deleteform'].submit()" );
			$lo_Page = $this->CreatePageObject( ltext("ma_iprestriction"), $lo_Data );
			$lo_Page->OutputHTML();
			exit;
		}
		Pager::EditElements (FALSE);
	}
	/* -------------------- end EditElements & related -------------------- */

	function isIP( $ps_IP ) {		
		return preg_match ( "/^([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){1,3}$/", $ps_IP );
	}
}
?>
