<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'defines.php');

include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );

include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );

include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );

global $DEBUG;
//$DEBUG = 1;

$gcUserSeparator = '@';

db_master_connect();
//
// List of resellers
//

if( ! isset( $gcListAction ) ){
	$gcListAction = 'anbieter_aendern_liste.php';
 }
if( ! isset( $gcSelectAction ) ){
	$gcSelectAction = 'anbieter_aendern_fwd.php';
 }
if( ! isset( $gaSavedParams ) ){
	$gaSavedParams = array();
 }
if( ! isset( $gcListTitle ) ){
	$gcListTitle = ltext( 'anaeli_title1' );
 }
$listFormIndex = 0;
  	
initPagingSettings( $_POST, array( 'name_to_search' => $name_to_search,
																	 'server_to_serach' => $server_to_search ) );
  
$lcSQL = "SELECT COUNT(*) FROM anbieter WHERE server_id <> '$masterServerID'";
$res = db_query( $lcSQL );
list( $total_number ) = db_fetch_array( $res );
db_free_query( $res );

$laOrders = array( 'reseller' => 'r.number', 
                   'state'    => 'gesperrt', 
                   'company'  => 'firma', 
                   'users'    => 'users',
                   'server'   => 'server'
                 );
                     
if( ! isset( $order ) || ! array_key_exists( $order, $laOrders ) ){	
  $order = 'reseller';
}
if( ! isset( $direction) ){
  $direction = 'asc';
}
  
$lcOrder  = " ORDER BY ".$laOrders[$order]; 
$lcOrder .= $direction == 'desc' ? " DESC" : ""; 

if( isset( $anbieter ) && $anbieter && ! isset( $name_to_search ) ){
	$name_to_search = $anbieter;
 }

if( isset( $server_id ) && $server_id && ! isset( $server_to_search ) ){
	$server_to_search = $server_id;
 }
  
  
// Search

$lcFields = "MIN(r.anbieter) AS anbieter, MIN(r.firma) AS firma,".
	" MIN(r.gesperrt) AS gesperrt, s.name AS server,s.server_id,".
	" r.number, COUNT(k.anbieter) AS users, a.login AS admin_login";

$lcFrom = " anbieter r ".
	" LEFT JOIN server s ON r.server_id=s.server_id".
	" LEFT JOIN admin a ON r.server_id=a.server_id".
	" LEFT JOIN kunden k ON r.server_id=k.server_id AND r.anbieter=k.anbieter";

if( ( isset( $name_to_search ) && $name_to_search ) ||
		( isset( $server_to_search ) && $server_to_search )
		){
  $loName = new SQLValue( $name_to_search, 'S' );
	$laWhere = array();
	$laArgs = array();
	if( isset( $name_to_search ) && $name_to_search ){
		$laWhere[] = "(r.anbieter LIKE '%?%' OR r.firma LIKE '%?%' ".
			" OR s.name LIKE '%?%' OR r.name LIKE '%?%' OR r.firstname LIKE '%?%')";
		$laArgs = array( $loName, $loName, $loName,
										 $loName, $loName );
	}
	if( isset( $server_to_search ) && $server_to_search ){
		$laWhere[] = "(r.server_id=?)";
		array_push( $laArgs, new SQLValue( $server_to_search, 'C' ) );
	}
	
	$laWhere[] = "(r.server_id <> '$masterServerID')";

	$lcWhere = join( ' AND ', $laWhere );

  $lcSQL = "SELECT COUNT(*) FROM anbieter r ".
	         " LEFT JOIN server s ON r.server_id=s.server_id WHERE $lcWhere"; 

  $loQuery = new SQLQuery( $lcSQL, $laArgs );
  
  $loQuery->doQuery();
  list( $total_number ) = $loQuery->fetchArray( 'N' );
  $loQuery->finish();

  $lcSQL = "SELECT $lcFields FROM $lcFrom WHERE $lcWhere ".
	" GROUP BY r.anbieter, r.server_id ".$lcOrder;

  $loQuery->Query( $lcSQL );

 } else {
 	$lcSQL = "SELECT $lcFields FROM $lcFrom ".
		" WHERE r.server_id <> '$masterServerID' GROUP BY r.anbieter, r.server_id ".$lcOrder;
 	$loQuery = new SQLQuery( $lcSQL );
}
  	
$laContent = array();
$lcDirIcon = $direction == 'desc' ? cc_DescIcon : cc_AscIcon; 
$lcNewDir  = $direction == 'desc' ? 'asc' : 'desc';
$laHeaders = array( 'reseller' => array( 'name' => 'anaeli_cell_reseller', 'sort' => 1 ), 
                    'company'  => array( 'name' => 'anaeli_cell_firm',     'sort' => 1 ), 
                    'users'    => array( 'name' => 'sl_users',             'sort' => 1 ), 
                    'server'   => array( 'name' => 'kust_server',          'sort' => 1 ), 
                    'select'   => array( 'name' => 'anaeli_cell_select',   'sort' => 0 ) 
                  );
  
foreach( $laHeaders as $lcKey => $laValue ){ 
  if( $laValue['sort'] ){ 
    if( $order == $lcKey ){ 
      $loContent = new CompoundDataField( new HTMLDataField( ltext( $laValue['name'] ) ), 
                                          new IconDataField( $lcDirIcon ) 
                                        ); 
      $loContent->SetSeparator( '' ); 
    }else{ 
      $loContent = new HTMlDataField( ltext( $laValue['name'] ) ); 
    } 
    $laContent[] = new DataValue( $lcKey, NULL, new LinkDataField( "javascript:setValue('order', '$lcKey',$listFormIndex);". 
                                                                   "setValue('start_index',1,$listFormIndex);". 
                                                                   "submitForm('direction','$lcNewDir',$listFormIndex)", 
                                                                   '', array(), $loContent 
                                                                  ) 
                                 ); 
  }else{ 
    $laContent[] = new ValueLocale( $laValue['name'] ); 
  } 
}
  
$loTitle = new CompoundValue( $laContent ); 

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );
$gcNoFirma = ltext('anaeli_nofirm');

function prepareFirma( $pcFirma ){
		global $gcNoFirma;
		return $pcFirma ? $pcFirma : $gcNoFirma;
}
  
$loTemplate = new CompoundValue( new CompoundValue( new ValueFromArray( 'anbieter' ),
																                    new ValueFromArray( 'server_id' )
																                    ),
																 new ValueFormated( 'firma', NULL, 'prepareFirma' ),
																 new ValueFromArray( 'users' ),
																 new CompoundValue(
																									 new ValueFromArray( 'server' ),
																									 new ValueFromArray( 'server_id'),
																									 new ValueFromArray( 'admin_login')
																									 ),
 																 new CompoundValue( new ValueFromArray( 'anbieter' ),
																                    new ValueFromArray( 'server_id' )
																                    )
																 );
  
$laWidths = array( '25%', '28%', '10%', '25%', '12%' );
$loDS->Template( $loTemplate );

function &createLink( &$poSrc ){

	list( $lcReseller, $lcServerID ) = $poSrc->listValue();

  $loLink   = new LinkDataField( 'adminredirect.php',
	      												 '',
																 array('type' => USERTYPE_RESELLER,
																			 'admin' => $lcReseller,
																			 'server_id' => $lcServerID ),
																 new TextDataField( $lcReseller ) );

	$loLink->AppendAttributes( array( 'target' => '_blank') );
		
	return $loLink;
}

function &createServerLink( &$poSrc ){

	list( $lcName, $lcServerID, $lcLogin ) = $poSrc->listValue();

  $loLink   = new LinkDataField( 'adminredirect.php',
	      												 '',
																 array('type' => USERTYPE_ADMIN,
																			 'admin' => $lcLogin,
																			 'server_id' => $lcServerID ),
																 new TextDataField( $lcName ) );

	$loLink->AppendAttributes( array( 'target' => '_blank') );
		
	return $loLink;
}


$gcSelect = ltext("anaeli_cell_select" );

function &createSelectLink( &$poSrc ){

  global $aktion;
  global $gcSelect,$gcSelectAction,$gaSavedParams;
  
	list( $lcReseller, $lcServerID ) = $poSrc->listValue();

	$laParams = array_merge( array( 'anbieter'=> $lcReseller,
																	'server_id' => $lcServerID,
																	'aktion'  => $aktion ),
													 $gaSavedParams
													 );

  $loLink   = 	 new LinkDataField( $gcSelectAction,
																		'',
																		$laParams,
																		new IconDataField( cc_Go, 
																											 array( 'alt' => $gcSelect,
																															'title' => $gcSelect ) )
																		);
		
	return $loLink;
}

$loCountData = new TextDataField( '', 'users');
$loCountData->ParentAttribute('align','right');

$loDS->Conversion( new CompoundValue( 
  																		new ValueFormated( 'reseller', NULL, 'createLink' ),
																			NULL,
																			new DataValue( 'users', $loCountData ),
																			new ValueFormated( 'server', NULL, 'createServerLink' ),
  																		new ValueFormated( 'select', NULL, 'createSelectLink' )
																			)
										 );
$loDS->doQuery();
$loPTV = new PagedTableView( $loDS, $total_number );
$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );
$loPTV->setParameter( 'aktion', $aktion );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'anbieter', $anbieter );
$loPTV->setParameter( 'direction', $direction );
$loPTV->setParameter( $gaSavedParams );

$loPTV->Anchor( 'list' );
$loPTV->FormIndex( $listFormIndex );
	
if( isset( $name_to_search ) && $name_to_search ){
  $loPTV->NoItemsMessage( ltext( 'll_empty_search' ) );
}else{
	$loPTV->NoItemsMessage( ltext( 'll_empty_list' ) );
}

$tbl = $loPTV->GetOutputPresentation( array( 'action' => $gcListAction.'#list',
																							 'method' => 'post',
																							 'name' => 'list_res' ), 
																				      $gcListTitle );

//==================================================
//
// search

$dsServers = new CompoundDBValue( "SELECT a.server_id, s.name, a.confixx_domain ".
																	" FROM admin a LEFT JOIN server s ON s.server_id=a.server_id ".
																	" ORDER BY s.name, a.confixx_domain");
$dsServers->doQuery();
$loIter =& $dsServers->getFirstIterator();
$loServerSelect = new CompoundValue();
while( $loItem =& $loIter->getNext() ){

	list($lcServerID,$lcName,$lcHostname) = $loItem->listValue();

	$lcPrompt = "$lcName ($lcHostname)";
	$loServerSelect->addValue( new KeyValue( 'server_to_search', $lcServerID ),
														 new KeyValue( 'name', $lcPrompt )
														 );
 }

$loServerSelect->addValue( new KeyValue( 'server_to_search', '' ),
													 new ValueLocale('ll_all' ) );


$dsSearch = new CompoundValue( new ValueFromArray( 'name_to_search', $name_to_search ),
															 new ValueLocale( 'alse_cell_server' ),
															 $loServerSelect,
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'name_to_search', 
																																	'size' => '16',
																																	'value' => $name_to_search,
																																	'MAXLENGTH'=> '32' )
																													 ),
																		 new HTMLElement( '' ), // prompt
																		 new SelectElement(array( 'name' => 'server_to_search' )), 
																		 new PPButtonElement( '', 
																													"javascript:submitForm('start_index',1)", 
																													'bid-search' 
																													),
																		 new PPButtonElement( '', 
																													"javascript:setValue('name_to_search','');".
																													"setValue('server_to_search','');".
																													"submitForm('start_index',1)", 
																													'bid-show-all'
																													) 
																		 );

$loSearch->setDataSource( $dsSearch, array( 'name_to_search' => $name_to_search,
																						'server_to_search' => $server_to_search) );


$tbl->setSearchElement( $loSearch );
$tbl->updateBodyContent();

// end search
//
//=====================================
	
$page = new MainPageElement( $tbl );
$page->OutputHTML( array( '../js/paged_form.js' ) );

db_close();
?>
