<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/class.SQLString.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/module.Constants.php' );

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "anbieter_kundenzuordnung2.php: _POST<br><pre>\n";
	print_r( $_POST );
	echo "</pre><hr>\n";
 }


db_master_connect();

$gcUserSeparator = '@';
list( $lcDstReseller , $server_id ) = explode( $gcUserSeparator, $zielanbieter);
if( isset( $kunde ) ){
	$server_id2 = $server_id;
	$lcSrcReseller = '';
 }else{
	list( $lcSrcReseller , $server_id2 ) = explode( $gcUserSeparator, $quellanbieter);
 }

if( $server_id2 != $server_id  && ! isset( $kunde ) ){
	$fehlertext = ltext('anku_server_warning');
	db_close();
	include('anbieter_kundenzuordnung.php');
	exit();
}

if( $lcSrcReseller == $lcDstReseller ){
	$fehlertext = ltext( 'anku2_error5' );
	db_close();
	include( 'anbieter_kundenzuordnung.php' );
	exit();
 }

$loDstReseller = new SQLString( $lcDstReseller );
$loSrcReseller = new SQLString( $lcSrcReseller ); 
$loServerID    = new SQLString( $server_id );


$lrId = safe_query2( "SELECT gesperrt FROM anbieter WHERE anbieter = ?  AND server_id=?", 
                    $loDstReseller, $loServerID );

$cnt = db_num_rows( $lrId );
list( $dstLock ) = db_fetch_array( $lrId );
db_free_query( $lrId );

if( ! $cnt  ){
	 $fehlertext = ltext( 'anku2_error1' );
	 db_close();
	 include( 'anbieter_kundenzuordnung.php' );
	 exit();
}

if( isset( $quellanbieter ) ){
	
	$lrId = safe_query2( "SELECT gesperrt FROM anbieter WHERE anbieter = ? AND server_id=?", 
											 $loSrcReseller, $loServerID );
	
	$cnt = db_num_rows( $lrId );
	list( $srcLock ) = db_fetch_array( $lrId );
	db_free_query( $lrId );

	if( ! $cnt ){
		$fehlertext = ltext( 'anku2_error3', array( $lcSrcReseller ) );
		db_close();
		include( 'anbieter_kundenzuordnung.php' );
	 exit();
	}
 }else{
	$srcLock = 0;
 }

                    
if( $dstLock || $srcLock ){
	 $fehlertext = ltext( 'anku2_error2' );
	 db_close();
	 include( 'anbieter_kundenzuordnung.php' );
	 exit();
}
//
// If move all users
//
if( ! isset( $kunde ) ){

  $lrId = safe_query2( "SELECT COUNT(kunde) FROM kunden WHERE anbieter = ? AND server_id=?", 
                       $loSrcReseller, $loServerID );
	list($cnt) = db_fetch_array( $lrId );
	db_free_query( $lfId );

  if( ! $cnt ){
		$fehlertext = ltext( 'anku2_error4', array( $lcSrcReseller ) );
  	 db_close();
  	 include( 'anbieter_kundenzuordnung.php' );
  	 exit();
  }
  
  # /checken ob quellanbieter existiert und ob dieser kunden hat
  
  # anzahl ipadressen checken
  $lrId = safe_query2( "SELECT count(ip) AS ipanzahl FROM ipadressen WHERE anbieter = ?  AND kunde != '' AND server_id=?", 
                     $loSrcReseller, $loServerID );
  list( $anzahlips ) = db_fetch_array( $lrId );
	db_free_query( $lrId );
  # /anzahl ipadressen checken
  
  $lcConfirm = ltext( 'anku2_confirmation1', array( $lcSrcReseller, $lcDstReseller ) );
  
  if( $anzahlips == 1 ){
  	 $lcConfirm .= ltext( 'anku2_confirmation2', array( $lcSrcReseller, $lcDstReseller ) );
  }elseif( $anzahlips > 1 ){
  	 $lcConfirm .= ltext( 'anku2_confirmation2', array( $anzahlips, $lcSrcReseller, $lcDstReseller ) );
  }
  
  ## kundenliste erstellen
  $lrId = safe_query2( "SELECT kunde FROM kunden WHERE anbieter = ?  AND server_id=?", 
                      $loSrcReseller, $loServerID );
  $kundenliste = array();                     
  while( $laRow = db_fetch_array( $lrId ) ){
    $kundenliste[] = $laRow['kunde'];
  }
	db_free_query( $lrId );
  ## /kundenliste erstellen

}else{

  $lrId = safe_query2( "SELECT userprefix FROM admin WHERE server_id=?", 
											 $loServerID );
  list( $lcUserPrefix ) = db_fetch_array( $lrId );
  db_free_query( $lrId );

  if( $kunde == $lcUserPrefix.'0'	){
  	 $fehlertext = ltext( 'anku2_forbidden', array( $kunde ) );
  	 db_close();
  	 include( 'anbieter_kundenzuordnung.php' );
  	 exit();
  }	

  $loUser = new SQLString( $kunde );

  # If user dosn't exist
  $lrId = safe_query2( "SELECT anbieter FROM kunden WHERE kunde = ?  AND server_id=?",
											 $loUser, $loServerID );
	$cnt = db_num_rows( $lrId );
  list( $lcSrcReseller ) = db_fetch_array( $lrId );
	db_free_query( $lrId );
  if( ! $cnt ){
		$fehlertext = ltext( 'anku2_error6' );
		db_close();
		include( 'anbieter_kundenzuordnung.php' );
		exit();
  }

  if( $lcSrcReseller == $lcDstReseller ){
		$fehlertext = ltext( 'anku2_error7', array( $kunde,$lcSrcReseller ) );
		db_close();
		include( 'anbieter_kundenzuordnung.php' );
		exit();
  }

  
  # anzahl ipadressen checken
  $lrId = safe_query2( "SELECT COUNT(ip) AS ipanzahl FROM ipadressen WHERE kunde = ?  AND server_id=?", 
                    $loUser, $loServerID );
  list( $anzahlips ) = db_fetch_array( $lrId );
	db_free_query( $lrId );
  # /anzahl ipadressen checken
  
  
  $lcConfirm = ltext( 'anku2_confirmation4', array( $kunde, $lcSrcReseller, $lcDstReseller ) );
  
  if( $anzahlips == 1 ){
  	 $lcConfirm .= ltext( 'anku2_confirmation5', array( $lcSrcReseller, $lcDstReseller ) );
  }
}

$loData = new SetOfRowsData();
for ($i = 0; $i < count($kundenliste); $i++) {
	$loData->AppendRow( new HTMLDataField("<b>".$kundenliste[$i]."</b>" ) );
}
$loData->AppendRow(	new OptionsDataField( array( "ja" => ltext( "anku2_descr1" ), 
                                                "nein" => ltext("anku2_descr2" ) 
                                                ),
		                                     "nein",
		                                     "transferieren", 
		                                     cc_RadioGroupPresentation 
		                                    )
		               );

$loData->AppendHidden( new TextDataField( $lcSrcReseller, "quellanbieter" ) );
$loData->AppendHidden( new TextDataField( $lcDstReseller, "zielanbieter" ) );
$loData->AppendHidden( new TextDataField( $server_id, "server_id" ) );
$loData->AppendHidden( new TextDataField( $kunde, "kunde" ) );
$loData->AppendButton( ltext( "anku2_button1" ), "javascript:doChange()", cc_IDOk );
$loForm = $loData->GetInputPresentation( array( "action" => "anbieter_kundenzuordnung3.php", "method"=>"post" ),
	                                           $lang_text["anku_title1"]);
	
$loForm->AppendTop( $lcConfirm );
$loPage = new MainPageElement( $loForm );
$loPage->OutputHTML();

db_close();

?>
