<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/class.SQLInteger.php' );
include_once( '../include/class.SQLString.php' );
include_once( '../include/module.DNSTemplate.php' );
include_once( '../include/db/class.DBConnect.php' );
include_once( '../include/class.HOPermissions.php' );
include_once( '../include/class.HOStates.php' );

global $DEBUG;
//$DEBUG = 1;

if( $DEBUG ){
	echo "anbieter_kundenzuordnung3.php: _POST<br><pre>\n";
	print_r( $_POST );
	echo "</pre><hr>\n";
}

$lbDnsFlag = false;
$timestamp = time();

/**
 * Do not move user 
 */
if( $transferieren != 'ja' ){
  $fehlertext = ltext( "anku3_error1" );
  $fehlertitel = "Hinweis:";
  include( 'anbieter_kundenzuordnung.php' );
  exit();
}

db_master_connect();


$lcDstReseller = $zielanbieter; 
$lcSrcReseller = $quellanbieter; 
$loDstReseller = new SQLString( $lcDstReseller ); 
$loSrcReseller = new SQLString( $lcSrcReseller ); 
$loServerID    = new SQLString( $server_id );

/**
 * The target reseller does not exist?
 */
$id = safe_query2( "SELECT anbieter, maxkunden, maxkundenlimit, gesperrt".
									 " FROM anbieter WHERE anbieter = ? AND server_id=?", 
									 $loDstReseller, $loServerID );
									 
if( db_num_rows( $id ) < 1 ){
	 $fehlertext = ltext( "anku3_error2" );
	 db_close();
	 include( "anbieter_kundenzuordnung.php" );
	 exit();
}

$werte = db_fetch_array($id);
$maxkunden = $werte['maxkunden'];
$maxkundenlimit = $werte['maxkundenlimit'];
db_free_query( $id );

/**
 * Are resellers are locked?
 */
if( $werte['gesperrt'] ){
	 $fehlertext = ltext( 'anku3_error3' );
	 db_close();
	 include( 'anbieter_kundenzuordnung.php' );
	 exit();
}

/**
 * Fetch new reseller DNS info
 */
$id = safe_query2( "SELECT dnstemplate FROM admin WHERE server_id=?",
									 $loServerID );
list( $lcDnsTemplate ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT standardip,pns,sns FROM anbieter WHERE anbieter = ?  AND server_id=?", 
									 $loDstReseller, $loServerID );
$werte = db_fetch_array($id);
$lcIP = $werte['standardip'];
$lcPNS = $werte['pns'];
$lcSNS = $werte['sns'];
db_free_query( $id );

/**
 * Assign all users to another reseller
 */
if( istleer( $kunde ) ){
  /**
   * Check user limit...
   */
	if( $maxkundenlimit == 1 ){
	 $id = safe_query2( "SELECT count(kunde) as neukunden FROM kunden WHERE anbieter = ?  AND server_id=?", 
											$loSrcReseller, $loServerID);
	 list( $neukunden ) = db_fetch_array($id);
	 db_free_query( $id );
	 
	 $id = safe_query2( "SELECT count(kunde) as freikunden FROM kunden WHERE anbieter = ?  AND server_id=?", 
											$loDstReseller, $loServerID );
	 list( $cnt ) = db_fetch_array($id);
	 db_free_query( $id );
	 $freikunden = $maxkunden - $cnt;

	 if( $neukunden > $freikunden ){
		 $fehlertext = ltext( 'anku3_error4', array($lcDstReseller,$neukunden,$freikunden));
		 db_close();
		 include( 'anbieter_kundenzuordnung.php' );
		 exit();
		}
	}

  /**
   * Sorry, source reseller does not exist
   */
	$id = safe_query2( "SELECT anbieter FROM anbieter WHERE anbieter = ? AND server_id=?", 
                     $loSrcReseller, $loServerID );
	if( db_num_rows( $id ) < 1 ){
		$fehlertext = ltext( 'anku3_error5', array( $lcSrcReseller ) );
		db_close();
		include( 'anbieter_kundenzuordnung.php' );
		exit();
	}
	
	$id = safe_query2( "SELECT COUNT(kunde) FROM kunden WHERE anbieter = ? AND server_id=?", 
										 $loSrcReseller, $loServerID );
	list( $cnt ) = db_fetch_array( $id );
	db_free_query( $id );
	if( $cnt < 1 ){
		$fehlertext = ltext( "anku3_error6",array($lcSrcReseller));
		db_close();
		include( "anbieter_kundenzuordnung.php" );
		exit();
	}

	$id = safe_query2( "SELECT kunde, ip FROM ipadressen WHERE status = 1 AND anbieter = ? AND ".
	                   " kunde != '' AND server_id=?", $loSrcReseller, $loServerID );
  
	$laExclusiveIps = array();
  
	while( $laRow = db_fetch_array( $id, 'A' ) ){
    $laExclusiveIps[$laRow['kunde']] = $laRow['ip'];
	}                   
	
	db_free_query( $id );

  /**
   * Rewrite zone files
   */
	$id = safe_query2( "SELECT domain, kunde FROM dns WHERE anbieter = ? AND kunde != ''  AND server_id=?", 
                    $loSrcReseller, $loServerID );
	while( list( $lcDomain, $lcKunde ) = db_fetch_array( $id ) ){
    
	  if( ! array_key_exists( $lcKunde, $laExclusiveIps ) ){
	  	
		list( $lcZonefile, $ls_Serial ) = ff_ProcessTemplate ( array( $lcDstReseller, 
																																	$server_id
																																	),
																													 $lcDomain,
																													 $lcIP,
																													 NULL,
																													 $lcDnsTemplate,
																													 $lcPNS,
																													 $lcSNS
																													 );
		safe_query2( "UPDATE dns SET anbieter = ?, zonefile = ?, neu = 1 WHERE domain = ? AND server_id=?", 
	            $loDstReseller, new SQLString( $lcZonefile ), new SQLString( $lcDomain ), $loServerID );
	  }
	  if( ! $lbDnsFlag ){
	  	$lbDnsFlag = true;
	  }
	}		
	db_free_query( $id );
  
	safe_query2( "UPDATE domains SET anbieter = ? , lastchange = ? WHERE anbieter = ?  AND server_id=?", 
							 $loDstReseller, new SQLInteger( $timestamp ), $loSrcReseller , $loServerID);

	safe_query2( "UPDATE mysql_datenbanken SET anbieter = ? WHERE anbieter = ? AND server_id=?", 
							 $loDstReseller, $loSrcReseller, $loServerID );

	safe_query2( "UPDATE email SET anbieter = ? WHERE anbieter = ? AND server_id=?", 
						 $loDstReseller, $loSrcReseller, $loServerID );
	safe_query2( "UPDATE ftp SET anbieter = ? WHERE anbieter = ? AND server_id=?", 
							 $loDstReseller, $loSrcReseller, $loServerID );

	safe_query2( "UPDATE ipadressen SET anbieter = ? WHERE anbieter = ? AND kunde != '' AND server_id=?", 
							 $loDstReseller, $loSrcReseller , $loServerID);

  safe_query2( "UPDATE kunden SET ip =?, anbieter = ? ,pw=1, lastchange = ? WHERE anbieter = ? AND kunde !=''  AND server_id=?", 
                new SQLString( $lcIP ), $loDstReseller, new SQLInteger( $timestamp ), $loSrcReseller, $loServerID );
	
	safe_query2( "UPDATE allgemein SET webalizerpw = 1 ".( $lbDnsFlag ? ", dns = 1 " : "" )." WHERE server_id=?",
						 $loServerID );

	safe_query2( "UPDATE pop3 SET anbieter = ? , lastchange = ? WHERE anbieter = ?  AND server_id=?", 
             $loDstReseller, new SQLInteger( $timestamp ), $loSrcReseller, $loServerID );

	safe_query2( "UPDATE fehlermeldungen SET anbieter = ? WHERE anbieter = ? AND server_id=?", 
             $loDstReseller, $loSrcReseller, $loServerID );

	safe_query2( "UPDATE pwschutz SET anbieter = ? , lastchange = ? WHERE anbieter = ?  AND server_id=?", 
						 $loDstReseller, new SQLInteger( $timestamp ), $loSrcReseller, $loServerID );

	safe_query2( "UPDATE frontpage SET anbieter = ? WHERE anbieter = ? AND server_id=?", 
						 $loDstReseller, $loSrcReseller, $loServerID );

	safe_query2( "UPDATE perl SET anbieter = ? WHERE anbieter = ? AND server_id=?", 
						 $loDstReseller, $loSrcReseller, $loServerID );

	safe_query2( "UPDATE webalizer SET anbieter = ? WHERE anbieter = ? AND server_id=?", 
						 $loDstReseller, $loSrcReseller, $loServerID );

	safe_query2( "UPDATE autoresponder SET anbieter = ? WHERE anbieter = ? AND server_id=?", 
						 $loDstReseller, $loSrcReseller, $loServerID );

	safe_query2( "UPDATE cssl SET anbieter = ? WHERE anbieter = ? AND server_id=?", 
						 $loDstReseller, $loSrcReseller, $loServerID );

	safe_query2( "UPDATE transfer SET geloescht=1 WHERE anbieter = ? AND server_id=?",
						 $loSrcReseller, $loServerID );
  
  /**
   * Httpd options
   */
  $loHOPermissions = new HOPermissions( $server_id, $lcDstReseller );
  $loHOPermissions->moveFromReseller( $lcSrcReseller ); 

  $loHOStates = new HOStates( $server_id, $lcDstReseller );
  $loHOStates->moveFromReseller( $lcSrcReseller ); 

  /**
   * Process user with exlusive IPs
   */
  foreach ( $laExclusiveIps as $lcKunde => $lcIP ){
    
    $loUser = new SQLString( $lcKunde );
    
    $id = safe_query2( "SELECT domain FROM dns WHERE anbieter = ?  AND kunde = ?  AND server_id=?", 
  										 $loSrcReseller, $loUser, $loServerID );
  	while( list( $lcDomain ) = db_fetch_array( $id ) ){
  		list($lcZonefile, $ls_Serial) = ff_ProcessTemplate( array( $lcDstReseller,
  																															 $server_id ),
  																												$lcDomain,
  																												$lcIP,
  																												NULL,
  																												$lcDnsTemplate,
  																												$lcPNS,
  																												$lcSNS
  																												);
    	safe_query2( "UPDATE dns SET anbieter = ?, zonefile = ?, neu = 1 WHERE domain = ?  AND server_id=?", 
  								 $loDstReseller,new SQLString( $lcZonefile ), new SQLString( $lcDomain ), $loServerID );
     }		
    # datenbank updaten
    safe_query2( "UPDATE kunden SET ip =?, anbieter = ? ,pw=1, lastchange = ? WHERE kunde = ?  AND server_id=?", 
                  new SQLString( $lcIP ), $loDstReseller, new SQLInteger( $timestamp ), $loUser, $loServerID );
    
  }
  
	$fehlertext  = ltext( "anku3_error7", array( $lcDstReseller, $lcSrcReseller ) );
	$fehlertitel = ltext( "anku3_errortitle" );
	
	db_close();
	include( "anbieter_kundenzuordnung.php" );
	exit();

/**
 * Move individual users
 */
}else{
  
  $loUser = new SQLString( $kunde );

  /**
   * This user does not exist?
   */
  $id = safe_query2( "SELECT kunde, ip FROM kunden WHERE kunde = ? AND server_id=?", 
										 $loUser, $loServerID  );
  
  if( db_num_rows( $id ) < 1 ){
		$fehlertext = ltext( 'anku3_error8' );
		db_close();
		include( 'anbieter_kundenzuordnung.php' );
		exit();
	}
	
	$laRow = db_fetch_array( $id, 'A');
	$lcOldUserIp = $laRow['ip'];
	$loOldUserIp = new SQLString( $lcOldUserIp );
	db_free_query( $id );
	
	$id = safe_query2( "SELECT ip FROM ipadressen WHERE status = 1 AND anbieter = ? ".
	                   " AND kunde = ? AND ip = ? AND server_id=?", $loSrcReseller, $loUser, 
	                   $loOldUserIp, $loServerID );

  if( db_num_rows( $id ) == 1 ){
    $lcIP = $lcOldUserIp;
	}
	db_free_query( $id );
								
  if( $maxkundenlimit == 1 ){
		$neukunden = 1;
  
		$id = safe_query2( "SELECT count(kunde) AS freikunden FROM kunden ".
												" WHERE anbieter = ?  AND server_id=?", 
											 $loDstReseller, $loServerID );
		list( $cnt ) = db_fetch_array( $id );
		db_free_query( $id );
		
		$freikunden = $maxkunden - $cnt;

    /**
     * Check user limit...
     */
		if( $neukunden > $freikunden ){
			$fehlertext = ltext( 'anku3_error9', array( $lcDstReseller, $neukunden, $freikunden ) );
			db_close();
			include( "anbieter_kundenzuordnung.php" );
			exit();
		}
	}
  
  $id = safe_query2( "SELECT domain FROM dns WHERE anbieter = ?  AND kunde = ?  AND server_id=?", 
										 $loSrcReseller, $loUser, $loServerID );
	while( list( $lcDomain ) = db_fetch_array($id)) {
		list($lcZonefile, $ls_Serial) = ff_ProcessTemplate( array( $lcDstReseller,
																															 $server_id ),
																												$lcDomain,
																												$lcIP,
																												NULL,
																												$lcDnsTemplate,
																												$lcPNS,
																												$lcSNS
																												);
  	safe_query2( "UPDATE dns SET anbieter = ?, zonefile = ?, neu = 1 WHERE domain = ?  AND server_id=?", 
								 $loDstReseller,new SQLString( $lcZonefile ), new SQLString( $lcDomain ), $loServerID );
	  if( ! $lbDnsFlag ){
	  	$lbDnsFlag = true;
	  }
   }		
  # datenbank updaten
  safe_query2( "UPDATE domains SET anbieter = ? , lastchange = ?  WHERE kunde = ?  AND server_id=?", 
               $loDstReseller, new SQLInteger( $timestamp ), $loUser, $loServerID );

  safe_query2( "UPDATE email SET anbieter = ? WHERE kunde = ? AND server_id=?", 
               $loDstReseller, $loUser, $loServerID );

  safe_query2( "UPDATE ftp SET anbieter = ? WHERE kunde = ? AND server_id=?", 
							 $loDstReseller, $loUser, $loServerID );
  safe_query2( "UPDATE ipadressen SET anbieter = ? WHERE kunde = ? AND server_id=?", 
							$loDstReseller, $loUser, $loServerID );

  safe_query2( "UPDATE kunden SET ip =?, anbieter = ? ,pw=1, lastchange = ? WHERE kunde = ?  AND server_id=?", 
                new SQLString( $lcIP ), $loDstReseller, new SQLInteger( $timestamp ), $loUser, $loServerID );
	
  safe_query2( "UPDATE allgemein SET webalizerpw=1".( $lbDnsFlag ? ", dns = 1 " : "" )." WHERE server_id=?",
							 $loServerID );

  safe_query2( "UPDATE pop3 SET anbieter = ? , lastchange = ?  WHERE kunde = ?  AND server_id=?", 
							 $loDstReseller, new SQLInteger( $timestamp ), $loUser, $loServerID );

  safe_query2( "UPDATE fehlermeldungen SET anbieter = ? WHERE kunde = ? AND server_id=?", 
							 $loDstReseller, $loUser, $loServerID );

  safe_query2( "UPDATE pwschutz SET anbieter = ? , lastchange = ? WHERE kunde = ?  AND server_id=?", 
               $loDstReseller, new SQLInteger( $timestamp ), $loUser, $loServerID );
  safe_query2( "UPDATE mysql_datenbanken SET anbieter = ? WHERE kunde = ? AND server_id=?", 
               $loDstReseller, $loUser, $loServerID );
  safe_query2( "UPDATE frontpage SET anbieter = ? WHERE kunde = ? AND server_id=?", 
							 $loDstReseller, $loUser, $loServerID );

  safe_query2( "UPDATE perl SET anbieter = ? WHERE kunde = ? AND server_id=?", 
               $loDstReseller, $loUser, $loServerID );

  safe_query2( "UPDATE webalizer SET anbieter = ? WHERE kunde = ? AND server_id=?", 
               $loDstReseller, $loUser, $loServerID );

  safe_query2( "UPDATE autoresponder SET anbieter = ? WHERE kunde = ? AND server_id=?", 
               $loDstReseller, $loUser, $loServerID );

  safe_query2( "UPDATE cssl SET anbieter = ? WHERE kunde = ? AND server_id=?", 
               $loDstReseller, $loUser, $loServerID );

  safe_query2( "UPDATE transfer SET geloescht=1 WHERE kunde = ? AND server_id=?", 
               $loUser, $loServerID );
  
  /**
   * Httpd options
   */
  $loHOPermissions = new HOPermissions( $server_id, $lcDstReseller );
  $loHOPermissions->moveFromReseller( $lcSrcReseller, null, $kunde ); 

  $loHOStates = new HOStates( $server_id, $lcDstReseller );
  $loHOStates->moveFromReseller( $lcSrcReseller, null, $kunde ); 

  $fehlertext = ltext( 'anku3_error10', array( $lcDstReseller, $kunde, $lcSrcReseller ) );
  $fehlertitel = ltext( 'anku3_errortitle' );
  db_close();
  include( 'anbieter_kundenzuordnung.php' );
  exit();
  db_close();
}

?>
