<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );/*{{{*/
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/class.HOStates.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
/*}}}*/

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo 'einstellungen_httpd_anbieter_aendern.php<br>\n';
 }

db_master_connect();

$loRes = new SQLString( $anbieter );
$loServerID = new SQLString( $server_id );

$lrId= db_query( "SELECT COUNT(id) FROM httpd_definitions" );
list( $liHttpdCount ) = db_fetch_array( $lrId, 'N');
db_free_query( $lrId );

$lbHttpdSpecial = 1;
$lbHttpdOptions = $liHttpdCount;

/**
 * Save action
 */
if( isset($act) && $act == 'save' ){/*{{{*/

  if( $mode == 'advanced' ){
    $loText = new SQLString( $zusatz );

    if( $ueberschreiben == 'ja' ){
    safe_query2( "UPDATE domains SET zusatz = ? WHERE anbieter = ? AND richtigedomain != 7 AND server_id=?", 
                 $loText, $loRes, $loServerID );

   } elseif( $ueberschreiben == 'nein' ){

     $id = safe_query2( " SELECT domain FROM domains WHERE anbieter = ? ".
                        " AND zusatz != '' AND richtigedomain !=7 AND server_id=?", 
                        $loRes, $loServerID );
     while( list( $domain ) = db_fetch_array( $id, 'N' ) ){
       $nichtgeaendert .= $domain."<br>";
     }
     db_free_query( $id );

     safe_query2( " UPDATE domains SET zusatz = ? WHERE anbieter = ? AND zusatz = '' ".
                  " AND richtigedomain !=7 AND server_id=?", 
                  $loText, $loRes, $loServerID );
    }

    if( $all == 1 ){
      safe_query2( "UPDATE anbieter SET httpdspezial = ? WHERE anbieter = ? AND server_id=?",
                   $loText, $loRes, $loServerID );
      safe_query2( "UPDATE kunden SET httpdspezial = ? WHERE anbieter = ?  AND server_id=?", 
                   $loText, $loRes, $loServerID );
   }
  }else{
   /**
    * Httpd options
    */
    $loHttpdOptions = new HOStates( $server_id );
    $loHttpdOptions->setForReseller( $anbieter, $httpd_ids, $all );
  }
	safe_query2( "UPDATE kunden SET httpd=1 WHERE anbieter = ? AND server_id=?",
							 $loRes, $loServerID );

	safe_query2( "UPDATE allgemein SET httpd=1, httpdupdate=0 WHERE server_id=?",
							 $loServerID );
	db_close();

	$fehlertitel = ltext( 'eihtanaesp_errortitle1' );
	$fehlertext = ltext( 'eihtanaesp_error1' );
	if( strlen( $nichtgeaendert ) > 0 ) {
		$fehlertext = ltext( 'eihtanaesp_error1', array( $nichtgeaendert ) );
	}
	if( isset( $ret_path) && $ret_path ){
		include( $ret_path );
	}else{
		include( 'einstellungen_httpd.php');
	}
	exit();
 }/*}}}*/

$id = safe_query2( "SELECT httpdspezial FROM anbieter WHERE anbieter = ?  AND server_id=?",
									 $loRes, $loServerID );
list( $zusatz ) = db_fetch_array($id);
db_free_query( $id );

$loData = new SetOfRowsData();

$loData->AppendRow(new HTMLDataField( '##user##' ),
                 	 new HTMLDataField( ltext("eihtkuae_cell_username") ));
$loData->AppendRow(new HTMLDataField( '##domain##' ),
                   new HTMLDataField( ltext("eihtkuae_cell_domain") ));


if( $lbHttpdOptions && $lbHttpdSpecial ){
  $loLinkBlock = new CompoundDataField(  new LinkDataField( "javascript:displayDiv('sim_mode',1);displayDiv('adv_mode',0);",
                                                          "",
	                                                        array( ),
                                                          ltext('simple_mode') ) ,
                                         new LinkDataField( "javascript:displayDiv('adv_mode',1);displayDiv('sim_mode',0);",
                                                           "",
	                                                        array( ),
                                                          ltext('advanced_mode') )             
                                                        );
  $loLinkBlock->SetSeparator(" / ");
  $loLinkBlock->AppendParentAttributes(array("colspan"=>2));
  $loData->AppendRow($loLinkBlock);
}

$boxLegend=$loData->GetOutputPresentation(ltext("eihtanae_title2") ); // Infotable
$boxLegend->SetWidths("20%","80%");

if( $lbHttpdOptions ){
  $liFormIndex = 1;
}else{
  $liFormIndex = 0;
}
 
$loData->ClearRows();
$loData->AppendRow( new HTMLDataField( ltext("eihtanae_cell_title1",array($kunde))), 
                  	new LongTextDataField( $zusatz, "zusatz" ) 
                  );

$loData->AppendRow( new HTMLDataField(ltext("eihtanae_cell_text3")),
                    new YesNoDataField(array("1"=>""),array(),"","all"));


$lo_Radio= new OptionsDataField( array( "ja"   => ltext("eihtanae_cell_text1"),
                                        "nein" => ltext("eihtanae_cell_text2")
                                       ),
                                 "nein", "ueberschreiben", cc_RadioGroupPresentation );
$lo_Radio->SetColSpan( 2 );
$loData->AppendRow( $lo_Radio );

$loData->AppendHidden( new TextDataField( 'advanced', 'mode' ) );
$loData->AppendHidden( new TextDataField( $anbieter, 'anbieter' ) );
$loData->AppendHidden( new TextDataField( $server_id, 'server_id' ) );
$loData->AppendHidden( new TextDataField( $ret_path, 'ret_path' ) );
$loData->AppendHidden( new TextDataField( 'save', 'act' ) );
$loData->AppendHidden( new TextDataField( 'anbieter', 'ret_field' ) );


$loData->AppendButton( ltext( 'eihtanae_button1' ),
										 "javascript:doChange($liFormIndex)", 
										 cc_IDOk );
$lcTitle = ltext( 'eiht_cell_onereseller' ).' <strong>'.htmlspecialchars( $anbieter ).'</strong>';
$form = $loData->GetInputPresentation(
	array( 'action' => 'einstellungen_httpd_anbieter_aendern.php',
				 'method' => 'post'),
  $lcTitle );

$form->SetWidths( '20%', '80%' );
 $laTmp = array( 'id'=>'adv_mode' ); 

if( $lbHttpdOptions ){
  $laTmp['style'] = 'display:none';
}

$loSpecial = new DivElement( $laTmp );
$loSpecial->AppendToContent( $form );


/**
 * Httpd options
 */
if( $lbHttpdOptions ){
  $loHttpdOptionsStates = new HOStates( $server_id );
  $loHttpdOptions = & $loHttpdOptionsStates->getSORDForReseller();
  $loHttpdOptions->AppendRow( new HTMLDataField( '' ),
                              new YesNoDataField( array( '1'=> ltext('eihtanae_cell_text3')  ), array(),'','all' ) 
                            );

  $loHttpdOptions->AppendHidden( new TextDataField( 'simple', 'mode' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( $anbieter, 'anbieter' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( $server_id, 'server_id' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( $ret_path, 'ret_path' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( 'save', 'act' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( 'anbieter', 'ret_field' ) );

  $loHttpdOptions->AppendButton( ltext( 'eihtdoae_button1' ), 'javascript:doChange()',  cc_IDOk );
 
  $form2 = $loHttpdOptions->GetInputPresentation( array(
                                             'action'=>'einstellungen_httpd_anbieter_aendern.php', 
                                             'method'=>'post' ),
                                     $lcTitle );

  $form2->SetWidths('10%','90%');
  $loOptions = new DivElement(array('id'=>'sim_mode'));
  $loOptions->AppendToContent($form2);
}


if( $lbHttpdOptions && $lbHttpdSpecial ){
  $loPage = new MainPageElement( $boxLegend, $loOptions, $loSpecial );
}elseif( $lbHttpdOptions ){
  $loPage = new MainPageElement( $boxLegend, $loOptions );
}elseif( $lbHttpdSpecial){
  $loPage = new MainPageElement( $boxLegend, $loSpecial );
}else{
  $loPage = new MainPageElement( $boxLegend );
}

$loPage->OutputHTML( array( '../../js/paged_form.js' ));

db_close();

?>
