<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com ##### 

include_once( 'auth.php' );/*{{{*/
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.PagedSetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( 'defines.php' );
include_once( '../include/class.HOStates.php' );
/*}}}*/

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "einstellungen_httpd_domain.php: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
}

db_master_connect();


$lrId= db_query( "SELECT COUNT(id) FROM httpd_definitions" );
list( $liHttpdCount ) = db_fetch_array( $lrId, 'N');
db_free_query( $lrId );

$lbHttpdOptions =  $liHttpdCount;



$loPathBar = new PathBar();
$laFirstItem = array('main_menu_page' => 'einstellungen_httpd_domain.php',
										 'head_id' => 'httpd_spec_domain',
										 'head_text' => ltext('eihtdo_cell_domain'),
										 'menu_node_id' => 'menu_node_httpd_spec_domain'
										 );
$loPathBar->pushPathBar( $laFirstItem );
 

initPagingSettings( $_POST, array( 'name_to_search' => $name_to_search,
																	 'server_to_search' => $server_to_search ) );

$lcSQL = "SELECT COUNT(*) FROM domains WHERE richtigedomain NOT IN (5,7)";
$res = db_query( $lcSQL );
list( $total_number ) = db_fetch_array( $res );
db_free_query( $res );

$loWhereAnd = new SQLFieldSet (new SQLField('d.server_id','a.server_id','U'));

if( isset($server_to_search) && $server_to_search ){
	$loWhereAnd->addField( 'd.server_id', $server_to_search, 'C' );
 }
$lcWhere = $loWhereAnd->getSQLWhere( ' AND ' );


if( isset($name_to_search) && $name_to_search ){
	$loWhereOr = new SQLFieldSet ();
	$loWhereOr->addField( 'd.domain', '%'.$name_to_search.'%', 'C' );
	$loWhereOr->addField( 'd.kunde', '%'.$name_to_search.'%', 'C' );
	$loWhereOr->addField( 's.name', '%'.$name_to_search.'%', 'C' );
																
	$lcWhereOr = $loWhereOr->getSQLWhere( ' OR ' );
	$lcWhere .= " AND ( $lcWhereOr )";

}else{
	 $lcWhereOr = '';
 }


$loName = new SQLValue( $name_to_search, 'S' );
$lcSQL = "SELECT COUNT(*) FROM domains d, admin a LEFT JOIN server s ON s.server_id=a.server_id ".
	" WHERE richtigedomain NOT IN (5,7) AND $lcWhere";
$loQuery = new SQLQuery( $lcSQL );
$loQuery->doQuery();
list($total_number) = $loQuery->fetchArray('N');
$loQuery->finish();
	
$lcSQL = "SELECT d.domain, d.id, d.kunde, d.zusatz, a.confixx_domain, s.name, d.server_id ".
	" FROM domains d, admin a LEFT JOIN server s ON s.server_id=a.server_id ".
	" WHERE richtigedomain NOT IN (5,7) AND $lcWhere".
	" ORDER BY kunde,id";
$loQuery->Query( $lcSQL );

$listFormIndex = 0;

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new ValueFromArray( 'domain' ),
																 new ValueFromArray( 'kunde' ),
																 new CompoundValue( new ValueFromArray( 'confixx_domain' ),
																										new ValueFromArray( 'name' )
																										),
																 new ValueFromArray( 'zusatz' )
																 );

$loTitle = new CompoundValue( new ValueLocale( 'eihtdosu_cell_domain' ),
															new ValueLocale( 'eihtdosu_cell_user' ),
															new ValueLocale( 'eihtdosu_cell_server' ),
															new ValueLocale( 'me_httpd' )
															);

$laWidths = array( '25%', '10%', '20%', '5%', '40%' );

if( $lbHttpdOptions ){
  $loTemplate->addValue( new CompoundValue(  new ValueFromArray( 'id' ),
                                             new ValueFromArray( 'server_id' )   
                                           )     
                        );
  $loTitle->addValue( new ValueLocale( 'httpd_options' ) );
  $laWidths = array( '25%',  '5%', '10%',  '20%' , '35%','5%'  );
}

$loTemplate->addValue( new CompoundValue( new ValueFromArray( 'domain' ),
																   				new ValueFromArray( 'zusatz' ),
																					new ValueFromArray( 'server_id' ) ) );
$loTitle->addValue( new ValueLocale( 'll_change' )	);

$loDS->Template( $loTemplate );

//===================================================
//
// function to make visible objects

$gcView = ltext( 'eihtdosu_preview' );

function &makeDomainLink( $pcDomain ){/*{{{*/
	global $gcView;
	$loLink = new LinkDataField( 'http://'.$pcDomain, '', array(), new HTMLDataField( $pcDomain ) );
	$loLink->Attribute( 'target', 'view_domain' );
	//	$loLink->Attribute( 'title',  $gcView );

	return $loLink;
}/*}}}*/

function &makeServerName( $poSrc ){/*{{{*/
	list($lcHostname,$lcName) = $poSrc->listValue();
	//$loName = new HTMLDataField($lcHostname." ($lcName)" );
	$loName = new HTMLDataField( $lcName );
	return $loName;
}/*}}}*/

$gcChange = ltext( 'eiht_cell_domain' );
$gcOn = ltext( 'll_on' );
$gcOff = ltext( 'll_off' );

function &makeOptions( $poSrc ){/*{{{*/

  list( $piId, $server_id ) = $poSrc->listValue();

  $laOptions = array();
  $laOptions2 = array();
  $laOptionsFull = array();
  $liMax = 20;
  $lbFlag = true;
  $loHOptions = new HOStates( $server_id );
  $laOptions = $loHOptions->getOptionsForDomain( $piId );
  foreach( $laOptions as $liId => $laOption ){
    $lcTmp = $laOption['label'].'('.$laOption['state']['label'].')';
    $laOptionsFull[] = $lcTmp;
    if( strlen( $lcTmp ) < $liMax && $lbFlag ){
      $laOptions2[] = $lcTmp;
      $liMax -= strlen( $lcTmp );
    }elseif( $lbFlag ){
      $laOptions2[] = '...';
      $lbFlag = false;
    }
  }
	$loRet = new HTMLDataField( implode( ', ', $laOptions2 ), 
                              false, 
                              array(), 
                              array( 'title'=> implode(", \n",$laOptionsFull ) ) );
	return $loRet;
}/*}}}*/

function &makeStatusLink( $poParams ){/*{{{*/
	global $gcChange, $gcOn, $gcOff;
	global $confixx_interface_version;

	list($lcDomain,$lcSpec, $lcServerID) = $poParams->listValue();
	$loCnt = new IconDataField( cc_ChangeIcon );
	$loLink = new LinkDataField( 'einstellungen_httpd_domain_aendern.php',
															 '',
															 array('domain' => $lcDomain,
																		 'server_id'=> $lcServerID ),
															 $loCnt
															 );
	$loLink->Attribute( 'title', $gcChange );
	$loLink->ParentAttribute( 'align', 'center' );

	return $loLink;
}/*}}}*/

function &makeSpecialView( $pcSpecial ){/*{{{*/
  $lcLine = '';
  $liMaxLen = 20;

  if( $pcSpecial ){
    $laLines = explode( "\n", $pcSpecial );
    $liLen = strlen( $laLines[0] );

    if( $liLen > $liMaxLen ){
      $lcLine = substr( $laLines[0], 0 , $liMaxLen ) . '...';
    }else{
      $lcLine =  $laLines[0];
    }
  }
    return new HTMLDataField( $lcLine );
}/*}}}*/

//
// end function to make visible objects
//==================================================

$loConversion =  new CompoundValue( new ValueFormated( 'domain', NULL, 'makeDomainLink' ),
																			NULL, /* user */
																			new ValueFormated( 'server', NULL, 'makeServerName' ),
																			new ValueFormated( 'special', NULL, 'makeSpecialView' )
                                    );
if( $lbHttpdOptions ){
  $loConversion->addValue( new ValueFormated( 'options', NULL, 'makeOptions' ) );
}

$loConversion->addValue( new ValueFormated( 'change', NULL, 'makeStatusLink' ) );

$loDS->Conversion( $loConversion );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );

$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );
$loPTV->Anchor( 'list' );
$loPTV->FormIndex(0);

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'einstellungen_httpd_domain.php#list',
																						 'name' => 'list_res' ), 
																			ltext( 'eiht_cell_domain' ) );


$dsSearch = new CompoundValue( new ValueFromArray( 'name_to_search', $name_to_search ) );

$dsSearch->addValue( new ValueLocale( 'alse_cell_server' ));

$dsServers = new CompoundDBValue( "SELECT a.server_id, s.name, a.hostname ".
																	" FROM admin a LEFT JOIN server s ON s.server_id=a.server_id WHERE a.server_id != '$masterServerID' ".
																	" ORDER BY s.name, a.hostname");
$dsServers->doQuery();

$loIter =& $dsServers->getFirstIterator();

$loServerSelect = new CompoundValue();
while( $loItem =& $loIter->getNext() ){
	
	list($lcServerID,$lcName,$lcHostname) = $loItem->listValue();
	
	$lcPrompt = $lcHostname;
	$loServerSelect->addValue( new KeyValue( 'server_to_search', $lcServerID ),
														 new KeyValue( 'name', $lcPrompt )
														 );
 }

$loServerSelect->addValue( new KeyValue( 'server_to_search', '' ),
													 new ValueLocale('ll_all' ) );
														 
$dsSearch->addValue( $loServerSelect );
$dsSearch->addValue( new ValueLocale( 'll_search' ) );
$dsSearch->addValue( new ValueLocale( 'll_show_all' ) );


$loSearch = new SimpleSearchElement( array(),
																		 new InputTextElement( array( 'name' => 'name_to_search', 
																																	'size' => '16',
																																	'value' => $ip_to_search,
																																	'MAXLENGTH'=> '64' )
																													 ) ,
																		 new HTMLElement( '' ), // prompt
																		 new SelectElement(array( 'name' => 'server_to_search' )), 
																		 new PPButtonElement( '',
																													"javascript:submitForm('start_index',1,$listFormIndex)",
																													'bid-search'
																													),
																		 new PPButtonElement( '',
																													"javascript:setValue('name_to_search','',$listFormIndex);".
																													"javascript:setValue('server_to_search','',$listFormIndex);".
																													"javascript:submitForm('start_index',1,$listFormIndex)",
																													'bid-search'
																													)
																		 );
$loSearch->setDataSource( $dsSearch, array( 'name_to_search' => $name_to_search,
																						'server_to_search' => $server_to_search) );

$tbl->setSearchElement( $loSearch );

$tbl->updateBodyContent();
	
$page = new MainPageElement( $tbl );

$page->OutputHTML( array( '../../js/paged_form.js' ) );

//==============================================================

?>
