<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####
/*{{{*/
include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.SpacesCompoundDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/data/class.PagedSetOfRowsData.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/module.Database.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
/*}}}*/

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "einstellungen_blacklist: _POST<br><pre>\n";
	print_r($_POST); 
	echo "</pre><br>\n";
}

db_connect();

/**
 * Need to perfom action
 */
if( ! empty( $action ) && $action == 'delete' ){
  include_once 'httpd_options_delete.php';
  exit;
}


/**
 * Adds form
 */
$loAddNew = new SetOfRowsData();/*{{{*/
$loAddNew->AppendRow( new HTMLDataField( ltext( 'httpd_options_help_text' ) ) );
$loAddNew->AppendRow( new HTMLDataField( '&nbsp;' ) );
$loAddNew->AppendRow( new ButtonData( ltext( 'httpd_options_add' ) ,
                                      "javascript:doChange()", 
                                      cc_IDAdd 
                                    ) 
                    );

$loAddForm = $loAddNew->GetInputPresentation( array( 'action' => 'httpd_options_change.php'),
																			    		ltext('httpd_options_new')
                                            );
/*}}}*/

/**
 * List 
 */	
									
initPagingSettings ( $_POST, array( 'to_search' => $to_search ) );

$id = safe_query2( "SELECT COUNT(*) AS total FROM httpd_definitions" );
list( $total_number ) = db_fetch_array( $id, 'N');
db_free_query( $id );


$order      =  empty( $order ) ? 'label' : $order;
$direction  =  empty( $direction ) ? 'asc' : $direction;
$lcSqlOrder = '';
$laOrders   = array( 'label' => 'label' );

if( array_key_exists( $order, $laOrders ) ){
	 $lcSqlOrder .= ' ORDER BY '.$laOrders[$order];
}else{
	 $lcSqlOrder .= ' ORDER BY '.$laOrders['label'];
}

if( $direction == 'desc' ){
  $lcSqlOrder .= ' DESC';
}


$lcFields = "id, label";

if( ! istleer( $to_search ) ){
 	$loDb = new SQLValue( $to_search, 'S' );
	$lcWhere = " label LIKE '%?%'";
	$lcSQL = "SELECT COUNT(id) FROM httpd_definitions WHERE ".$lcWhere;

	$loQuery = new SQLQuery( $lcSQL, array( $loDb, $loDb) );

	$loQuery->doQuery();
	list($total_number) = $loQuery->fetchArray('N');

	$lcSQL = "SELECT ".$lcFields." FROM httpd_definitions WHERE ".$lcWhere.$lcSqlOrder;
	$loQuery->Query( $lcSQL );

}else{
	$lcSQL = "SELECT ".$lcFields."  FROM httpd_definitions".$lcSqlOrder;
	$loQuery = new SQLQuery( $lcSQL );
}

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue(  new ValueFromArray( 'label'), 
                                  new ValueFromArray( 'id' ),
                                  new ValueFromArray( 'id' ) 
                               );
$listFormIndex = 1;
$laContent =array();
$laHeaders = array();
$lcDirIcon = ( $direction=='desc' ) ? cc_DescIcon : cc_AscIcon;
$lcNewDir  = ( $direction=='desc' ) ? 'asc' : 'desc';

/**
 * Generate table headers
 */
$laHeaders['label'] = array( 'label' => 'httpd_option_label', 'sort' => true );
$laHeaders['edit']  = array( 'label' => 'll_edit',            'sort' => false );

/**
 * Column widths
 */

$laWidths = array( '90%', '5%', '5%' );

foreach( $laHeaders as $lcKey => $laValue ){ /*{{{*/
  if( $laValue['sort'] ){ 
    if( $order == $lcKey ){ 
      $loContent = new CompoundDataField( new HTMLDataField( ltext( $laValue['label'] ) ), 
                                          new IconDataField( $lcDirIcon ) 
                                        ); 
      $loContent->SetSeparator( '' ); 
    }else{ 
      $loContent = new HTMlDataField( ltext( $laValue['label'] ) ); 
    } 
    $loLink = new LinkDataField( "javascript:setValue('order', '$lcKey',$listFormIndex);". 
                                 "setValue('start_index',1,$listFormIndex);". 
                                 "submitForm('direction','$lcNewDir',$listFormIndex)", 
                                 '', array(), $loContent );
    $laContent[] = new DataValue( $lcKey, NULL, $loLink );
  }else{ 
    $laContent[] = new ValueLocale( $laValue['label'] ); 
  } 
}/*}}}*/

$loTitle = new CompoundValue( $laContent ); 
$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('httpd_ids', this.checked, $listFormIndex)");
$loCheckBox->SetParentAttributes(array('align'=>'center'));
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

$loTitle->addValue( $loSelValue );

$loDS->Template( $loTemplate );

//==============================================================
// Begin call-back functions to make visble objects

function makeAction( $poSrc ){/*{{{*/
	global $listFormIndex, $confixx_interface_version;
	$lcText = ltext('ll_change');
	$loActions = new LinkDataField( "httpd_options_change.php", 
																	'', 
																	array('httpd_id' => $poSrc ), 
                                  ( $confixx_interface_version == 'powp' ) 
                                  ? new IconDataField( cc_ChangeIcon )
                                  : $lcText 
                                );
	$loActions->Attribute( 'title', ltext('ll_change')  );
	$loActions->ParentAttribute( 'align','center');
	return $loActions;
}/*}}}*/

function makeSelect( $id ){/*{{{*/
	$loCheckBox = new CheckDataField( $id, 'httpd_ids[]');
	$loCheckBox->ParentAttribute('align','center');
	return array( $loCheckBox->GetInputPresentation(), array('align'=>'center'));
}/*}}}*/

// end call-back functions to make visble objects
//==============================================================

$loConv = new CompoundValue( NULL, 
                             new ValueFormated( 'edit', NULL, 'makeAction' ),
                             new ValueFormated( 'id', NULL, 'makeSelect' ));

$loDS->Conversion( $loConv );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'httpd_id', '' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );
$loPTV->Anchor( 'list' );

$loPTV->FormIndex( $listFormIndex );

if( isset( $to_search ) && strlen( $to_search ) ){
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
}else{
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}


$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'httpd_options.php#list',
																						 'name' => 'list_httpd_options' ), 
																			ltext('m_httpd_options') );

$dsSearch = new CompoundValue( new ValueFromArray( 'to_search', $to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );

$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'to_search', 
																																	'size' => '16',
																																	'value' => $to_search,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );
	
$loGroup = new DivElement(array('class'=>'buttons'));
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,$listFormIndex)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('to_search','',$listFormIndex);".
																							 "submitForm('start_index',1,$listFormIndex)", 
																							 'bid-show-all'
																							 ) 
													);

$head_text = ltext('ll_delete');

$loGroup->AppendToContent( new PPButtonElement( $head_text, 
                                                "javascript:submitForm('action','delete',$listFormIndex);",
                                                'bid-delete')
													 );
	
$loSearch->setDataSource( $dsSearch, array( 'to_search' => $to_search ) );

if( ( isset( $to_search ) && strlen( $to_search ) ) || $total_number > 0 ){
	$tbl->setSearchElement( $loSearch );
}
if( $total_number > 0 ){
	$tbl->setGroupActionElement( $loGroup );
}

$tbl->updateBodyContent();
$go_Page = new MainPageElement( 
$loAddForm, $tbl  );
																					
$go_Page->OutputHTML( array( '../../js/paged_form.js' ) );

db_close();
?>
