<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com ##### 

include_once( 'class.InputDecode.php' );
include_once( "../include/module.DNSTemplate.php" );
include_once( "../events.inc.php" );
include_once( "../include/event_functions.php" );
include_once( "../include/class.Page.php" );
include_once( "idn_functions.php" );
include_once( "../include/module.url.inc.php" );
include_once( '../include/class.HOStates.php' );

global $DEBUG;
//$DEBUG=1;

//
// global variables
//


$goKunde  = new SQLString( $kunde );
$goServerID = new SQLString( $server_id );
if( ! ( isset( $anbieter ) && $anbieter ) ){
	$id = safe_query2( "SELECT anbieter FROM kunden WHERE kunde=? AND server_id=?".
										 $goKunde, $goServerID );

	list( $anbieter ) = db_fetch_array( $id, 'N' );
	db_free_query( $id );
 }
$goUser = new SQLString( $anbieter );

//
// change user's IP
//

function updateIP( $ip, $exclusiv ) {/*{{{*/
	global $fehlertext,$fehlertitel,$kunde;
	global $goUser, $goKunde;
	global $goServerID;
	
	$id = safe_query2( "SELECT standardip FROM anbieter WHERE anbieter=? AND server_id=?",
										 $goUser, $goServerID);
	list( $standardIP ) = db_fetch_array( $id );
	db_free_query( $id );

	$id = safe_query2( "SELECT standardip, neukundenreload FROM admin WHERE server_id=?", $goServerID );
	list( $adminIP, $neukundenreload) = db_fetch_array( $id, 'N' );
	db_free_query( $id );

	if( ! $standardIP ) {
		$standardIP = $adminIP;
	}

	if( $ip == 'standard' ){
		$ip = $standardIP;
		$loIP = new SQLString($ip);
    db_query( "UPDATE ipadressen SET kunde = '' WHERE kunde = ? AND server_id=?", $goKunde, $goServerID);

	} else {
		$loIP = new SQLString($ip);
		$id = safe_query2( "SELECT COUNT(ip) FROM ipadressen WHERE anbieter=? AND ip=? AND (kunde='' OR kunde=?) AND server_id=?",
											 $goUser, $loIP, $goKunde , $goServerID);
		list($count) = db_fetch_array( $id );
		db_free_query( $id );

		if( ! $count ) {
      $fehlertext = ltext("kudoup_error6");
			return 0;
		}
		if( $exclusiv == 1 ){
			$id = safe_query2( "SELECT COUNT(ip) FROM kunden WHERE ip = ? AND kunde != ? AND server_id=?", $loIP, $goKunde, $goServerID);
			list( $count ) = db_fetch_array( $id );
			if ( $count>0 ){
				$fehlertext = ltext( 'kudoup_error7' );
				return 0;
			}

			safe_query2( "UPDATE ipadressen SET kunde = '' WHERE kunde = ? AND anbieter = ? AND server_id=?",
									 $goKunde, $goUser, $goServerID);

			safe_query2( "UPDATE ipadressen SET kunde = ? WHERE ip = ? AND anbieter=? AND server_id=?",
									 $goKunde, $loIP, $goUser, $goServerID );

		} else {
			safe_query2( "UPDATE ipadressen SET kunde = '' WHERE kunde = ? AND anbieter = ? AND server_id=?",
									 $goKunde, $goUser, $goServerID);
		}
	}
	
	$id = safe_query2( "SELECT ip FROM kunden WHERE kunde=? AND server_id=?", $goKunde, $goServerID );
	list( $oldIP ) = db_fetch_array( $id );
	db_free_query( $id );

	safe_query2( "UPDATE kunden SET ip=?, httpd=1 WHERE kunde=? AND anbieter=? AND server_id=?",
							 $loIP, $goKunde, $goUser, $goServerID );
	safe_query2( "UPDATE allgemein SET httpd=1 WHERE server_id=?",
							 $goServerID );

  $fehlertitel = ltext( 'errtype_notice' );
  $fehlertext = ltext( 'msg_saved_data' );

	//
	// change DNS info
	//
	$liResellerDNS = 0;
  $id = safe_query2( "SELECT dns FROM anbieter WHERE anbieter=? AND server_id=?", $goUser, $goServerID );
	list( $liResellerDNS ) = db_fetch_array( $id );
	db_free_query( $id );

	if( ( $oldIP != $ip )&&( $liResellerDNS == 1 ) ) {
		$id = safe_query2("SELECT domain, dns FROM domains WHERE kunde=? AND richtigedomain=1 AND server_id=?", $goKunde, $goServerID);
		while( list( $domain, $dns ) = db_fetch_array( $id, 'N' ) ) {
			updateDNS( $domain, $dns );
		}
		db_free_query( $id );
	}

	return 1;
}/*}}}*/

//
// update DNS info for the domain ( on/off)
//

function updateDNS( $domain, $dns ){/*{{{*/
	global $goUser, $goKunde;
	global $fehlertext,$fehlertitel;
	global $DEBUG;
	global $goServerID, $server_id;
	global $kunde, $PHP_AUTH_USER, $anbieter;
	if($DEBUG){
		echo "updateDNS: domain=$domain, dns=$dns<br>\n";
	}
	$id = safe_query2( "SELECT dns, standardip, dnsspezial FROM anbieter WHERE anbieter=? AND server_id=?",
										 $goUser, $goServerID);
	list( $skdns, $standardip, $dnstemplate ) = db_fetch_array( $id, 'N');
	db_free_query( $id );

	if( $skdns == 0 ){
		$fehlertext = "Reseller can't setting up DNS";
		return 0;
	}

	if( is_numeric( $domain ) ){
		$domain_id = $domain;
		$id = safe_query2( "SELECT domain FROM domains WHERE id=? AND server_id=?", new SQLInteger($domain_id), $goServerID);
		list( $domain ) = db_fetch_array( $id );
		db_free_query( $id );
	}
	$loDomain = new SQlString( $domain );

	if( $dns ){

		if( ! $standardip ){
			$id = safe_query2( "SELECT standardip FROM admin WHERE server_id=?" );
			list( $standardip ) = db_fetch_array( $id, 'N');
			db_free_query( $id );
		}
		
		$id = safe_query2( "SELECT ip FROM kunden WHERE kunde=? AND server_id=?",$goKunde, $goServerID);
		list($ip) = db_fetch_array($id);
		db_free_query( $id );
		if( ! $ip ) {
			$ip = $standardip;
		}

		list( $zonefile, $seriennummer ) = ff_ProcessTemplate( array( $anbieter,
																																	$server_id ),
																														$domain,
																														$ip,
																														NULL,
																														$dnstemplate,
																														$pns,
																														$sns );
		$id = safe_query2( "SELECT COUNT(*) FROM dns WHERE domain=? AND server_id=?", $loDomain, $goServerID);
		list( $count ) = db_fetch_array($id);
		db_free_query( $id );
		
		$loFields = new SQLFieldSet(array( 'zonefile' => array( $zonefile, 'C' ),
																			 'lastchange' => $seriennummer,
																			 'neu' => 1,
																			 'kunde' => array( $kunde, 'C' ),
																			 'anbieter' => array( $anbieter, 'C' )
																			 )
																);
		
		if ( $count > 0 ) {
			$sql = "UPDATE dns SET ".$loFields->getSQLUpdate()." WHERE domain=? AND server_id=?";
		} else {
			list( $lcFlds, $lcVals ) = $loFields->getSQLInsert();
			$sql = "INSERT INTO dns ($lcFlds,domain, server_id) VALUES ($lcVals,?, ?)";
		}

		safe_query2( $sql, $loDomain, $goServerID );

	} else {
    safe_query2( "UPDATE dns SET neu=2, kunde=?, anbieter=? WHERE domain = ? AND server_id=?",
								 $goKunde, $goUser, $loDomain, $goServerID );

	}

	safe_query2( "UPDATE allgemein SET dns=1 WHERE server_id=?", $goServerID );
	
}/*}}}*/


//
// send DNS request for the domain
//

$gaUser = array();
$gaReseller = array();

function sendDNSRequest( $domain ){/*{{{*/
	global $goKunde, $goUser, $kunde;
	global $fehlertext, $fehlertitel;
	global $gaUser, $gaReseller;
	global $goServerID;
	
	global $dnr_c_firstname,$dnr_c_gender,$dnr_c_plz,$dnr_c_land,$dnr_c_name,$dnr_c_firma,
		$dnr_c_anschrift,$dnr_c_ort,$dnr_c_telefon,$dnr_c_telefax,$dnr_c_emailadresse,
		$dnr_d_domain,$dnr_d_pns,$dnr_d_sns;

	global $dnr_a_firstname,$dnr_a_gender,$dnr_a_plz,$dnr_a_land,$dnr_a_name,$dnr_a_firma,
		$dnr_a_anschrift,$dnr_a_ort,$dnr_a_telefon,$dnr_a_telefax,$dnr_a_emailadresse;

	
	if( !file_exists("../dnr.php") ) {
		return 0;
	}
	include_once("../dnr.php");

	if( is_numeric( $domain ) ) { 
		$domain_id = $domain;
		$id = safe_query2( "SELECT domain FROM domains WHERE id=? AND server_id=?", new SQLInteger($domain_id), $goServerID);
		list( $domain ) = db_fetch_array( $id );
		db_free_query( $id );
	}

	
	$loDomain = new SQLString( $domain );
	safe_query2 ( "UPDATE domains SET dnr=1 WHERE domain=? AND kunde=? AND anbieter=? AND server_id=?",
								$loDomain, $goKunde, $goUser, $goServerID );

	if( !count( $gaReseller ) ) {
		$id = safe_query2( "SELECT gender,plz,firstname,land,name,firma,anschrift,plzort,".
											 "telefon,fax,emailadresse,pns,sns FROM anbieter WHERE anbieter = ? AND server_id=?", $goUser, $goServerID);

		$gaReseller = db_fetch_array($id);
		db_free_query( $id );
	}

	$dnr_a_firstname    = $gaReseller['firstname'];
	$dnr_a_gender       = $gaReseller['gender'];
	$dnr_a_plz          = $gaReseller['plz'];
	$dnr_a_land         = $gaReseller['land'];
	$dnr_a_name         = $gaReseller['name'];
	$dnr_a_firma        = $gaReseller['firma'];
	$dnr_a_anschrift    = $gaReseller['anschrift'];
	$dnr_a_ort          = $gaReseller['plzort'];
	$dnr_a_telefon      = $gaReseller['telefon'];
	$dnr_a_telefax      = $gaReseller['fax'];
	$dnr_a_emailadresse = $gaReseller['emailadresse'];

	$pns = $gaReseller['pns'];
	$sns = $gaReseller['sns'];


	if( ! count( $gaUser ) ){
		$id = safe_query2( "SELECT gender,plz,firstname,land,name,firma,anschrift,plzort,".
										 "telefon,fax,emailadresse FROM kunden WHERE kunde = ? AND server_id=?", $goKunde, $goServerID );

		$gaUser = db_fetch_array($id);
		db_close( $id );
	}

	$dnr_c_firstname    = $gaUser['firstname'];
	$dnr_c_gender       = $gaUser['gender'];
	$dnr_c_plz          = $gaUser['plz'];
	$dnr_c_land         = $gaUser['land'];
	$dnr_c_name         = $gaUser['name'];
	$dnr_c_firma        = $gaUser['firma'];
	$dnr_c_anschrift    = $gaUser['anschrift'];
	$dnr_c_ort          = $gaUser['plzort'];
	$dnr_c_telefon      = $gaUser['telefon'];
	$dnr_c_telefax      = $gaUser['fax'];
	$dnr_c_emailadresse = $gaUser['emailadresse'];
	## domaindaten:
	$dnr_d_domain       = $domain;
	$dnr_d_pns          = $pns;
	$dnr_d_sns          = $sns;
                    ## adminvariablen:
	sendDnr();
	
	return 1;
}/*}}}*/

//
// append new domain
//

function appendDomain( $domain, $dns, $dnr ){/*{{{*/
	global $goUser, $goKunde;
	global $fehlertext,$fehlertitel,$kunde, $anbieter;
	global $db_type;
	global $server_id, $goServerID;

	$goServerID = new SQLString( $server_id );

	$id = safe_query2( "SELECT standarddomain, idn, userprefix,standardip ".
										 " FROM admin WHERE server_id=?", 
										 $goServerID );
	$werte = db_fetch_array( $id, 'A' );
	db_free_query( $id );

	$stddomain = $werte['standarddomain'];
	$user_prefix = $werte['userprefix'];
	$idn_support = $werte['idn'];
	$stdip = $werte['standardip'];

	$id = safe_query2( "SELECT maxdomains, maxdomainslimit, httpdspezial, dns, dnr,standardip ".
											" FROM anbieter WHERE anbieter=? AND server_id=?",
										 $goUser, $goServerID );

	$werte = db_fetch_array($id);
	db_free_query( $id );

	$maxdomains = $werte['maxdomains'];
	$maxdomainslimit = $werte['maxdomainslimit'];
	$httpdspezial = $werte['httpdspezial'];
	$skdns = $werte['dns'];
	$skdnr = $werte['dnr'];
	if( ! $stip ){
		$stip = $werte['standardip'];
	}

	$id = safe_query2( "SELECT ip FROM kunden WHERE kunde=? AND server_id=?",
										 $goKunde, $goServerID );
	list($ip) = db_fetch_array($id);
	db_free_query( $id );

	if( ! $ip ){
		$ip = $stip;
	}


#
# check if reseller can add the new domain
#
	$id = safe_query2( "SELECT COUNT(domain) FROM domains WHERE anbieter=? AND richtigedomain=1 AND server_id=?",
										 $goUser, $goServerID );
	list($count) = db_fetch_array( $id );
	db_free_query( $id );
	
	if (($count >= $maxdomains) && ( $maxdomainslimit == 1) && ( $maxdomains >=0 ) ) {
		$fehlertext = ltext("kudoup_error3",array($maxdomains,$anzahldomains));
		return 0;
	}

	
#
# IDN
#
	$lcTmp = $domain;
	$lcDomainTranslated = InputDecode::decode( $domain );
	if ( $domain != $lcDomainTranslated ) {
		if ( $idn_support ) {
			// has national characters
			$domain = translate_name_to_idn($lcDomainTranslated); 
		} else {
			// has national characters, but there are no IDN support
			// try to get name from database
			$res_idn = safe_query2( "SELECT COUNT(d.domain) FROM domains d, idn_aliases idn WHERE ".
															"idn.domain_id = d.id AND idn.idn_name = ? AND idn.server_id=? AND d.server_id=?",
															new SQLString($lcDomainTranslated), $goServerID, $goServerID );
			list( $cnt ) = db_fetch_array( $id, 'N' );
			db_free_query( $id );
			if( $cnt ){
				$fehlertext = ltext( 'kudoup_error4', array( $lcDomainTranslated ) );
				return 0;
			} else {
				$fehlertext = ltext('error_bad_domains__no_idn_support', array( $domain ));
				return 0;
			}
		}
	} else {
		$lcDomainTranslated = '';
	}


#
# check syntax
#
  $domain = strtolower(trim($domain));

	if ( ! checkDomain( $domain ) || 
					 preg_match( '/^www\./', $domain ) 
					 ) {
		
		$fehlertext = ltext("kune5_error19", array($domain));
		return 0;
  }

	$dname_regexp = "/${user_prefix}[0-9]+\." . str_replace('.', '\.', $stddomain) . "/i";
	if(preg_match($dname_regexp, $domain)){
		$fehlertext = ltext("kune5_error23", array( $omain, $user_prefix, $stddomain));
		return 0;
	}


#
# check if there is this domain already
#
	$loDomain = new SQLString( $domain );
  $id = safe_query2( " SELECT COUNT(domain) FROM domains ".
                     " WHERE domain=? AND ( richtigedomain <> 7 OR  kunde = ?  )", 
                      $loDomain, $goKunde );
	
	list($count) = db_fetch_array( $id );
	db_free_query( $id );

	if( $count ){
		$fehlertext = ltext( 'kudoup_error4', array( $domain ) );
		return 0;
	}
	
	$timestamp = time();
	$dns = $dns && $skdns;
	$dnr = $dnr && ( $skdns && $skdnr );
	
	$sql = "INSERT INTO domains (domain, kunde, anbieter, richtigedomain, pfad, ".
		"lastchange, zusatz, dns, dnr, server_id) ".
		" VALUES (?, ?, ?, 1, '/', $timestamp, ?, ?, ?, ?)";

	$loSpezial = new SQLString( $httpdspezial );
	$res1 = safe_query2( $sql,
											 $loDomain, $goKunde, $goUser, 
											 $loSpezial, new SQLInteger($dns), 
											 new SQLInteger( $dnr), $goServerID );
	if( $db_type == 'mysql' ){
		$id1  = db_insert_id( $res1 );
	}else{
		$id1  = db_insert_id( 'domains','id');
	}

	domain_aendern( $domain, 'anlegen', $kunde, $server_id );
	fpalias_aendern( $domain, 'anlegen', $kunde, $server_id );

	$sql = "INSERT INTO domains (domain, kunde, anbieter, richtigedomain, pfad, ".
		"lastchange, zusatz, dns, dnr, server_id) VALUES (?, ?, ?, 2, '/', $timestamp, ?, 0, 0, ?)";
	$res2 = safe_query2( $sql, 
											 new SQLString( 'www.'.$domain ), $goKunde, $goUser,
											 $loSpezial, $goServerID );

	if( $db_type == 'mysql' ){
		$id2  = db_insert_id( $res2 );
	}else{
		$id2  = db_insert_id('domains','id');
	}
	db_free_query( $res2 );

	safe_query2("UPDATE domains SET grp=id WHERE richtigedomain IN (1,2) ".
							" AND grp!=id AND kunde=? AND server_id=?", $goKunde, $goServerID );

	domain_aendern( 'www.'.$domain, 'anlegen', $kunde, $server_id );
	fpalias_aendern( 'www.'.$domain, 'anlegen', $kunde, $server_id );

	if( $lcDomainTranslated ) {
			include_once('idn_functions.php');
//		save_idn_alias($id1, $lcDomainTranslated, false);
//		save_idn_alias($id2, 'www.'.$lcDomainTranslated, false);
			save_idn_alias( $id1, $lcTmp, false, $server_id );
			save_idn_alias( $id2, 'www.'.$lcTmp, false, $server_id );
	}

	if( $dns ){
		updateDNS( $domain, $dns );
	}
	if( $dnr ){
		sendDNSRequest( $domain );
	}

## //
  set_countdomains( $kunde, $server_id );
## //

  $loHOStates = new HOStates( $server_id, $anbieter );
  $loHOStates->setDefaultsForDomain( $domain );
  $loHOStates->setDefaultsForDomain( 'www.'.$domain );


  safe_query2( "UPDATE kunden SET changedomains = 1, httpd=1 WHERE kunde = ? AND anbieter = ? AND server_id=?",
							 $goKunde, $goUser, $goServerID );

  if ( $neukundenreload == 1 ) {
    safe_query2("UPDATE allgemein SET httpd=1, httpdupdate=0,webalizer=1 WHERE server_id=?",
								$goServerID);
  } else{
    safe_query2("UPDATE allgemein SET httpd=1,webalizer=1 WHERE server_id=?",
								$goServerID);
  }

	changeWebalizer( $goKunde, $goUser, $goServerID );

	return 1;
}/*}}}*/
/**
 * New shared domain
 */
function appendSharedDomain( $domain ){/*{{{*/

	global $goUser, $goKunde;
	global $fehlertext,$fehlertitel,$kunde;
	global $user_prefix;
  global $ServerID;
  global $goServerID;
	global $DEBUG;

  $id = db_query( "SELECT standarddomain, idn, userprefix,standardip FROM admin WHERE server_id=?", $goServerID );
	$werte = db_fetch_array($id);
	db_free_query( $id );

	$stddomain = $werte["standarddomain"];
	$user_prefix = $werte["userprefix"];
	$idn_support = $werte["idn"];
	$stdip = $werte["standardip"];

	$lrId = safe_query2( " SELECT maxshareddomains, maxshareddomainslimit ".
											 " FROM anbieter WHERE anbieter=? AND server_id=?",
											 $goUser, $goServerID );

	$laRow = db_fetch_array( $lrId );
	db_free_query( $lrId );

 /**
  * check if reseller can add the new domain
  */
  $lrId = safe_query2( " SELECT COUNT(domain) FROM domains WHERE anbieter=? ".
                       " AND richtigedomain=7 AND server_id=?",
										 $goUser, $goServerID );
	list( $liCount ) = db_fetch_array( $lrId );
	db_free_query( $lrId );

  if( $liCount >= $laRow['maxshareddomains']  
      && $laRow['maxshareddomainslimit'] == 1 
      && $laRow['maxshareddomains'] >=0 ){
		$fehlertext = ltext("kudoup_error9",array($maxshareddomains,$liCount ) );
		return 0;
	}
  
/**
 * IDN
 */
	$lcTmp = $domain;
  $lcDomainTranslated = InputDecode::decode( $domain );
	if ( $domain != $lcDomainTranslated ) {
		if ( $idn_support ) {
			// has national characters
			$domain = translate_name_to_idn($lcDomainTranslated); 
		} else {
			// has national characters, but there are no IDN support
			// try to get name from database
			$res_idn = safe_query2( " SELECT d.domain FROM domains d, idn_aliases idn WHERE ".
                              " idn.domain_id = d.id AND idn.idn_name = ? ".
                              " AND idn.server_id=? AND d.server_id=?",
															new SQLString($lcDomainTranslated), $goServerID, $goServerID );
			if (db_num_rows($res_idn) > 0) {
				$fehlertext = ltext("kudoup_error4",array( $lcDomainTranslated ) );
				return 0;
			} else {
				$fehlertext = ltext('error_bad_domains__no_idn_support', array( $domain ));
				return 0;
			}
			db_free_query( $res_idn );
		}
	} else {
		$lcDomainTranslated = '';
	}

 /**
  * check syntax
  */
  $domain = strtolower(trim($domain));
  if( ! checkDomain( $domain ) 
    || preg_match( '/^www\./', $domain ) ){
		$fehlertext = ltext("kune5_error19", array($domain));
		return 0;
  }
   
	$dname_regexp = "/${user_prefix}[0-9]+\." . str_replace('.', '\.', $stddomain) . "/i";
	if(preg_match($dname_regexp, $domain)){
		$fehlertext = ltext("kune5_error23", array( $omain, $user_prefix, $stddomain));
		return 0;
	}


 /**
  * check if there is this domain already
  */
	$loDomain = new SQLString( $domain );
  $id = safe_query2( " SELECT COUNT(domain) FROM domains ".
                     " WHERE  domain = ? AND ( kunde = ? OR richtigedomain=5 )", 
                     $loDomain, $goKunde );
	list($count) = db_fetch_array( $id );
	db_free_query( $id );

	if( $count ){
		$fehlertext = ltext("kudoup_error4",array($domain));
		return 0;
	}
	
	$timestamp = time();
	
	$sql = " INSERT INTO domains (domain, kunde, anbieter, richtigedomain, pfad,".
         " lastchange, zusatz, dns, dnr, server_id, httpd)". 
         " VALUES (?, ?, ?, 7, '', $timestamp, '', '', '', ?, 0)";

  $res1 = safe_query2( $sql, $loDomain, $goKunde, $goUser, $goServerID );

	global $db_type;
	db_free_query($res1);

  global $db_type;
	if($db_type=='mysql'){
		$id1  = db_insert_id( $res1 );
	}else{
		$id1  = db_insert_id( 'domains','id');
	}
  db_free_query($res1);
  if( $lcDomainTranslated ) {
			include_once('idn_functions.php');
		save_idn_alias($id1, $lcTmp, false);
	}
	return 1;
}/*}}}*/

function changeWebalizer( &$goKunde, &$goUser, &$goServerID ){/*{{{*/

	$id = safe_query2( "SELECT COUNT(*) FROM webalizer WHERE neu=1 AND server_id=?".
										 " AND kunde=? AND anbieter=?",
										 $goServerID, $goKunde, $goUser
										 );
	list( $cnt ) = db_fetch_array( $id, 'N' );
	db_free_query( $id );
	if( ! $cnt ){
		safe_query2( "INSERT INTO webalizer( loeschen, neu, server_id ,kunde, anbieter)".
								 " VALUES( 0, 1, ?, ?, ? )",
								 $goServerID, $goKunde, $goUser );
	}
}/*}}}*/


//
// batch deleting of domains
//

function deleteDomains( &$domain_ids, $update_db = FALSE ){/*{{{*/
	global $goUser, $goKunde;
	global $kunde, $anbieter;
	global $goServerID, $server_id;

	$laToDelete = array();

  if( ! is_array( $domain_ids ) ){
    $domain_ids = array();
  }
  
	foreach( $domain_ids as $id) { // loop by domains

		$loDomainID = new SQLInteger( $id );

		//
		// DNS update
		//

		$sql = "SELECT d.domain, d.dns, d.dnr, dns.neu, not(dns.kunde IS NULL) AS dns_inserted ".
			" FROM domains d  LEFT JOIN dns ON dns.domain=d.domain AND dns.kunde=d.kunde AND dns.server_id=d.server_id".
			" WHERE d.richtigedomain IN( 1,7) AND d.kunde = ? AND d.anbieter=? AND d.id = ? AND d.server_id=?";
		$res = safe_query2( $sql, $goKunde, $goUser, $loDomainID, $goServerID );
		list( $domain, $dns, $neu, $dns_inserted ) = db_fetch_array( $res, 'N' );
		db_close( $res );

		if( $update_db && $dns ){ // switch off DNS
			updateDNS( $domain, 0 );
		}
		
		//
		// get list of subdomains
		//

		$laSubdomains = array();
		$loDomains = new SQLFieldSet();

		$res = safe_query2( "SELECT domain, id FROM domains WHERE richtigedomain NOT IN (1,7)  AND ".
												"kunde=? AND anbieter=? AND domain LIKE ?  AND server_id=?",
												 $goKunde, $goUser, new SQLString('%.'.$domain), $goServerID );
		while(list($subdomain,$subid) = db_fetch_array( $res ) ){
			$laSubdomains[$subdomain] = $subid; 
			$loDomains->addField( $subid, $subdomain, 'C');
		}
		db_close( $res );

		$laToDelete[$domain] = array($laSubdomains);

		$laSubdomains[$domain] = $id; 
		$loDomains->addField( $id, $domain, 'C');
		
		$lcDomains = $loDomains->getSQLValues();

		//
		// get list of emails
		//
		$laEmails = array();
		$res = safe_query2( "SELECT ident, prefix, domain FROM email WHERE domain IN ($lcDomains) ".
												"AND kunde = ? AND anbieter = ? AND server_id=?",
												$goKunde, $goUser, $goServerID );
		while( list( $ident,$prefix,$edomain ) = db_fetch_array( $res, 'N' ) ) {
			$laEmails[$prefix.'@'.$edomain] = $ident;
		}
		db_close( $res );

		$laToDelete[$domain][] = $laEmails;

		if( $update_db && count( $laEmails ) ) {
			$loFields = new SQLFieldSet( array( 'account' => array( '','C'),
																					'type' => array( 'alias','C'),
																					'kunde' => array( $kunde, 'C'),
																					'pfad' => array( '', 'C' )
																					)
																	 );
			$lcFlds = $loFields->getSQLNames();
			foreach( $laEmails as $email => $ident ) {

				list( $prefix, $edomain ) = split( '@', $email, 2 );

				$loFields->updateField( 0, $prefix );
				$loFields->updateField( 3, $edomain );

				$lcVals = $loFields->getSQLValues();

				safe_query2( "INSERT INTO delaccs( $lcFlds, server_id ) VALUES ( $lcVals, ? )" , $goServerID);
			}							 
			
			$lcIDs = join(',',array_values($laEmails));

      safe_query2( " DELETE FROM autoresponder WHERE kunde=? AND ident IN ($lcIDs) ".
                   " AND server_id=?", $goKunde , $goServerID);					 
      safe_query2( " DELETE FROM email WHERE kunde=? AND anbieter=? ".
                   " AND ident IN ($lcIDs) AND server_id=?", $goKunde, $goUser, $goServerID );					 
      safe_query2( " DELETE FROM email_forward WHERE kunde=? AND email_ident ".
                   " IN ($lcIDs) AND server_id=?", $goKunde, $goServerID );					 

		}

		//
		// get list of at-domains
		//
		$lcDomainIDs = join(',',array_values($laSubdomains));
		$laAtDomains = array();
		$res = safe_query2( "SELECT a.id, a.name, d.domain FROM atdomains a, domains d ".
												" WHERE d.kunde =? AND d.anbieter=? ".
												" AND a.id_from=d.id AND d.id IN ( $lcDomainIDs ) AND a.server_id=? AND d.server_id=?",
												$goKunde, $goUser, $goServerID, $goServerID );
		while( list( $atid,$name,$atdomain ) = db_fetch_array( $res, 'N' ) ){
			$laAtDomains[$name.'@'.$atdomain] = $atid;
		}
		db_close( $res );

		$laToDelete[$domain][] = $laAtDomains;

		if( $update_db && count( $laAtDomains ) ) {
			$lcIDs = join(',',array_values($laAtDomains));
			safe_query2( "DELETE FROM atdomains WHERE id IN ($lcIDs) AND server_id=?", $goServerID );
		}

		//
		// get list of maillists
		//
		$laMailists = array();

		$res = safe_query2( "SELECT m.id, m.name, d.domain FROM maillist m, domains d ".
												" WHERE m.domain_id=d.id ".
												" AND d.id IN ( $lcDomainIDs ) AND kunde=? AND anbieter=? AND d.server_id=? AND m.server_id=?",
												$goKunde, $goUser, $goServerID, $goServerID );
		while( list( $mlid, $name, $mldomain ) = db_fetch_array( $res, 'N' ) ){
			$laMaillists[$name.'@'.$mldomain] = $mlid;
		}
		db_close( $res );


		$laToDelete[$domain][] = $laMaillists;


		if( $update_db && count( $laMaillists ) ) {
			MailListPage::deleteLists ( array_values($laMaillists), $server_id );
		}

		if( $update_db ) {

      $loHOStates = new HOStates( $server_id, $anbieter );
      foreach( $laSubdomains as $liId ){
        $loHOStates->dropForDomain( $liId );
      }
			
      foreach( array_keys($laSubdomains) as $domain ) {
				domain_aendern( $domain, 'loeschen', $kunde, $server_id );
				fpalias_aendern( $domain, 'loeschen', $kunde, $server_id );
			}

			safe_query2( "DELETE FROM idn_aliases WHERE domain_id IN ( $lcDomainIDs )  AND server_id=?", $goServerID);		

			safe_query2( "DELETE FROM domains WHERE id IN ($lcDomainIDs) AND kunde=? AND anbieter=? AND server_id=?",
									 $goKunde, $goUser, $goServerID );
		}
	}

	if( $update_db ) {
		$res = safe_query2("SELECT neukundenreload FROM admin WHERE server_id=?", $goServerID);
		list( $neukundenreload ) = db_fetch_array($res);
		db_free_query( $res );

		safe_query2("UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id=?", $goKunde, $goServerID);

		if( $neukundenreload == 1 ){
			safe_query2( "UPDATE allgemein SET dns=1, httpd=1, httpdupdate=0, aliases = 1,webalizer=1 WHERE server_id=?",
									 $goServerID);
		} else {
			safe_query2( "UPDATE allgemein SET dns=1, httpd=1, aliases=1, webalizer=1 WHERE server_id=?",
									 $goServerID);
		}

		set_countdomains( $kunde, $server_id );

		safe_query2( "UPDATE kunden SET changedomains = 1 WHERE kunde = ? AND anbieter=? AND server_id=?", 
								 $goKunde, $goUser, $goServerID );

		changeWebalizer( $goKunde, $goUser, $goServerID );
	} else {

		if($DEBUG){
			/*
			 echo "<br><pre>\n";
			 print_r($laToDelete);
			 echo "</pre><hr>\n";
			*/
		}

		if( count( $laToDelete ) ) {
			$loRD = new SetOfRowsData();
			foreach ( $laToDelete as $domain => $laItems ) {
				if ( $idn_str = get_html_idn_name( $domain ) ) {
					$domain = $idn_str;
				}

				$loRD->AppendHeaderRow( new HTMLDataField($domain) );

				list($laSubDomains,$laEmails,$laAtDomains,$laMailLists) = $laItems;

				if(count($laSubDomains)){
					$loRD->AppendHeaderRow( new HTMLDataField( ltext('kudoup_title4') ) );
					foreach($laSubDomains as $subdomain => $id){
						if( $idn_str = get_html_idn_name( $subdomain ) ) {
							$subdomain = $idn_str;
						}

						$loRD->AppendRow( new HTMLDataField($subdomain));
					}
				}

				if(count($laEmails)){
					$loRD->AppendHeaderRow( new HTMLDataField( ltext('kudoup_title5') ) );
					foreach($laEmails as $email => $id){
						$loRD->AppendRow( new HTMLDataField($email));
					}
				}

				if(count($laMailLists)){
					$loRD->AppendHeaderRow( new HTMLDataField( ltext('kudoup_title6') ) );
					foreach($laMailLists as $email => $id){
						$loRD->AppendRow( new HTMLDataField($email));
					}
				}

			}
			foreach ($domain_ids as $id){
				$loRD->AppendHidden( new TextDataField( $id, 'domain_ids[]' ) );
			}

			$loRD->AppendHidden( new TextDataField( 1, 'update_db' ) );
			$loRD->AppendHidden( new TextDataField( $kunde, 'kunde' ) );
			$loRD->AppendHidden( new TextDataField( $anbieter, 'anbieter' ) );
			$loRD->AppendHidden( new TextDataField( $server_id, 'server_id' ) );
			$loRD->AppendHidden( new TextDataField( '', 'action' ) );

			$loRD->AppendButton( ltext('kudoup_button1'),
													 "javascript:submitForm('action','delete');",
													 c_IDOK );

			$loForm = $loRD->GetInputPresentation( array( 'action'=>'kunden_domains.php',
																										'method'=>'post',
																										'name' => 'confirm_delete'),
																						 ltext('kudoup_title3').$kunde
																						 );
			$page = new MainPageElement( $loForm );
			$page->OutputHTML( array( '../../js/paged_form.js' ));

			exit;
		}
	}
}/*}}}*/


//
// batch changing of DNS status
//

function batchDNSDNR( &$domain_ids, $dnsdnr ){/*{{{*/
	global $goUser, $goKunde;
	global $DEBUG;
	global $goServerID;
	/*
	if($DEBUG){
		echo "batchDNSDNR: dnsdnr: $dnsdnr<br><pre>\n";
		print_r($domain_ids);
		echo "</pre><hr>\n";
	}
	*/

  if( ! is_array( $domain_ids ) ){
    $domain_ids = array();
  }
    
	foreach ($domain_ids as $id){ // loop by domains

		$id = safe_query2( "SELECT d.domain,d.dns,dns.neu FROM domains d ".
											 " LEFT JOIN dns ON dns.domain=d.domain AND dns.server_id=d.server_id".
											 " WHERE d.kunde=? AND d.anbieter=? AND d.id=? AND d.server_id=?",
											 $goKunde, $goUser, new SQlInteger($id), $goServerID);
		list($domain,$dns,$neu) = db_fetch_array( $id, 'N');
		if( is_null( $neu ) ) {
			$neu = -1;
		} 

		db_close( $id );

		switch( $dnsdnr ){
		case 1:
			if(  !( $neu == 1) ){ // switch on dns
				updateDNS( $domain, 1 );
			}
			break;
		case 2:
			if( $dns && !($neu==2 || $neu==-1) ){ // switch off dns
				updateDNS( $domain, 0 );
			}
			break;
		case 3: // send DNR
			sendDNSRequest( $domain );
			break;
		case 4:
			if( !($neu == 1) ){ // switch on dns & send DNR
				updateDNS( $domain, 1 );
				sendDNSRequest( $domain );
			}
			break;
		}
	}
}/*}}}*/

?>
