<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/

include( 'auth.php' );

include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.ButtonURLData.php' );

include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );

include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

include_once( 'defines.php' );


global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "menuitems.php: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
}

if( !is_numeric( $menublock_id ) ) {
	$fehlertext = ltext( 'cm_wrongid');
	include('custommenu.php');
	exit;
}

db_connect($db_host, $db_user, $db_pass);

$loMenuBlockID = new SQLInteger( $menublock_id );

switch($action){
 case 'new':
	 $action = '';
	 if( !$href ) {
		 $fehlertext = ltext('cm_wronghref');
		 break;
	 }
	 if( !$label ){
		 $fehlertext = ltext('cm_wronglabel');
		 break;
	 }
	 $loFields = new SQLFieldSet( array( 'menublock_id' => $menublock_id,
																			 'label' => array( $label, 'C' ),
																			 'href' => array( $href, 'C' ),
																			 'in_frame' => $in_frame,
																			 'server_id' => array( $masterServerID, 'C')
																			 )
																);
	 list( $lcFlds, $lcVals ) = $loFields->getSQLInsert();
	 db_query( "INSERT INTO menuitem ($lcFlds) VALUES ($lcVals)" );
	 break;
	 
 case 'delete':
	 $action = '';
	 if( is_array( $ids ) ) {
		 $loIDs = new SQLFieldSet();
		 foreach( array_values($ids) as $id ){
			 $loIDs->addField( 'id', $id, 'N' );
		 }

		 if ( $lcIN = $loIDs->getSQLValues() ) {
			 safe_query2( "DELETE FROM menuitem WHERE menublock_id = ? AND server_id='$masterServerID' ".
										" AND id IN ($lcIN)", $loMenuBlockID );
		 }
	 }
	 break;

 case 'in_frame':
	 $action = '';
	 if(is_numeric($item_id)){
		 safe_query2( "UPDATE menuitem SET in_frame=? WHERE menublock_id=? AND id=? AND server_id='$masterServerID'",
								 new SQLInteger( $in_frame ), $loMenuBlockID, new SQLInteger( $item_id ) ); 
	 }
	 break;
 }

$res = safe_query2("SELECT usertype,label FROM menublock ".
									 " WHERE server_id='$masterServerID' AND id=?", $loMenuBlockID );
list($lcUserType, $lcBlockLabel ) = db_fetch_array( $res, 'N');
db_free_query( $res );

//=============================================================
//
// add form

$loDR = new SetOfRowsData();
$loDR->AppendHeaderRow( new HTMlDataField( ltext( 'cm_text' ) ),
												new HTMlDataField( ltext( 'cm_link' ).' *' ), 
												new HTMlDataField( ltext( 'cm_in_frame' ) ), 
												new HTMlDataField( '' ) 
												);

$loDR->AppendRow( new TextDataField( "$label", 'label' ),
									new TextDataField( "$href", 'href' ),
									new CheckDataField( 1, 'in_frame',
																			array(), array( 'align' => 'center' ) ),
									new ButtonData(ltext( 'll_add' ),
																 'javascript:doChange()',cc_IDOk )
									);

$loDR->AppendHidden( new TextDataField( 'new', 'action' ) );
$loDR->AppendHidden( new TextDataField( $menublock_id, 'menublock_id' ) );

$loAddForm = $loDR->GetInputPresentation( array( 'action' => 'menuitems.php',
																								 'method' => 'post',
																								 'name' => 'add_form' ),
																					ltext( 'll_add' )
																					);
$loAddForm->appendHelp( '<b>*</b> '.ltext('cm_parameters') );

// end form
//
//==============================================================
//
// list of menu items

$liFormIndex = 1;

initPagingSettings( $_POST );

$loBlockID = new SQLInteger( $menublock_id );
$res = safe_query2( "SELECT COUNT(*) FROM menuitem WHERE server_id='$masterServerID' AND menublock_id=?",$loBlockID );
list( $total_number ) = db_fetch_array( $res );

$loQuery = new SQLQuery( "SELECT id, label, href, in_frame FROM menuitem WHERE server_id='$masterServerID' AND menublock_id = ? ORDER BY id", new SQLValue( $menublock_id, 'N' ) );

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new ValueFromArray( 'label' ),
																 new ValueFromArray( 'href' ),
																 new CompoundValue( new ValueFromArray( 'in_frame' ),
																										new ValueFromArray( 'id' ) 
																										),
																 new ValueFromArray( 'id' )
																 );

$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute( 'onclick', "javascript:checkedAll('ids', this.checked, $liFormIndex)");
$loCheckBox->AppendParentAttributes( array( 'style'=>'text-align:center;' ) );
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );
$loTitle = new CompoundValue( new ValueLocale( 'cm_text'),
															new ValueLocale( 'cm_link'),
															new ValueLocale( 'cm_in_frame' ),
															$loSelValue
															);

$laWidths = array(  '35%', '40%', '15%','10%' );

$loDS->Template( $loTemplate );

//=======================================================
//
// call-back functions 

function makeHrefLink( $poSrc ){
	$loLink = new LinkDataField( $poSrc, '', array(), new HTMLDataField($poSrc) );
	$loLink->Attribute( 'target', 'href_link' );
	return $loLink;
}

$gcSwitchOffInFrame = ltext( 'cm_in_frame_switch_off' );
$gcSwitchOnInFrame = ltext( 'cm_in_frame_switch_on' );

function makeInFrameButton( $poSrc ){
	global $liFormIndex, $confixx_interface_version;
	global $gcSwitchOffInFrame, $gcSwitchOnInFrame;

	$loInFrame =& $poSrc->Value(0);
	if( $loInFrame->Value() ){
		$lcIcon = cc_InFrameOnIcon;
		$lcIconText = ltext('ll_on');
		$lcTitle = $gcSwitchOffInFrame;
		$liNewInFrame = 0;

	} else {
		$lcIcon = cc_InFrameOffIcon;
		$lcIconText = ltext('ll_off');
		$lcTitle = $gcSwitchOnInFrame;
		$liNewInFrame = 1;
	}

	$loID =& $poSrc->Value(1);
	$liID = $loID->Value();

	$loLink = new LinkDataField( "javascript:setValue('item_id',$liID,$liFormIndex);".
															 "setValue('in_frame',$liNewInFrame,$liFormIndex);".
															 "submitForm('action','in_frame',$liFormIndex)", 
															 '', 
															 array(), 
															 ($confixx_interface_version == 'powp')?
															 new IconDataField( $lcIcon ):
															 new HTMLDataField($lcIconText) );

	$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
	$loLink->AppendParentAttributes( array( 'align' => 'left' ) );

	return $loLink;
}

function makeSelect( $poSrc ){

	$loCheckBox = new CheckDataField( $poSrc, 'ids[]');
	$loCheckBox->ParentAttribute('align','center');

	return array( $loCheckBox->GetInputPresentation(), array('align'=>'center'));
}


// end call-back functions
//
//=======================================================

$loConv = new CompoundValue( NULL,
														 new ValueFormated( 'href', NULL, 'makeHrefLink' ),
														 new ValueFormated( 'in_frame', NULL, 'makeInFrameButton' ),
														 new ValueFormated( 'select', NULL, 'makeSelect' )
														 );

$loDS->Conversion( $loConv );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );

$loPTV->setParameter( 'menublock_id', $menublock_id );
$loPTV->setParameter( 'item_id', '' );
$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'in_frame', '' );


$loPTV->Anchor( 'list' );
$loPTV->FormIndex( 1 );

$loPTV->SetButtons( new ButtonURLData( ltext('cm_back'), 'custommenu.php', cc_IDBack ) );

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'menuitems.php#list',
																						 'method' => 'post',
																						 'name' => 'list_item' ), 
																			ltext( 'cm_path', array( $lcBlockLabel,
 
																															 ( $lcUserType == 'reseller' )?
																															 ltext('cm_path_reseller'):
																															 ltext('cm_path_user')
																															 
																															 ) 
																						 ) 
																			);

$loGroup = new DivElement( array( 'class'=>'buttons' ) );
$head_text = ltext( 'll_delete' );
$lcConfirm = ltext( 'll_confirm_delete' );
$lcNothing = ltext( 'll_nothing' );

$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:deleteSelected('ids','$lcConfirm',$liFormIndex,'$lcNothing')",
																								'bid-delete' 
																								)
													 );
	
$tbl->setGroupActionElement( $loGroup );

$tbl->updateBodyContent();



// end list of menu items
//
//==============================================================
$page = new MainPageElement( $loAddForm, $tbl );

$page->OutputHTML( array( '../js/paged_form.js' ) );

?>
