<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com ##### 

include_once( 'auth.php');
include_once( '../include/cron_functions.php' );
include_once( '../include/module.Database.php' );
include_once( '../include/limits/class.AllLimits.php' );
include_once( '../include/class.Traffic.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.ButtonURLData.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

global $DEBUG;
//$DEBUG=1;

db_master_connect();

if( ! isset( $server_id ) ){
	$server_id = $ServerID;
 }

$loServerID = new SQlString( $server_id );

## anbieterdaten holen
$id = safe_query2( "SELECT * FROM admin WHERE server_id=?",
									 $loServerID );
$admin = db_fetch_array( $id );
db_free_query( $id );

$id = safe_query2( "SELECT name,descr FROM server WHERE server_id=?",
									 $loServerID );
list($server_name,$descr) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT * FROM personalinfo WHERE server_id=? AND id=".$admin['personalinfoid'],
									 $loServerID );
$werte = db_fetch_array( $id );
db_free_query( $id );

$name = $werte[ 'name' ];
$firma = $werte[ 'firma' ];
$anschrift = $werte[ 'anschrift' ];
$plzort = $werte[ 'plzort' ];
$telefon = $werte[ 'telefon' ];
$fax = $werte[ 'fax' ];
$emailadresse = $werte[ 'emailadresse' ];
$freifeldname1 = $werte[ 'freifeldname1' ];
$freifeldname2 = $werte[ 'freifeldname2' ];
$freifeldname3 = $werte[ 'freifeldname3' ];
$freifeldwert1 = $werte[ 'freifeldwert1' ];
$freifeldwert2 = $werte[ 'freifeldwert2' ];
$freifeldwert3 = $werte[ 'freifeldwert3' ];

$php = $admin['php'];
$ftp = $admin['ftp'];
$perl = $admin['perl'];
$modpython = $admin['modpython'];
$ssi = $admin['ssi'];
$ssl = $admin['cssl'];
$shell = $admin['shell'];
$scponly = $admin['scponly'];
if ($scponly ==2) $scponly =1;
$statistik = $admin['statistik'];
$pwschutz = $admin['pwschutz'];
$fehlerseiten = $admin['fehlerseiten'];
$webftp = $admin['webftp'];
$webmail = $admin['webmail'];
$stdcgi = $admin['stdcgi'];
$frontpage = $admin['frontpage'];
$dbext = $admin['mysql'];
$phpupload = $admin['phpupload'];
$wap = $admin['wap'];
$coldfusion = $admin['coldfusion'];
$dirlist = $admin['dirlist'];
$spamfilter = $admin['spamfilter'];
## /anbieterdaten holen

# speicher berechnen
$id = safe_query2( " SELECT SUM(kbhomedir) AS kbhomedir, SUM(kbdb) AS kbdb,".
									 " SUM(maxkb) AS kbvergeben, COUNT(kunde) AS anzahlkunden, SUM(IF(popmaxkb=0,kbpop,0)) AS kbpop,".
                   " SUM(IF(popmaxkb!=0,kbpop,0)) AS kbpop2".
									 " FROM kunden WHERE server_id=?", $loServerID );
list( $kbhomedir, $kbdb, $kbvergeben, $anzahlkunden, $kbpop, $kbpop2 ) = db_fetch_array( $id, 'N' );
$kbgesamt = $kbdb + $kbhomedir + $kbpop;
db_free_query( $id );

$id = safe_query2( "SELECT COUNT(kunde) FROM kunden WHERE maxkb = -1 ".
									 " AND server_id=?", $loServerID );
list( $unbegrenzt ) = db_num_rows($id, 'N' );
db_free_query( $id );

if( $unbegrenzt > 0 ){ 
	$kbvergeben = -1; 
 }

# /speicher berechnen


## transfer berechnen
$monat = date( 'n');
$jahr = date( 'Y' );
$tag = date( 'j' );

$jahrstr = $jahr;
$monatstr = $lang_months[$monat];

$trf = new Traffic();
$trf->setLog( $trafficLog );
$trf->setServerID( $server_id );
$trf->setFields( array( 'web', 'ftp', 'email', 'pop' ) );
$trf->monthlyQuery($monat,$jahr);

$transferweb = $trf->getTraffic('web');
$transferftp = $trf->getTraffic('ftp');
$transferemail = $trf->getTraffic('email')+$trf->getTraffic('pop');


$transfergesamt = $transferftp + $transferweb + $transferemail;

## anzahl kunden, domains, pop3, email, subdomains, dbs, ipadressen

$id = safe_query2( "SELECT COUNT(domain) AS anzahldomains FROM domains ".
									 " WHERE server_id=? AND richtigedomain=1",
									 $loServerID );
list($anzahldomains) = db_fetch_array($id,'N');
db_free_query( $id );

$id = safe_query2( "SELECT COUNT(domain) AS anzahlsubdomains FROM domains ".
									 " WHERE server_id=? AND richtigedomain=0",
									 $loServerID );
list( $anzahlsubdomains ) = db_fetch_array($id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT COUNT(domain) AS anzahlsubdomains FROM domains ".
									 " WHERE server_id=? AND richtigedomain=7",
									 $loServerID );
list( $shareddomains ) = db_fetch_array($id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT COUNT(account) AS anzahlpop FROM pop3 ".
									 " WHERE server_id=?",
									 $loServerID );
list($anzahlpop) = db_fetch_array($id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT COUNT(account) AS ftp FROM ftp ".
									 " WHERE server_id=?",
									 $loServerID );
list($anzahlftp) = db_fetch_array($id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT COUNT(*) AS atd FROM atdomains at, domains d, kunden k ".
									 " WHERE at.id_from=d.id AND at.server_id=d.server_id ".
									 " AND d.kunde=k.kunde AND d.server_id=k.server_id ".
									 " AND k.server_id=?",
									 $loServerID );
list( $atdomains ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT COUNT(ident) AS anzahlemail FROM email ".
									 " WHERE server_id=?",
									 $loServerID );
list($anzahlemail) = db_fetch_array($id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT COUNT(ident) AS anzahlautoresponder FROM autoresponder ".
									 " WHERE server_id=?",
									 $loServerID );
list($anzahlautoresponder) = db_fetch_array($id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT COUNT(ip) AS anzahlips FROM ipadressen ".
									 " WHERE server_id=?",
									 $loServerID );
list($anzahlips) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$id = safe_query2( "SELECT COUNT(ip) AS anzahlusedips FROM ipadressen ".
									 " WHERE server_id=? AND kunde <> ''",
									 $loServerID );
list($anzahlusedips) = db_fetch_array( $id, 'N' );
db_free_query( $id );
## /anzahl kunden, domains, pop3, email, subdomains, dbs, ipadressen

## anzahl mysql-datenbanken ermitteln
$id = safe_query2( "SELECT COUNT(datenbank) AS anzahlmysql FROM mysql_datenbanken ".
									 " WHERE server_id=?",
									 $loServerID );
list($anzahlmysql) = db_fetch_array( $id, 'N' );
db_free_query( $id );
## //anzahl mysql-datenbanken ermitteln

## cron
$cronjobs = count_cron_jobs_server( $server_id );
## //cron

## anzahl wildcards
$id = safe_query2( "SELECT COUNT(domain) AS anzahlwildcards FROM domains ".
									 " WHERE richtigedomain = 0 AND server_id=? AND domain LIKE '*.%'",
									 $loServerID );
list($anzahlwildcards) = db_fetch_array($id, 'N' );
db_free_query( $id );
##// anzahl wildcards

## idn
if($admin['idn']){
	$id = safe_query2( "SELECT COUNT(*) AS cnt FROM idn_aliases idn, domains d".
										 " WHERE d.id = idn.domain_id AND d.server_id=idn.server_id ".
										 " AND d.server_id=?",
										 $loServerID );
	list($idn_count) = db_fetch_array( $id, 'N' );
	db_free_query( $id );
}
## //idn

##
if($admin['majordomo']){
	$id = safe_query2( "SELECT COUNT(*) AS cnt FROM maillist m, domains d ".
										 " WHERE  d.id = m.domain_id AND d.server_id=m.server_id ".
										 " AND d.server_id=? AND m.neu <> 3",
										 $loServerID );
	list($maillist_count) = db_fetch_array($id);
	db_free_query( $id );
}
##
//
// end calculate
//=========================================================================
// begin output
//
$page = new MainPageElement();

global $data;
$data= new SetOfRowsData();

//
// <Lavel> <Value> if Value is not empty
//
function makeLV($label,$value=TRUE){
	global $data;
	if($value){
		$data->AppendRow(new HTMLDataField($label), new HTMLDataField($value));
	}
}

//----------------------------------------------------------------
makeLV(ltext( 'srst_cell_descr' ), $descr );

makeLV(ltext( 'stde_cell_firm' ), $firma );
makeLV(ltext( 'stde_cell_name' ), $name );
makeLV(ltext( 'stde_cell_address' ), $anschrift );
makeLV(ltext( 'stde_cell_city' ), $plzort );
makeLV(ltext( 'stde_cell_tel' ), $telefon );
makeLV(ltext( 'stde_cell_fax' ), $fax );
makeLV(ltext( 'stde_cell_email' ), $emailadresse );
makeLV(ltext( 'stde_cell_cid' ), $kundennummer );
makeLV( $freifeldname1, $freifeldwert1 );
makeLV( $freifeldname2, $freifeldwert2 );
makeLV( $freifeldname3, $freifeldwert3 );

$table = $data->GetOutputPresentation( ltext('srst_title1')." $server_name ($hostname)" );
$table->SetWidths( '50%', '50%' );
$page->AppendToContent( $table );

//------------------------------------------------------------------

$errorColor = array( 'bgcolor' => $fehlerfarbe );

//
// <Lable><Colored value> 
//
function makeLC($label,$value,$ifError=false){
	global $data;
	global $errorColor;
	$loValue = new HTMLDataField($value);
	if ($ifError){
		$loValue->SetParentAttributes($errorColor);
	}
	$data->AppendRow(new HTMLDataField($label),$loValue);
}

$data->ClearRows();

makeLC( ltext( 'stde_cell_users' ),
				 sinnv_intwert( $anzahlkunden, ltext('g_nolimit') ) );

makeLC( ltext( 'stde_cell_domains' ),
				 sinnv_intwert($anzahldomains,ltext('g_nolimit') ) );
makeLC( ltext( 'alst_cell_shareddomains' ),
				 sinnv_intwert($shareddomains,ltext('g_nolimit') ) );
 	
makeLC( ltext( 'stde_cell_pop3' ),
				 sinnv_intwert( $anzahlpop, ltext('g_nolimit') ) );
	
makeLC( ltext( 'stde_cell_email' ),
				 sinnv_intwert( $anzahlemail, ltext('g_nolimit' ) ) );
 	
makeLC( ltext( 'stde_cell_autoresponder' ),
				 sinnv_intwert( $anzahlautoresponder, ltext( 'g_nolimit' ) ) );

makeLC( ltext('stde_cell_subdomains'),
				 sinnv_intwert( $anzahlsubdomains, ltext( 'g_nolimit' ) ) );

makeLC( ltext( 'stde_cell_wildcard' ),
				sinnv_intwert( $anzahlwildcards, ltext( 'g_nolimit' ) ) );

makeLC( ltext( 'stde_cell_mysql' ),
				sinnv_intwert( $anzahlmysql, ltext( 'g_nolimit' ) ) );

if ( $admin['cronjobs'] ){	
	makeLC( ltext( 'stde_cell_cron' ),
					 sinnv_intwert( $cronjobs, ltext( 'g_nolimit' ) ) );;
}

if ( $admin['majordomo'] ){
	makeLC( ltext('stde_cell_maillist'),
					 sinnv_intwert($maillist_count,ltext('g_nolimit' ) ) );
}		

makeLC( ltext( 'stde_cell_ftpusers' ),
				 sinnv_intwert( $anzahlftp, ltext( 'g_nolimit' ) ) );
	
makeLC( ltext( 'stde_cell_atdomains' ),
				 sinnv_intwert( $atdomains,ltext('g_nolimit')));
$table = $data->GetOutputPresentation( ltext( 'stde_title3' ) );
$table->SetWidths( '50%', '50%' );	
$page->AppendToContent( $table );
//------------------------------------------------------------------

$data->ClearRows();


makeLC( ltext( 'stde_cell_vusedspace' ),
				sinnv_kbwert( $kbvergeben, ltext( 'g_nolimit' ) ),
				( $kbvergeben == -1 ));

makeLC( ltext( 'stde_cell_usedspace' ),
				 sinnv_kbwert( $kbgesamt, ltext( 'g_nolimit' ) ) );

makeLC( ltext( 'stde_cell_dufiles' ),
				sinnv_kbwert( $kbhomedir, ltext( 'g_nolimit' ) ) );
	
makeLC( ltext( 'stde_cell_dudb' ),
				sinnv_kbwert( $kbdb, ltext( 'g_nolimit' ) ) );

$table = $data->GetOutputPresentation( ltext( 'stde_title4' ) );
$table->SetWidths( '50%', '50%' );		
$page->AppendToContent( $table );
//------------------------------------------------------------------

$gcSrvDetails = ltext( 'stsrtr_head' );

$data->ClearRows();

makeLC ( ltext('stde_cell_usedtraffic'),
	sinnv_kbwert($transfergesamt,ltext('g_nolimit')));

makeLC ( ltext('stde_cell_traffichttpd'),
	sinnv_kbwert($transferweb,ltext('g_nolimit')));
	
makeLC ( ltext('stde_cell_trafficftp'),
	sinnv_kbwert($transferftp,ltext('g_nolimit')));

if ($show_emailtransfer == 1) {
	makeLC ( ltext('stde_cell_trafficemail'),
	sinnv_kbwert($transferemail,ltext('g_nolimit')));
}

$linkRes = new ButtonURLData(ltext('stde_cell_trafficlink'),
														 new LinkDataField( 'statistik_details_transfer.php',
																								'',
																								array( 'server_id'=>$server_id,
																											 'monat' => $monat,
																											 'jahr' => $jahr,
																											 'menu_node_id' => 'stat_srv_trf',
																											 'cur_page' => 'statistik_details_transfer.php',
																											 'head_text' => $gcSrvTrf 
																											 )
																								)
														 );
	
$linkRes->SetColSpan(2);
$data->AppendRow($linkRes);

$table=$data->GetOutputPresentation( ltext('stde_title5').' '.$monatstr.' '.$jahrstr );

$table->SetWidths('50%','50%');	
$page->AppendToContent($table);
//------------------------------------------------------------------
$data->ClearRows();


makeLC ( ltext('stde_cell_numberofips'), $anzahlips.' '. ltext('stde_cell_ipaddress'));
makeLC ( ltext('stde_cell_usedips'), $anzahlusedips.' '. ltext('stde_cell_ipaddress'));

$table=$data->GetOutputPresentation( ltext('stde_title6'));
$table->SetWidths('50%','50%');	
$page->AppendToContent($table);
//------------------------------------------------------------------

$data->ClearRows();

//
// <Label><Activ/Deactiv>
//
function makeLA($label,$value){
	global $data;
	
	$loValue = new HTMLDataField($value?ltext('stde_activated'):ltext('stde_deactivated'));
	
	$data->AppendRow(new HTMLDataField($label),$loValue);
}

makeLA( ltext('stde_cell_ftp'), $admin['ftp']);
makeLA( ltext('stde_cell_php'), $php); 
if( $admin['php'] ){ 
	makeLA( ltext( 'stde_cell_phpupload' ), $phpupload);
}
makeLA( ltext( 'stde_cell_perl' ), $perl ); 
makeLA( ltext( 'stde_cell_modpython' ), $modpython ); 
makeLA( ltext( 'stde_cell_ssi' ), $ssi ); 
makeLA( ltext( 'stde_cell_ssl' ), $ssl ); 
makeLA( ltext( 'stde_cell_frontpage' ), $frontpage ); 
makeLA( ltext( 'stde_cell_shell' ), $shell );
makeLA( ltext( 'stde_cell_scponly' ), $scponly );
makeLA( ltext( 'stde_cell_wap' ), $wap );
makeLA( ltext( 'stde_cell_coldfusion' ), $coldfusion );
makeLA( ltext( 'stde_cell_dirlist' ), $dirlist );
makeLA( ltext( 'stde_cell_dbext' ), $dbext );
makeLA( ltext( 'stde_cell_webalizer' ), $statistik );
makeLA( ltext( 'stde_cell_errorfiles' ), $fehlerseiten );
makeLA( ltext( 'stde_cell_webftp' ), $webftp );
makeLA( ltext( 'stde_cell_webmail' ), $webmail );
makeLA( ltext( 'stde_cell_stdscripts' ), $stdcgi );
makeLA( ltext( 'stde_cell_spamfilter' ), $spamfilter );

$table = $data->GetOutputPresentation( ltext( 'stde_title7' ) );
$table->SetWidths( '50%', '50%' );	
$page->AppendToContent( $table );
//------------------------------------------------------------------


$page->OutputHTML();

db_close();
?>

