<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.ButtonData.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/pagers/class.ResellerDomainsPager.php' );
include_once( '../include/pagers/class.ResellerValuesSource.php' );
include_once( '../include/class.User.php' );
include_once( '../include/module.Database.php' );
include_once( '../include/limits/class.AllLimits.php' );
include_once( '../include/event_functions.php' );
include_once( 'defines.php' );
include_once( '../events.inc.php' );

global $DEBUG;
//$DEBUG=1;

if( $DEBUG ){
	echo "kunden_domains: POST:<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
	echo "GET:<br><pre>\n";
	print_r($_GET);
	echo "</pre><hr>\n";
}

$loKunde = new SQLString($kunde);
/**
 * Get reseller's settings
 */
$loUser = new SQLString($PHP_AUTH_USER);
$id = safe_query2( " SELECT dns,dnr,maxdomains,maxdomainslimit,".
                   " standardip, maxshareddomains, maxshareddomainslimit ".
                   " FROM anbieter WHERE anbieter=? AND server_id='$ServerID'", $loUser );
$ga_Reseller = db_fetch_array( $id, 'A' );
$skdns = $ga_Reseller['dns'];
$skdnr = $ga_Reseller['dnr'];
$liResSharedDomains = $ga_Reseller['maxshareddomains'];

$standardIP = $ga_Reseller['standardip'];
db_free_query( $id );

if( ! $standardIP ){
	$id = safe_query2( "SELECT standardip FROM admin WHERE server_id='$ServerID'");
	list($standardIP) = db_fetch_array( $id );
	db_free_query( $id );
}


/**
 * Need to perform action?
 */
if ($action) {

	include('kunden_domains_update.php');

	switch( $action ){
	case 'ip':
		updateIP( $ip, $exclusiv);
		break;
  case 'new':
    if( istleer( $shared ) ){
      appendDomain( $new_domain, $dns, $dnr, $shared );

      /**
      * Add event to AWstats
      */
      $id = safe_query2("SELECT awstats FROM kunden WHERE kunde=? ".
                        " AND anbieter = ? AND server_id='$ServerID'", 
                        $loKunde, new SQLString($PHP_AUTH_USER));
      list($liIsSetAwstats) = db_fetch_array( $id );
      db_free_query( $id );

      if( $liIsSetAwstats == 1 ){
        eventAdd($OBJECT_STAT, $EVENT_CHANGE, $kunde);
      }
    }elseif( $liResSharedDomains ){
      appendSharedDomain( $new_domain );
    }
		break;
	case 'dnsdnr':
		batchDNSDNR( $domain_ids, $dnsdnr );
		break;
	case 'dns':
		updateDNS( $domain_id, $dns);
		break;
	case 'dnr':
		sendDNSRequest( $domain_id );
		break;
	case 'delete':
		deleteDomains( $domain_ids, $update_db);
		
		/**
		* Add event to AWstats
		*
	  */
    $id = safe_query2("SELECT awstats FROM kunden WHERE kunde=? ".
                      " AND anbieter = ? AND server_id='$ServerID'", 
                      $loKunde, new SQLString($PHP_AUTH_USER));
    list($liIsSetAwstats) = db_fetch_array( $id );
		db_free_query( $id );

		if ($liIsSetAwstats == 1) {
    	eventAdd($OBJECT_STAT, $EVENT_CHANGE, $kunde);
		}
		
		break;
	case 'back':
		if($confixx_interface_version == 'powp'){
			popPathBar( TRUE );
			include( 'kunden_start.php' );
		}else{
			include( 'kunden_aendern_fwd.php' ); 
		}
		exit();
		break;
	}
	$action = '';
}

/**
 * Add form
 */
$lrId = safe_query2( " SELECT COUNT(id) FROM domains WHERE richtigedomain=1 ".
                     " AND anbieter=? AND server_id='$ServerID'", $loUser);
list( $liDomainsCount ) = db_fetch_array( $lrId );
db_free_query( $lrId );

$lrId = safe_query2( " SELECT COUNT(id) FROM domains WHERE richtigedomain = 7 ".
                     " AND anbieter=? AND server_id='$ServerID'", $loUser);
list( $liSharedDomainsCount ) = db_fetch_array( $lrId );
db_free_query( $lrId );

$lbDomainsCondition = ( $liDomainsCount < $ga_Reseller['maxdomains'] 
                        || $ga_Reseller['maxdomains'] == -1 
                        || $ga_Reseller['maxdomainslimit']  == 0 );


$lbSharedDomainsCondition = ( $liSharedDomainsCount < $ga_Reseller['maxshareddomains']
                              || $ga_Reseller['maxshareddomains'] == -1  
                              || $ga_Reseller['maxshareddomainslimit']  == 0 ) && $liResSharedDomains;

if( $lbDomainsCondition || $lbSharedDomainsCondition ){

	$loRD = new SetOfRowsData();
	
	$loRow =& $loRD->AppendRow( new HTMLDataField(ltext('ed_domain')),
															new TextDataField( $new_domain, 'new_domain' )
															);
	if( $skdns && $lbDomainsCondition ){
		$loRow->AppendFields( new CheckDataField( 1, 'dns' ),
													new HTMlDataField( ltext( 'kune4_cell_dns1' ) )
													);
		if( $skdnr){
			$loRow->AppendFields( new CheckDataField( 1, 'dnr' ),
														new HTMlDataField( 'DNR' )
													);
		}
	}
	if( $lbSharedDomainsCondition ){
    $loRow->AppendFields( new CheckDataField( 1, 'shared'),	
                          new HTMlDataField( ltext( 'kune4_cell_shared' ) ) );
  }
	$loRow->AppendFields( new ButtonData(ltext( 'll_add' ),'javascript:doChange()', cc_IDAdd ) );
	$loRD->AppendHidden( new TextDataField( 'new', 'action' ) );
	$loRD->AppendHidden( new TextDataField( $kunde, 'kunde' ) );

	$loAppendForm = $loRD->GetInputPresentation( array( 'action' => 'kunden_domains.php',
																											'method' => 'post',
																											'name' => 'append_new' ),
																							 ltext( 'll_add' )
																							 );
	$liFormIndex = 1;
} else {
	$liFormIndex = 0;
}

/**
 * List of domains
 */
initPagingSettings( $_POST, array( 'domain_to_search' => $domain_to_search,
                                   'kunde'            => $kunde ) );

$lcSQL = " SELECT COUNT(domain) FROM domains WHERE kunde = ? AND (richtigedomain = 1 ".
         " OR richtigedomain = 7) AND server_id='$ServerID'";
$res = safe_query2( $lcSQL, $loKunde );
list( $total_number ) = db_fetch_array( $res, 'N' );
db_free_query( $res );

$lcFields = "d.id,d.domain,d.httpd,d.dns,d.dnr,d.cssl,dns.neu as dns_neu, d.richtigedomain";
$listFormIndex++;
	
if( ! isset( $order ) ){
	$order = 'domain';
}

if( ! isset( $direction ) ){
	$direction = 'asc';
}

$laOrders = array( 'domain' => 'd.domain',
                   'state'  => 'd.httpd',
                   'dns'    => 'd.dns',
                   'dnr'    => 'd.dnr',
                   'shared' => 'd.richtigedomain' );

if( array_key_exists( $order, $laOrders ) ){
	 $lcSqlOrder .= ' ORDER BY '.$laOrders[$order];
}else{
	 $lcSqlOrder .= ' ORDER BY '.$laOrders['domain'];
}
if( $direction == 'desc' ){
  $lcSqlOrder .= ' DESC';
}

/**
 * Need to perform search?
 */
if( ! istleer( $domain_to_search ) ){
	$loDomain = new SQLValue( $domain_to_search, 'S' );
  $lcSQL = " SELECT COUNT(*) FROM domains WHERE domain LIKE '%?%'".
           " AND (richtigedomain = 1 OR richtigedomain =7 ) AND kunde = ? AND server_id='$ServerID'";
	$loQuery = new SQLQuery( $lcSQL, array( $loDomain, new SQLValue($kunde,'C') ) );
	$loQuery->doQuery();
	list($total_number) = $loQuery->fetchArray('N');
	$loQuery->finish();

	$lcSQL = " SELECT $lcFields FROM domains d LEFT JOIN dns ON dns.domain=d.domain".
	         " AND dns.server_id=d.server_id".
           " WHERE d.domain LIKE '%?%' AND ( d.richtigedomain = 1 OR d.richtigedomain = 7) AND d.kunde = ?".
           " AND d.server_id='$ServerID'".$lcSqlOrder;
	$loQuery->Query( $lcSQL );
}else{
  $lcSQL = " SELECT $lcFields FROM domains d ".
           " LEFT JOIN dns ON dns.domain=d.domain AND dns.server_id=d.server_id".
           " WHERE d.kunde = ? AND (d.richtigedomain = 1 OR d.richtigedomain = 7) ".
           " AND d.server_id='$ServerID'".$lcSqlOrder;
  $loQuery = new SQLQuery( $lcSQL, array( new SQLValue($kunde,'C') ) );
}

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue(new ValueFromArray( 'httpd')); 

$loTemplate->addValue( new CompoundValue( new ValueFromArray( 'httpd'),
																					new ValueFromArray( 'domain'),
																					new ValueFromArray( 'richtigedomain')
																				) );
										 
$laContent =array();
$laHeaders = array();
$lcDirIcon = ( $direction=='desc' ) ? cc_DescIcon : cc_AscIcon;
$lcNewDir  = ( $direction=='desc' ) ? 'asc' : 'desc';

/**
 * Generate table headers
 */
$laHeaders['state']  = array( 'label' => 'kudo_cell_state', 'sort' => true );
$laHeaders['domain'] = array( 'label' => 'kudo_cell_domain', 'sort' => true );
if( $skdns ){
  $laHeaders['dns'] = array( 'label' => 'kudo_cell_dns', 'sort' => true );
  if( $skdnr ){
    $laHeaders['dnr'] = array( 'label'=> 'kudo_cell_dnr', 'sort' => true );
  }
}
if( $liResSharedDomains ){
  $laHeaders['shared'] = array('label' => 'kune4_cell_shared', 'sort' => true );
}

/**
 * Column widths
 */
if( $skdns && $skdnr && $liResSharedDomains ){
  $laWidths = array( '5%','60%', '10%', '10%','10%', '5%' );
}elseif( $skdns && $liResSharedDomains ){
	$laWidths = array( '5%','70%', '10%', '10%', '5%' );
}elseif( $liResSharedDomains ){
	$laWidths = array( '5%','80%', '10%', '5%' );
}elseif( $skdns && $skdnr ){
	$laWidths = array( '5%','70%', '10%', '10%', '5%' );
}elseif( $skdns ){
	$laWidths = array( '5%','80%', '10%', '5%' );
}else{
	$laWidths = array( '5%','90%', '5%' );
}

foreach( $laHeaders as $lcKey => $laValue ){ 
  if( $laValue['sort'] ){ 
    if( $order == $lcKey ){ 
      $loContent = new CompoundDataField( new HTMLDataField( ltext( $laValue['label'] ) ), 
                                          new IconDataField( $lcDirIcon ) 
                                        ); 
      $loContent->SetSeparator( '' ); 
    }else{ 
      $loContent = new HTMlDataField( ltext( $laValue['label'] ) ); 
    } 
    $loLink = new LinkDataField( "javascript:setValue('order', '$lcKey',$listFormIndex);". 
                                 "setValue('start_index',1,$listFormIndex);". 
                                 "submitForm('direction','$lcNewDir',$listFormIndex)", 
                                 '', array(), $loContent );
    $laContent[] = new DataValue( $lcKey, NULL, $loLink );
  }else{ 
    $laContent[] = new ValueLocale( $laValue['label'] ); 
  } 
}

$loTitle = new CompoundValue( $laContent ); 
										 
if( $skdns ){
	$loTemplate->addValue( new CompoundValue( new ValueFromArray( 'dns' ),
																						new ValueFromArray( 'id' ),
																						new ValueFromArray( 'dns_neu' ),
																						new ValueFromArray( 'richtigedomain' )
																						)
                                          );
	if( $skdnr ){
		$loTemplate->addValue( new CompoundValue( new ValueFromArray( 'dnr'),
																							new ValueFromArray( 'id'),
                                              new ValueFromArray( 'dns_neu'), 
                                              new ValueFromArray( 'richtigedomain') 
                                            ) 
													 );
	}
}

if( $liResSharedDomains ){
		$loTemplate->addValue( new ValueFromArray( 'richtigedomain') );
} 

$loTemplate->addValue( new ValueFromArray( 'id' ) ); /* select */

$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('domain_ids', this.checked, $liFormIndex)");
$loCheckBox->SetParentAttributes(array('align'=>'center'));
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

$loTitle->addValue( $loSelValue );

$loDS->Template( $loTemplate );

/**
 * call back functions to make visible objects
 */
function &makeLink( $poSrc ){

  list( $liHttpd, $lcDomain, $liType) = $poSrc->listValue();

  if( $liHttpd || $liType == 7 ){ 
		$loLink = new HtmlDataField( $lcDomain,false,array(),array() );
		$loLink->SetAttributes (array( 'target' => 'show_domain' ) );
		$loLink->SetParentAttributes (array( 'align' => 'left' ) );
	} else {
		$loLink = new LinkDataField( "http://".$lcDomain, '', array(), $lcDomain);
		$loLink->SetAttributes (array( 'target' => 'show_domain' ) );
		$loLink->SetParentAttributes (array( 'align' => 'left' ) );
	}
	
	return $loLink;
}

$gcSwitchOnDNS = ltext('kune4_dns_switch_on');
$gcSwitchOffDNS = ltext('kune4_dns_switch_off');
$gcProcessOnDNS = ltext('kune4_dns_process_on');
$gcProcessOffDNS = ltext('kune4_dns_process_off');

function makeDnsStatus( $poSrc ){
	global $gcSwitchOnDNS, $gcSwitchOffDNS, $gcProcessOnDNS, $gcProcessOffDNS,$confixx_interface_version;
	global $liFormIndex;
	global $DEBUG;
	$lcIconText = '';
  list( $liDomainDNS, $liId, $liDNS, $liShared ) = $poSrc->listValue();
  
	$liNewDNS = -1;
	if( $liDNS == 1 ) {
		$lcIcon = cc_ProcessOnDNSIcon;
		$lcTitle = $gcProcessOnDNS;
		$lcIconText = ltext('kune4_dns_process_on');
		$liNewDNS = 0;
	} elseif( $liDNS == 2){
		$lcIcon = cc_ProcessOffDNSIcon;
		$lcIconText = ltext('kune4_dns_process_off');
		$lcTitle = $gcProcessOffDNS;
		$liNewDNS = 1;
	} elseif( $liDomainDNS ) {
		$lcIcon = cc_OnDNSIcon;
		$lcIconText = ltext('ll_on');
		$lcTitle = $gcSwitchOffDNS;
		$liNewDNS = 0;
	} else {
		$lcIcon = cc_OffDNSIcon;
		$lcIconText = ltext('ll_off');
		$lcTitle = $gcSwitchOnDNS;
		$liNewDNS = 1;
	}
  
	if( $liNewDNS >= 0 && $liShared !=7 ){
		$loLink = new LinkDataField( "javascript:setValue('domain_id',$liId,$liFormIndex);".
																 "setValue('dns',$liNewDNS,$liFormIndex);".
																 "submitForm('action','dns',$liFormIndex)", 
																 '', 
																 array(), 
																 ($confixx_interface_version == 'powp')?
																 new IconDataField( $lcIcon ):
																 $lcIconText );
		$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
		$loLink->AppendParentAttributes( array( 'align' => 'left' ) );

	} else {
		if ($confixx_interface_version == 'powp') {
		$loLink = new IconDataField( $lcIcon, 
																 array( 'title' => $lcTitle, 'alt' => $lcTitle ),
																 array( 'align' => 'left' ) 
																 );
		} else {
		$loLink = new HTMLDataField( $lcIconText, 
																 array( 'title' => $lcTitle, 'alt' => $lcTitle ),
																 array( 'align' => 'left' ) 
																 );
		}
	}
		
	return $loLink;
}

$gcSwitchOnDNR = ltext('kune4_dnr_switch_on');

function makeDnrStatus( $poSrc ){
	global $gcSwitchOnDNR,$confixx_interface_version;
	global $liFormIndex;
	global $DEBUG;
  $lcIconText = '';

  list( $liDomainDnr, $liID, $liDns, $liShared ) = $poSrc->listValue();
	
	if( $liDomainDnr ) {
		$lcIconText = ltext('ll_on');
		$lcIcon = cc_OnDNRIcon;
	} else {
		$lcIconText = ltext('ll_off');
		$lcIcon = cc_OffDNRIcon;
	}
	$liNewDNR = 1;
	$lcTitle = $gcSwitchOnDNR;
  if( $liShared != 7 ){	
    $loLink = new LinkDataField( "javascript:setValue('domain_id',$liID,$liFormIndex);".
                                        "setValue('dnr',$liNewDNR,$liFormIndex);".
                "submitForm('action','dnr',$liFormIndex)", 
                 '', 
                 array(), 
                 ($confixx_interface_version == 'powp')?
                 new IconDataField( $lcIcon ):
                 new HTMLDataField($lcIconText) );
    $loLink->AppendAttributes( array( 'title' => $lcTitle ) );
    $loLink->AppendParentAttributes( array( 'align' => 'left' ) );
  }else{
    $loLink =  ($confixx_interface_version == 'powp') ?
				       new IconDataField( $lcIcon ):
               new HTMLDataField($lcIconText);  
  }
	return $loLink;
}

function makeSelect( $poSrc ) {
	$loCheckBox = new CheckDataField( $poSrc, 'domain_ids[]');
	$loCheckBox->ParentAttribute('align','center');
	return array( $loCheckBox->GetInputPresentation(), array('align'=>'left'));
}

$gcShared = ltext( 'kune4_cell_shared' );

function makeSharedStatus( $piShared ){
  global $confixx_interface_version;
  global $gcShared;

  if( $piShared == 7 ){ 
		$lcTitle = $gcShared;
		$lcIcon = cc_DomainStateSharedIcon;
		$lcIconText = $gcShared;

    if( $confixx_interface_version == 'powp' ){
      $loIcon = new IconDataField( $lcIcon, 
                                   array( 'alt' => $lcTitle, 'title' => $lcTitle ), 
                                   array( 'align'=>'left') );
    }else{
      $loIcon = new HTMLDataField( $lcIconText, 
                                   array( 'alt' => $lcTitle, 'title' => $lcTitle ), 
                                   array( 'align'=>'left') );
    }
  }else{
		$loIcon = new HTMLDataField( ' ' ); 
  }
  return $loIcon;
}

$gcOk  = ltext('ll_state_ok');
$gcNew = ltext('ll_state_new');

function makeStatus( $poSrc ) {
		global $confixx_interface_version, $gcNew, $gcOk;
		switch( $poSrc ){
		case 1:
			$lcTitle = $gcNew;
			$lcIcon = cc_StateNewIcon;
			$lcIconText = $gcNew;
			break;
		case 0:
			$lcTitle = $gcOk;
			$lcIcon = cc_StateOkIcon;
			$lcIconText = $gcOk;
			break;
		default:
			$lcTitle = $gcOk;
			$lcIcon = cc_StateOkIcon;
			$lcIconText = $gcOk;
		}
	if ($confixx_interface_version == 'powp') {
		$loIcon = new IconDataField( $lcIcon, 
																 array( 'alt' => $lcTitle, 'title' => $lcTitle ), 
																 array( 'align'=>'left') );
	} else {
		$loIcon = new HTMLDataField( $lcIconText, 
																 array( 'alt' => $lcTitle, 'title' => $lcTitle ), 
																 array( 'align'=>'left') );
	}
		return $loIcon;
}

//============================================================

$loConv = new CompoundValue( new ValueFormated( 'httpd', NULL, 'makeStatus'),
														 new ValueFormated( 'domain', NULL, 'makeLink'));
if( $skdns  ) {
	$loConv->addValue( new ValueFormated( 'dns', NULL, 'makeDnsStatus'));
	if( $skdnr ) {
		$loConv->addValue( new ValueFormated( 'dnr', NULL, 'makeDnrStatus'));
	}
}
if( $liResSharedDomains  ) {
	$loConv->addValue( new ValueFormated( 'shared', NULL, 'makeSharedStatus' ) );
}
$loConv->addValue( new ValueFormated( 'select', NULL, 'makeSelect' ) );

$loDS->Conversion( $loConv );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );
$loPTV->setParameter( 'kunde', $kunde );
$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'domain_id', '' );
$loPTV->setParameter( 'domain', '' );
$loPTV->setParameter( 'dns', '' );
$loPTV->setParameter( 'dnr', '' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );
$loPTV->Anchor( 'list' );
$loPTV->FormIndex($liFormIndex);

$loPTV->SetButtons( new ButtonURLData( ltext('ll_back'), 
																			 "kunden_domains.php?action=back&kunde=$kunde",
																			 cc_IDBack ) );

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'kunden_domains.php#list',
																						 'name' => 'list_domains' ), 
																			ltext( 'ed_summary', array( $kunde ) ) );

$dsSearch = new CompoundValue( new ValueFromArray( 'domain_to_search', $domain_to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' ) );
	
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'domain_to_search', 
																																	'size' => '16',
																																	'value' => $domain_to_search,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );

$loGroup = new DivElement(array('class'=>'buttons'));
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,$liFormIndex)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('domain_to_search','',1);submitForm('start_index',1,$liFormIndex)", 
																							 'bid-show-all'
																							 ) 
													);

if( $skdns ){
	$laOptions[0] = ltext('kune4_group_action');
	$laOptions[1] = ltext('kune4_dns_switch_on');
	$laOptions[2] = ltext('kune4_dns_switch_off');
	if( $skdnr){
		$laOptions[3] = ltext('kune4_dnr_switch_on');
		$laOptions[4] = ltext('kune4_cell_dnr1');
	}
	for( $i=1; $i<=count($laOptions); $i++){
		if( ( $len = strlen( $laOptions[$i] ) ) > 30 ){
			$laOptions[$i] = substr( $laOptions[$i], 0, 26).'...';
		}
	}
	

	$loDnsDnr = new CompoundDataField(  new OptionsDataField( $laOptions,
																													 0,
																													 'dnsdnr',
																													 array('onchange'=>"javascript:if(this.value>0)".
																																 "submitForm('action','dnsdnr',$liFormIndex)")
																													 )
																		 );

	$loGroup->AppendToContent( 	$loDnsDnr->GetInputPresentation()	);
}


$head_text = ltext( 'll_delete' );
$lcConfirm = ltext( 'll_confirm_delete' );
$lcNothing = ltext( 'll_nothing' );

$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','delete_dom',$liFormIndex);".
																								"setValue('cur_page','kunden_domain_upd.php',$liFormIndex);".
																								"setValue('head_text','$head_text',$liFormIndex);".
																								"deleteSelected('domain_ids','$lcConfirm',$liFormIndex,'$lcNothing')",
																								'bid-delete' 
																								)
													 );
	
	
$loSearch->setDataSource( $dsSearch, array( 'domain_to_search' => $domains_to_search ) );

$tbl->setSearchElement( $loSearch );
$tbl->setGroupActionElement( $loGroup );

$tbl->updateBodyContent();


/**
 * IP-form
 */
$loRD = new SetOfRowsData();
$id = safe_query2( "SELECT ip FROM kunden WHERE kunde=? AND server_id='$ServerID'", $loKunde);
list($lcIP) = db_fetch_array( $id );

if( !$lcIP ) {
	$lcIP = $standardIP;
}


$laOptions = array();
$laOptions['standard'] = ltext('kune4_cell_select_stdip');

$id = safe_query2( "SELECT COUNT(kunde) FROM ipadressen WHERE ip=? AND kunde=? AND server_id='$ServerID'",new SQLString($lcIP), $loKunde);
list($llExclusive) = db_fetch_array($id);
$loExclusive = new CheckDataField( 1, 'exclusiv');
$loExclusive->isChecked($llExclusive);

$id = safe_query2( "SELECT ip FROM ipadressen WHERE anbieter=? AND status=1 ".
									 " AND kunde IN ( '', ? )".
									 " AND ip != ? AND server_id='$ServerID' ORDER BY ip", 
									 $loUser, $loKunde, new SQLString($standardIP));
while(list($ip) = db_fetch_array( $id ) ){
	$laOptions[$ip] = $ip;
}
db_free_query( $id );

$loRow = new CompoundDataField( new OptionsDataField( $laOptions, $lcIP, 'ip'),
																				 $loExclusive,
																				 new HTMlDataField( ltext('kune4_cell_text3'))
																);
$loRow->SetSeparator(' ');
$loRD->AppendRow( $loRow	);
$loRD->AppendButton(ltext('kune4_button1'),'javascript:doChange(2)', cc_IDOk);

$loRD->AppendHidden( new TextDataField( 'ip', 'action' ) );
$loRD->AppendHidden( new TextDataField( $kunde, 'kunde' ) );

$loIPForm =  $loRD->GetInputPresentation( array( 'action' => 'kunden_domains.php',
																								 'method' => 'post',
																								 'name' => 'chnage_ip' ),
																					ltext( 'kune4_title3' )
																					);

/**
 * Output
 */
$page = new MainPageElement( $loAppendForm, $tbl, $loIPForm );
$page->OutputHTML( array( '../../js/paged_form.js' ));

?>
