<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com ##### 

include_once( "auth.php" );
include_once( "defines.php" ); 
include_once( "../include/class.SQLString.php" );
include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.LinkDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.CompoundDataField.php" );
include_once( "../include/elements/data/class.IconDataField.php" );
include_once( "../include/elements/data/class.PagedTableView.php" );
include_once( "../include/data_source/class.DataValue.php" );
include_once( "../include/elements/html/class.SimpleSearchElement.php" );
include_once( "../include/elements/html/class.PPButtonElement.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );
include_once( "../include/elements/html/class.ButtonElement.php" );
include_once( "../include/data_source/class.SQLQuery.php" );
include_once( "../include/data_source/class.CompoundValue.php" );
include_once( "../include/data_source/class.ValueLocale.php" );
include_once( "../include/data_source/class.ValueFormated.php" );
include_once( "../include/data_source/class.ValueFromArray.php" );
include_once( "../include/data_source/class.ConversedDBValue.php" );
include_once( '../include/class.PathBar.php' );

db_connect($db_host, $db_user, $db_pass);

//$DEBUG = 1;

$loUser = new SQLString( $PHP_AUTH_USER );
$id = safe_query2( "SELECT frontpage, cssl, maxmysql FROM anbieter WHERE anbieter = ? AND server_id='$ServerID'", $loUser );
list( $skfrontpage, $skssl, $maxmysql ) = db_fetch_array($id);
if( $maxmysql != 0 ) $skmysql = 1;

if( $skfrontpage < 1 )	{
	$fehlertext = ltext( "kufr_error1" );
	db_close();

	$page = new MainPageElement(  );
	$page->AppendToHelp( array( 'kufr_descr1', 'kufr_descr2' ) );
	$page->OutputHTML();

	exit();
 }

$id = safe_query2( "SELECT COUNT(kunde) FROM kunden WHERE frontpage=1 AND anbieter = ?  AND server_id='$ServerID'", $loUser );
list( $total_number ) = db_fetch_array($id);
if( !$total_number ){
	$fehlertext = ltext( "kufr_nouser" );
	db_close();

	if( $confixx_interface_version == 'powp' ) {
		$url = "kunden_start.php?error_text=kufr_nouser";
		header("Location: $url");
		newLocation( $url );

	} else {
		$page = new MainPageElement(  );
		$page->AppendToHelp( array( 'kufr_descr1', 'kufr_descr2' ) );
		$page->OutputHTML();
	}
	exit();
 }

if( $confixx_interface_version == 'powp' ) {

	$loPathBar = new PathBar();
	$laFirstItem = array('main_menu_page' => 'kunden_frontpage_list.php',
											 'head_id' => 'frontpage',
											 'head_text' => ltext( 'mk_frontpage' ),
											 'menu_node_id' => 'menu_node_frontpage'
											 );
	$loPathBar->pushPathBar( $laFirstItem );

 }

initPagingSettings( $_POST, array( 'name_to_search' => $name_to_search ) );

//Sort settings 
	$listFormIndex = 0;
	if (!isset($direction)) $direction = 'asc';
	if (!isset($order)) $order = 'user';
	$lcDirIcon = ( $direction =='desc' ) ? cc_DescIcon : cc_AscIcon;
	$lcNewDir =  ( $direction =='desc' ) ? 'asc' : 'desc';

switch ( $order ) {
 case 'user':
	 $lcOrder = "  ORDER BY k.number";
	 if ( $direction == 'desc' ) $lcOrder .= " DESC";
	 break;
 case 'status':
	 $lcOrder = " ORDER BY status";
	 if ( $direction == 'desc' ) $lcOrder .= " DESC";
	 break;
 case 'name':
	 $lcOrder = " ORDER BY k.firstname";
	 if ( $direction == 'desc' ) $lcOrder .= " DESC";
	 break;
 }

if( isset($name_to_search)&&strlen($name_to_search) ) {
	$loName = new SQLValue( $name_to_search, 'S' );
		
	$lcSQL = "SELECT COUNT(kunde) FROM kunden WHERE ( kunde LIKE '%?%' OR name LIKE '%?%' )"
	        ." AND anbieter=? AND frontpage=1 AND server_id='$ServerID'";

	$loQuery = new SQLQuery( $lcSQL, array( $loName, $loName, new SQLValue($PHP_AUTH_USER,'C') ) );

	$loQuery->doQuery();
	list($total_number) = $loQuery->fetchArray('N');

  $lcSQL = " SELECT MIN(k.kunde) as kunde, MIN(k.name) as name,MIN(k.firstname) AS firstname,".
           " (f.neu*2+f.loeschen) as status FROM kunden k".
        	 " LEFT JOIN frontpage f ON k.kunde = f.kunde AND k.server_id=f.server_id".
           " WHERE ( k.kunde LIKE '%?%' OR k.name LIKE '%?%' ) AND k.anbieter=? AND ".
           " k.frontpage=1 AND k.server_id='$ServerID' GROUP BY k.number".$lcOrder;

	$loQuery->Query( $lcSQL );

 } else {

   $lcSQL = " SELECT MIN(k.kunde) as kunde, MIN(k.name) as name, MIN(k.firstname) AS firstname,".
            " (f.neu*2+f.loeschen) as status FROM kunden k".
        		" LEFT JOIN frontpage f  ON k.kunde = f.kunde AND f.server_id=k.server_id".
        		" WHERE k.anbieter=? AND k.frontpage=1 AND k.server_id='$ServerID'".
        		" GROUP BY k.number".$lcOrder;

	$loQuery = new SQLQuery( $lcSQL, new SQLValue($PHP_AUTH_USER,'C') );

 }
$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue(	new CompoundValue( new ValueFromArray( 'status' ),
											            new ValueFromArray( 'kunde' )),
									new ValueFromArray( 'kunde' ),
									new CompoundValue( new ValueFromArray( 'firstname' ),
											           new ValueFromArray( 'name' )),
									new ValueFromArray( 'kunde' )
								);
$laContent = array();
if( $order == 'status' ) {
	$laContent['status'] = new CompoundDataField( new HTMLDataField( ltext( 'kuss_cell_status' )),
																						 new IconDataField( $lcDirIcon ));
	$laContent['status']->SetSeparator('');
 } else {
	$laContent['status'] = new HTMlDataField( ltext( 'kuss_cell_status' ) );
 }
 if( $order == 'user' ) {
	$laContent['user'] = new CompoundDataField( new HTMLDataField( ltext( 'kufr_cell_user' )),
																						 new IconDataField( $lcDirIcon ));
	$laContent['user']->SetSeparator('');
 } else {
	$laContent['user'] = new HTMlDataField( ltext( 'kufr_cell_user' ) );
 }
 if( $order == 'name' ) {
	$laContent['name'] = new CompoundDataField( new HTMLDataField( ltext( 'kufr_cell_name' )),
																						 new IconDataField( $lcDirIcon ));
	$laContent['name']->SetSeparator('');
 } else {
	$laContent['name'] = new HTMlDataField( ltext( 'kufr_cell_name' ) );
 }
 
 
$loTitle = new CompoundValue( new DataValue( 'status', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','status',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['status']
																																)
																						 ),
															new DataValue( 'user', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','user',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['user']
																																)
																						 ),
															new DataValue( 'name', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','name',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['name']
																																)
																						 ),
															new ValueLocale( 'kuaeku_cell_domains' )
);

$laWidths = array( '5%', '25%', '35%', '40%' );

$loDS->Template( $loTemplate );

//=====================================================================
//
// call back functions to make visible objects

$gcOn = ltext("ll_on");
$gcOnOn = ltext("ll_process_on");
$gcOnOff = ltext("ll_process_off");
$gcOff = ltext("ll_off");

function &createStatusLink( $poSrc ){

	global $gcHeadText, $confixx_interface_version, $gcOn, $gcOnOn, $gcOnOff, $gcOff;
	$lcIconText = "";
	$loNeu =& $poSrc->Value(0);
	$liNeu = $loNeu->Value();
	$loValue =& $poSrc->Value(1);
	$lcUrlUser = urlencode( $loValue->Value() );

	$lcQuery  = "kunde=$lcUrlUser";
if (isset($liNeu)) {
	
	if ($liNeu == 0) {
		$lcIcon = cc_OnIcon;
		$lcTitle = ltext("kufr_fpdeact");
    $lcIconText = $gcOn;
	} elseif( $liNeu == 2) { 
		$lcIcon = cc_StateNewIcon;
		$lcTitle = ltext("kufr_fpdeact");
    $lcIconText = $gcOnOn;
	} elseif ($liNeu == 1) {
		$lcIcon = cc_StateDeleteIcon;
		$lcTitle = ltext("kufr_fpact");
    $lcIconText = $gcOnOff;
	}
} else {
	$lcIcon = cc_OffIcon;
	$lcTitle = ltext("kufr_fpact");
  $lcIconText = $gcOff;

}
	$loLink = new LinkDataField( 'kunden_frontpage_upd.php', 
															 $lcQuery, 
															 array(), 
															 ($confixx_interface_version == 'powp')?
                                new IconDataField( $lcIcon ) : $lcIconText );
															 
	$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
	$loLink->AppendParentAttributes( array( 'align' => 'center' ) );
		
	return $loLink;
}
function &createName($poSrc) 
{
	$lo_firstName = & $poSrc->Value(0);
	$lc_firstName = $lo_firstName->Value();
	$lo_lastName  = & $poSrc->Value(1);
	$lc_lastName  = $lo_lastName->Value();

	return new HTMLDataField($lc_firstName.' '. $lc_lastName);
}


$goDomains = new CompoundDBValue( " SELECT domain, richtigedomain FROM domains ".
                                  " WHERE kunde=? AND server_id='$ServerID' ".
                                  " AND richtigedomain IN (1,7,3) ORDER BY domain" );
	
function &createDomainList( $pcKunde ){
	global $goDomains;

	$goDomains->doQuery( array( new SQLValue( $pcKunde,'C' ) ) );
	
	$loColumn =& $goDomains->getColumn(0);
	$loDomainType =& $goDomains->getColumn(1);
	if ( $loColumn->getCount() > 3 ) {
		$loColumn->keepLeft( 3 );
		$loColumn->addValue( new KeyValue( 'domain', '...' ) );
	}

	$loList = new CompoundDataField();
	$loIter =& $loColumn->getFirstIterator();
  $loIterType =& $loDomainType->getFirstIterator();

  while( $loItem =& $loIter->getNext() && $loItemType =& $loIterType->getNext()){
		$lcDomain = $loItem->Value();
		$liDomainType = $loItemType->Value();
    
    if( $lcDomain == '...' || $liDomainType == 7 ){
			$loList->AppendToContent( new HTMLDataField('<i>'.$lcDomain.'</i>' ) );
		}else{
			/* possibly need to create object before cycle and unset after and of cycle ? */
			$loLinkTmp = new LinkDataField( 'http://'.$lcDomain, '', array(), $lcDomain );
			$loLinkTmp->Attribute( 'target', '_blank');
			$loList->AppendToContent( $loLinkTmp );
		}
	}
	$loList->SetSeparator( ', ' );

	return $loList;
}

// end call back functions
//
//============================================================

$loDS->Conversion( new CompoundValue(	new ValueFormated( 'status', NULL, 'createStatusLink' ),
																			NULL,
									   new ValueFormated( 'name', NULL, 'createName' ),
									   new ValueFormated( 'domains', NULL, 'createDomainList' )
																			)
									 );
																										
$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );
$loPTV->Anchor( 'list' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );

if (isset($name_to_search)&&strlen($name_to_search)) {
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
}	else {
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'kunden_frontpage_list.php#list',
																						 'name' => 'list_fp' ), 
																			ltext( 'kufr_cell_title1' ) 
																			);


$dsSearch = new CompoundValue( new ValueFromArray( 'name_to_search', $name_to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'name_to_search', 
																																	'size' => '16',
																																	'value' => $name_to_search,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,$listFormIndex)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('name_to_search','',$listFormIndex);submitForm('start_index',1,$listFormIndex)", 
																							 'bid-show-all'
																							 ) 
													);

$loSearch->setDataSource( $dsSearch, array( 'name_to_search' => $name_to_search ) );

$tbl->setSearchElement( $loSearch );

$tbl->updateBodyContent();
	
$page = new MainPageElement( $tbl );

$page->OutputHTML( array( '../../js/paged_form.js' ) );

/* -------------------- end HTML -------------------- */
?>
