package Modules::Restore::Tables::Table_ipadressen;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use XML::DOM;
use XML::DOM::NodeList;

use DBI;

use Modules::Restore::Map;
use Modules::Restore::Tables::Common;
use Modules::Restore::Table;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;
use Modules::Restore::Tables::Common qw(&update_query &insert_query);


my @ordIPs;
my $indIP;

sub pre_map_tab($$$$) {

  my ($table_name, $ptrConfXML,$clean,$xmlTable) = @_;

#  print "pre mapping table 'ipadressen'\n" if $::DEBUG;

  my $sth=$main::dbh->prepare( "SELECT ip,anbieter FROM ipadressen ".
															 " WHERE status=1 AND server_id='$::ServerID' ORDER by anbieter" );
  return 1 unless $sth;
  $sth->execute();

  my ($anbieter,$ip);
  @ordIPs = ();
  while( ( $ip ) = $sth->fetchrow ){
    next unless $ip;
    next unless ($ip=~/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/);
    push @ordIPs,$ip;
  }
  $sth->finish;
  $indIP = 0;
  return 0;
}

sub map_row($$$) {
  my ($table_name, $ptrRow, $ptrTable) = @_;

#  print STDERR "processing reseller '$ptrAttrs->{'anbieter'}'\n" if $::DEBUG;

#  my $anbieter=$ptrAtts->{'anbieter'};
  my $ip=$ptrRow->{'ip'};
  return 0 unless $ip;
  return 0 unless ($ip=~/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/);

  if( $indIP < @ordIPs ){
    $main::map->add_attr( "ip($ip).address", $ordIPs[$indIP++] );
  }else{
    $main::map->add_attr( "ip($ip).address", '');
  }
  return 0;

}

sub pre_restore_tab($$$$) {
  my ($table_name, $ptrConfXML,$clean,$xmlTable) = @_;
  my $ptrHash = $::map->getAttrHash('ip(*).address');
  my $table = $ptrConfXML->getTable($table_name);
  unless( ref($table) =~ /Table/ ){
    print STDERR "Error: Tables::Table_ipadressen: table '$table_name' not found\n";
    return 0;
  }
  while( my( $oldIP, $newIP) = each( %{$ptrHash}) ){
    $table->addToMap('ip',$oldIP,$newIP);
  }
  return 0;
}

sub restore_row($$$){
  my ($table_name, $ptrRow, $ptrTable) = @_;
  my ($oldIP,$newIP,$sql,$sth,$where,$key);

	return 0 unless $ptrRow->{'status'}; ## restore only active IP

  $oldIP = $ptrRow->{'ip'};

  $newIP = $ptrTable->getMappedValue('ip',$oldIP);
  return 0 unless($newIP);

  
  $sql = "SELECT ip FROM $table_name WHERE server_id='$::ServerID' AND ip='$newIP'";
  $sth = $main::dbh->prepare($sql);
  unless( $sth->execute ){
    return 0;
  }
  if( $sth->rows ){
    $where = "ip='$newIP'";
    delete( $ptrRow->{'ip'} );
  }else{
    $ptrRow->{'ip'} = $newIP;
  }
  $sth->finish;

  my ($oldValue,$newValue);

#
# map user
#
  $oldValue = $ptrRow->{'kunde'};
  if( $oldValue ){
    $key = "user($oldValue).name";
    if( $newValue = $main::map->get_attr( $key ) ){
      $ptrRow->{'kunde'} = $newValue;
    }
  }

#
# map reseller
#
  $oldValue = $ptrRow->{'anbieter'};
  if( $oldValue ){
    $key = "reseller($oldValue).name";
    if($newValue = $main::map->get_attr($key)){
      $ptrRow->{'anbieter'}=$newValue;
    }
  }

  if($where){
    &Modules::Restore::Tables::Common::update_query($table_name, $ptrRow, $where);
  }else{
    &Modules::Restore::Tables::Common::insert_query($table_name, $ptrRow);
  }

  return 0;
}

return 1;
