package Modules::SQL::SQLTable;

use DBI;
use strict;

use Modules::SQL::SQLField;

#
# constructor
#

sub new {
	my $classname = shift;
	my( $name, $myDbh, $db_type ) =@_;

	my $this = { 'name' => $name,
							 'dbh' => ( ref( $myDbh ) =~ /DBI/ )? $myDbh: $::dbh,
							 'fields' => {},
							 'index' => []
						 };

	if( $db_type ){
		$this->{'type'} = ( $db_type =~ /Pg/i )? 'Pg': 'mysql';

	} else {
		$this->{'type'} = 'mysql';
		if( ref( $this->{'dbh'} ) =~ /DBI/ ){
		    my $type = $this->{'dbh'}->get_info(17);

		    if( $type =~ /Postgre/ ){
			$this->{'type'} = 'Pg';
		    }
		}
	}

	bless( $this, $classname );

	if( $name && ref( $this->{'dbh'} ) ){
		$this->getSQLInfo();
	}

	return $this;
}

#
# members
#

sub DBH {
	my $this = shift;
	if( @_ ){
		my $myDbh = shift;
		if( ref( $myDbh ) =~ /DBI/ ){
			$this->{'dbh'} = $myDbh;
		}
	}
	return $this->{'dbh'};
}

sub Field {
	my $this = shift;
	my $fieldName  = shift;
	if(@_){
		my $newField = shift;
		if( ref( $newField ) =~ /SQLField/ ){
			unless( exists($this->{'fields'}->{$fieldName})){
				push @{$this->{'index'}}, $fieldName;
			}
			$this->{'fields'}->{$fieldName} = $newField;
		}
	}
	return $this->{'fields'}->{$fieldName};
}

#
# /members
#

#
# methods
#

sub getSQLInfo {
	my $this = shift;
	my $myDbh = shift;

	my ( $ref, $sql, $field, $fieldName );

	if( ( $ref = ref( $myDbh ) ) =~ /DBI/ ){
		$this->{'dbh'} = $myDbh;

	} elsif( ! $ref && $myDbh ) {
		$sql = $myDbh;

	} else {
		if( $this->{'type'} =~ /mysql/ ){
			$sql = 'SELECT * from `'.$this->{'name'}.'` limit 1';

		}elsif($this->{'type'} =~ /Pgl/ ){
      $sql= 'SELECT * from "'.$this->{'name'}.'" limit 1';

		}else{
      $sql= 'SELECT * from '.$this->{'name'}.' limit 1';
		}
	}
	
	$this->{'dbh'}->{'PrintError'} = 0;

	my $sth = $this->{'dbh'}->prepare( $sql );

	unless( $sth->execute ){
		print STDERR "Can not select data from table '",$this->{'name'},"'. Probably, the table does not exist.\n";	
		return undef;
	}	

	$this->{'dbh'}->{'PrintError'} = 1;
	
	my $fldNumb = $sth->{'NUM_OF_FIELDS'};

	$this->clean();

	for( my $j = 0; $j < $fldNumb; $j++ ){

		$field = Modules::SQL::SQLField->new( $sth, $j, $this->{'type'} );

		$fieldName = $field->Name();

		$this->{'fields'}->{$fieldName} = $field;
		push @{$this->{'index'}}, $fieldName;

	}

	$sth->finish;

	return $fldNumb;
}

sub clean {
	my $this = shift;

	map{ $this->{'fields'}->{$_}->clean() } keys %{$this->{'fields'}};

	$this->{'index'} = [];
	$this->{'fields'} = {};
}

#
# /methods
#
1;
