#!/usr/bin/perl
BEGIN{
	use Cwd;
	use FindBin;
	use File::Basename;

  use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib dirname($FindBin::Bin).'/subs';
	use lib dirname(dirname($FindBin::Bin));
}

use FindBin;
use File::Basename;
use File::Path;
use Cwd;
use Getopt::Long;

use Cwd qw/abs_path/;

use DBI;
use XML::DOM;

use strict;

use lib_module_common;
use lib_module_db;
my @config_opts = (
									'src|s=s', 
									  'help|h',
									 'debug|dbg',
									 'config|c=s'
									);

my %args = ();

unless( &GetOptions( \%args, @config_opts ) ){
	&printHelp;
	die;
}

if( exists($args{'help'} ) ){
	&printHelp;
	exit 0;
}


if( exists( $args{'config'} ) && -f $args{'config'} ){
	&initConfig( $args{'config'} );
}else{
	&initConfig();
}

my $dbh = DBI->connect( $db_address, $dbUser, $dbPw ) or
	die "Error connect to database: $DBI::errstr\n";


my $cwd = getcwd();
if( exists($args{'src'})){
  if( -d $args{'src'} ){
	$cwd = $args{'src'};
  }else{
	&printHelp();
	die "Error: '".$args{'src'}."' is not a dir\n";
  }
}
unless( opendir(CWD, $cwd ) ){
	die "Error open dir '$cwd': $!\n";
}

my( $srcDir, $info, $xmlInfo, $content, $script, $webappId, $webappName );

my $xmlParser = new XML::DOM::Parser;

my %default_param = map{ $_ => 1 } qw/vhost_path ssl_target_directory domain_name/;

while( my $dir = readdir( CWD ) ){
	next if $dir =~ /^\.\.?$/;
	$srcDir = "$cwd/$dir";
	next unless -d $srcDir;
	
	$info = $srcDir.'/info/info.xml';
	next unless -f $info;
	
	print "prepare $srcDir ...";
	
	if( open( INFO, $info ) ){
		$content = '';
		while( <INFO> ){
			s/(\r|\n)+$//;
			$content .= $_;
		}
		close(INFO);
		$xmlInfo = $xmlParser->parse( $content );

		($webappId,$webappName) = &parseInfo( $xmlInfo, $dir );

		$xmlInfo->dispose;

		$script = $srcDir.'/scripts/postinstall';
		if( -f $script ){
			&adjustParam( $script, $webappId );
		}

		$script = $srcDir.'/forms/installer-handler-1.php';
		if( -f $script ){
#			&adjustPasswd( $script, $webappName );
		}
		
		print " ... ok\n";
	}else{
	    warn "error open file: $info: $!\n";
	}
}
closedir( CWD );

#fixups 
  my $cmdPrefix =  $bin_mysql.' '.&makeCmdLine( { 'server' => $dbServer,
                                                    'port' => $dbPort,
                                                    'user' => $dbUser,
                                                    'password' => $dbPw}
                                                );
      
  my $srcSQL = "$installDir/admin/siteapps/webapp_param_defaults.sql";
  my @fixups = `ls $installDir/admin/siteapps/*.sql`;
  my $fixup;
  foreach $fixup (@fixups){
    chomp $fixup;
    if ( -e $fixup){
  		my $cmd = "$cmdPrefix $dbDB <$fixup";
  		system $cmd;
    }
  }

$dbh->disconnect;
#
#
#=============================================
#
#
#

sub adjustPasswd{
	my( $script, $webappName ) = @_;
	unless( $webappName ){
		warn "Web application's name is not set\n";
		return undef;
	}
	unless( open( SCRIPT, '<', $script ) ){
		warn "Error open file '$script': $!\n";
		return undef;
	}
	
	my( $arg, $tail, $hash );
	my $state = 0;
	while( <SCRIPT> ){
		if( $state == 0 ){
			if(/function\s+my_crypt\s*\(\s*(\S+)\s*\)/){
				$arg = $1;
				$state = 1
			}elsif(/sapp_set_param\s*\(\s*'admin_passwd'\s*,\s*(.+)/ ){
				$tail = $1;
				if( $tail =~ /^md5\s*\(/ ){
					$hash = 'md5';
					last
				}elsif( $tail =~ /^\$admin_passwd/ ){
					$hash = 'plain';
					last;
				}
			}
			
		}elsif( $state == 1 ){
			if( /return\s+(.+)/ ){
				$state = 0;
				$tail = $1;
				if( $tail =~ /^md5\s*\(/ ){
					$hash = 'md5';
					last
				}elsif( $tail =~ /^\$\Q$arg\E/ ){
					$hash = 'plain';
					last;
				}
			}
		}
	}
	close( SCRIPT );
	if( $hash ){
		my $where = "webapp=? AND server_id='$ServerID'";
		my $sth = $dbh->prepare( "SELECT COUNT(*) FROM webapp_knowledge WHERE $where");
		unless( $sth->execute( $webappName ) ){
			die "Error sql query: $DBI::errstr\n";
		}
		my( $cnt ) = $sth->fetchrow;
		$sth->finish;

		if( $cnt > 1 ){
			$dbh->do( "DELETE FROM webapp_knowledge WHERE $where", undef, $webappName );
			$cnt = 0;
		}
		my( $sql );
		if( $cnt ){
			$sql = "UPDATE webapp_knowledge SET hash_type='$hash' WHERE $where";
		}else{
			$sql = "INSERT into webapp_knowledge (webapp,server_id,hash_type ) VALUES (?,'$ServerID','$hash')";
		}
		unless( $dbh->do( $sql,	undef, $webappName ) ){
			die "Error sql query: $DBI::errstr\n";
		}
	}
	return $hash;
}

sub adjustParam{
	my( $script, $webappId ) = @_;

	unless( $webappId =~ /^\d+$/ ){
		warn "Web application ID is not set\n";
		return undef;
	}

	unless( open( SCRIPT, '<', $script ) ){
		warn "Error open file '$script': $!\n";
		return undef;
	}
	my $line = <SCRIPT>;
	my $val = '';
	my $strong = 0;
	if( $line =~ /^#!.+perl/ ){
		my $state = 0;
		while(<SCRIPT> ){
			if( $state == 0 ){
				if( /\@imp_params\s*=\s*(.*)/ ){
					$val = $1;
					if( $val =~ s/;.*$// ){
						$strong = 1;
						last;
					}else{
						$state = 1;
					}
				}
			}elsif( $state == 1 ){
				if( s/;.*$// ){
					$val .= ' '.$_;
					last;
				}
			}
		}

	}else{
		my %toFind = map{ $_ => qr/$_/ } qw/install_prefix admin_fullname/;
		my @found = ();
		my( @keys, $key, $re );
		while( <SCRIPT> ){
			@keys = keys %toFind;
			last unless @keys;
			foreach $key ( @keys ){
				$re = $toFind{$key};
				if(/$re/){
					push @found, $key;
					delete $toFind{$key};
				}
			}
		}
		if( @found ){
			$val = 'qw/'.join(' ',@found ).'/';
		}
	}

	close( SCRIPT );
	
	return undef unless $val;

	my $cmd = '@imp_params='.$val.';';
				
	my @imp_params = ();
	eval $cmd;

	unless( @imp_params ){
		return 0;
	}

	my %imp = map{
		$_ => undef;
	} grep {
		! exists $default_param{$_};
	} @imp_params;

	my $sql = "SELECT name, id FROM webapp_param WHERE webapp_id=$webappId AND server_id='$ServerID'";
	my $sth = $dbh->prepare( $sql );
	unless( $sth->execute ){
		warn "Error sql query: '$sql': $DBI::errstr\n";
		return undef;
	}
	my( %names, $name, $id, @to_delete );
	while( ( $name, $id ) = $sth->fetchrow ){
		if( exists $imp{$name} ){
			delete $imp{$name};
			next;
		}else{
			push @to_delete, $id;
		}
	}
	$sth->finish;

	if( $strong && @to_delete ){
		$sql = "DELETE FROM webapp_param WHERE server_id='$ServerID' AND id IN (".
			join( ',', @to_delete ).")";
		$dbh->do( $sql );
	}
	if( keys %imp ){
		$sth = $dbh->prepare( "INSERT INTO webapp_param(server_id,webapp_id,name) ".
													" VALUES ('$ServerID',$webappId, ? )" );
		foreach $name ( keys %imp ){
			$sth->execute( $name );
		}
	}
	return 1;
}

sub parseInfo{
	my( $xmlRoot,$path) = @_;
	my ( $webappId, $nodeName, $webappName );
	foreach my $kid ( $xmlRoot->getChildNodes() ){
		next unless( $kid->getNodeType == ELEMENT_NODE );
		$nodeName = $kid->getNodeName();
		if( $nodeName =~ /WEBAPP/i ){
			($webappId, $webappName ) = &parseWebapp( $kid, $path );
		}
	}

	return ($webappId, $webappName );
}

sub parseWebapp{
	my( $xmlRoot, $path ) = @_;
	my $webappName = $xmlRoot->getAttribute( 'name' );
	my $version = $xmlRoot->getAttribute( 'version' );
	my $release = $xmlRoot->getAttribute( 'release' );

	return undef unless $webappName;

	my($webappId, $sql, $nodeName);
	my $sth = $dbh->prepare( "SELECT id FROM webapp WHERE name='$webappName' AND server_id='$ServerID'" );
	if( $sth->execute ){
		( $webappId ) = $sth->fetchrow;
		$sth->finish;
	}
	if( $webappId ){
		$sql = "UPDATE webapp SET name=?, version=?, rls=?, path=? WHERE id=$webappId AND server_id='$ServerID'";
	}else{
		$sql = "INSERT INTO webapp (name,version,rls,path,server_id) VALUES ( ? , ? , ? , ? , '$ServerID' )";
	}
	unless( $dbh->do( $sql, undef,
										$webappName,$version,$release,$path ) ){
		return undef;
	}
	unless( $webappId ){
		if( $sth->execute ){
			( $webappId ) = $sth->fetchrow;
			$sth->finish;
		}
	}

	foreach my $kid ( $xmlRoot->getChildNodes() ){
		next unless( $kid->getNodeType == ELEMENT_NODE );
		$nodeName = $kid->getNodeName();

		if( $nodeName =~ /ATTRIBUTES/i ){
			&parseAttr( $webappId, $kid );

		}elsif( $nodeName =~ /REQUIREMENTS/i ){
			&parseRequir( $webappId, $kid );

		}elsif( $nodeName =~ /PROPERTIES/i ){
			&parseProp( $webappId, $kid );
		}		

	}
	return ($webappId, $webappName );
}


sub parseAttr{
	my( $id, $xmlRoot ) = @_;
	return undef unless $id;

	my( $nodeName );

	foreach my $kid ( $xmlRoot->getChildNodes() ){
		next unless( $kid->getNodeType == ELEMENT_NODE );
		$nodeName = $kid->getNodeName();
		if( $nodeName =~ /DESCRIPTION/i ){
			
			my $xmlDescr = $kid->getFirstChild();
			my $descr = $xmlDescr->getData();
			$dbh->do( "UPDATE webapp SET descr=? WHERE id=$id AND server_id='$ServerID'",
								undef, $descr );
		}
	}	
	return $id;
}

sub parseRequir{
	my( $id, $xmlRoot ) = @_;
	my( $type, $name, $val, $nodeName );

	return undef unless $id;

	$dbh->do( "DELETE FROM webapp_requir WHERE webapp_id=$id AND server_id='$ServerID'" );

	foreach my $kid ( $xmlRoot->getChildNodes() ){
		next unless( $kid->getNodeType == ELEMENT_NODE );
		$nodeName = $kid->getNodeName();
		if( $nodeName =~ /VERSION/i ){
			$type = 'version';
			$name = $kid->getAttribute( 'name' );
			$val = $kid->getAttribute( 'value' );

			$dbh->do( "INSERT INTO webapp_requir (webapp_id,type,name,val,server_id) ".
								" VALUES($id, ?, ?, ?, '$ServerID' )",
								undef, $type,$name,$val );

		}elsif( $nodeName =~ /APACHE_VHOST/i ){
			$type = 'vhost';
			$name = $kid->getAttribute( 'name' );
			$val = $kid->getAttribute( 'value' );

			$dbh->do( "INSERT INTO webapp_requir (webapp_id,type,name,val,server_id) ".
								" VALUES($id, ?, ?, ?, '$ServerID' )",
								undef, $type,$name,$val );
		}		
	}

	return $id;
}

sub parseProp{
	my( $id, $xmlRoot ) = @_;

	return undef unless $id;

	my( $name, $default, $type, $valtype, $nodeName );

	$dbh->do( "DELETE FROM webapp_param WHERE webapp_id=$id AND server_id='$ServerID'" );

	foreach my $kid ( $xmlRoot->getChildNodes() ){
		next unless( $kid->getNodeType == ELEMENT_NODE );
		$nodeName = $kid->getNodeName();
		next unless $nodeName =~ /PROPERTY/i;
		
		$name = $kid->getAttribute( 'name' );
		next unless $name;

		$default = $kid->getAttribute( 'default' );
		$type = $kid->getAttribute( 'type' );
		$valtype = $kid->getAttribute( 'valtype' );		
		
		$dbh->do( "INSERT INTO webapp_param ( webapp_id, name, def_val, type, valtype, server_id ) ".
						" VALUES( $id, ?, ?, ?, ?, '$ServerID' )",
						undef, $name, $default, $type, $valtype );
		
	}

	return $id;
}

sub printHelp{
	print STDERR <<HELP;

Analuse web applications

Usage:
  analyse.pl 

Arguments:  
  --config|-c <path-to-config>
  --src   |-s <dir-of-pakcages>

HELP

}
