#!/usr/bin/perl


use FindBin;
use File::Basename;
use File::Path;
use Cwd;
use Getopt::Long;

use Cwd qw/abs_path/;

use strict;

my @config_opts = ( 'src|s=s',
										'dst|d=s',
										'debug|dbg',
										'help|h'
									);
my %args = ();

unless( &GetOptions( \%args, @config_opts ) ){
	&printHelp;
	die;
}

if( exists( $args{'help'} ) ){
	&printHelp;
	exit 0;
}

my ($bin_uudecode,$bin_tar) = &findBin( 'uudecode', 'tar' );

$bin_uudecode ||= '/usr/bin/uudecode';
$bin_tar ||= '/bin/tar';

unless( -x $bin_uudecode ){
	die "Error: '$bin_uudecode' is not found or not executable\n";
}

unless( -x $bin_tar ){
	die "Error: '$bin_tar' is not found or not executable\n";
}


my $cwd = getcwd();
if( $args{'src'} ){
	unless( -d $args{'src'} ){
		&printHelp;
		die "Error: '".$args{'src'}."' is not a dir\n";
	}
	$cwd = $args{'src'};
}

my $dstDir = $cwd;

if( $args{'dst'} ){
	unless( -d $args{'dst'} ){
		&printHelp;
		die "Error: '".$args{'dst'}."' is not a dir\n";
	}
	$dstDir = $args{'dst'};
}


unless( opendir(CWD, $cwd ) ){
	die "Error open dir '$cwd': $!\n";
}

my( $shPath, $cmd, $name, $dir, $dstPath, $single, $tmpDir );

while( my $sh = readdir( CWD ) ){
	next unless $sh =~ /(.+)\.sh$/;
	$name = $1;
	$shPath = "$cwd/$sh";
	next unless -f $shPath;

	$dir = '';
	if( open( SH, $shPath ) ){
		while( <SH> ){
			if( /begin\s+\d+\s+(\S+)(\.tar\.gz|\.tgz)/ ){
				$dir = '/'.$1;
				last;
			}
		}
		close( SH );
	}

	print "extract $name ...";

	$dstPath = "$dstDir$dir";

	if( -d $dstPath ){
		rmtree( $dstPath );
	}

	mkdir( $dstPath );

	$cmd = "$bin_uudecode -o /dev/stdout $shPath | $bin_tar -C $dstPath -xzf -";
	if( system( $cmd ) ){
		warn "error execute: $cmd: $!\n";
	}

	$single = undef;
	if( opendir( DST, $dstPath ) ){
		while( $dir = readdir( DST ) ){
			next if $dir =~ /^\.\.?$/;
			if( $single ){
				$single = undef;
				last;
			}
			$single = $dir;
		}
		closedir( DST );
	}

	if( $single ){
		$tmpDir = "$dstDir/temp";
		rmtree( $tmpDir ) if -d $tmpDir;
		rename( $dstPath, $tmpDir );
		system( "mv $tmpDir/$single $dstPath" );
		rmtree( $tmpDir ); 
	}

	print " ... ok\n";
}

closedir( CWD ); 

#
#
#==================================================
#
#

sub findBin{
	my @bins = @_;
	my @dirs = qw|/bin /usr/bin /sbin /usr/sbin /local/bin /local/sbin /local/usr/bin /local/usr/sbin|;
	my( @result, $bin, $dir, $path, $found );
	foreach $bin ( @bins ){
		$found = 0;
		foreach $dir ( @dirs ){
			$path = "$dir/$bin";
			if( -x $path ){
				push @result, $path;
				$found = 1;
				last;
			}
		}
		unless( $found ){
			push @result, $bin;
		}
	}
	return @result;
}

sub printHelp{
	print STDERR <<HELP;

Extract web applications from sh-pakcages

Usage:
  extract.pl [--src|-s] <src-dir> [--dst|-d] <dst-dir>

HELP

}
