#!/usr/bin/perl

########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####


# Error codes (DBI:1xxx, IO: 2xxx)
# IO:
# DBI: 38

use DBI;
use strict;

use lib_module_common;
use lib_module_events;
use lib_module_db;
use lib_module_messaging;

use vars qw/$confixxInstallScript $createDB $psqldump $mysqldump $wDir/;

## /Pre-Main
$createDB = 0;
unless($confixxInstallScript){
  die "Can do 'createDB_install.pl' ONLY from install.pl\n";
}
&header2( &ltext('install_header_db') );
## Pre-Main


## Main
if ( $dbType eq 'mysql' ) {
  &CreateDBMysql;

} else {
  &CreateDBPostgres;
}

my $support_master_module = 0;

my $dbh = &CreateAdminDefaults;

&installTypes( $dbh );

&fillTables( $dbh ); 

$dbh->disconnect;

$createDB = 1;
## /Main


## Unterprogramme
sub CreateDBPostgres{
  my $file = $psqldump;
  print &ltext('install_db_psql_pw', $dbUser);

  my ($dbaddress, $dbh, $return, $cmd);

  $dbaddress = &makeDSN($dbType,$dbServer,$dbRootUser,$dbPort);

  $dbh = DBI->connect( $dbaddress, $dbRootUser, $dbRootPw )
    or die( &ltext('db_connect', '#2018', $DBI::errstr) );


	my $DSN = &makeDSN($dbType,$dbServer, $dbDB, $dbPort);
	my $dbhCheck = DBI->connect( $DSN, $dbRootUser, $dbRootPw );
	if( $dbhCheck ){
		$dbhCheck->disconnect;

    if ( &YesNoQuestion (&ltext('install_db_mysql_db_exists', $dbDB ) ) ) {
      $dbh->do("DROP DATABASE $dbDB") 
				or die("#2017: $DBI::errstr\n");
    }
	}

  $dbh->do("CREATE DATABASE $dbDB") 
    or die("#2017: $DBI::errstr\n");
  $dbh->disconnect;


	$bin_psql ||= $bin{'psql'} || 'psql';

	if( $dbServer eq 'localhost' ){
		$cmd = "$bin_psql $dbDB -U $dbUser -f $file";
	} else {
		$cmd = "$bin_psql -h $dbServer $dbDB -U $dbUser -f $file";
	}

  if ( $return = system( $cmd ) ) {
		&hard_error ( &ltext('update_db_table_add_err', $dbDB) );
	}
}


sub CreateDBMysql{
  my ($host, $return);

  if($dbServer eq 'localhost'){
		$dbMysqlHost ||= 'localhost';
  } else {
		$dbMysqlHost ||= $hostname;
  }


  my ($dbaddress, $dbh, $sthUser, $sthDb, $weiter, $exists, $check);

  $dbaddress = &makeDSN($dbType,$dbServer,'mysql',$dbPort);

  $dbh = DBI->connect($dbaddress, $dbRootUser, $dbRootPw)
    or die( &ltext('db_connect', '#2018', $DBI::errstr) );

	$sthUser = $dbh->prepare( "SELECT User FROM user WHERE User=? AND Host=?" );

  if ( $dbRootUser ne $dbUser ) {

    $weiter = 1;
		$check = 1;
    while( $weiter ){

      $weiter = 0; ## don't continue loops

			if( $check ){ ## check if there is the user
				$sthUser->execute( $dbUser, $dbMysqlHost );
				$exists = $sthUser->rows;
				$sthUser->finish;

				$check = 0;

			}else{
				$exists = 0;
			}

      if( $exists && ! $rpm_version_flag ){
				if( &YesNoQuestion( &ltext('install_db_mysql_user_exists', $dbUser, $dbServer))){

					$dbUser = &Question( &ltext('install_question_mysqluser', $dbDB) , 'confixx');
					$dbPw = &PassQuestion( &ltext('install_question_mysqlpass', $dbUser, $dbServer), '');
					$check = 1; ## check if there is the user
				}
				$weiter = 1; ## make yet loop
				
			} else {
			
				print &ltext('install_db_mysql_db_perms', $dbDB);
	
				$dbh->do( "GRANT ALL PRIVILEGES ON $dbDB.* TO '$dbUser'\@'$dbMysqlHost'".
									" IDENTIFIED BY '$dbPw'" ) or
										die("#2016: $DBI::errstr\n");

				$dbh->do( "UPDATE user set Password = Password('$dbPw') ".
									" WHERE User='$dbUser'" )	or
										die( "$DBI::errstr\n" );
			
				$dbh->do( "FLUSH PRIVILEGES" ) or
					die("#2016: $DBI::errstr\n");
				
      }
    }
  }

  print &ltext('install_db_db_create', $dbDB),"\n";

	$bin_mysql ||= $bin{'mysql'} || 'mysql';

	my $cmdPrefix = "$bin_mysql -v ";
	$cmdPrefix .= &makeCmdLine( { 'server' => $dbServer, 
																'port' => $dbPort,
																'user' => $dbUser,
																'password' => $dbPw}
														);
	
	my $cmd = "$cmdPrefix -e 'use $dbDB' 2>&1";

	my $out = `$cmd`;
	chomp $out;
  if ( $out ) {
		if ( $out =~ /\Q$dbUser\E\@([^\s'"]+)/ ) { ## Access denied
			$dbMysqlHost = $1;

      $sthUser->execute( $dbUser, $dbMysqlHost );
      unless( $sthUser->rows ) {
				$dbh->do("INSERT INTO user (Host, User, Password, Select_priv, Insert_priv,".
								 " Update_priv, Delete_priv,".
								 " Create_priv, Drop_priv, File_priv, Grant_priv, Alter_priv) ".
								 " VALUES ('$dbMysqlHost', '$dbUser', Password('$dbPw'), 'N', 'N',".
								 " 'N', 'N', 'N', 'N', 'N', 'N', 'N')") or 
									 die("#2016: $DBI::errstr\n");
			}
			$sthUser->finish;

			$sthDb->execute( $dbUser, $dbMysqlHost );
			unless ( $sthDb->rows ) {
				$dbh->do("INSERT INTO db (Host, Db, User, Select_priv, Insert_priv, Update_priv,".
								 " Delete_priv,".
								 " Create_priv, Drop_priv, Grant_priv, Alter_priv)".
								 " VALUES ('$dbMysqlHost', '$dbDB', '$dbUser', 'Y', 'Y', 'Y',".
								 " 'Y', 'Y', 'Y', 'Y', 'Y')" ) or 
									 die("#2016: $DBI::errstr\n");
			}
			$sthDb->finish;

			$dbh->do("FLUSH PRIVILEGES") or
				die("#2016: $DBI::errstr\n");


			$dbh->do( "GRANT ALL PRIVILEGES ON $dbDB.* TO '$dbUser'\@'$dbMysqlHost' ".
								" IDENTIFIED BY '$dbPw'"
							)	or
								die("$DBI::errstr\n");
			
			$dbh->do( "FLUSH PRIVILEGES" )or
				die( "#2016: $DBI::errstr\n");

			$out = `$cmd`; ## repead checking
			chomp $out;

		}
	}

	unless( $out ) {
    if( &YesNoQuestion( &ltext( 'install_db_mysql_db_exists', $dbDB ) ) ) {
      $dbh->do( "DROP DATABASE $dbDB" ) or
				die("#2017: $DBI::errstr\n");
    }
  }

  $dbh->do( "CREATE DATABASE $dbDB" ) or
		die( "#2017: $DBI::errstr\n" );
  $dbh->disconnect;

	$cmd = "$cmdPrefix $dbDB <$mysqldump";
	
  if ( $return = system( $cmd ) ) {
		&hard_error ( &ltext('update_db_table_add_err', $dbDB) );
	}

	if( $ServerID ){

		$dbaddress = &makeDSN( $dbType, $dbServer, $dbDB, $dbPort );

		$dbh = DBI->connect($dbaddress, $dbUser, $dbPw) or
			die ( &ltext('db_connect', '#2009', "$DBI::errstr") );

		if( open( DUMP, '<', $mysqldump ) ){
			while( <DUMP> ){
				if( /(?:;|^)\s*CREATE\s+TABLE\s+(\S+)(?:\(|\s)/i ){
					my $sql = "ALTER TABLE $1 ALTER server_id SET DEFAULT '$ServerID'";
					$dbh->do( $sql );
				}
			}
			close( DUMP );
		}else{
			warn "Open file '$mysqldump' error: $!\n";
		}

		$dbh->disconnect;

	}
}


sub CreateAdminDefaults{

	my( $dontDisconnect ) = @_;

  my ($use_webalizer,$use_frontpage);
  (-x $bin_webalizer) ? ($use_webalizer = 1) : ($use_webalizer = 0);
  (-x $bin_fpsrvadm) ? ($use_frontpage = 1) : ($use_frontpage = 0);
  my ($index, $dbh, $dbaddress);

	my $index_file = "$wDir/languages/$language/default_index.html";

	if( -f $index_file ){
		if( open( IN, '<', $index_file ) ){
			while( <IN> ){
#
# bug #76556
#
#				s/##domain##/$hostname/g;
#				s/##confixx_domain##/$confixx_domain/g;

				$index .= $_;
			}
			close(IN);
		}
	}

	unless( $index ){
		$index = &ltext( 'install_default_indexcode', $hostname );
	}

  my ($use_mail);
  if($mta eq "noEmail" || $mta eq ""){
    $use_mail = 0;
  }
  else{
    $use_mail = 1;
  }

	$use_quota ||= 0;
	$use_SSL ||= 0;
	$use_dns ||= 0;
	$use_dnr ||= 0;
	$awstats ||= 0;

  $dbaddress = &makeDSN( $dbType, $dbServer, $dbDB, $dbPort );

  $dbh = DBI->connect($dbaddress, $dbUser, $dbPw) or
		die ( &ltext('db_connect', '#2009', "$DBI::errstr") );

  my $sth = $dbh->prepare("SELECT * FROM webmail_sign");
  $sth->execute or 
		die ("#2020: $DBI::errstr\n");
  while( my @row = $sth->fetchrow_array ){
    # nothing;
  }
	$sth->finish;

  my $use_pop = $mail_pop3Server?1:0;
 
	$use_webmail = 1 unless defined( $use_webmail );
	$use_webftp = 1 unless defined( $use_webftp );

	my $dnstemplate = "##domain##.      86400  IN   A         ##ip##\n".
		                "*.##domain##.   86400  IN   A         ##ip##\n\n".
										( ( !$mail_server &&
												$mail_pop3Server &&
												( $mail_pop3Server ne 'localhost' ) &&
												( $mail_pop3Server ne '127.0.0.1' )
											)?	
											"##domain##.     86400   IN   MX 10   $mail_pop3Server.\n\n":
											"##domain##.     86400   IN   MX 10   mail.##domain##.\n\n" ).
										"##domain##.     86400   IN   NS        ##ns1##.\n".
										"##domain##.     86400   IN   NS        ##ns2##.";

	my %admin = ( 'passwort' => [ '', 'C' ],
								'mysqlshelluser' => [ $mysql_shell_user, 'C' ],
								'mysqlshellpasswort' =>[ $mysql_shell_user_pw, 'C' ],
								'mysqlshellhost' => [ $mysql_shell_user_host, 'C' ],
								'pop' => $use_pop,
								'email' => $use_mail,
								'webftp' => $use_webftp,
								'webmail' => $use_webmail,
								'mysql' => $use_mysql,
								'lokaleips' => [ $lokaleips, 'C' ],
								'minuid' => $min_uid,
								'maxuid' => $max_uid,
								'standardip' => [ $stdIP, 'C' ],
								'quota' => $use_quota,
								'indexcode' => [ $index, 'C' ],
								'indexfile' => [ 'index.html', 'C' ],
								'cssl' => $use_SSL,
								'frontpage' => $use_frontpage,
								'statistik' => $use_webalizer,
								'standarddomain' => [ $stdDomain, 'C' ],
								'longpw' => [ $confixx_admin_pw_crypt, 'C' ],
								'dns' => $use_dns,
								'ip_pns' => [ $ip_pns, 'C' ],
								'ip_sns' => [ $ip_sns, 'C' ],
								'dnstemplate' => [ $dnstemplate, 'C'],
								'dnr' => $use_dnr, 
								'userprefix' => [ $user_prefix, 'C' ],
								'spamfilter' => $spamassassin_support,
								'coldfusion' => $coldfusion_support,
								'cronjobs' => $cronjobs_support,
								'modpython' => $modpython_support,
								'hostname' => [ $hostname, 'C'],
								'personalinfoid' => 0,
								'checkupdates' => 1,
								'confixx_ip' => [ $confixx_IP, 'C' ],
								'confixx_domain' => [ $confixx_domain, 'C' ],
								'awstats' => $awstats
							);

  my $scponly = 0;
  if ( $scponly_shell && -x $scponly_shell ) {
    $scponly = 1;
  }
	$admin{'scponly'} = $scponly;

  if ( $use_phpmyadmin ) {
		$admin{'phpmyadmin'} = 1;
		$admin{'phpmyadminpfad'} = [ $phpmyadminpfad, 'C' ];
  }

  if ( $support_master_module ) {
		$admin{'business'} = 1;
  }
  unless( $rpm_version_flag ) {
		$admin{'postconf'} = 1;
  }

  if($use_mysqlshell){
		$admin{'mysqlshelluser'} = [ $mysql_shell_user, 'C' ];
		$admin{'mysqlshellpasswort'} = [ $mysql_shell_user_pw, 'C' ];
		$admin{'mysqlshellhost'} = [ $mysql_shell_user_host, 'C' ];
		$admin{'mysqlshelllongpwcrypt'} = [ $mysql_shell_user_pw_crypt, 'C' ];
		$admin{'mysqlshelluid'} = $mysql_shell_uid;
  }

	$admin{'login'} = [ $confixx_admin_user, 'C' ];
	$admin{'language'} = [ $language, 'C' ];

	foreach my $key (qw/ftp fehlerseiten pwschutz php phpupload dirlist
											ssi perl subdomains stdcgi shell wap/){
		$admin{$key} = 1;
	}

  if( $mta ) {
		$admin{'autoresponder'} = 1;
  }

  my $maillist = 0;
  if( $majordomo_home && -d $majordomo_home && -x $majordomo_wrapper){
		$admin{'majordomo'} = 1;
		$admin{'majordomohome'} = [ $majordomo_home, 'C' ];
		$admin{'majordomoml'} = [ $majordomo_ldir, 'C'];
    $maillist = -1;
  }

	my( $fields, $values ) = &makeSqlInsert( \%admin );
	my $sql = "INSERT INTO admin ( $fields ) VALUES ( $values )";

  $dbh->do($sql) or die ("#2010: $DBI::errstr\n");


  $dbh->do("INSERT INTO allgemein (newpwd) VALUES (0)") or
		die ("#2013: $DBI::errstr\n");

  $dbh->do("INSERT INTO grep (type,pattern) VALUES ('ftp','####NEW####')") or
		die ("#2014: $DBI::errstr\n");

  $dbh->do("INSERT INTO zeiten (confixxfaktor,checknewversion) VALUES (2,12)") or
		die ("#2015: $DBI::errstr\n");

  $dbh->do("INSERT INTO register (hinweis) VALUES ('')") or
		die ("#2016: $DBI::errstr\n");

  $dbh->do("UPDATE allgemein SET newpwd=1, httpdupdate=0, aliases=1, webalizerpw=1, domains=1, adduser=1")
		or die ("#2017: $DBI::errstr\n");

	if($bin_fpsrvadm && -x $bin_fpsrvadm){ 
		$dbh->do("UPDATE allgemein SET frontpageadd=1") or
			die ("#2016: $DBI::errstr\n");
	}


  $dbh->do("INSERT INTO domains (domain, richtigedomain) VALUES (?, '5')", undef, $confixx_domain) or
		die ("#2021: $DBI::errstr\n");

  $dbh->do("INSERT INTO bdefault (defaultserver) VALUES (0)");

  my $idn = '0'; # for comfixx easy 
  if(-x $idn_shell && $idn_vendor){
    $dbh->do("UPDATE admin SET idn=1") or
			die ("#2019: $DBI::errstr\n");
    $idn = '-1';
  }
  
  
  if ( $install_default_users == 1 ) {
		my( $maxpop, $maxemail);
    $maxpop = $maxemail = $use_mail?'-1':'0';
    my $maxmysql = $use_mysql?'-1':'0';
    my $maxautoresponder = $mta?'-1':'0';
    my $ssl = $use_SSL?'1':'0';
    my $timestamp = time;
    my $maxcronjobs = $cronjobs_support?'-1':'0';
  
		my %res0 = (
								'anbieter' => [ 'res0', 'C' ],
								'number' => 0,
								'passwort' => undef,
								'longpw' => undef,
								'maxkunden' => -1,
								'maxkundenlimit' => 0,
								'maxpop' => $maxpop,
								'maxpoplimit' => 0,
								'maxkb' => -1,
								'maxkblimit' => 0,
								'maxmysql' => $maxmysql,
								'maxmysqllimit' => 0,
								'maxemail' => $maxemail,
								'maxautoresponder' => $maxautoresponder,
								'maxemaillimit' => 0,
								'maxautoresponderlimit' => 0,
								'maxftp' => -1,
								'maxftplimit' => 0,
								'maxtransfer' => -1,
								'maxsubdomains' => -1,
								'maxsubdomainslimit' => 0,
								'maxdomains' => -1,
								'maxdomainslimit' => 0,
								'maxwildcards' => -1,
								'php' => 1,
								'ftp' => 1,
								'perl' => 1,
								'ssi' => 1,
								'cssl' => undef,
								'shell' => 1,
								'statistik' => undef,
								'pwschutz' => 1,
								'fehlerseiten' => 1,
								'webftp' => undef,
								'webmail' => undef,
								'stdcgi' => 1,
								'frontpage' => undef,
								'anmeldedatum' => $timestamp,
								'name' => [ 'res0', 'C' ],
								'firma' => [ '', 'C' ],
								'anschrift' => [ '', 'C' ],
								'plzort' => [ '', 'C' ],
								'telefon' => [ '', 'C' ],
								'fax' => [ '', 'C' ],
								'gender' => [ '', 'C' ],
								'firstname' => [ '', 'C' ],
								'plz' => [ '', 'C' ],
								'land' => [ '', 'C' ],
								'emailadresse' => [ '', 'C' ],
								'kundennummer' => [ '', 'C' ],
								'freifeldname1' => [ '', 'C' ],
								'freifeldwert1' => [ '', 'C' ],
								'freifeldname2' => [ '', 'C' ],
								'freifeldwert2' => [ '', 'C' ],
								'freifeldname3' => [ '', 'C' ],
								'freifeldwert3' => [ '', 'C' ],
								'personendatenangeben' => 1,
								'kundendatenanzeigen' => 0,
								'kundendatenbeikundenanzeigen' => 1,
								'indexcode' => undef,
								'indexfile' => undef,
								'hilfecode' => [ '', 'C' ],
								'standardip' => undef,
								'language' => undef,
								'lastchange' => $timestamp,
								'httpdspezial' => [ '', 'C' ],
								'phpupload' => 1,
								'dirlist' => 1,
								'dbext' => 1,
								'wap' => 1,
								'coldfusion' => undef,
								'dns' => undef,
								'pns' => [ $hostname, 'C' ],
								'sns' => [ $hostname, 'C' ],
								'dnr' => undef,
								'maxcronjobs' => $maxcronjobs,
								'maxcronjobslimit' => 0,
								'spamfilter' => undef,
								'maxidn' => $idn,
								'maxidnlimit' => 0,
								'maxmaillist' => $maillist,
								'maxmaillistlimit' => 0,
								'scponly' => undef,
								'maxatdomains' => -1,
								'modpython' => undef,
								'awstats' => undef
							 );

		foreach my $key ( keys %res0 ){
			unless(defined($res0{$key})){
				$res0{$key} = $admin{$key};
			}
		}

		my($fields,$values) = makeSqlInsert( \%res0 );

		$sql = "INSERT INTO anbieter ( $fields ) VALUES ( $values )";

    $dbh->do( $sql ) or
			die ("#2024: $DBI::errstr\n");

    $dbh->do("update ipadressen set anbieter='res0' where ip = '$stdIP' and anbieter = ''") or
			die ("#2025: $DBI::errstr\n");
    $dbh->do("insert into skins (cuser, skin) values ('res0','default')") or
			die ("#2026: $DBI::errstr\n");


    my $username = $user_prefix . '0';
    my $userdomain = $username . "." . $stdDomain;

    $dbh->do("insert into domains (domain, kunde, anbieter, richtigedomain,".
						 " pfad, lastchange, zusatz)".
						 " VALUES ('$userdomain', '$username', 'res0', '3', '/', '$timestamp','')") or
							 die ("#2027: $DBI::errstr\n");

    $dbh->do("insert into domainlog (kunde, neu, domain, loeschen)".
						 " VALUES ('$username', 1, '$userdomain', 0)");

		my %allgemein = ('domains' => 1);


    $dbh->do("insert into webalizer (kunde, loeschen, neu, anbieter) VALUES ('$username', '0', '1', 'res0')") or
			die ("#2031: $DBI::errstr\n");

		$allgemein{'webalizer'} = 1;

    $dbh->do("insert into perl (kunde, loeschen, neu, anbieter) VALUES ('$username', '0', '1', 'res0')") or
			die ("#2033: $DBI::errstr\n");

		$allgemein{'perl'} = 1;
		$allgemein{'stdcgi'} = 1;

		$scponly = $scponly? 2: '0'; ## need for creating

		my %web0 = ( 
								'kunde' => [ $username, 'C' ],
								'number' => 0,
								'uid' => 0,
								'passwort' => undef,
								'longpw' => undef,
								'anbieter' => undef,
								'maxpop' => undef,
								'maxkb' => undef,
								'maxmysql' => undef,
								'maxemail' => undef,
								'maxautoresponder' => undef,
								'maxftp' => -1,
								'maxtransfer' => -1,
								'maxsubdomains' => -1,
								'php' => 1,
								'ftp' => 1,
								'wildcard' => -1,
								'perl' => 1,
								'ssi' => 1,
								'shell' => 1,
								'statistik' => 1,
								'statistikpasswort' => [ '', 'C' ],
								'statistiklongpw' => [ $confixx_admin_pw_crypt, 'C' ],
								'pwschutz' => 1,
								'fehlerseiten' =>  1,
								'webftp' => undef,
								'webmail' => undef,
								'stdcgi' => 1,
								'anmeldedatum' => $timestamp,
								'name' => [ $username, 'C' ],
								'firma' => undef,
								'anschrift' => undef,
								'plzort' => undef,
								'telefon' => undef,
								'fax' => undef,
								'gender' => undef,
								'firstname' => undef,
								'plz' => undef,
								'land' => undef,
								'emailadresse' => undef,
								'kundennummer' => undef,
								'freifeldname1' => undef,
								'freifeldwert1' => undef,
								'freifeldname2' => undef,
								'freifeldwert2' => undef,
								'freifeldname3' => undef,
								'freifeldwert3' => undef,
								'kundendatenanzeigen' => 0,
								'ip' => [ $stdIP, 'C' ],
								'quota' => 1,
								'language' => undef,
								'lastchange' => $timestamp,
								'phpupload' => 1,
								'wap' => 1,
								'coldfusion' => 1,
								'dirlist' => 1,
								'httpdspezial' => [ '', 'C' ],
								'maxcronjobs' => undef,
								'spamfilter' => undef,
								'maxidn' => undef,
								'maxmaillist' => undef,
								'scponly' => $scponly,
								'maxatdomains' => -1,
								'modpython' => undef,
								'cssl' => undef,
								'awstats' => undef
							 );

		
		foreach my $key ( keys %web0 ){
			unless( defined( $web0{$key} ) ) {
				$web0{$key} = $res0{$key};
			}
		}

		($fields,$values) = makeSqlInsert( \%web0 );
		$sql = "INSERT INTO kunden ( $fields) VALUES ( $values )";

    $dbh->do( $sql ) or
			die ("#2036: $DBI::errstr\n");
  
    $dbh->do("update transfer set geloescht = 1 where kunde = '$username'") or
			die ("#2037: $DBI::errstr\n");


		$allgemein{'adduser'} = 1;
		$allgemein{'httpd'} = 1;
		$allgemein{'httpdupdate'} = 1;
		$allgemein{'quota'} = 1;

		$sql = "UPDATE allgemein SET ".makeSqlUpdate( \%allgemein );
    $dbh->do( $sql ) or
			die ("#2035: $DBI::errstr\n");

  }
  

  $sth->finish;
	unless( $dontDisconnect ){
		$dbh->disconnect;
		$dbh = undef;
	}
	return $dbh;
}

sub fillTables{
	my( $dbh ) = @_;
	my $srcDir = $wDir.'/install';	
	if( opendir( INSTALL, $srcDir ) ){
		my( $srcSQL, $cmd, $table, $return );
		my $cmdPrefix =  $bin_mysql.' '.&makeCmdLine( { 'server' => $dbServer, 
																										'port' => $dbPort,
																										'user' => $dbUser,
																										'password' => $dbPw}
																								);
		
		while( my $file = readdir( INSTALL ) ){
			next unless $file =~ /(.+)\.sql$/;
			$table = $1;
			$srcSQL = "$srcDir/$file";
			next unless -f $srcSQL;

			if ( $dbType eq 'mysql' ) {
				$cmd = "$cmdPrefix $dbDB <$srcSQL";

			}else{
				if( $dbServer eq 'localhost' ){
					$cmd = "$bin_psql $dbDB -U $dbUser -f $srcSQL";
				} else {
					$cmd = "$bin_psql -h $dbServer $dbDB -U $dbUser -f $srcSQL";
				}
			}
			if( $return = system( $cmd ) ) {
				&soft_error("Error: insert into atble '$table'" );
			}else {
				 $dbh->do( "UPDATE $table SET server_id='$ServerID'" );
			}
		}
		closedir( INSTALL );
	}
}

## /Unterprogramme
