use 5.006000;
use ExtUtils::MakeMaker;

use Getopt::Long;
use File::Copy;

my @optsConfig = (
  'debug|dbg',
  'help|h',
  'target|t=s'
);

my %args = ();
unless( GetOptions( \%args, @optsConfig )){
	&printHelp;
	exit 1;
}

if($args{'help'}){
	&printHelp;
	exit 0;
}

sub printHelp {
	print <<EOL

Options:
     --debug-mode | -d  - debug mode
     --help  | -h       - configure help
     --target | -t      - define target os. it is usefull for Gentoo.
     
EOL
}

our $VERSION = '1.0.6';

my $mm = new ExtUtils::MakeMaker({'NAME' => 'Confixx::Filter'});

##
## define and check gcc compiler
##
my $gcc = $mm->{'CC'} || 'gcc';

print STDOUT "GCC compiler has";
if ( system("$gcc --help 1>/dev/null 2>&1") ) 
{
  print STDOUT " problems - `$gcc --help` command return error code. Exiting.\n";
  exit 1;
} else {
  print STDOUT " no problems.\n";
}

my $obj_ext = $mm->{'OBJ_EXT'} || '.o';

##
## process Gentoo OS case
##
my $isGentoo = 0;
$isGentoo = 1 if ( -e '/etc/gentoo-release' );
$isGentoo = 1 if ( $args{'target'} =~ /gentoo/i );

##
## define architecture of host
##
my $is32bit = 1;

if( open( TEST, '>', 'conftest.c' ) ) {
	print TEST "int i;\n";
	close TEST;
	my $cmd = $gcc.' '.$mm->{'CCFLAGS'}.' -c conftest.c';
	unless( system("$cmd 2>conftest.err") ) {
		my $file = 'file';
		foreach $path ('/usr/bin','/usr/local/bin',split(':',$ENV{'PATH'})){
			if ( -x "$path/file" ){
				$file = "$path/file";
				last;
			}
		}

		print STDOUT "'file' utility has";
		if ( system("$file --help 1>/dev/null 2>&1") )
		{
		  print STDOUT " problems - `$file --help` command returns error code. \n";
		  print STDOUT " So it is suggested that server architecture is 32bit. \n";
		} else {
		  print STDOUT " no problems.\n";
		}
		
		my $file_out = `$file conftest$obj_ext`;
		if( $file_out =~ /64-bit|-64\s/ ){
			$is32bit = 0;
		}
	}
	system("rm -f conftest.*");     
}

if( $is32bit) {
    copy (  'Cipher.o.32', 'Cipher.o');
    my $v5_8_5 = 5.008005;
    foreach my $release qw(/etc/SuSE-release /etc/fedora-release) {	
	if( -T $release ){
	    if( open( IN, '<', $release ) ){
		while( <IN> ){
		    if(/VERSION\s*=\s*(\d+\.\d+)/i){ ## SuSE
			if( $1 == 9.3 ){
			    $v5_8_5 = 5.008006; # correct the perl version
			}	    
			last;
		    }elsif(/\s+release\s+(\d+)/i){ ## fedora
			if( $1 == 4 ){
			    $v5_8_5 = 5.008006; # correct the perl version
			}
			last;
		    }
		}
		close( IN );
	    }	
	}
    }
    if ( $isGentoo ) {
      copy( 'Filter.o.32.gentoo', 'Filter.o');
    } elsif( $] > $v5_8_5 ){
	copy( 'Filter.o.32', 'Filter.o' );
    }elsif( $] > 5.007002 ){
	copy( 'Filter.o.32.5.8.5', 'Filter.o' );
    } else{
	copy( 'Filter.o.32.5.7.2', 'Filter.o' );
    }

}else{
    copy ( 'Cipher.o.64', 'Cipher.o');
    if ($isGentoo) {
      copy( 'Filter.o.64.gentoo', 'Filter.o' );
    } else {
      copy( 'Filter.o.64', 'Filter.o' );
    }
}

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'Confixx::Filter',
    VERSION_FROM      => 'lib/Confixx/Filter.pm', # finds $VERSION
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/Confixx/Filter.pm', # retrieve abstract from module
       AUTHOR         => 'info@confixx.com') : ()),
    LIBS              => [''], # e.g., '-lm'
    DEFINE            => $args{'debug'}?
	    '-DCONFIXX_FILTER_DEBUG_MODE -DCONFIXX_FILTER_DEBIAN -DCONFIXX_FILTER_DEBVG_MODE':
	    ' -DCONFIXX_FILTER_DEBIAN -DCONFIXX_FILTER_DEBVG_MODE', # e.g., '-DHAVE_SOMETHING'
    INC               => '-I.', # e.g., '-I. -I/usr/include/other'
	# Un-comment this if you add C files to link with later:
     OBJECT            => 'Filter.o Cipher.o', 
	OPTIMIZE     => '-O2',
);
