#!/usr/bin/perl

########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

BEGIN{
	use FindBin qw($Bin);
	use File::Basename;

  use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin;
  use lib dirname( $Bin ).'/subs';
  use lib dirname( $Bin ).'/scripts';
  use lib $Bin.'/admin/subs';
}

use Getopt::Long;

use lib_module_common;
use lib_module_db;

use strict;

&useModule( 'lib_module_master' );

my @conf_opts = ( 'sid|s=s',
									'force|f',
									'help|h' );
my %args = ();

unless( &GetOptions( \%args, @conf_opts ) ) {
  warn "Error: Errors in the command line found. Use the format described below.\n";
  print STDERR &help_text();
  exit 1;
}

if( exists($args{'help'}) ){
    print &help_text;
    exit 0;
    }

&initConfig();

if( $args{'sid'} ){
	unless( $args{'sid'} =~ /^[0-9a-z]{32}$/i ){
		warn "Error: bad server ID: $args{'sid'}\n";
		exit 1;
	}
	if( $args{'sid'} eq $ServerID ){
		warn "Error: new server ID is same as the old\n";
		exit 1;
	}
}


unless( $::installDir && -d $::installDir ){
	die "Can't get install dor of confixx server ($installDir)\n";
}

&lib_module_master::readMasterConfig();

safe_do $::installDir.'/admin/subs/subs_include_writeConfig.pl';

my $newServerID = $args{'sid'};

my( @dbhs, $localDbh );

if( $master_confixx ){

	$localDbh = DBI->connect( $db_local_dsn, $dbLocalUser, $dbLocalPw ) or
		die "Error connetion to database: $DBI::errstr\n";

	unless( $db_local_dsn eq $db_master_dsn ){
		my $masterDbh = DBI->connect( $db_master_dsn, $dbMasterUser, $dbMasterPw ) or
			die "Error connetion to database: $DBI::errstr\n";
		push @dbhs, $masterDbh;
	}

}else{
	$localDbh = DBI->connect( $db_address, $dbUser, $dbPw ) or
		die "Error connetion to database: $DBI::errstr\n";
}
push @dbhs, $localDbh;

my $salt = '';
my( $sth,$cnt, $dbh );
while( ! $newServerID ){
	$newServerID = lib_module_master::generateServerID( 'Primary'.$salt );
	foreach $dbh (@dbhs){
		$sth = $dbh->prepare( "SELECT COUNT(*) FROM admin WHERE server_id='$newServerID'" );
		next unless $sth->execute;
		( $cnt ) = $sth->fetchrow;
		$sth->finish;
		last if $cnt;
	}
	if( $cnt ){
		$newServerID = undef;
		$salt = time();
	}
}
if( $newServerID eq $ServerID ){
	warn "Error: new server ID is same as the old\n";
	foreach $dbh (@dbhs){
		$dbh->disconnect;
	}
	exit 1;
}

$cnt = 0;
foreach $dbh ( @dbhs ){
	$sth = $dbh->prepare( "SELECT COUNT(*) FROM admin WHERE server_id='$newServerID'" );
	next unless $sth->execute;
	( $cnt ) = $sth->fetchrow;
	$sth->finish;
	last if $cnt;
}

if( $cnt ){
	warn "Error: the server ID '$newServerID' is already in database. Replace is failed\n";
	foreach $dbh (@dbhs){
		$dbh->disconnect;
	}
	exit 1;
}

unless( $args{'force'} ){
	safe_do $::installDir.'/admin/subs/subs_include_questions.pl';
	unless( &YesNoQuestion( "You really wish to change old server ID '$ServerID' on new '$newServerID'?" ,'n' ) ){
		foreach $dbh (@dbhs){
			$dbh->disconnect;
		}
		exit 0;
	}
}

my $sqlInit = $::installDir.'/admin/subs/mysqltables';
unless( -f $sqlInit ){
	die "Error: file '$sqlInit' does'nt exist\n"; 
}

if( open( SQL, '<', $sqlInit ) ){
	print "Update databse(s) ...\n";
	my( $table, $sql );
	while( <SQL> ){
		next unless /create\s+table\s+(\S+?)(\s|\(|$)/i;
		$table = $1;
		print "Update table '$table' ...\n";
		$sql = "UPDATE $table SET server_id='$newServerID' WHERE server_id='$ServerID'";
		foreach $dbh (@dbhs){
			unless( $dbh->do( $sql ) ){
			}
		}
		if( $dbType eq 'mysql' ){
			$sql = "ALTER TABLE $table ALTER server_id SET DEFAULT '$newServerID'";
			$localDbh->do( $sql );
		}
	}
	close( SQL );
	print " ... finished\n";
}else{
	die "Error open file '$sqlInit': $!\n";
}

foreach $dbh (@dbhs){
	$dbh->disconnect;
}

#
# rewrite configs
#

$dbh = DBI->connect( $db_address, $dbUser, $dbPw ) or
	die &ltext('db_connect', '#2001', $DBI::errstr);

$ServerID = $newServerID;

&WriteMainConfigFile;

unless( $dns_server == 2 || $mail_server == 2 ){  ## launch only on primary server
	&WritePHPConfigFile;
}

if($::mail_server){ ## launch only on mail serevr
	# spamassassin depends on db configuration
	system("$installDir/subs/subs_includes_spamassassin.pl");
}

&rewriteScripts();

$dbh->disconnect;

print "\nConfixx update script started. \nWARNING: The operation could take a long time.\n";

system ( "cd $installDir; $installDir/confixx_updatescript.pl --force-all --skip-calc" );



#
#
#=========================================
#
#
#

sub help_text{
	return <<HELP;

Change the Confixx server ID

Usage:
	restore_connect.pl [argumrts]

Argumets:
       --sid  |-s = [new sid]   set new server ID
       --force|-f               don't ask about confirmation

HELP

}
