#!/usr/bin/perl

########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

BEGIN{
	use FindBin qw($Bin);
	use File::Basename;

  use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin;
  use lib dirname( $Bin ).'/subs';
  use lib dirname( $Bin ).'/scripts';
  use lib $Bin.'/admin/subs/';	
}

use File::Copy;
use Getopt::Long;

use lib_module_common;
use lib_module_db;

use strict;

&useModule( 'lib_module_master' );

my @conf_opts = ( 'type|t=s',
									'local|l',
									'master|m',
									'help|h' );
my %args = ();

unless( &GetOptions( \%args, @conf_opts ) ) {
  warn "Error: Errors in the command line found. Use the format described below.\n";
  print STDERR &help_text();
  exit 1;
}

if( exists($args{'help'}) ){
    print &help_text;
    exit 0;
    }

&initConfig();

unless( $::installDir && -d $::installDir ){
	die "Can't get install dor of confixx server ($installDir)\n";
}

&lib_module_master::readMasterConfig();

my( $type );

if( exists( $args{'type'} ) ){
	$type = $args{'type'};

}elsif( exists( $args{'local'} ) ){
	$type = 'local';

}elsif( exists( $args{'master'} ) ){
	$type = 'master';
}

if( $type =~ /local|l/ ){
	$::db_address = $::db_local_dsn;
	$::dbType = $::dbLocalType;
	$::dbServer = $::dbLocalServer;
	$::dbPort = $::dbLocalPort;
	$::dbDB = $::dbLocalDB;
	$::dbUser = $::dbLocalUser;
	$::dbPw = $::dbLocalPw;

	$::master_confixx = 0 if $::master_confixx == 1;

}elsif( $type =~ /master|m/ ){
	$::db_address = $::db_master_dsn;
	$::dbType = 'mysql';
	$::dbServer = $::mysqlMasterServer;
	$::dbPort = $::mysqlMasterPort;
	$::dbDB = $::dbMasterDB;
	$::dbUser = $::dbMasterUser;
	$::dbPw = $::dbMasterPw;

	$::master_confixx = 1 if $::master_confixx == 0

}else{
	die "Type of connection is unknown ($type)\n";
}

my $dbh = DBI->connect( $db_address, $dbUser, $dbPw ) or
	die &ltext('db_connect', '#2001', $DBI::errstr);

copy( "$::installDir/confixx_main.conf",
			"$::installDir/confixx_main.conf.restore_bak" );

&rewriteScripts();

$dbh->disconnect;

sub help_text{
	return <<HELP;

Change the Confixx database connection to a selected

Usage:
	restore_connect.pl --type|-t=<local|master>

HELP

}
