#!/usr/bin/perl

########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

BEGIN{
	use FindBin qw($Bin);
	use File::Basename;

  use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin;
  use lib dirname( $Bin ).'/subs';
  use lib dirname( $Bin ).'/scripts';
}

use SOAP::Lite;
use Getopt::Long;

use lib_module_common;
use lib_module_db;

use strict;

&useModule( 'lib_module_master' );

my @config_opts = (
									 'host|h=s',
									 'login|l=s',
									 'pass|p=s',

									 'sid=s',

									 'debug|dbg:i'
									);
my %args = ();
unless ( &GetOptions( \%args, @config_opts ) ) {

	warn "Error: errors in the command line found\n";
	&print_help();
	exit 1;
}


if( exists( $args{'debug'})){
	$args{'debug'} = 1 unless $args{'debug'};
}

if($args{'debug'}){
	SOAP::Lite->import( +trace => 'all' );
}

my($master_domain, $db_port);

&initConfig();

unless( $master_confixx ){
	warn "The Confixx server is not in a datacenter\n";
	exit 0;
}

&lib_module_master::readMasterConfig();

if( $args{'host'} ){
	$master_domain = $args{'host'};
	$db_port = '';
}else{
	$master_domain = $dbMasterServer || $mysqlMasterServer;
	$db_port = $dbMasterPort || $mysqlMasterPort;
}

my $db_login = $args{'login'} || $dbMasterUser;
my $db_pass = $args{'pass'} || $dbMasterPw;
my $server_id = $args{'sid'} || $ServerID;

my $db_host = getMysqlHost( { 'server' => $master_domain,
															'port' => $db_port,
															'user' => $db_login,
															'paswd' => $db_pass,
															'dbname' => $dbMasterDB
														} );

my( $soap_mysql );
$soap_mysql = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/MySQL')
	-> proxy( "http://$master_domain/cgi-bin/soap/server.cgi" )
	-> on_fault( \&on_error );


my $db_host = $soap_mysql->restore_db_conn( $server_id,
																						$db_login,
																						$db_pass,
																						$db_host )->result;

print "db-host: $db_host\n";

exit 0;

#
#
#===========================================
#
#

sub on_error {
	my( $soap, $res ) = @_;
	if( ref($res) =~ /SOAP/ ){
		print STDERR "error-code: ",$res->faultcode,
			"\nerror-string: ",$res->faultstring,
			"\nerror-detail: ",$res->faultdetail,"\n";
		exit 2;
	}else{
		die $soap->transport->status,"\n";
	}
}

sub print_help {
	print <<"HELP";

restore_db_conn.pl - restore database connection to the master database

command line options:

  --host |-h = < hostname of the master server >
  --login|-l = < login name of the master database >
  --pass |-p = < password of databases's login>

  --sid = < server ID >

  --debug|-dbg = < debug level >

HELP

}

