<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( "auth.php" );
include_once( "../include/class.SQLInteger.php" );
include_once( "../include/class.SQLString.php" );
include_once( "../include/module.DNSTemplate.php" );
include_once( "../include/db/class.DBConnect.php" );
include_once( "../include/class.HOPermissions.php" );
include_once( "../include/class.HOStates.php" );


$timestamp = time();

/**
 * Do not move user 
 */
if ($transferieren != "ja") {
  $fehlertext = ltext("anku3_error1");
  $fehlertitel = "Hinweis:";
  include("anbieter_kundenzuordnung.php");
  exit();
}

$lbDnsFlag = false;

/**
 * zielanbieter  - destination reseller
 * quellanbieter - source reseller
 */
db_connect($db_host, $db_user, $db_pass);

/**
 * The target reseller does not exist?
 */
$id = safe_query2( "SELECT anbieter, maxkunden, maxkundenlimit 
                    FROM anbieter WHERE anbieter = ? AND server_id='$ServerID'", 
                    new SQLString( $zielanbieter ) 
                  );
if( db_num_rows( $id ) < 1 ){
	 $fehlertext = ltext("anku3_error2");
	 db_close();
	 include("anbieter_kundenzuordnung.php");
	 exit();
}

$werte = db_fetch_array($id);
$maxkunden = $werte["maxkunden"];
$maxkundenlimit = $werte["maxkundenlimit"];

/**
 * Are resellers are locked?
 */
$id1 = safe_query2( "SELECT anbieter FROM anbieter WHERE anbieter = ?  AND gesperrt='1' AND server_id='$ServerID'", 
                    new SQLString( $zielanbieter ) );
$id2 = safe_query2( "SELECT anbieter FROM anbieter WHERE anbieter = ?  AND gesperrt='1' AND server_id='$ServerID'", 
                    new SQLString( $quellanbieter ) );

if( ( db_num_rows( $id1 ) > 0 ) || ( db_num_rows( $id2 ) > 0 ) ){
	 $fehlertext = ltext("anku3_error3");
	 db_close();
	 include("anbieter_kundenzuordnung.php");
	 exit();
}

/**
 * Fetch new reseller DNS info
 */
$id = safe_query( "SELECT dnstemplate FROM admin WHERE server_id='$ServerID'" );
$werte = db_fetch_array($id);
$lcDnsTemplate = $werte['dnstemplate'];

$id = safe_query( "SELECT standardip,pns,sns FROM anbieter WHERE anbieter = ?  AND server_id='$ServerID'", 
                  TRUE, new SQLString( $zielanbieter ) );
$werte = db_fetch_array($id);
$lcIP = $werte['standardip'];
$lcPNS = $werte['pns'];
$lcSNS = $werte['sns'];

/**
 * Assign all users to another reseller
 */
if( istleer( $kunde ) ){
  /**
   * Check user limit...
   */
  if( $maxkundenlimit == 1 ){
     $id = safe_query2( "SELECT COUNT(kunde) AS neukunden FROM kunden WHERE anbieter = ?  AND server_id='$ServerID'", 
                        new SQLString( $quellanbieter ) );
     $werte = db_fetch_array($id);
     $neukunden = $werte["neukunden"];
     
     $id = safe_query2( "SELECT COUNT(kunde) AS freikunden FROM kunden WHERE anbieter = ?  AND server_id='$ServerID'", 
                         new SQLString( $zielanbieter ) );
     $werte = db_fetch_array( $id );
     $freikunden = $maxkunden - $werte["freikunden"];

     if( $neukunden > $freikunden ){
       $fehlertext = ltext("anku3_error4", array( $zielanbieter,$neukunden,$freikunden ) );
       db_close();
       include("anbieter_kundenzuordnung.php");
       exit();
      }
  }

  /**
   * Sorry, source reseller does not exist
   */
  $id = safe_query2( "SELECT anbieter FROM anbieter WHERE anbieter = ?  AND server_id='$ServerID'", 
                      new SQLString( $quellanbieter ) );
  if( db_num_rows( $id ) < 1 ){
     $fehlertext = ltext("anku3_error5",array($quellanbieter));
     db_close();
     include("anbieter_kundenzuordnung.php");
     exit();
  }

  /**
   * Sorry, source reseller has not been assigned any users.
   */
  $id = safe_query2( "SELECT kunde FROM kunden WHERE anbieter = ?  AND server_id='$ServerID'", 
                      new SQLString( $quellanbieter ) );
  if( db_num_rows( $id ) < 1 ){
     $fehlertext = ltext("anku3_error6",array($quellanbieter));
     db_close();
     include("anbieter_kundenzuordnung.php");
     exit();
  }

  $id = safe_query2( "SELECT kunde, ip FROM ipadressen WHERE status = 1 AND anbieter = ? AND ".
                     " kunde != '' AND server_id=?", new SQLString( $quellanbieter ), new SQLString( $ServerID ) );
  
  $laExclusiveIps = array();
  
  while( $laRow = db_fetch_array( $id, 'A' ) ){
    $laExclusiveIps[$laRow['kunde']] = $laRow['ip'];
  }                   
  
  db_free_query( $id );

  /**
   * Rewrite zone files
   */
  $id = safe_query2( "SELECT domain, kunde FROM dns WHERE anbieter = ? AND kunde != ''  AND server_id='$ServerID'", 
                     new SQLString( $quellanbieter ) );
     while ($werte = db_fetch_array($id)) {
      $lcDomain = $werte["domain"];
      $lcKunde = $werte["kunde"];
      
      if( ! array_key_exists( $lcKunde, $laExclusiveIps ) ){
        list($lcZonefile, $ls_Serial) = ff_ProcessTemplate ( $zielanbieter, 
                                                                  $lcDomain,
                                                                  $lcIP,
                                                                  NULL,
                                                                  $lcDnsTemplate,
                                                                  $lcPNS,
                                                                  $lcSNS
                                                                  );
      safe_query2( "UPDATE dns SET anbieter = ?, zonefile = ?, neu = 1 WHERE domain = ? AND server_id='$ServerID'", 
                   new SQLString( $zielanbieter ),
                   new SQLString( $lcZonefile ), 
                   new SQLString( $lcDomain ) 
                   );
     }
     if( ! $lbDnsFlag ){
        $lbDnsFlag = true;
      }
   }		

  safe_query( "update domains set anbieter = ? , lastchange = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLInteger( $timestamp ), new SQLString( $quellanbieter ) );
  safe_query( "update mysql_datenbanken set anbieter = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $quellanbieter ) );
  safe_query( "update email set anbieter = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $quellanbieter ) );
  safe_query( "update ftp set anbieter = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $quellanbieter ) );
  safe_query( "update ipadressen set anbieter = ?  where anbieter = ?  and kunde != '' AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $quellanbieter ) );
  safe_query2( "UPDATE kunden SET ip =?, anbieter = ? ,pw=1, lastchange = ? WHERE anbieter = ? AND server_id='$ServerID'", 
                  new SQLString( $lcIP ), new SQLString( $zielanbieter ), new SQLInteger( $timestamp ), new SQLString( $quellanbieter ));
  safe_query( "update allgemein set webalizerpw=1".( $lbDnsFlag ? ", dns = 1 " : "" )." WHERE server_id='$ServerID'", TRUE );
  safe_query( "update pop3 set anbieter = ? , lastchange = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLInteger( $timestamp ), new SQLString( $quellanbieter ) );
  safe_query( "update fehlermeldungen set anbieter = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $quellanbieter ) );
  safe_query( "update pwschutz set anbieter = ? , lastchange = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLInteger( $timestamp ), new SQLString( $quellanbieter ) );
  safe_query( "update frontpage set anbieter = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $quellanbieter ) );
  safe_query( "update perl set anbieter = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $quellanbieter ) );
  safe_query( "update webalizer set anbieter = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $quellanbieter ) );
  safe_query( "update autoresponder set anbieter = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $quellanbieter ) );
  safe_query( "update cssl set anbieter = ?  where anbieter = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $quellanbieter ) );
  safe_query( "update transfer set geloescht='1' where anbieter = ?  AND server_id='$ServerID'", TRUE, new SQLString( $quellanbieter ) );

  /**
   * Httpd options
   */
  $loHOPermissions = new HOPermissions( $ServerID, $zielanbieter );
  $loHOPermissions->moveFromReseller( $quellanbieter ); 

  $loHOStates = new HOStates( $ServerID, $zielanbieter );
  $loHOStates->moveFromReseller( $quellanbieter ); 

  /**
   * Process user with exlusive IPs
   */
  foreach ( $laExclusiveIps as $lcKunde => $lcIP ){
     
      $loUser = new SQLString( $lcKunde );
      
      $id = safe_query2( "SELECT domain FROM dns WHERE anbieter = ?  AND kunde = ?  AND server_id='$ServerID'", 
                         new SQLString( $quellanbieter ), $loUser );
      while( list( $lcDomain ) = db_fetch_array( $id ) ){
        list($lcZonefile, $ls_Serial) = ff_ProcessTemplate( $zielanbieter,
                                                            $lcDomain,
                                                            $lcIP,
                                                            NULL,
                                                            $lcDnsTemplate,
                                                            $lcPNS,
                                                            $lcSNS
                                                            );
        safe_query2( "UPDATE dns SET anbieter = ?, zonefile = ?, neu = 1 WHERE domain = ?  AND server_id='$ServerID'", 
                     new SQLString( $zielanbieter ), 
                     new SQLString( $lcZonefile ), 
                     new SQLString( $lcDomain ) 
                     );
       }		
      safe_query2( "UPDATE kunden SET ip =?, anbieter = ? ,pw=1, lastchange = ? WHERE kunde = ?  AND server_id='$ServerID'", 
                    new SQLString( $lcIP ), 
                    new SQLString( $zielanbieter ), 
                    new SQLInteger( $timestamp ), 
                    $loUser 
                    );
      
  }

  $fehlertext  = ltext("anku3_error7", array( $zielanbieter, $quellanbieter ) );
  $fehlertitel = ltext("anku3_errortitle");
  db_close();
  include("anbieter_kundenzuordnung.php");
  exit();

/**
 * Move individual users
 */
}else{
  
  $loUser = new SQLString( $kunde );
  $id = safe_query2( "SELECT kunde, ip FROM kunden WHERE kunde = ? AND server_id='$ServerID'", 
										 $loUser );
 /**
  * This user does not exist?
  */
  if( db_num_rows( $id ) < 1 ){
		$fehlertext = ltext( 'anku3_error8' );
		db_close();
		include( 'anbieter_kundenzuordnung.php' );
		exit();
	}
	
	$laRow = db_fetch_array( $id, 'A');
	$lcOldUserIp = $laRow['ip'];
	$loOldUserIp = new SQLString( $lcOldUserIp );
	db_free_query( $id );
	
	$id = safe_query2( "SELECT ip FROM ipadressen WHERE status = 1 AND anbieter = ? AND ".
	                   " kunde = ? AND ip = ? AND server_id='$ServerID'",  new SQLString( $quellanbieter ), $loUser, 
	                   $loOldUserIp );

  if( db_num_rows( $id ) == 1 ){
    $lcIP = $lcOldUserIp;
	}
	db_free_query( $id );

  if( $maxkundenlimit == 1){
     $neukunden = 1;

     $id = safe_query( "SELECT COUNT(kunde) AS freikunden FROM kunden WHERE anbieter = ?  AND server_id='$ServerID'", 
                       TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde )  );
     $werte = db_fetch_array($id);
     $freikunden = $maxkunden - $werte["freikunden"];

     /**
      * Check user limit...
      */
     if( $neukunden > $freikunden ){
       $fehlertext = ltext("anku3_error9",array($zielanbieter,$neukunden,$freikunden));
       db_close();
       include("anbieter_kundenzuordnung.php");
       exit();
      }
    }

    $id = safe_query2( "SELECT domain FROM dns WHERE anbieter = ?  AND kunde = ?  AND server_id='$ServerID'", 
                        new SQLString( $quellanbieter ),
                        new SQLString( $kunde ) 
                      );
     while ($werte = db_fetch_array($id)) {
      $lcDomain = $werte["domain"];
      list($lcZonefile, $ls_Serial) = ff_ProcessTemplate ( $zielanbieter, 
                                                           $lcDomain,
                                                           $lcIP,
                                                           NULL,
                                                           $lcDnsTemplate,
                                                           $lcPNS,
                                                           $lcSNS
                                                          );
      safe_query2( "UPDATE dns SET anbieter = ?, zonefile = ?, neu = 1  WHERE domain = ?  AND server_id='$ServerID'", 
                    new SQLString( $zielanbieter ),
                    new SQLString( $lcZonefile ), 
                    new SQLString( $lcDomain ) );
    if( ! $lbDnsFlag ){
      $lbDnsFlag = true;
    }	             
  }		
  
  safe_query( "update domains set anbieter = ? , lastchange = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLInteger( $timestamp ), new SQLString( $kunde ) );
  safe_query( "update email set anbieter = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde ) );
  safe_query( "update ftp set anbieter = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde ) );
  safe_query( "update ipadressen set anbieter = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde ) );
  safe_query( "update kunden set ip=?, anbieter = ? ,pw='1', lastchange = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $lcIP ), new SQLString( $zielanbieter ), new SQLInteger( $timestamp ), new SQLString( $kunde ) );
  safe_query( "update allgemein set webalizerpw=1".( $lbDnsFlag ? ", dns = 1 " : "" )." WHERE server_id='$ServerID'", TRUE );
  safe_query( "update pop3 set anbieter = ? , lastchange = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLInteger( $timestamp ), new SQLString( $kunde ) );
  safe_query( "update fehlermeldungen set anbieter = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde ) );
  safe_query( "update pwschutz set anbieter = ? , lastchange = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLInteger( $timestamp ), new SQLString( $kunde ) );
  safe_query( "update mysql_datenbanken set anbieter = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde ) );
  safe_query( "update frontpage set anbieter = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde ) );
  safe_query( "update perl set anbieter = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde ) );
  safe_query( "update webalizer set anbieter = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde ) );
  safe_query( "update autoresponder set anbieter = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde ) );
  safe_query( "update cssl set anbieter = ?  where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $zielanbieter ), new SQLString( $kunde ) );
  safe_query( "update transfer set geloescht='1' where kunde = ?  AND server_id='$ServerID'", 
              TRUE, new SQLString( $kunde ) );

  /**
   * Httpd options
   */
  $loHOPermissions = new HOPermissions( $ServerID, $zielanbieter );
  $loHOPermissions->moveFromReseller( $quellanbieter, null, $kunde ); 

  $loHOStates = new HOStates( $ServerID, $zielanbieter );
  $loHOStates->moveFromReseller( $quellanbieter, null, $kunde ); 


  $fehlertext = ltext("anku3_error10", array($zielanbieter,$kunde,$quellanbieter));
  $fehlertitel = ltext("anku3_errortitle");
  db_close();
  include("anbieter_kundenzuordnung.php");
  exit();

  db_close();

}

?>
