<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/

include('auth.php');

include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.CompoundDataField.php" );
include_once( "../include/elements/data/class.PagedTableView.php" );
include_once( "../include/elements/data/class.IconDataField.php" );
include_once( "../include/elements/data/class.OptionsDataField.php" );
include_once( "../include/elements/data/class.CheckDataField.php" );

include_once( "../include/data_source/class.SQLQuery.php" );
include_once( "../include/data_source/class.CompoundValue.php" );
include_once( "../include/data_source/class.ValueLocale.php" );
include_once( "../include/data_source/class.ValueFromArray.php" );
include_once( "../include/data_source/class.ValueFormated.php" );
include_once( "../include/data_source/class.ConversedDBValue.php" );
include_once( "../include/data_source/class.DataValue.php" );


include_once( "../include/elements/html/class.CompoundElement.php" );
include_once( "../include/elements/html/class.PPButtonElement.php" );
include_once( "../include/elements/html/class.ButtonURLElement.php" );
//include_once( "../include/elements/html/class.SimpleSearchElement.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );

include_once( "defines.php");

global $DEBUG;
//$DEBUG=1;
if($DEBUG){
	echo "custommenu.php: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
}

db_connect($db_host, $db_user, $db_pass);

switch($action){
 case 'new':
	 $action = '';
	 if( $label ){
		 if( $usertype != 'reseller' ) {
			 $usertype = 'user';
		 }
		 safe_query2( "INSERT INTO menublock( label, usertype, server_id ) VALUES ( ?,'$usertype', '$ServerID')", 
									new SQLString($label) );
	 } else {
		 $fehlertext = ltext("cm_wronglabel"); 
	 }
	 break;
 case 'change':
	 $action = '';
	 include('menuitems.php');
	 exit;
	 break;
 case 'delete':
	 $action = '';
	 if(is_array($ids)){
		 $loIDs = new SQLFieldSet();
		 foreach( array_values($ids) as $id ){
			 $loIDs->addField( 'id', $id, 'N' );
		 }

		 if ( $lcIN = $loIDs->getSQLValues() ) {
			 safe_query2( "DELETE FROM menuitem WHERE menublock_id IN ($lcIN) AND server_id='$ServerID'");
			 safe_query2( "DELETE FROM menublock WHERE id IN ($lcIN) AND server_id='$ServerID'");
		 }
	 }
	 break;
}


//=============================================================
//
// add form

$loDR = new SetOfRowsData();
$loDR->AppendHeaderRow(new HTMlDataField( ltext( 'cm_text' ) ),
											 new HTMlDataField( ltext( 'cm_usertype' ) ), 
											 new HTMlDataField( '' ) 
											 );

$loDR->AppendRow( new TextDataField( $label, 'label' ),
									new OptionsDataField( array( 'reseller' => ltext( 'cm_reseller' ),
																							 'user' => ltext( 'cm_user' )
																							 ),
																				'',
																				'usertype'
																				),
									new ButtonData(ltext( 'll_add' ),'javascript:doChange()',cc_IDAdd)
									);
$loDR->AppendHidden( new TextDataField( 'new', 'action' ) );
//$loDR->AppendButton(ltext( 'll_add' ),'javascript:doChange()',cc_IDOk);

$loAddForm = $loDR->GetInputPresentation( array( 'action' => 'custommenu.php',
																								 'method' => 'post',
																								 'name' => 'add_form' ),
																					ltext( 'll_add' )
																					);

// end form
//
//==============================================================
//
// list of menus

$liFormIndex = 1;

initPagingSettings( $_POST );

$res = db_query( "SELECT COUNT(*) FROM menublock WHERE server_id='$ServerID'" );
list( $total_number ) = db_fetch_array( $res );


$loQuery = new SQLQuery( "SELECT b.id, b.label, b.usertype, COUNT(i.id) as ids FROM menublock b".
												 " LEFT JOIN menuitem i ON b.id = i.menublock_id  AND b.server_id=i.server_id"
												 ." WHERE b.server_id='$ServerID' GROUP BY b.id" );

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new ValueFromArray( 'label' ),
																 new ValueFromArray( 'usertype' ),
																 new ValueFromArray( 'id' ),
																 new CompoundValue( new ValueFromArray( 'id' ),
																										new ValueFromArray( 'ids' )
																										),
																 new ValueFromArray( 'id' )
																 );

$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute( 'onclick', "javascript:checkedAll('ids', this.checked, $liFormIndex)");
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

$loTitle = new CompoundValue( new ValueLocale( 'cm_text'),
															new ValueLocale( 'cm_usertype'),
															new ValueLocale( 'cm_edit' ),
															new ValueLocale( 'll_change' ),
															$loSelValue
															);
$laWidths = array(  '40%', '20%', '10%', '20%','10%' );

$loDS->Template( $loTemplate );

//=======================================================
//
// call-back functions 

function makeEditButton( $poSrc ){
	global $confixx_interface_version;
	$loLink = new LinkDataField( 'menuedit.php',
															 'menublock_id='.$poSrc,
															 array( 'menu_node_id' => 'edit_block',
																			'cur_page' => 'menuedit.php',
																			'head_text' => ltext( 'cm_edit' ) ),
															($confixx_interface_version == 'powp')?
															 new IconDataField( cc_ChangeIcon ):
															 new HTMLDataField(ltext('ll_edit'))
															 );
	$loLink->ParentAttribute('align','center');
	return $loLink;
}

function makeItemsLink( $poSrc ){
	$loVal =& $poSrc->Value(0);
	$liID = $loVal->Value();

	$loVal =& $poSrc->Value(1);
	$liCount = $loVal->Value();

	$loLink = new LinkDataField( 'menuitems.php',
															 'menublock_id='.$liID,
															 array('menu_node_id' => 'edit_items',
																			'cur_page' => 'menuitems.php',
																			'head_text' => ltext( 'll_change' )),
															 new HTMLDataField( ltext( 'cm_items', array( $liCount )
																												 )
																									)
															 );
	$loLink->ParentAttribute('align','right');
	return  $loLink;
}

function makeSelect( $poSrc ){

	$loCheckBox = new CheckDataField( $poSrc, 'ids[]');
	$loCheckBox->ParentAttribute('align','center');

	return array( $loCheckBox->GetInputPresentation(), array('align'=>'center'));
}


// end call-back functions
//
//=======================================================

$loConv = new CompoundValue( NULL,
														 NULL,
														 new ValueFormated( 'edit', NULL, 'makeEditButton' ),
														 new ValueFormated( 'itemd', NULL, 'makeItemsLink' ),
														 new ValueFormated( 'select', NULL, 'makeSelect' )
														 );


$loDS->Conversion( $loConv );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );

$loPTV->Anchor( 'list' );
$loPTV->FormIndex( 1 );
$loPTV->NoItemsMessage(ltext('ll_empty_list'));
	
$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'custommenu.php#list',
																						 'method' => 'post',
																						 'name' => 'list_menu' ), 
																			ltext( 'ma_custommenu' ) );


$loGroup = new DivElement( array( 'class'=>'buttons' ) );
$head_text = ltext( 'll_delete' );
$lcConfirm = ltext( 'll_confirm_delete' );
$lcNothing = ltext( 'll_nothing' );

$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('action','delete',$liFormIndex);".
																								"deleteSelected('ids','$lcConfirm',$liFormIndex,'$lcNothing')",
																								'bid-delete' 
																								)
													 );
	
if ($total_number>0) {
	$tbl->setGroupActionElement( $loGroup );
}

$tbl->updateBodyContent();

$page = new MainPageElement( $loAddForm, $tbl );
$page->OutputHTML( array( '../js/paged_form.js' ) );

?>