<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.SpacesCompoundDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/data/class.PagedSetOfRowsData.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/module.Database.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( "../include/module.url.inc.php" );

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "einstellungen_blacklist: _POST<br><pre>\n";
	print_r($_POST); 
	echo "</pre><br>\n";
}

db_connect();

//
// Add new domain into black list
//

if( isset( $newdomain ) ){
	$newdomain = trim( $newdomain );

	$flag = ! checkDomain( $newdomain );
	$loDomain = new SQLString($newdomain);
	$id = safe_query2( "SELECT COUNT(*) AS total FROM domains ".
										 " WHERE domain = ?",
										 $loDomain );
	list($cnt) = db_fetch_array($id,'N');
	db_free_query( $id );

	if( $flag ){
		$fehlertitel = ltext( 'eibl_errortitle' );
		$fehlertext  = ltext( 'eibl_baddomain' );

	}elseif( $cnt ){
		$fehlertitel = ltext( 'eibl_errortitle' );
		$fehlertext  = ltext( 'eibl_errorhas', array( htmlspecialchars( $newdomain ) ) );

	}else{
		$loDomain = new SQLString( $newdomain );
		safe_query2( "INSERT INTO domains (domain,richtigedomain,server_id)".
								 " VALUES ( ?, 5, '$ServerID' )", 
								 $loDomain );

		$newdomain   = '';
		$fehlertitel = ltext("eibl2_errortitle");
		$fehlertext  = ltext("eibl2_error1");
	}

}else {
	$newdomain='';
}

//
//	Delete domains
//

if( $action == 'delete' ){
	$loFields = new SQLFieldSet();
	foreach ($domains as $value){
		$loFields->addField( 'id', $value );
	}
	$lcIDs = $loFields->getSQLValues();
	db_query( "DELETE FROM domains WHERE ".
					 " richtigedomain=5 AND id IN ($lcIDs) AND server_id='$ServerID'" );

}
 

//
//	Adds form
//

$go_AddNew = new SetOfRowsData();
$go_AddNew->AppendRow(new HTMLDataField(ltext('eibl_domain')),new TextDataField($newdomain,"newdomain"),
											new ButtonData( ltext('eibl_ok') ,"javascript:doChange()", cc_IDAdd));
											
// 
//	List 
//	
										
initPagingSettings ( $_POST, array( 'to_search' => $to_search ) );

$id = safe_query2( "SELECT COUNT(*) AS total FROM domains ".
									 " WHERE richtigedomain = 5 AND server_id='$ServerID'" );
list( $total_number ) = db_fetch_array( $id, 'N');
db_free_query( $id );

$lcFields = "id, domain";

if ( isset( $to_search ) && strlen($to_search) ){
 	$loDb = new SQLValue( $to_search, 'S' );
	$lcWhere = " richtigedomain = 5 AND domain LIKE '%?%' AND server_id='$ServerID'";
	$lcSQL = "SELECT COUNT(domain) FROM domains WHERE ".$lcWhere;

	$loQuery = new SQLQuery( $lcSQL, array( $loDb, $loDb) );

	$loQuery->doQuery();
	list($total_number) = $loQuery->fetchArray('N');

	$lcSQL = "SELECT ".$lcFields." FROM domains WHERE ".$lcWhere;
	$loQuery->Query( $lcSQL );

 }else{
	$lcSQL = "SELECT ".$lcFields."  FROM domains WHERE richtigedomain = 5 AND server_id='$ServerID'";
	$loQuery = new SQLQuery( $lcSQL );
 }

$lcSQL =& $loQuery->Query();

/* Sort mode */
$order = 'domain';
$lcSQL .= "  ORDER BY domain";

if( $direction == 'desc' ){
	$lcSQL .= " DESC";
}

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new ValueFromArray( 'domain'), new ValueFromArray( 'id'));
$listFormIndex = 1;

$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('domains',this.checked,$listFormIndex)");
$loCheckBox->SetParentAttributes(array('align'=>'center'));
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

$laContent =array();
if( $direction=='desc' ){
	$lcDirIcon = cc_DescIcon;
	$lcNewDir = 'asc';
 } else {
	$lcDirIcon = cc_AscIcon;
	$lcNewDir = 'desc';
 }
 
$laContent['domain'] = new SpacesCompoundDataField( new HTMLDataField( ltext('eibl_domain')), 
																							new IconDataField( $lcDirIcon ));
 
$loTitle = new CompoundValue( new DataValue( 'domain', NULL, 
															new LinkDataField( "javascript:setValue('order','domain',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['domain'])),$loSelValue);

$laWidths = array( '95%','5%' );

$loDS->Template( $loTemplate );

//==============================================================
// Begin call-back functions to make visble objects

function makeSelect( $id )
{
	$loCheckBox = new CheckDataField( $id, 'domains[]');
	$loCheckBox->ParentAttribute('align','center');
	return array( $loCheckBox->GetInputPresentation(), array('align'=>'center'));
}

// end call-back functions to make visble objects
//==============================================================

$loConv = new CompoundValue( NULL, new ValueFormated( 'id', NULL, 'makeSelect' ));

$loDS->Conversion( $loConv );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );
$loPTV->Anchor( 'list' );

$loPTV->FormIndex( $listFormIndex );

if( isset( $to_search ) && strlen( $to_search ) ){
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
}else{
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}


$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'einstellungen_blacklist.php#list',
																						 'name' => 'list_domains' ), 
																			ltext('eibl_title1') );

$dsSearch = new CompoundValue( new ValueFromArray( 'to_search', $to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );

$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'to_search', 
																																	'size' => '16',
																																	'value' => $to_search,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );
	
$loGroup = new DivElement(array('class'=>'buttons'));
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,$listFormIndex)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('to_search','',$listFormIndex);".
																							 "submitForm('start_index',1,$listFormIndex)", 
																							 'bid-show-all'
																							 ) 
													);

$head_text = ltext('ll_delete');

$loGroup->AppendToContent( new PPButtonElement( $head_text,"javascript:deleteSelected( 'domains','".ltext('ll_confirm_delete')."', $listFormIndex);",
																								'bid-delete')
													 );
	
$loSearch->setDataSource( $dsSearch, array( 'to_search' => $to_search ) );

if( ( isset( $to_search ) && strlen( $to_search ) ) || $total_number > 0 ){
	$tbl->setSearchElement( $loSearch );
}
if( $total_number > 0 ){
	$tbl->setGroupActionElement( $loGroup );
}

$tbl->updateBodyContent();
$go_Page = new MainPageElement( 

$go_AddNew->GetInputPresentation(array( 'action' => 'einstellungen_blacklist.php'),
																					ltext('eibl_addnew')), $tbl  );
																					
$go_Page->OutputHTML( array( '../../js/paged_form.js' ) );

db_close();
?>
