#!/usr/bin/perl

BEGIN {
	use FindBin;
	use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib $FindBin::Bin.'/modules';

}

use SOAP::Lite;

use MIME::Base64;

use Getopt::Long qw( :config no_ignore_case );

use strict;

no utf8;

my @config_opts = ( 'host|h=s', 'login|l=s', 'pass|p=s',

									 'sid=s',

									 'user|u=s',
									 'path=s',

									 'sort|s=s',
									 'rev|r',
									 'all|a',
									 'almost-all|A',
									 'dir-only|d',
									 
									 'trace-root|tr=s',
									
									 'logout!',

									 'debug|dbg:i'
									);
									 
my %args = ();
unless ( &GetOptions( \%args, @config_opts ) ) {

	warn "Error: errors in the command line found\n";
	&print_help();
	exit 1;
}

unless( exists( $args{'logout'})){
	$args{'logout'} = 1;
}
if( exists( $args{'debug'})){
	$args{'debug'} = 1 unless $args{'debug'};
}

if($args{'debug'}){
	SOAP::Lite->import( +trace => 'all' );
}

unless( $args{'host'} ){
	warn "Error: hostname is not set\n";
	&print_help();
	exit 1;
}

my $soap_host = $args{'host'};
$soap_host =~ s/^('|")(.*)\1/$2/;

unless( $args{'sid'} || ( $args{'login'} && $args{'pass'} ) ){
	warn "Error: missing parameters of connection\n";
	&print_help();
	exit 1;
}

unless( $args{'user'}){
	warn "Error: missing name of the user\n";
	&print_help();
	exit 1;
}


my $soap_session = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/Session')
	-> proxy( "http://$soap_host/cgi-bin/soap/server.cgi" )
	-> on_fault( \&on_error );

my $soap_dir = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/Dir')
	-> proxy( "http://$soap_host/cgi-bin/soap/server.cgi" )
	-> on_fault( \&on_error );

my ($session_id);
if( $args{'sid'} ){
	$session_id = $args{'sid'};
}else{
	$session_id = $soap_session->login( $args{'login'}, $args{'pass'} )->result;
	print "session_id: $session_id\n";
}

#
# can do it
#
$soap_session->check_rights( $session_id, $args{'user'} );

my %val = ( 'rev' => 'r',
						'all' => 'a',
						'almost-all' => 'A',
						'dir-only' =>'d'
					);


my $keys = join( ':', map{ $val{$_} } grep{ exists( $args{$_} ) } keys %val );

my @args = ( SOAP::Data->name('session_id')->value($session_id),
						 SOAP::Data->name('user')->value( $args{'user'} ),
						 SOAP::Data->name('path')->value( $args{'path'} ),
						 SOAP::Data->name('keys')->value( $keys ),
						 SOAP::Data->name('sort')->value( $args{'sort'} ) );

my( @last, $type );

my $result = $soap_dir->ls( SOAP::Data->value( @args	) );

my $name = $result->result();

if( $name ){
	@last = $result->paramsout();
	while( $name ){
		$type = shift @last;
		if( $type =~ /d/ ){
			print 'ls-dir:';
		}elsif( $type =~ /f/ ){
			print 'ls-file:';
		}
		if( $type =~ /m/ ){
			$name = decode_base64( $name );
		}
		print $name,"\n";

		$name = shift @last;
	}
}

if( $args{'trace-root'} ){
	my $root = $args{'trace-root'};
	my $path = $args{'path'};
	if( $path =~ m%^\Q$root\E/(.+)% ){
		$args{'dir-only'} = 1;
		$keys = join( ':', map{ $val{$_} } grep{ exists( $args{$_} ) } keys %val );

		@args = ( SOAP::Data->name('session_id')->value($session_id),
							SOAP::Data->name('user')->value( $args{'user'} ),
							SOAP::Data->name('path')->value( $root ),
							SOAP::Data->name('keys')->value( $keys ),
							SOAP::Data->name('sort')->value( $args{'sort'} ) );

		( $name = $1 ) =~ s%/$%%; ## remove last slash
		my @tail = split( m%/%, $name );

		pop @tail; ## remove last dir

		$root =~ s%(?:^|/)([^/]+)$%%;
		( $name = $1 ) =~ s%^/%%; ## remove first slash

		unshift @tail, $name; ## append root dir

		my $level = 1;

		while( @tail ){
			$root .= '/'.shift( @tail );

			$args[2] = SOAP::Data->name('path')->value( $root );

			$result = $soap_dir->ls( SOAP::Data->value( @args	) );

			$name = $result->result();
			if( $name ){
				@last  = $result->paramsout();
				while( $name ){
					$type = shift @last;
					if( $type =~ /m/ ){
						$name = decode_base64( $name );
					}
					if( $type =~ /d/ ){ ## check type: must be 'dir'
						print "tr-$level: $name\n";
						$name = shift @last;
					}
				}
			}
			$level++;
		}
	}
}

if( $args{'logout'} ){
	$soap_session->logout( $session_id );
}

exit 0;

#
#
#============================================
#
#

sub on_error {
	my( $soap, $res ) = @_;
	if( ref($res) =~ /SOAP/ ){
		print STDERR "error-code: ",$res->faultcode,
			"\nerror-string: ",$res->faultstring,
			"\nerror-detail: ",$res->faultdetail,"\n";
		exit 2;
	}else{
		die $soap->transport->status,"\n";
	}
}

sub print_help {
	print <<"HELP";

ls_dir.pl - get list of items of the dir

command line options:

  --host |-h = < hostname of the Confixx's server >
  --login|-l = < login name of the Confixx's administrator >
  --pass |-p = < password of the Confixx's administrator >

  --user |-u = < user's name ( webN ) >
  --path     = < path of the dir ( html/dir1 ) >

  --sort      |-s = < sort mode: 'name', 'ext', 'none'. default: 'name' >
  --rev       |-r   - reverse sorting 
  --all       |-a   - get all dir's items, including files that start with '.'
  --almost-all|-A   - get all dir's items, except for '.' and '..'
  --dir-only  |-d   - get list of subdirs only
  --trace-root|-tr = < root dir to trace path >

  --no-logout  -  don't logout after action
  --sid = < session's ID >

  --debug|-dbg = < debug level >

HELP

}

