<?
include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/module.Constants.php' );
//include("ftp_header.php");
include("ftp_config.php");
include_once( 'ftp_class.php' );
include_once( 'ftp_functions.php' );

$ftp = new ftp();
$ftp->debug = FALSE;
if( ! $ftp->ftp_connect( $ftp_host ) ){
  die("Cannot connect\n");
 }

if( ! $ftp->ftp_login( $ftp_user, $ftp_pass ) ){
  $ftp->ftp_quit();
  echo "User: ".htmlspecialchars( $ftp_user );
  die( "Login failed\n" );
}

if(array_key_exists('path', $_REQUEST)) {
  $path = $_REQUEST['path'];
  setPath($path); 
}
else {
  $path = getPath();
}

if( ! $path ){
  $path = '/';
 }

$res_msg = '';
$JSscriptPart = '';
$JSscriptInclude = array();
$JSscriptInclude[] = "ftp_webftp.js";

$JSscriptPart .= "function filesSelected(){\n".
         "  var i;\n".
         "  if ( ! document.del_form.del_name )\n".
         "    return false;\n".
         "  if ( document.del_form.del_name.length ){\n".
         "    for ( i=0; i<document.del_form.del_name.length; i++ )\n".
         "      if ( document.del_form.del_name[i].checked )\n".
         "        return true;\n".
         "  }\n".
         "  else\n".
         "    return document.del_form.del_name.checked;\n".
         "}\n";

$JSscriptPart .= "function performDelete(){\n".
         "  if ( !filesSelected() ){\n".
            js_alert(ltext("wftp_select_files"))."\n". 
         "    return;\n".
         "  }\n".
         "  if ( ".js_confirm(ltext("wftp_confirm_delete"))." )\n".
         "    document.del_form.submit();\n".
         "}\n";

if($edit) {
  if($edit != "new") {
    $fullpath = $edit;
    $path = str_replace(($pathfilename),"",$edit);
    $pathfilename = explode("/",$edit);
    $filename = $pathfilename[((count($pathfilename)-1))];
    $path = str_replace(("/".$filename),"",$edit);
    if(@substr_count($path,"/")<1) {
      $path = "/".$path;
    }
  }

  if($ftp->ftp_chdir($path)) {
    if($edit != "new") {
      $filecontent = $ftp->ftp_get($filename, $edit,1);
      //$filecontent = htmlentities($filecontent);
//      $filecontent = htmlspecialchars($filecontent);
    }
    if(!$filesize || $filesize <= $maxEditSize) {
      $data = new SetOfRowsData();
      $data->AppendHidden( new TextDataField( $edit, "edit" ) );
      
      $filename_cell = new CompoundDataField();
      $filename_cell->SetSeparator("&nbsp;");
      $filename_cell->SetColSpan("3");
      $filename_field = new TextDataField( $filename, "editnew_filename" );
      $filename_field->SetAttributes(array("size"=>"30"));
      $filename_cell->AppendToContent(new HTMLDataField( $lang_text["wftp_filename"] ));
      $filename_cell->AppendToContent($filename_field);
      $data->AppendRow( $filename_cell );
      
      $fcontent_field = new LongTextDataField($filecontent, "filecontent");
      $fcontent_field->SetAttributes(array("rows"=>"20", "cols"=>"80", "wrap"=>"virtual", "style"=>"width:430px"));
      $fcontent_field->SetColSpan("3");
      $data->AppendRow( $fcontent_field );
      
      $overwrite_cell = new CompoundDataField();
      $overwrite_cell->SetSeparator("&nbsp;");
      $overwrite_cell->SetColSpan("3");
      $overwrite_cell->AppendToContent(new HTMLDataField( $lang_text["wftp_upload_force"] ));
      $overwrite_cell->AppendToContent(new YesNoDataField( array("1"=>""), array("0"=>""), $edit=="new"?"0":"1", "force" ));
      $data->AppendRow( $overwrite_cell );      

      $data->AppendRow( new ButtonData(ltext('wftp_back'),'javascript:history.back()',cc_IDOk),
              new ButtonData(ltext('wftp_reset'),'javascript:document.forms[0].reset()',cc_IDOk),
              new ButtonData(ltext('wftp_upload'),'javascript:document.forms[0].submit()',cc_IDOk) );
          
      $form = $data->GetInputPresentation( array( "action"=>"ftp_index.php?path=".urlencode($path), "method"=>"post", "name"=>"form1" ), $lang_text['m_wftp_new'] );
      $page = new MainPageElement( $form );
      $page->OutputHTML($JSscriptInclude, $JSscriptPart);
    } 
    else $res_msg = getMsg($lang_text["wftp_edit_filesize"],"|%maxfilesize%","|$maxEditSize");
  } 
  else $res_msg = getMsg($lang_text["wftp_chdir_failed"],"|%fullpath%","|$path");
  
  if ($res_msg) {
    $data = new SetOfRowsData();
    $data->AppendRow( new HTMLDataField( $res_msg ) );
    $form = $data->GetOutputPresentation( $lang_text['m_wftp_new'] );
    $page = new MainPageElement( $form );
    $page->OutputHTML($JSscriptInclude, $JSscriptPart);
  }
}

$ftp->ftp_quit();
?>
