<?
include_once("auth.php");
include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.CompoundDataField.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );
include_once( "../include/elements/html/module.Constants.php" );
//include("ftp_header.php");
include("ftp_config.php");
include("ftp_class.php");
include("ftp_functions.php");

$ftp = new ftp();
$ftp->debug = FALSE;
if (!$ftp->ftp_connect($ftp_host)) die("Cannot connect\n");

if (!$ftp->ftp_login($ftp_user, $ftp_pass)) {
	$ftp->ftp_quit();
	echo "User: ".htmlspecialchars( $ftp_user );
	die( "Login failed\n" );
}

if(array_key_exists('path', $_REQUEST)) {
	$path = $_REQUEST['path'];
	setPath($path);	
}
else {
	$path = getPath();
}

if(!$path) $path = '/';

$JSscriptPart = '';
$JSscriptInclude = array();
$JSscriptInclude[] = "ftp_webftp.js";

$JSscriptPart .= "function filesSelected(){\n".
				 "	var i;\n".
				 "	if ( ! document.del_form.del_name )\n".
				 "		return false;\n".
				 "	if ( document.del_form.del_name.length ){\n".
				 "		for ( i=0; i<document.del_form.del_name.length; i++ )\n".
				 "			if ( document.del_form.del_name[i].checked )\n".
				 "				return true;\n".
				 "	}\n".
				 "	else\n".
				 "		return document.del_form.del_name.checked;\n".
				 "}\n";

$JSscriptPart .= "function performDelete(){\n".
				 "	if ( !filesSelected() ){\n".
						js_alert(ltext("wftp_select_files"))."\n". 
				 "		return;\n".
				 "	}\n".
				 "	if ( ".js_confirm(ltext("wftp_confirm_delete"))." )\n".
				 "		document.del_form.submit();\n".
				 "}\n";

if($ftp->ftp_chdir($path)) {
	$data = new SetOfRowsData();
	$data->AppendHidden( new TextDataField( htmlspecialchars($path), "path" ) );
	$dirname_field = new TextDataField( "", "mkdir" );
	$dirname_field->SetAttributes(array("size"=>"30"));
	$dirname_field->SetColSpan("2");
	$data->AppendRow( new HTMLDataField( $lang_text["wftp_mkdir_newdir"] ), $dirname_field );
	$path_field = new TextDataField( htmlspecialchars($path), "in_dir" );
	$path_field->SetAttributes(array("size"=>"30"));
	$path_field->SetColSpan("2");
	$data->AppendRow( new HTMLDataField( $lang_text["wftp_intopath"] ), $path_field );
	$data->AppendRow( new ButtonData(ltext('wftp_back'),'javascript:history.back()',cc_IDOk),
					new ButtonData(ltext('wftp_reset'),'javascript:document.forms[0].reset()',cc_IDOk),
					new ButtonData(ltext('wftp_mkdir'),'javascript:document.forms[0].submit()',cc_IDOk) );
	$form = $data->GetInputPresentation( array( "action"=>"ftp_index.php?path=".urlencode($path), "method"=>"post", "name"=>"form1" ), $lang_text['wftp_mkdir_newdir'] );
	$page = new MainPageElement( $form );
	$page->OutputHTML($JSscriptInclude, $JSscriptPart);
} else {
	$data = new SetOfRowsData();
	$data->AppendRow( new HTMLDataField( getMsg($lang_text["wftp_chdir_failed"],"|%fullpath%","|$path") ) );
	$form = $data->GetOutputPresentation( ltext('wftp_mkdir_newdir') );
	$page = new MainPageElement( $form );
	$page->OutputHTML($JSscriptInclude, $JSscriptPart);		
}

$ftp->ftp_quit();
?>

