<?
include_once ( dirname(__FILE__) . "/class.SelectColumn.php" );
include_once ( dirname(__FILE__) . "/class.InputTextColumn.php" );
include_once ( dirname(__FILE__) . "/class.EMailValidator.php" );


class Actor {

	var $ms_Name; // name of user
	var $ms_Number; // number of user

	var $ms_Password; // password

	var $ma_Personal; // personal information - array of ListColumn objects
	var $ma_Services; // services/limits - array of ListColumn objects

	var $ms_Timestamp; // time stamp

	var $ms_ReportErrors; // report errors automatically

	function Actor(){
		$this->ma_Personal = array();
		$this->ma_Services = array();

		$this->SetReportErrors (TRUE);

	}

	/* -------------------- methods to manipulate data -------------------- */
	function SetFromArray ( &$pa_Columns, $pa_Data ) {
		foreach ( array_keys($pa_Columns) as $ls_Key )
			$pa_Columns[$ls_Key]->SetFromArray ( $pa_Data, NULL );
	}

	function SetFromSQL ( &$pa_Columns, $ps_Query ){

	  $lo_DB =& get_db_connection();
		
		$lo_Query =& $lo_DB->Select ( $ps_Query );
		$this->SetFromArray ( $pa_Columns, $lo_Query->nextrow() );
		$lo_Query->Close();
	}

	function CallOnColumns ( &$pa_Columns, $ps_Method ){
		$la_Arguments = func_get_args();
		array_splice ( $la_Arguments, 0, 2 );
		foreach ( array_keys($pa_Columns) as $ls_Key )
			call_user_func_array ( array( &$pa_Columns[$ls_Key], $ps_Method ), $la_Arguments );
	}
    /* -------------------- end methods to manipulate data -------------------- */


	function InitializePersonal (){
		$this->ma_Personal = array();
		$this->ma_Personal["gender"] = new SelectColumn ( array ( "m" => ltext("pi_male"), "f" => ltext("pi_female") ),
																												"gender", ltext("pi_gender"), "" );
		$this->ma_Personal["firstname"] = new InputTextColumn ( "firstname", ltext("pi_firstname"), "" );
		$this->ma_Personal["name"] = new InputTextColumn ( "name", ltext("pi_lastname"), "" );
		$this->ma_Personal["firma"] = new InputTextColumn ( "firma", ltext("pi_company"), "" );
		$this->ma_Personal["anschrift"] = new InputTextColumn ( "anschrift", ltext("pi_address"), "" );
		$this->ma_Personal["plzort"] = new InputTextColumn ( "plzort", ltext("pi_city"), "" );
		$this->ma_Personal["plz"] = new InputTextColumn ( "plz", ltext("pi_zip"), "" );
		$this->ma_Personal["land"] = new InputTextColumn ( "land", ltext("pi_country"), "" );
		$this->ma_Personal["telefon"] = new InputTextColumn ( "telefon", ltext("pi_phone"), "" );
		$this->ma_Personal["fax"] = new InputTextColumn ( "fax", ltext("pi_fax"), "" );
		$lo_Column = new InputTextColumn ( "emailadresse", ltext("pi_email"), "" );
		$lo_Column->SetValidator ( new EMailValidator(TRUE) );
		$this->ma_Personal["emailadresse"] = $lo_Column;
	}

	function SetPersonalData( $pa_Data ){
		$this->SetFromArray( $this->ma_Personal, $pa_Data );
	}

	function SetPersonalFromSQL ( $ps_Query ){
		$this->SetFromSQL ( $this->ma_Personal, $ps_Query );
	}

	function FirstPersonal(){
		reset ( $this->ma_Personal );
	}

	function &NextPersonal(){
		return ( list($ls_Key) = each($this->ma_Personal) ) ? $this->ma_Personal[$ls_Key] : NULL;
	}
	/* -------------------- end personal information -------------------- */


	/* -------------------- services & limits -------------------- */

	function SetServicesData ( $pa_Data ){
		$this->SetFromArray ( $this->ma_Services, $pa_Data );
	}

	function FirstService(){
		reset ( $this->ma_Services );
	}

	function &NextService(){
		return ( list ( $ls_Key ) = each ( $this->ma_Services ) ) ? $this->ma_Services[$ls_Key] : NULL;
	}

	function CallOnServices ( $ps_Method ) {
		$la_Arguments = func_get_args();
		array_unshift ( $la_Arguments, &$this->ma_Services );
		call_user_func_array ( array( &$this, "CallOnColumns" ), $la_Arguments );
	}
	/* -------------------- end services & limits -------------------- */


	/* -------------------- error processing -------------------- */
	function SetReportErrors ( $ps_ReportErrors ){
		$this->ms_ReportErrors = $ps_ReportErrors;
	}

	function GetReportErrors(){
		return $this->ms_ReportErrors;
	}

	function AddMessage ( $ps_Type, $ps_Text ) {
		global $DEBUG;
		if( $DEBUG ){
			echo "Actor::AddMEssage : $ps_Type, $ps_Text<br>\n";
		}
		if ( $this->GetReportErrors() ){
			message ( $ps_Type, $ps_Text );
		}
	}
	/* -------------------- end error processing -------------------- */

	/* -------------------- Get... -------------------- */

	function &Name( $pcName = NULL ) {
		if( is_string( $pcName ) ) {
			$this->ms_Name = $pcName;
		}
		return $this->ms_Name;
	}

	function &Number( $piNum = NULL ) {
		if( is_numeric( $piNum ) ) {
			$this->ms_Number = $piNum;
		}
		return $this->ms_Number;
	}

	function GetName(){
		return $this->ms_Name;
	}

	function GetNumber(){
		return $this->ms_Number;
	}

	function GetPassword(){
		return $this->ms_Password;
	}

	function &Password( $pcPwd = NULL){
		if(is_string($pcPwd)){
			return $this->ms_Password = $pcPwd;
		}
		return $this->ms_Password;
	}

	function GetPersonal ( $ps_Name ) {
		return $this->ma_Personal[$ps_Name]->GetValue();
	}
    /* -------------------- end Get... -------------------- */



}
?>