<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

/**
 * Class provides management of "httpd options" 
 * permissions for reseller/user
 */
class HOPermissions {

  var $mcServerID;
  var $mcReseller;
  var $mcUser;
  var $maOverWriteData;
  var $mcErrorMessage;

 /**
   * Constructor
   * 
   * @param string $pcServerID
   * @param string $pcReseller
   * @param string $pcUser
   * @param array $paOverWriteData
   */
  function HOPermissions( $pcServerID = null, $pcReseller = null, $pcUser = null, $paOverWriteData = array() ){/*{{{*/
    $this->mcServerID = $pcServerID;
    $this->mcReseller = $pcReseller;
    $this->mcUser = $pcUser;
    $this->mcErrorMessage = null;

    if( $pcUser && ! $pcReseller ){
      $this->mcUser = $this->findResellerByUser( $pcUser, $pcServerID );
    }

    $this->maOverWriteData = empty( $paOverWriteData ) ? array() : $paOverWriteData;
  }
  /*}}}*/

/**
 * Set/Get methods
 */
 
  /**
   * Set/Get method for $this->mcServerID
   *
   * @param string $pcServerID
   * @return string $this->mcServerID
   */
  function ServerID( $pcServerID = null ){/*{{{*/
    if( is_string($pcServerID ) ){
      $this->mcServerID = $pcServerID;
    }
    return $this->mcServerID;
  }/*}}}*/

  /**
   * Set/Get method for $this->mcReseller
   *
   * @param string $pcReseller
   * @return string $this->mcReseller
   */
  function Reseller( $pcReseller = null ){/*{{{*/
    if( is_string($pcReseller ) ){
      $this->mcReseller = $pcReseller;
    }
    return $this->mcReseller;
  }/*}}}*/
  
  /**
   * Set/Get method for $this->mcUser
   *
   * @param string $pcUser
   * @return string $this->mcUser
   */
  function User( $pcUser = null ){/*{{{*/
    if( is_string($pcUser ) ){
      $this->mcUser = $pcUser;
    }
    return $this->mcUser;
  }/*}}}*/

/**
 * OverWrite methods
 */

  /**
   * Set/Get method for $this->maOverWriteData from
   * array ( 5 => 1, ... ), where 5 - is httpd option id, 
   * 1 - is httpd option permission on/0- off.
   *
   * @param  array $paOverWriteData
   * @return array $this->maOverWriteData
   */
  function OverWriteData( $paOverWriteData = null ){/*{{{*/
    if( is_array($paOverWriteData ) ){
      $this->maOverWriteData = $paOverWriteData;
    }
    return $this->maOverWriteData;
  }/*}}}*/

  /**
   * Set method for $this->maOverWriteData for reseller
   *
   * @param  string $pcReseller
   * @return bool
   */
  function OverWriteDataForReseller( $pcReseller ){/*{{{*/

    if( ! is_string( $pcReseller ) ){
      return false;
    }

    $this->maOverWriteData = array();
    $lrId = safe_query2( " SELECT httpd_id FROM httpd_permissions ".
                         " WHERE reseller = ? AND user = '' AND  template_id = 0  AND server_id =?",
                          new SQLString( $pcReseller ), 
                          new SQLString( $this->mcServerID ) 
                        );
    while( $laRow = db_fetch_array( $lrId, 'A' ) ){
      $this->maOverWriteData[$laRow['httpd_id']] = 1;
    }
    db_free_query( $lrId );

    return true;
  }/*}}}*/
  
  /**
   * Set method for $this->maOverWriteData for template. For 'master' Confixx
   * user use $pcReseller & $pcServerID parameters.
   *
   * @param  integer $piId
   * @param  string $pcReseller
   * @param  string $pcServerID
   * @return bool
   */
  function OverWriteDataForTemplate( $piId, $pcReseller = null, $pcServerID = null ){/*{{{*/
    
    if( ! is_numeric( $piId ) ){
      return false;
    }

    if( ! is_null( $pcReseller ) ){
      $loReseller = new SQLString( $pcReseller );
    }else{
      $loReseller = new SQLString( $this->mcReseller );
    }

    if( ! is_null( $pcServerID ) ){
      $loServerID = new SQLString( $pcServerID );
    }else{
      $loServerID = new SQLString( $this->mcServerID );
    }

    $this->maOverWriteData = array();
    $lrId = safe_query2( " SELECT httpd_id FROM httpd_permissions ".
                         " WHERE reseller = ? AND template_id = ? AND server_id =?",
                          $loReseller, 
                          new SQLInteger( $piId ), 
                          $loServerID 
                        );
    while( $laRow = db_fetch_array( $lrId, 'A' ) ){
      $this->maOverWriteData[$laRow['httpd_id']] = 1;
    }
    db_free_query( $lrId );
    return true;
  }/*}}}*/

  /**
   * Set method for $this->maOverWriteData for user
   *
   * @param  string $pcUser
   * @param  string $pcReseller
   * @param  string $pcServerID
   * @return bool
   */
  function OverWriteDataForUser( $pcUser, $pcReseller = null, $pcServerID = null  ){/*{{{*/
    
    if( ! is_string( $pcUser ) ){
      return false;
    }

    if( ! is_null( $pcReseller ) ){
      $loReseller = new SQLString( $pcReseller );
    }else{
      $loReseller = new SQLString( $this->mcReseller );
    }

    if( ! is_null( $pcServerID ) ){
      $loServerID = new SQLString( $pcServerID );
    }else{
      $loServerID = new SQLString( $this->mcServerID );
    }


    $this->maOverWriteData = array();
    $lrId = safe_query2( "SELECT httpd_id FROM httpd_permissions WHERE user = ? AND server_id =?",
                          new SQLString( $pcUser ), 
                          $loServerID 
                          );
    while( $laRow = db_fetch_array( $lrId, 'A' ) ){
      $this->maOverWriteData[$laRow['httpd_id']] = 1;
    }
    db_free_query( $lrId );

    return true;
  }/*}}}*/

  /**
   * Factory for SetOfRowsOfSata. Generate SetOfRowsOfData of httpd options
   * permissions for current Confixx user.
   *
   * @return SetOfRowsOfSata $loData
   */
  function & getSORD(){/*{{{*/
    
    include_once( dirname(__FILE__) . "/elements/data/class.SetOfRowsData.php" );/*{{{*/
    include_once( dirname(__FILE__) . "/elements/data/class.HTMLDataField.php" );
    include_once( dirname(__FILE__) . "/elements/data/class.ServiceDataField.php" );
    include_once( dirname(__FILE__) . "/elements/data/class.ShellServiceDataField.php" );
    include_once( dirname(__FILE__) . "/elements/data/class.OptionsDataField.php" );
/*}}}*/

    $loData = new SetOfRowsData;

    $laPerms =  $this->getPermissions();

    foreach( $laPerms as $liId => $lcLabel ){
      $loData->AppendRow( new HTMLDataField( $lcLabel),
                          new ServiceDataField( array_key_exists( $liId, $this->maOverWriteData ) 
                                              ? $this->maOverWriteData[$liId]
                                              : 0, 
                                               "httpd_ids[$liId]" ) 
                        );
    }

    return $loData; 
  }/*}}}*/

/**
 * Save permissions for object methods
 */

  /**
   * Save permissions for reseller. If $pbNew then we will not check if some
   * permissions already exists for this reseller.
   *
   * @param string $pcReseller
   * @param array  $paData
   * @param bool  $pbNew
   * @return bool
   */
  function saveForReseller( $pcReseller, $paData = array(), $pbNew = false ){/*{{{*/
    if( empty( $pcReseller ) ){
      $this->mcErrorMessage = 'Empty arguments for saveForReseller()';
      return false;
    }
    
    if( ! is_array( $paData ) ){
      $paData = array();
    }
    
    $loReseller = new SQLString( $pcReseller );
    $loServerID = new SQLString( $this->mcServerID );

    $laNew = array();
    $laBad = array();
    $laDelete = array();
    // New reseller
    if( $pbNew ){
      foreach( $paData as $id => $value  ){
        if( $value ){
          $laNew[] = $id;
        }
      }
      $paData = array();
    }

    foreach( $paData as $id => $value ){
      $lrId2 = safe_query2( "SELECT COUNT(reseller) FROM httpd_permissions
                             WHERE  reseller = ? AND httpd_id = ? AND template_id = 0 AND server_id=?",
                             $loReseller, 
                             new SQLInteger( $id ), 
                             $loServerID  
                           );
      list( $liCount ) = db_fetch_array( $lrId2, 'N' );
      db_free_query( $lrId2 );

      if( $value && ! $liCount ){
        $laNew[] = $id;
      }elseif( ! $value && $liCount ){
        $lrId = safe_query2( "SELECT COUNT(reseller) FROM httpd_permissions
                              WHERE  reseller = ? AND user !='' AND template_id = 0  AND httpd_id = ? AND server_id=?",
                              $loReseller, 
                              new SQLInteger( $id ), 
                              $loServerID  
                            );
        list( $liCountUsers ) = db_fetch_array( $lrId, 'N' );
        db_free_query( $lrId );
   
        if( $liCountUsers ){
          $laBad[] = $id;
        }else{
          $laDelete[] = $id;
        }
      }
    }

    if( ! count($laBad ) ){
      foreach( $laDelete as $id ){
        safe_query2( "DELETE FROM  httpd_permissions WHERE reseller = ? AND  httpd_id = ? AND server_id = ?",
                      $loReseller, 
                      new SQLInteger( $id ), 
                      $loServerID 
                    );
     
        safe_query2( "DELETE FROM  httpd_entries WHERE reseller = ? AND  httpd_id = ? AND  server_id = ?",
                     $loReseller, 
                     new SQLInteger( $id ), 
                     $loServerID 
                   );
      }

      foreach($laNew as $id){
       safe_query2( "INSERT INTO httpd_permissions SET reseller = ?, httpd_id = ?, server_id = ?",
                    $loReseller, 
                    new SQLInteger( $id ), 
                    $loServerID 
                  );
      }
    }else{
      $laTmp = array();
      foreach( $laBad as $id ){
        $lrId = safe_query2( "SELECT label FROM httpd_definitions
                              WHERE  id = ?",
                              new SQLInteger( $id )  
                            );
        list( $laTmp[] ) = db_fetch_array( $lrId, 'N' );
        db_free_query( $lrId );
      }
      $this->mcErrorMessage = ltext( 'httpd_options_warn_res_users', implode( ', ', $laTmp ) );  
      return false;
    }
    return true;
  }/*}}}*/

  /**
   * Save permissions for user. If $pbNew then we will not check if some
   * permissions already exists for this user.
   *
   * @param string $pcUser
   * @param array  $paData
   * @param bool  $pbNew
   * @return bool
   */
  function saveForUser( $pcUser, $paData = array(), $pbNew = false ){/*{{{*/

    if( empty( $pcUser ) ){
      $this->mcErrorMessage = 'Empty arguments for saveForUser()';
      return false;
    }
 
    if( ! is_array( $paData ) ){
      $paData = array();
    }
    
    $loUser = new SQLString( $pcUser );
    $loReseller = new SQLString( $this->mcReseller );
    $loServerID = new SQLString( $this->mcServerID );

    $laNew = array();
    $laBad = array();
    $laDelete = array();
    
    // New user
    if( $pbNew ){
      foreach( $paData as $id => $value  ){
        if( $value ){
          $laNew[] = $id;
        }
      }
      $paData = array();
    }

    foreach( $paData as $id => $value ){
      $lrId2 = safe_query2( "SELECT COUNT(user) FROM httpd_permissions
                             WHERE  reseller = ? AND user=? AND httpd_id = ? AND server_id=?",
                             $loReseller, 
                             $loUser, 
                             new SQLInteger( $id ), 
                             $loServerID  
                           );
      list( $liCount ) = db_fetch_array( $lrId2, 'N' );
      db_free_query( $lrId2 );

      if( $value && ! $liCount ){
        $laNew[] = $id;
      }elseif( ! $value && $liCount ){
        $laDelete[] = $id;
      }
    }

    foreach( $laDelete as $id ){
      safe_query2( "DELETE FROM  httpd_permissions WHERE reseller = ? AND user=? AND  httpd_id = ? AND server_id = ?",
                    $loReseller, 
                    $loUser, 
                    new SQLInteger( $id ), 
                    $loServerID 
                  );
   
    }

    foreach($laNew as $id){
     safe_query2( "INSERT INTO httpd_permissions SET reseller = ?, user=?, httpd_id = ?, server_id = ?",
                  $loReseller, 
                  $loUser, 
                  new SQLInteger( $id ), 
                  $loServerID 
                );
    }

    return true;
  }/*}}}*/

  /**
   * Save permissions for reseller's template. If $pbNew then we will not check if some
   * permissions already exists for this reseller's template.
   *
   * @param integer $piId
   * @param array  $paData
   * @param bool  $pbNew
   * @return bool
   */
  function saveForTemplate( $piId, $paData = array(), $pbNew = false ){/*{{{*/

    if( empty( $piId ) ){
      $this->mcErrorMessage = 'Empty arguments for saveForTemplate()';
      return false;
    }
  
    if( ! is_array( $paData ) ){
      $paData = array();
    }
 
    $loTemplate = new SQLInteger( $piId );
    $loReseller = new SQLString( $this->mcReseller );
    $loServerID = new SQLString( $this->mcServerID );

    $laNew = array();
    $laDelete = array();
    
    // New template
    if( $pbNew ){
      foreach( $paData as $id => $value  ){
        if( $value ){
          $laNew[] = $id;
        }
      } 
      $paData = array();
    }

    foreach( $paData as $id => $value ){
      $lrId2 = safe_query2( "SELECT COUNT(reseller) FROM httpd_permissions
                             WHERE  reseller = ? AND template_id =? AND httpd_id = ? AND server_id=?",
                             $loReseller, 
                             $loTemplate, 
                             new SQLInteger( $id ), 
                             $loServerID  
                           );
      list( $liCount ) = db_fetch_array( $lrId2, 'N' );
      db_free_query( $lrId2 );

      if( $value && ! $liCount ){
        $laNew[] = $id;
      }elseif( ! $value && $liCount ){
        $laDelete[] = $id;
      }
    }

    foreach( $laDelete as $id ){
      safe_query2( "DELETE FROM  httpd_permissions WHERE reseller = ? AND template_id =? AND  httpd_id = ? AND server_id = ?",
                    $loReseller, 
                    $loTemplate, 
                    new SQLInteger( $id ), 
                    $loServerID 
                  );
    }

    foreach( $laNew as $id){
     safe_query2( "INSERT INTO httpd_permissions SET reseller = ?, template_id =?, httpd_id = ?, server_id = ?",
                  $loReseller, 
                  $loTemplate, 
                  new SQLInteger( $id ), 
                  $loServerID 
                );
    }
    return true;
  }/*}}}*/

/**
 * Drop methods
 */

  /**
   * Drop permissions for template. If $paData is not empty ( array of httpd
   * options ids ) we drop only these options permissions.
   *
   * @param integer $piId
   * @param array  $paData
   * @return bool
   */
  function dropForTemplate( $piId, $paData = array() ){/*{{{*/
      
    if( ! is_array( $paData )  ){
      return false;
    }
  
    $loTemplate = new SQLInteger( $piId );
    $loReseller = new SQLString( $this->mcReseller );
    $loServerID = new SQLString( $this->mcServerID );

    // drop all  
    if( empty( $paData ) ){
       safe_query2( "DELETE FROM  httpd_permissions WHERE reseller = ? AND template_id =? AND server_id = ?",
                      $loReseller, 
                      $loTemplate, 
                      $loServerID 
                    );
    // drop not all =)  
    }else{
      foreach( $paData as $id ){
        safe_query2( "DELETE FROM  httpd_permissions WHERE reseller = ? AND template_id =? AND  httpd_id = ? AND server_id = ?",
                      $loReseller, 
                      $loTemplate, 
                      new SQLInteger( $id ), 
                      $loServerID 
                    );
      }
    }
    return true;
  }/*}}}*/
  
  /**
   * Drop permissions for user. If $paData is not empty ( array of httpd
   * options ids ) we drop only these options permissions.
   *
   * @param string $pcUser
   * @param array  $paData
   * @return bool
   */
  function dropForUser( $pcUser, $paData = array() ){/*{{{*/
    
    if( ! is_array( $paData )  ){
      return false;
    }

    $loUser     = new SQLString( $pcUser );
    $loReseller = new SQLString( $this->mcReseller );
    $loServerID = new SQLString( $this->mcServerID );

    // drop all  
    if( empty( $paData ) ){
       safe_query2( "DELETE FROM  httpd_permissions WHERE reseller = ? AND user =? AND server_id = ?",
                      $loReseller, 
                      $loUser, 
                      $loServerID 
                    );
    // drop not all =)  
    }else{
      foreach( $paData as $id ){
        safe_query2( "DELETE FROM  httpd_permissions WHERE reseller = ? AND user =? AND  httpd_id = ? AND server_id = ?",
                      $loReseller, 
                      $loUser, 
                      new SQLInteger( $id ), 
                      $loServerID 
                    );
      }
    }
    return true;
  }/*}}}*/

  /**
   * Drop permissions for reseller. If $paData is not empty ( array of httpd
   * options ids ) we drop only these options permissions.
   *
   * @param string $pcReseller
   * @param array  $paData
   * @return bool
   */
  function dropForReseller( $pcReseller, $paData = array() ){/*{{{*/
    
    if( ! is_array( $paData )  ){
      return false;
    }

    $loReseller = new SQLString( $pcReseller );
    $loServerID = new SQLString( $this->mcServerID );

    // drop all  
    if( empty( $paData ) ){
       safe_query2( "DELETE FROM  httpd_permissions WHERE reseller = ?  AND server_id = ?",
                      $loReseller, 
                      $loServerID 
                    );
    // drop not all =)  
    }else{
      foreach( $paData as $id ){
        safe_query2( "DELETE FROM  httpd_permissions WHERE reseller = ? AND  httpd_id = ? AND server_id = ?",
                      $loReseller, 
                      new SQLInteger( $id ), 
                      $loServerID 
                    );
      }
    }
    return true;
  }/*}}}*/
  
  /**
   * Move permissions from source reseller for all or specified users
   *
   * @param string $pcSReseller
   * @param string $pcSServerID
   * @param array|string $pmUsers
   * @return bool
   */
  function moveFromReseller( $pcSReseller, $pcSServerID = null, $pmUsers = null ){/*{{{*/
    
    if( empty( $pcSReseller ) ){
      $this->mcErrorMessage = 'Empty pcSReseller in HOPermissions::moveFromReseller call';
      return false;
    }

    if( is_null( $pcSServerID ) ){
      $pcSServerID = $this->mcServerID;
    }

    $loSServerID = new SQLString( $pcSServerID );
    $loSReseller = new SQLString( $pcSReseller );
    $loReseller  = new SQLString( $this->mcReseller );
    $loServerID  = new SQLString( $this->mcServerID );

    // Move permissions of all users
    if( is_null( $pmUsers ) ){
      safe_query2( "UPDATE httpd_permissions SET reseller = ?, server_id = ? 
                    WHERE user != '' AND reseller = ? AND server_id = ?",
                    $loReseller, 
                    $loServerID, 
                    $loSReseller, 
                    $loSServerID 
                  );
    // Move permissions for some users
    }elseif( is_array( $pmUsers ) ){
      foreach( $pmUsers as $pcUser  ){
        safe_query2( "UPDATE httpd_permissions SET reseller = ?, server_id = ? 
                      WHERE user = ? AND reseller = ? AND server_id = ?",
                      $loReseller, 
                      $loServerID, 
                      new SQLString($pcUser ),
                      $loSReseller, 
                      $loSServerID 
                    );
      }
    // Move permissions for one user
    }elseif( is_string( $pmUsers ) ){
      safe_query2( "UPDATE httpd_permissions SET reseller = ?, server_id = ? 
                          WHERE user = ? AND reseller = ? AND server_id = ?",
                          $loReseller, 
                          $loServerID, 
                          new SQLString($pmUsers ),
                          $loSReseller, 
                          $loSServerID 
                        );
    }

    return true;
  }/*}}}*/

  /**
   * Count permissions for current Confixx user (master/admin/reseller/user)
   *
   * @return int $liCount
   */
  function countPermissions(){/*{{{*/
    $liCount = 0;
 
    // user
    if( $this->mcReseller && $this->mcUser ){
      $lrId =  safe_query2( "SELECT COUNT(*) FROM httpd_permissions WHERE reseller=? AND user=? AND server_id=?",
                            new SQLString( $this->mcReseller ),
                            new SQLString( $this->mcUser ),
                            new SQLString( $this->mcServerID ) 
                          );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    // reseller
    }elseif( $this->mcReseller ){
      $lrId =  safe_query2( "SELECT COUNT(*) FROM httpd_permissions ".
                            " WHERE reseller=? AND user='' AND template_id = 0 AND server_id=?",
                            new SQLString( $this->mcReseller ),
                            new SQLString( $this->mcServerID ) 
                          );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    // admin
    }elseif( $this->mcServerID ){
      $lrId =  safe_query2( "SELECT COUNT(*) FROM httpd_definitions" );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    // Master
    }else{
      $lrId =  safe_query2( "SELECT COUNT(*) FROM httpd_definitions" );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    }

    return $liCount;
  }/*}}}*/

/**
 *  Method returns array of permissions for current Confixx user
 *  Example of result:
 *  $laPerms = array( 5 => 'safe_mode' ); Where 5 is httpd options id,
 *  'safe_mode' is httpd option label.
 *
 *  @return array $laPerms
 */
  function getPermissions(){/*{{{*/
    
    $laPerms = array();

    $loServerID = new SQLString( $this->mcServerID );

    // User
    if( $this->mcReseller && $this->mcUser ){
      $loReseller = new SQLString( $this->mcReseller );
      $loUser = new SQLString( $this->mcUser );

      $lrId = safe_query2( " SELECT d.id, d.label FROM httpd_definitions d, httpd_permissions s ".
                           " WHERE  d.id = s.httpd_id  AND  s.server_id=?".
                           " AND s.reseller = ? AND s.user=? AND s.template_id=0 ", 
                           $loServerID, $loReseller, $loUser );
    }elseif( $this->mcReseller ){
      // reseller
      $loReseller = new SQLString( $this->mcReseller );

      $lrId = safe_query2( " SELECT d.id, d.label FROM httpd_definitions d, httpd_permissions s ".
                           " WHERE d.id = s.httpd_id  AND  s.server_id=?".
                           " AND s.reseller = ?  AND s.template_id = 0 ", 
                           $loServerID, $loReseller );
    }elseif( $this->mcUser ){
      // User
      $loUser = new SQLString( $this->mcUser );

      $lrId = safe_query2( " SELECT d.id, d.label FROM httpd_definitions d, httpd_permissions s ".
                           " WHERE  d.id = s.httpd_id  AND  s.server_id=?".
                           " AND s.user = ?  AND s.template_id = 0 ", 
                           $loServerID, $loUser );
    }elseif( $this->mcServerID ){
      // Admin
      $lrId = safe_query2( "SELECT id, label FROM httpd_definitions" );
    }else{
      // Master
      $lrId = safe_query2( "SELECT id, label FROM httpd_definitions" );
    }

    while( $laRow = db_fetch_array( $lrId, 'A') ){
      $laPerms[$laRow['id']] = $laRow['label'];
    }
    db_free_query( $lrId ); 
    return $laPerms;
  }/*}}}*/

/**
 * Return current error message
 * 
 * @return string $this->mcErrorMessage
 */
  function getErrorMessage(){/*{{{*/
    return $this->mcErrorMessage;
  }/*}}}*/
/**
 * Auxiliary methods
 */

  /**
   * Tries to find reseller by server_id and user. Return false if can't find
   * reseller.
   *
   * @param  string $pcUser
   * @return false|string $lcReseller
   */
  function findResellerByUser( $pcUser, $pcServerId ){/*{{{*/
    
    $lcReseller = false;

    $lrId = safe_query2( "SELECT anbieter FROM kunden WHERE kunde = ? AND server_id = ? ",
                         new SQLString( $pcUser ),
                         new SQLString( $pcServerID ) );
    if( db_num_rows( $lrId ) ){
      list( $lcReseller ) = db_fetch_array( $lrId, 'N' );
    }
    db_free_query( $lrId );
    return $lcReseller;
  }/*}}}*/


}
?>
