<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once ( dirname(__FILE__) . '/module.Database.php' );
include_once ( dirname(__FILE__) . '/class.User.php' );
include_once ( dirname(__FILE__) . '/class.Actor.php' );
include_once ( dirname(__FILE__) . '/class.InputDecode.php' );
include_once ( dirname(__FILE__) . '/module.url.inc.php' );

class Reseller extends Actor {

    var $ma_Data; // data from anbieter table
    var $ma_Users; // user's list of reseller
    var $ma_UserOrder;
    var $mcServerID;
		var $miDomainsCount; // number of reseller's domains
		var $miSharedDomainsCount; // number of reseller's shared domains

    /**
     * Constructor
     */ 
    function Reseller ( $ps_Name = NULL, $psServerID = null ){
			global $PHP_AUTH_USER;
      global $ServerID;
			$this->Actor();

			$this->ms_Name = is_null($ps_Name) ? $PHP_AUTH_USER : $ps_Name;
			$this->mcServerID = is_null($psServerID) ? $ServerID : $psServerID;

			$lrID = safe_query2( "SELECT * FROM anbieter WHERE server_id=? AND anbieter=?",
													 new SQLString($this->mcServerID), new SQLString($this->ms_Name)	);
			$this->ma_Data = db_fetch_array( $lrID );
			db_free_query( $lrID );
		}

    function IsMyUser ( $ps_UserName ){
	    
			$lrID = safe_query2( "SELECT COUNT(kunde) FROM kunden WHERE server_id=? AND kunde=? AND anbieter=?",
													 new SQLString( $this->mcServerID ),
													 new SQlString( $ps_UserName ),
													 new SQLString( $this->ms_Name ) );
			list( $liCnt ) = db_fetch_array( $lrID );
			db_free_query( $lrID );

			return $liCnt;
    }

    /**
     * Checks if reseller can add more shared domains
     *
     * @param mix $piCount
     * @return bool 
     */
    function CanAddSharedDomains( $piCount = 0 ){
      
			if( $this->ma_Data['maxshareddomainslimit'] != 1 || 
					$this->ma_Data['maxshareddomains'] == -1 ){
				return TRUE;
			}
    
			$lrId = safe_query2( "SELECT COUNT(domain) FROM domains ".
											  	 " WHERE server_id=? AND richtigedomain=7 AND anbieter=?", 
												   new SQLString( $this->mcServerID ),
												   new SQLString( $this->ms_Name ) );
			list( $this->miSharedDomainsCount ) = db_fetch_array( $lrId , 'N' );
			db_free_query( $lrId );

			if( is_array( $piCount ) ) {
        $liTmp = 0;
        foreach($piCount as $value){
          if( $value ){
            $liTmp++;
          }
        }
				$piCount = $liTmp;
			}

			$llRet = (($this->miSharedDomainsCount + $piCount) < $this->ma_Data['maxshareddomains'])? 1: 0;

			if( $llRet ){
				$this->miSharedDomainsCount += $piCount;
			}

			return $llRet; 
    }


    /**
     * Checks if reseller can add more domains
     *
     * @param mix $piCount
     * @return bool 
     */
    function CanAddDomains ( $piCount=0) {
      
			if( $this->ma_Data['maxdomainslimit'] != 1 || 
					$this->ma_Data['maxdomains'] == -1 ){
				return TRUE;
			}

			$id = safe_query2( "SELECT COUNT(id) as cnt FROM domains ".
												 " WHERE server_id=? AND anbieter=? AND richtigedomain = 1", 
												 new SQLString( $this->mcServerID ),
												 new SQLString( $this->ms_Name ) 
												);

			list( $this->miDomainsCount ) = db_fetch_array( $id );
			db_free_query( $id );

			if( is_array( $piCount ) ) {
				$piCount = count( $piCount );
			}

			$llRet = (($this->miDomainsCount + $piCount) < $this->ma_Data['maxdomains'])? 1: 0;
			if( $llRet ){
				$this->miDomainsCount += $piCount;
			}

			return $llRet; 
    }

    function &GetField ( $ps_Name ){
			return $this->ma_Data[$ps_Name];
    }

		function &GetFields(){
			return $this->ma_Data;
		}

    function GetFieldForSQL ()
    {
	
    }
    
    function FillUserList (){

			
			$lrID = safe_query2( "SELECT kunde FROM kunden WHERE server_id=? AND anbieter=?",
													 new SQLString( $this->mcServerID ),
													 new SQLString( $this->ms_Name )
													 );
			$this->ma_Users = array();
			$this->ma_UserOrder = array();
			$li_UserNumber = 0;
			while( list( $lcUser ) = db_fetch_array( $lrID, 'N' ) ){
				$this->ma_Users[$lcUser] =& new User( $lcUser, $this->mcServerID );
				$this->ma_UserOrder[$lcUser] = ++$li_UserNumber;
			}
			db_free_query( $lrID );

			return $li_UserNumber;
    }
    
    function &GetUsersList(){
    	return $this->ma_Users;
    }

    function &GetUser( $ps_UserName ){
    	if(array_key_exists( $ps_UserName, $this->ma_Users ) ){	
    		return $this->ma_Users[$ps_UserName];
    	}else{
				$llRet = false;
    		return $llRet;	
    	}
    }
    
    function SetUserStatistics( $ps_Key, $pa_Values ){
    	global $DEBUG;
    	foreach( array_keys( $this->ma_Users ) as $lo_UserName ){
    		$lo_User =& $this->ma_Users[$lo_UserName];
    		if( array_key_exists( $lo_UserName, $pa_Values ) ){
    			$lo_User->SetStatistics( $ps_Key, $pa_Values[$lo_UserName] );
    		}
    	}
    }

    function GetUserStatistics($ps_Key){
    	global $DEBUG;
    	$la_ret=array();
    	foreach (array_keys($this->ma_Users) as $lo_UserName) {
    		$lo_User =& $this->ma_Users[$lo_UserName];
   			$la_ret[$lo_UserName]=$lo_User->GetStatistics($ps_Key);
    	}
    	return $la_ret;
    }

    
    function CalcUserStatistics($ps_Key,$ps_sql){
    	
    	global $DEBUG;
	    $lo_DB =& get_db_connection();
			$lo_Query =& $lo_DB->Select ( $ps_sql);
			if($lo_Query){
	  		while($la_Row =& $lo_Query->nextrow()){
	  			$la_UserName=$la_Row[0];
	  			$la_Value = $la_Row[1];

	  			if(array_key_exists($la_UserName, $this->ma_Users)){	
	  				$lo_User =& $this->ma_Users[$la_UserName];
    				$lo_User->SetStatistics($ps_Key,$la_Value);
    			}
    		}
	  	}else{
	  		echo "Reseller.CalcUserStatistics: error sql query: $ps_sql<br>\n";
	  	}
    }
    
    function SetUserOrder($ps_key,$ps_desc=''){
    	if($ps_key == 'number'){
    		foreach ($this->ma_Users as $la_UserName => $lo_User){
    			$this->ma_UserOrder[$la_UserName]=$lo_User->GetUserNumber();
    		}
    	}	elseif ($ps_key == 'name')	{
	    	foreach (array_keys($this->ma_Users) as $lo_UserName) {
  	  		$lo_User =& $this->ma_Users[$lo_UserName];
    			$this->ma_UserOrder[$la_UserName]=$lo_User->GetUserName();
    		}
    	}else{
	    	foreach (array_keys($this->ma_Users) as $lo_UserName) {
  	  		$lo_User =& $this->ma_Users[$lo_UserName];
    			$this->ma_UserOrder[$la_UserName]=$lo_User->GetStatistics($ps_key);
    		}
    	}
    	if(stristr($ps_desc,'desc')){
    		arsort($this->ma_UserOrder,SORT_NUMERIC);
    	}else{
    		asort($this->ma_UserOrder,SORT_NUMERIC);
    	}
    	return $this->ma_UserOrder;
    }
    
    function GetUserOrder(){
    	return array_keys($this->ma_UserOrder);
    }
    
    function SharedDomainsCount( $pmCount = null ){
      if( is_numeric( $pmCount ) ){
      	$this->miSharedDomainsCount = $pmCount;
      }elseif( is_array( $pmCount ) ){
        $liTmp = 0;
        foreach($pmCount as $value ){
          if($value){
            $liTmp++;
          }
        }
        $this->miSharedDomainsCount = $liTmp;
      }
      return $this->miSharedDomainsCount;
    }

    function &ServerID( $pcServerId = null ){
      if( is_string( $pcServerId ) ){
      	$this->mcServerID = $pcServerId;
      }
      return $this->mcServerID;
    }
    /**
     * Check domain's name 
     *
     * @return: value for storing into database
     */
    function validateDomain( $pcDomain, $piCount = 0, 
                             $piShared = false, $laSharedDomains = array() ){

			global $DEBUG;
			global $ServerID;

			if( is_array( $piCount ) ) {
				$laDomains = $piCount;
				$piCount = count($laDomains);
			}else{
				$laDomains = array();
			}
      
      $liCountShared = 0;

      if( is_array( $laSharedDomains ) ){
        foreach( $laSharedDomains as $value ){
          if( $value ){
            $liCountShared++;
          }
        }
      }elseif( is_integer( $laSharedDomains ) ){
        $liCountShared = $laSharedDomains;
      }

      $piCount -= $liCountShared;

			$pcDomain = strtolower(trim($pcDomain));

			if( ! $pcDomain){ /* name of the domain is empty */
				$this->AddMessage ( ERROR, ltext( 'kune5_error16' ) );
				return $pcDomain;
      }
      /**
       * Can't add new shared  domain: limit is exceeded 
       */
      if( $piShared ){
        if( ! $this->CanAddSharedDomains( $liCountShared ) ){
          $this->AddMessage ( ERROR, ltext( 'kune5_error26', 
                                            $this->ma_Data['maxshareddomains'], 
                                            $this->miSharedDomainsCount ) );
          return FALSE;
        }
      }else{
        /**
         * Can't add new domain: limit is exceeded 
         */
        if( ! $this->CanAddDomains( $piCount ) ){ 
          $this->AddMessage ( ERROR, ltext( 'kune5_error17', 
                                            $this->ma_Data['maxdomains'], 
                                            $this->miDomainsCount ) );
          return FALSE;
        }
      }
    
			$lrID = safe_query2( "SELECT standarddomain, idn FROM admin WHERE server_id=?",
													 new SQLString( $this->mcServerID )
													 );
			$la_Admin = db_fetch_array( $lrID, 'A' );
      db_free_query( $lrID );

      /**
       * IDN-domain
       */
			$ls_Translated = InputDecode::decode( $pcDomain );
			if( $ls_Translated != $pcDomain ){

				if ( $la_Admin['idn'] ){
					$pcDomain = translate_name_to_idn ( $ls_Translated);
				}else{
					$pcDomain = false;
				}
				if( ! $pcDomain ){
					$this->AddMessage ( ERROR, ltext( "error_bad_domains__no_idn_support", $pcDomain  ) );
					return NULL;
				}
			}
      /**
       * alr syntax
       */
			if ( ! checkDomain( $pcDomain ) || 
					 preg_match( '/^www\./', $pcDomain ) 
					 ) {
				
				$this->AddMessage ( ERROR, ltext( 'kune5_error19', $pcDomain ) );
				return NULL;

			}

      /**
       * Resereved names
       */ 
			$ls_Expression = "/^${user_prefix}[0-9]+\." . str_replace( ".", "\.", $la_Admin["standarddomain"] ) . "$/i";

			if ( preg_match ( $ls_Expression, $pcDomain ) ) {

				$this->AddMessage ( ERROR, ltext( 'kune5_error23', $pcDomain ) );
				return NULL;
      }

      /**
       * Already exists
       */
      if( $piShared ){
        $lrID = safe_query2( "SELECT COUNT(domain) FROM domains WHERE domain = ? AND richtigedomain = 5", 
                             new SQLString( $pcDomain ) 
                             );
        list( $liCnt ) = db_fetch_array( $lrID );
        db_free_query( $lrID );
        if( $liCnt || in_array( $pcDomain, $laDomains ) ){
          $this->AddMessage ( ERROR, ltext( 'kune5_error18', $pcDomain ) );
          return NULL;
        }
      }else{
        $lrID = safe_query2( "SELECT COUNT(domain) FROM domains WHERE domain = ? AND richtigedomain <> 7", 
                             new SQLString( $pcDomain ) 
                             );
        list( $liCnt ) = db_fetch_array( $lrID );
        db_free_query( $lrID );
        if( $liCnt || in_array( $pcDomain, $laDomains ) ){
          $this->AddMessage ( ERROR, ltext( 'kune5_error18', $pcDomain ) );
          return NULL;
        }
        
        // If already exists in DNS
        $lrID = safe_query2( "SELECT COUNT(domain) FROM dns WHERE domain = ?", 
                             new SQlString( $pcDomain ) );
        list( $liCnt ) = db_fetch_array( $lrID );
        db_free_query( $lrID );
        if ( $liCnt || in_array( $pcDomain, $laDomains ) ){
          $this->AddMessage ( ERROR, ltext( 'kune5_error18', $pcDomain ) );
          return NULL;
        }
      }
			return $pcDomain;
		}

}
?>
