<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/module.Genlib.php" );





class ValuesSource
{
    /* -------------------- Members -------------------- */
    var $ms_PageNumber; // current page, starting from 0
    var $ms_ItemsPerPage; // items per page

    var $ms_IDName; // name or index of ID field

    var $ms_SortColumn; // name of column that should be used for sorting
    var $ms_SortReverse; // if TRUE - then sort in descending order

	var $ms_RecalcPage; // if TRUE - page number should be re-calculated after setting of items per page
    /* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function ValuesSource ( $ps_IDName=0, $ps_PageNumber = NULL, $ps_ItemsPerPage = NULL )
	{
		if ( is_null($ps_PageNumber) ){
			if ( $_SERVER["REQUEST_METHOD"] == "GET" )
				$la_Data =& $_GET;
			else
				$la_Data =& $_POST;
			$this->ms_PageNumber = array_key_exists ( "page", $la_Data ) ? intval($la_Data["page"]) : NULL;
		}
		else
			$this->ms_PageNumber = intval($ps_PageNumber);
		if ( is_null($ps_ItemsPerPage) )
			$this->ms_ItemsPerPage = 10;
		else
			$this->ms_ItemsPerPage = intval($ps_ItemsPerPage);
		if( $this->ms_ItemsPerPage <= 0 )
			$this->ms_ItemsPerPage = 10;
		if( is_null( $this->ms_PageNumber ) && !is_null( ff_GetFromPostGet("start") ) ) {
			$this->ms_PageNumber = intval( ff_GetFromPostGet("start")/$this->ms_ItemsPerPage );
			if( strlen(ff_GetFromPostGet("next")) )
				$this->ms_PageNumber++;
			elseif( strlen(ff_GetFromPostGet("prev")) )
				$this->ms_PageNumber--;
			$this->ms_RecalcPage = TRUE;
		}
		else
			$this->ms_RecalcPage = FALSE;
		if( $this->ms_PageNumber <= 0 )
			$this->ms_PageNumber = 0;
		$this->ms_IDName = $ps_IDName;
	}
	/* -------------------- end Constructor -------------------- */





    /* -------------------- Get... -------------------- */
    function GetPageNumber()
    {
	return $this->ms_PageNumber;
    }

    function GetItemsPerPage()
    {
	return $this->ms_ItemsPerPage;
    }

    function GetIDName()
    {
	return $this->ms_IDName;
    }

    function GetTotalPages ( $pa_Search )
    {
	$ls_Elements = $this->TotalElements ( $pa_Search );
	if ( $ls_Elements == 0 )
	    return 1;
	$ls_PerPage = $this->GetItemsPerPage();
	return intval ( ( $ls_Elements + $ls_PerPage - 1 ) / $ls_PerPage );
    }

    function GetFirstItem ()
    {
	return $this->GetPageNumber() * $this->GetItemsPerPage() + 1;
    }

    function GetLastItem ( $pa_Search )
    {
	$ls_Last = ( $this->GetPageNumber() + 1 ) * $this->GetItemsPerPage();
	$ls_Total = $this->TotalElements ( $pa_Search );
	return $ls_Total > $ls_Last ? $ls_Last : $ls_Total;
    }

    function GetSortColumn()
    {
	return $this->ms_SortColumn;
    }

    function GetSortReverse()
    {
	return $this->ms_SortReverse;
    }
    /* -------------------- end Get... -------------------- */





	/* -------------------- Set... -------------------- */
	function SetItemsPerPage ( $ps_ClassName )
	{
		if ( ff_GetFromPostGet("ItemsPerPage") )
			$this->ms_ItemsPerPage = intval(ff_GetFromPostGet ("ItemsPerPage"));
		elseif( ff_GetFromPostGet("step") )
			$this->ms_ItemsPerPage = intval( ff_GetFromPostGet("step") );
		elseif ( array_key_exists( $ps_ClassName."_ItemsPerPage", $_COOKIE ) )
			$this->ms_ItemsPerPage = intval($_COOKIE[$ps_ClassName."_ItemsPerPage"]);
		else
			$this->ms_ItemsPerPage = 10;

		if( $this->ms_RecalcPage && !is_null( ff_GetFromPostGet("start") ) ) {
			$this->ms_PageNumber = intval( ff_GetFromPostGet("start")/$this->ms_ItemsPerPage );
			if( strlen(ff_GetFromPostGet("next")) )
				$this->ms_PageNumber++;
			elseif( strlen(ff_GetFromPostGet("prev")) )
				$this->ms_PageNumber--;
		}

		if ( !headers_sent() )
			setcookie ( $ps_ClassName."_ItemsPerPage", $this->ms_ItemsPerPage, time()+3600*24*365, "/" );
//		print_r($this);
	}

    function SetSort ( $ps_ClassName )
    {
	if ( ff_GetFromPostGet("SortColumn") )
	    $this->ms_SortColumn = ff_GetFromPostGet("SortColumn");
	elseif ( array_key_exists( $ps_ClassName."_SortColumn", $_COOKIE ) )
	    $this->ms_SortColumn = $_COOKIE[$ps_ClassName."_SortColumn"];
	else
	    $this->ms_SortColumn = $this->GetDefaultSort();

	if ( ff_GetFromPostGet("SortReverse") )
	    $this->ms_SortReverse = ff_GetFromPostGet("SortReverse") == "Y";
	elseif ( array_key_exists( $ps_ClassName."_SortReverse", $_COOKIE ) )
	    $this->ms_SortReverse = $_COOKIE[$ps_ClassName."_SortReverse"] == "Y";
	else
	    $this->ms_SortReverse = FALSE;

	if ( !headers_sent() )
	{
	    setcookie ( $ps_ClassName."_SortColumn", $this->ms_SortColumn, time()+3600*24*365, "/" );
	    setcookie ( $ps_ClassName."_SortReverse", $this->ms_SortReverse==TRUE ? "Y": "N", time()+3600*24*365, "/" );
	}
    }
	/* -------------------- end Set... -------------------- */





	/* -------------------- Is... -------------------- */
	function IsBrowse ( &$pa_Search ) {
		return ! $this->IsSearch ( $pa_Search );
	}

	function IsSearch ( &$pa_Search ) {
		for ( $i=0; $i<count($pa_Search); $i++ )
			if ( $pa_Search[$i]->IsSetInQuery() )
				return TRUE;
		return FALSE;
	}
	/* -------------------- end Is... -------------------- */





    /* -------------------- "abstract" methods -------------------- */
    function GetElement()
    {
	echo ( "method GetElement should return element!" );
    }

    function Start ( &$pa_Search )
    {
	echo ( "method Start should initialize iteration!" );
    }


    function &NextElement()
    {
	echo ( "method NextElement should return next element!" );
    }

    function TotalElements ( $pa_Search )
    {
	echo ( "method TotalElements should return total number of elements!" );
    }

    function InIteration()
    {
	echo ( "method InIteration should return TRUE if iteration is started and not ended yet!" );
    }

    function AddElement()
    {
	echo ( "method AddElement should add element and return NULL, array or object" );
    }

    function EditElements()
    {
	echo ( "method EditElements should edit elements and return NULL, array or object" );
    }

    function DeleteElements ( &$pa_IDs )
    {
	echo ( "method DeleteElements should delete elements and return number of deleted elements" );
    }

    function ValidateAdd()
    {
	echo ( "method ValidateAdd should return NULL, array or object" );
    }

    function ValidateEdit()
    {
	echo ( "method ValidateEdit should return NULL, array or object" );
    }

    function ValidateDelete ( &$pa_IDs )
    {
	echo ( "method ValidateDelete should return NULL, array or object" );
    }

    function GetDefaultSort()
    {
	return "";
    }
    /* -------------------- end "abstract" methods -------------------- */





    /* -------------------- three methods, should be defined for SQL sources -------------------- */
    function LockAdd()
    {
    }

    function LockEdit()
    {
    }

    function LockDelete()
    {
    }

    function UnLock()
    {
    }
    /* -------------------- end three methods, should be defined for SQL sources -------------------- */





    /* -------------------- UpdateColumns -------------------- */
    function UpdateColumns ( &$pa_Columns, &$pa_Row )
    {
	$ls_ID = array_key_exists ( $this->GetIDName(), $pa_Row ) ? $pa_Row[$this->GetIDName()] : NULL;
	for ( $i=0; $i<count($pa_Columns); $i++ )
	{
	    $lo_Column =& $pa_Columns[$i];
	    $lo_Column->SetFromArray ( $pa_Row, $ls_ID );
	}
    }
    /* -------------------- end UpdateColumns -------------------- */





    /* -------------------- UpdateFromQuery -------------------- */
    /* static */
    function UpdateFromQuery ( &$pa_Columns )
    {
	for ( $i=0; $i<count($pa_Columns); $i++ )
	    $pa_Columns[$i]->SetFromPostGet();
    }
    /* -------------------- end UpdateFromQuery -------------------- */

}
?>
