<?
include_once("class.ValueLocale.php");

class ValuePreLocaleSuf extends ValueLocale {

	var $maArgs;
	var $mcPrefix;
	var $mcSuffix;
	
	function ValuePreLocaleSuf( $pcKey, $puValue = NULL, $pcPrefix='', $pcSuffix='' ) {
		$this->maArgs = array();

		$this->Prefix( $pcPrefix );
		$this->Suffix( $pcSuffix );

		if ( is_null($puValue) ) {
			$this->setKey( $pcKey );

		} elseif( is_a( $pcKey, 'ValuePreLocaleSuf' ) ) {
			$this->copyFrom( $pcKey );

		} else {
			if (is_array($puValue)){
				$this->Arguments($puValue);
				$this->setKey( $pcKey );
			} else {
				parent::Key( $pcKey );
				$this->Value( $puValue );
			}
		}
	}

	function &Arguments( $paArgs = NULL){
		if ( is_array( $paArgs ) ) {
			$this->maArgs = $paArgs;
		} elseif(func_num_args()) {
			$this->maArgs = func_get_args();
		}
		return $this->maArgs;
	}

	function Key( $pcKey = NULL ) {
		if ( !is_null($pcKey)){
			$this->setKey( $pcKey );
		}
		return parent::Key();
	}

	function &Prefix( $pcSrc = NULL ){
		if( is_string( $pcSrc ) ) {
			$this->mcPrefix = $pcSrc;
		}
		return $this->mcPrefix;
	}

	function &Suffix( $pcSrc = NULL ){
		if( is_string( $pcSrc ) ) {
			$this->mcSuffix = $pcSrc;
		}
		return $this->mcSuffix;
	}

	function &setKey( $pcKey ){
		$lcKey =& parent::setKey( $pcKey );
		$this->setValue();
		return $lcKey;
	}

	function &setValue( $pcValue=NULL ){
		if( is_null( $pcValue ) ) {
			return parent::setValue( $this->Prefix().ltext( $this->Key(), $this->maArgs ).$this->Suffix() );

		} else {
			return parent::setValue( $this->Prefix().$pcValue.$this->Suffix() );
		}
	}

	function setFromArray(){
# do nothing
		return FALSE;
	}

	function copyFrom( &$poSource ){
		
		parent::copyFrom( $poSource );

		if( is_a( $poSource, 'ValuePreLocaleSuf' ) ) {
			$this->Prefix( $poSource->Prefix() );
			$this->Suffix( $poSource->Suffix() );
		}
	}


	function &getClone(){
		return new ValuePreLocaleSuf( $this );
	}


}
?>