<?php
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/

global $goConfixxDb,$goUserMysql,$goMasterMysql,$goMasterDB;

class DBConnect {

	/* -------------------- Members -------------------- */
	var $mcType;
	var $mcUser;
	var $mcHost;
	var $mcPass;
	var $mcDb;
	var $mcPort;
	var $mrConnectionId;
	var $mcGlobalKey;
	/* -------------------- end Members -------------------- */

	/* -------------------- Constructor -------------------- */
	function DBConnect ( $pcType, $pcHost, $pcUser, $pcPass, $pcDb, 
											 $pcPort, $pcGlobalKey = 'db_connection' ) {

		global $DEBUG;

		$this->Type( $pcType );
		$this->User( $pcUser );
		$this->Host( $pcHost );
		$this->Password( $pcPass );
		$this->DB( $pcDb );
		$this->Port( $pcPort );
		$this->GlobalKeyPrefix( $pcGlobalKey );
		
		if( $pcType && $pcHost && $pcDb ){
			$this->connect();
		}
		
		if( $DEBUG ){
			echo "DBConnect::DBConnect<br><pre>\n";
			print_r($this);
			echo "</pre><hr>\n";
		}
	}

	function &GlobalKeyPrefix( $pcKey = NULL ){
		if( is_string( $pcKey ) ){
			$this->mcGlobalKey = $pcKey;
		}
		return $this->mcGlobalKey;
	}

	function getIdGlobalKey(){
		return $this->mcGlobalKey.'_id';
	}
	function getDbGlobalKey(){
		return $this->mcGlobalKey.'_db';
	}

	function &Host( $pcHost = NULL ) {
		if( is_string( $pcHost ) ) {
			$this->mcHost = $pcHost;
		}
		return $this->mcHost;
	}


	function &Type( $pcType = NULL ) {
		if( is_string( $pcType ) ) {
			$this->mcType = $pcType;
		}
		return $this->mcType;
	}

	function &Port( $pcPort = NULL ){
		if( ! is_null( $pcPort ) ) {
			$this->mcPort = $pcPort;
		}
		return $this->mcPort;
	}

	function &User( $pcUser = NULL ){
		if( is_string( $pcUser ) ) {
			$this->mcUser = $pcUser;
		}
		return $this->mcUser;
	}

	function &Password( $pcPass = NULL ){
		if( is_string( $pcPass ) ) {
			$this->mcPass = $pcPass;
		}
		return $this->mcPass;
	}

	function &DB( $pcDb = NULL ){
		if( is_string( $pcDb ) ) {
			$this->mcDb = $pcDb;
		}
		return $this->mcDb;
	}

	function ConnectionId( $prConnId = NULL ){
		if( ! is_null( $prConnId ) ){
			$this->mrConnectionId = $prConnId;
		}
		return $this->mrConnectionId;
	}

	function getMysqlServer(){
		if( is_string( $this->Port() ) ) {
			return $this->mcHost.':'.$this->Port();

		} else {
			return $this->mcHost;
		}
	}

	function connect( $plForce = NULL ){
		global $DEBUG;

		$lcIdKey = $this->getIdGlobalKey();
		$lcDBKey = $this->getDbGlobalKey();
		switch( $this->Type()){
		case 'mysql':
			$lcCurrentDB = '';
			if( array_key_exists( $lcIdKey, $GLOBALS ) &&
					$GLOBALS[$lcIdKey] ) {
				$id = db_query( "SELECT DATABASE()", $GLOBALS[$lcIdKey] );
				list( $lcCurrentDB ) = db_fetch_array( $id, 'N' );
				db_free_query( $id );
			}

			if( ! $plForce &&
					array_key_exists( $lcIdKey, $GLOBALS ) &&
					$GLOBALS[$lcIdKey] &&
					( $lcCurrentDB == $this->DB() ) ) {
				$this->ConnectionId( $GLOBALS[$lcIdKey] );

			} else {
				if( $DEBUG ){
					$liConnID = mysql_connect( $this->getMysqlServer(), 
																		 $this->User(), 
																		 $this->Password() 
																		 );
				}else{
					$liConnID = @mysql_connect( $this->getMysqlServer(), 
																			$this->User(), 
																			$this->Password() 
																			);
				}
				if( ! $liConnID ) {
				
					die( ltext( "server_anlegen_fehler_noconnect" ).
							 "<br>\n". mysql_error()
							 );
				}

				$GLOBALS[$lcIdKey] = $this->ConnectionId( $liConnID );
				if( ! mysql_select_db ( $this->DB(), 
																$this->ConnectionId()
																)
						){
					die(ltext("server_anlegen_fehler_dbname"));
				}
				
				$GLOBALS[$lcDBKey] = $this->DB();
			}
			break;

		case 'Pg':

			if( !$plForce && $GLOBALS[$lcIdKey] ){
				$this->ConnectionId( $GLOBALS[$lcIdKey] );

			} else {
				if( $this->ConnectionId() ) {
					$this->disconnect();
				}
			

				$DSN = 'user='.$this->User().
					' password='.$this->Password().
					' dbname='.$this->DB();

				if( $this->Host() != 'localhost'){
					$DSN .= ' host='.$this->Host();
				}

				if( is_numeric( $this->Port() ) ) {
					$DSN .= ' port='.$this->Port(); 
				}
				if( $DEBUG ){
					$this->ConnectionId( pg_connect( $DSN ) ); 
				}else{
					$this->ConnectionId( @pg_connect( $DSN ) ); 
				}

				if( ! $this->ConnectionId() ){
					die(ltext("server_anlegen_fehler_dbname"));
				}
			
				$GLOBALS[$lcIdKey] = $this->ConnectionId(); 
				unset( $GLOBALS[$lcDBKey] );
			}
		}
		if( $DEBUG ){
			echo "DBConnect::connect : # ".$this->ConnectionId().
				" (".$this->DB().")<br>\n";
		}
		return $this->ConnectionId();
	}

	function disconnect(){
		switch( $this->Type()){
		case 'mysql':
			break;
		case 'Pg':
			if( $this->ConnectionId() ) {
				pg_close( $this->ConnectionId());
				$this->mrConenctionId = NULL;
				break;
			}
		}
	}
	/* -------------------- Methods -------------------- */
	function GetId() {
		return $this->mrConnectionId;
	}

	function isSame( &$poSrc ){

		return ( $this->Type() == $poSrc->Type() ) && 
		( $this->DB() == $poSrc->DB() ) &&
		( $this->User() == $poSrc->User() ); 
	}
	
	function CheckConnection() {
		global $DEBUG;
		if( !$this->ConnectionId() ){
			return $this->connect();
		}
		$lcIdKey = $this->getIdGlobalKey();
		$lcDBKey = $this->getDbGlobalKey();

		switch( $this->Type()){
		case 'mysql':
			$lcCurrentDB = "";
			if (!is_null($GLOBALS[$lcIdKey])) {
				$id = mysql_query( "SELECT DATABASE() as db_name", $GLOBALS[$lcIdKey] ); 
				list($lcCurrentDB) = db_fetch_array( $id, 'N' );
			}
			if ($GLOBALS[$lcDBKey] == $this->ConnectionId() ) {
				if ($lcCurrentDB != $this->DB() ) {

					mysql_select_db ($this->DB(), $this->ConnectionId() );

					$GLOBALS[$lcDBKey] = $this->DB();
				}
			} else {
				return $this->connect();
			}
			break;
		case 'Pg':
			
		}
		if( $DEBUG ){
			echo "DbConnect::CheckConnection : # ".$this->ConnectionId().
				" (".$this->ConnectionId().")<br>\n";
		}
		return $this->ConnectionId();
	}
/* -------------------- end Methods -------------------- */
}

function &getConfixxDbConnect(){
	global $db_type, $db_host, $db_user, $db_pass, $db_db, $db_port;
	global $goConfixxDB;

	if( is_object( $goConfixxDB ) ){
		$goConfixxDB->CheckConnection();

	}else{
		$goConfixxDB = new DBConnect( $db_type, 
																	$db_host, 
																	$db_user, 
																	$db_pass, 
																	$db_db, 
																	$db_port,
																	'db_connection' );
	}

	return $goConfixxDB;
}

function &getUserDbConnect(){
	global $mysql_user_host, $mysql_user_user, $mysql_user_pass, $mysql_user_port;
	global $goUserMysql;
	if( is_object( $goUserMysql ) ){
		$goUserMysql->CheckConnection();

	}else{
		$goUserMysql = new DBConnect( 'mysql', /* type */
																	$mysql_user_host, 
																	$mysql_user_user, 
																	$mysql_user_pass, 
																	'mysql', /* data base */
																	$mysql_user_port,
																	'mysql_connection' );
	}
	return $goUserMysql;
}

function &getMasterMysqlConnect(){
	global $mysqlMasterServer, $mysqlMasterAdmin, $mysqlMasterAdminPw,
		$mysqlMasterPort;
	global $goMasterMysql;
	if( ! is_object( $goUserMysql ) ){
		$goMasterMysql = new DBConnect( 'mysql',
																		$mysqlMasterServer,
																		$mysqlMasterAdmin,
																		$mysqlMasterAdminPw,
																		'mysql',
																		$mysqlMasterPort,
																		'master_mysql'
																		);
	}else{
		$goMasterMysql->CheckConnection();
	}
	return $goMasterMysql;
}

function &getMasterDbConnect(){
	global $dbMasterDB, $dbMasterUser, $dbMasterPw;
	global $mysqlMasterServer, $mysqlMasterPort;
	global $goMasterDB;

	if( is_object ( $goMasterDB ) ){
		$goMasterDB->CheckConnection();

	}else{
		$goMasterDB = new DBConnect( 'mysql',
																 $mysqlMasterServer,
																 $dbMasterUser,
																 $dbMasterPw,
																 $dbMasterDB,
																 $mysqlMasterPort,
																 'db_connection'
																 );
	}
	return $goMasterDB;

}

?>
