<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.DataField.php" );
include_once( dirname(__FILE__) . "/../html/class.ButtonElement.php" );
include_once( dirname(__FILE__) . "/../html/class.HTMLElement.php" );





class ButtonData extends DataField {

	/* -------------------- Members -------------------- */
	var $ms_Label; // label on button
	var $ms_JS; // javascript of button
	var $ms_ID; // ID of button
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function ButtonData( $ps_Label, $ps_JS="javascript:doChange()", $ps_ID=NULL,
											 $paAttributes = NULL, $paParentAttributes = NULL ) {
		$this->DataField( $paAttributes, $paParentAttributes);
		$this->SetLabel($ps_Label);
		$this->SetJS($ps_JS);
		$this->SetID( $ps_ID );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetLabel( $ps_Label ) {
		$this->ms_Label = $ps_Label;
	}

	function GetLabel() {
		return $this->ms_Label;
	}

	function SetJS( $ps_JS ) {
		$this->ms_JS = $ps_JS;
	}

	function GetJS() {
		return $this->ms_JS;
	}

	function SetID( $ps_ID ) {
		$this->ms_ID = $ps_ID;
	}

	function GetID() {
		return $this->ms_ID;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- "abstract" methods -------------------- */
	function SetFromArray($pa_values){
	}
	
	function GetInputPresentation() {
		return new ButtonElement( $this->GetLabel(), $this->GetJS(), $this->GetID() );
	}

	function GetOutputPresentation() {
		return new ButtonElement( $this->GetLabel(), $this->GetJS(), $this->GetID() );
	}

	function GetHiddenPresentation() {
		return new HTMLElement( "" );
	}
	/* -------------------- end "abstract" methods -------------------- */

}
?>
