<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.HTMLDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.CompoundElement.php" );





class CompoundDataField extends DataField {

	/* -------------------- Members -------------------- */
	var $ma_Content; // content of field
	var $ms_Separator; // separator between fields
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function CompoundDataField( $paContent = NULL ) {
		$this->ClearContent();
		$this->DataField();
		$this->SetSeparator( ", " );
		if( !is_array( $paContent ) ) {
			$paContent = func_get_args();
		}

		if( count( $paContent ) )
			call_user_func_array( array( &$this, "AppendToContent" ), $paContent );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetSeparator( $ps_Separator ) {
		$this->ms_Separator = $ps_Separator;
	}

	function GetSeparator() {
		return $this->ms_Separator;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- methods to access content -------------------- */
	function ClearContent() {
		$this->ma_Content = array();
	}

	function AppendToContent( $pm_First ) {
		foreach( func_get_args() as $lm_Field )
			$this->ma_Content[] = is_object($lm_Field) ? $lm_Field : new HTMLDataField( $lm_Field );
	}

	function &GetContent( $ps_Index = NULL ) {
		if( is_null( $ps_Index ) )
			return $this->ma_Content;
		if( $ps_Index == cc_LastElement )
			return $this->ma_Content[ count($this->ma_Content) - 1 ];
		return $this->ma_Content[$ps_Index];
	}

	function CountContent() {
		return count($this->ma_Content);
	}
	/* -------------------- end methods to access content -------------------- */





	/* -------------------- SetDisabled -------------------- */
	function SetDisabled( $ps_Disabled ) {
		DataField::SetDisabled( $ps_Disabled );
		$la_Content =& $this->GetContent();
		foreach( array_keys($la_Content) as $ls_Key )
			$la_Content[$ls_Key]->SetDisabled( $ps_Disabled );
	}
	/* -------------------- end SetDisabled -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function SetFromArray( $pa_Data ) {
		$la_Content =& $this->GetContent();
		for( $i=0; $i<count($la_Content); $i++ )
			$la_Content[$i]->SetFromArray( $pa_Data );
	}

	function &GetInputPresentation( $ps_ID=NULL ) {
		$lo_Result = new CompoundElement();
		$lo_Result->SetSeparator( $this->GetSeparator() );
		foreach( $this->GetContent() as $lo_Field )
			$lo_Result->AppendToContent( $lo_Field->GetInputPresentation($ps_ID) );
		return $lo_Result;
	}

	function &GetOutputPresentation() {
		$lo_Result = new CompoundElement();
		$lo_Result->SetSeparator( $this->GetSeparator() );
		foreach( $this->GetContent() as $lo_Field )
			$lo_Result->AppendToContent( $lo_Field->GetOutputPresentation() );
		return $lo_Result;
	}

	function &GetHiddenPresentation( $ps_ID=NULL ) {
		$lo_Result = new CompoundElement();
		$lo_Result->SetSeparator("");
		foreach( $this->GetContent() as $lo_Field )
			$lo_Result->AppendToContent( $lo_Field->GetHiddenPresentation($ps_ID) );
		return $lo_Result;
	}
	/* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
