<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.DataField.php" );
include_once( dirname(__FILE__) . "/../../../ftplogin/ftp_config.php" );




class FileIconDataField extends IconDataField {

	/* -------------------- Members -------------------- */
	var $ms_FileName; // file name
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function FileIconDataField( $ps_FileName ) {
		$this->IconDataField( "" );
		$this->SetFileName( $ps_FileName );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetFileName( $ps_FileName ) {
		global $MimeIcon,$confixx_interface_version;
		$this->ms_FileName = $ps_FileName;
		$la_Path = pathinfo( $ps_FileName );
		$ls_Extension = $la_Path["extension"];
		if( array_key_exists( strtolower($ls_Extension), $MimeIcon ) )
		{
			if($confixx_interface_version == 'powp') 
			$this->SetIconName( "small_icons/" . $MimeIcon[$ls_Extension] );
			else
			$this->SetIconName( "file_icons/" . $MimeIcon[$ls_Extension] );
		}
		else
		{
			if($confixx_interface_version == 'powp') 
				$this->SetIconName( "small_icons/file_generic.gif" );
			else
				$this->SetIconName( "file_icons/file_generic.gif" );
		}
	}

	function GetFileName() {
		return $this->ms_FileName;
	}
	/* -------------------- end Set.../Get... -------------------- */

}
?>
