<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.OneValueDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.TextAreaElement.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputHiddenElement.php" );





class LongTextDataField extends OneValueDataField {

	/* -------------------- Constructor -------------------- */
	function LongTextDataField( $ps_Value="", $ps_Name=NULL, $paAttributes=array(), $paParentAttributes = array() ) {
		if (!(isset($paAttributes["cols"]) && !empty($paAttributes["cols"]))) {
			$paAttributes["cols"] = 50;
		}
		
		if (!(isset($paAttributes["rows"]) && !empty($paAttributes["rows"]))) {
			$paAttributes["rows"] = 10;
		}
		
		$this->OneValueDataField( $ps_Value, $ps_Name, $paAttributes, $paParentAttributes );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetInputPresentation( $ps_ID=NULL ) {
		$la_Attributes = $this->GetAttributes( $ps_ID );
		
		return new TextAreaElement( $la_Attributes, $this->GetValue() );
	}

	function GetOutputPresentation() {
		return new TextElement( $this->GetValue() );
	}

	function GetHiddenPresentation( $ps_ID=NULL ) {
		return new InputHiddenElement( array( "name"=>$this->GetNameWithID( $ps_ID ), "value"=>$this->GetValue() ) );
	}
	/* -------------------- end definitions "abstract" methods -------------------- */

}
?>
