<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.NameDataField.php" );
include_once( dirname(__FILE__) . "/../../module.Database.php" );





class ManyValuesDataField extends NameDataField {

	/* -------------------- Members -------------------- */
	var $ma_Values; // values of field
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function ManyValuesDataField( $pa_Values=array(), $ps_Name=NULL ) {
		$this->NameDataField( $ps_Name );
		$this->SetValues( $pa_Values );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods to access values -------------------- */
	function SetValues( $pa_Values ) {
		if (is_array($pa_Values))	{
			$this->ma_Values = $pa_Values;
		}else{
			$this->ma_Values = array($pa_Values);
		}	
	}

	function GetValues() {
		return $this->ma_Values;
	}

	function IsValue( $ps_Test ) {
		return in_array( $ps_Test, $this->GetValues() );
	}
	/* -------------------- end methods to access values -------------------- */





	/* -------------------- SetFromArray -------------------- */
	function SetFromArray( $pa_Data ) {
		$ls_Name = $this->GetName();
		if( is_null( $ls_Name ) )
			return;
		$this->SetValues( array_key_exists( $ls_Name, $pa_Data ) ? array( $pa_Data[$ls_Name] ) : array() );
	}
	/* -------------------- end SetFromArray -------------------- */

}
?>
