<?php
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once( dirname(__FILE__) . "/class.OneValueDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.SelectElement.php" );
include_once( dirname(__FILE__) . "/../html/class.OptionElement.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputHiddenElement.php" );
include_once( dirname(__FILE__) . "/../html/class.TagWithEndElement.php" );
include_once( dirname(__FILE__) . "/../html/module.Constants.php" );
include_once( dirname(__FILE__) . "/../html/class.InputRadioElement.php" );
include_once( dirname(__FILE__) . "/../html/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/../html/class.BRElement.php" );
include_once( dirname(__FILE__) . "/../../module.Database.php" );





class OptionsDataField extends OneValueDataField {

	/* -------------------- Members -------------------- */
	var $ma_Options; // array of options
	var $ms_Presentation; // what visual presentation should be used
	var $mo_Separator; // what object to show between options if radio group presentation is used
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function OptionsDataField( $pa_Options=array(), $ps_Value="", $ps_Name=NULL, $ps_Presentation=cc_SelectPresentation,
														 $paAttribute = array(), $paParentAttribute = array() ) {
		if( is_array( $ps_Presentation ) ) {
			$paParentAttribute = $paAttribute;
			$paAttribute = $ps_Presentation;
			$ps_Presentation = cc_SelectPresentation;
		}

		$this->OneValueDataField( $ps_Value, $ps_Name, $paAttribute, $paParentAttribute );
		$this->SetOptions( $pa_Options );
		$this->SetPresentation( $ps_Presentation );
		$this->SetSeparator( new BRElement( array() ) );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods to access options -------------------- */
	function SetOptions( &$pa_Options ) {
		if( is_array( $pa_Options ) ){
			$this->ma_Options = $pa_Options;
		}else{
			$this->AppendOptionsFromSQL( $pa_Options );
		}
	}

	function GetOptions() {
		return $this->ma_Options;
	}

	function AppendToOptions( $pa_New ){
		foreach( $pa_New as $ls_Key=>$ls_Value )
			$this->ma_Options[$ls_Key] = $ls_Value;
	}

	function AppendOptionsFromSQL( $ps_Query, $ps_ValueField=0, $ps_TextField=1 ) {
    global $master_confixx;
		if( is_a( $ps_Query, 'SQLQuery' ) ){
			if( $ps_Query->doQuery() ) {
				while( $la_Row =& $ps_Query->fetchArray( 'N' ) ) {
					$this->ma_Options[ $la_Row[$ps_ValueField] ] = $la_Row[$ps_TextField];
					
				}
				$ps_Query->freeResult();
			}

		} else {
			
		    $lo_DB =& get_db_connection();

			
			$lo_Query =& $lo_DB->Select( $ps_Query );
			if( $lo_Query ){
				while( $la_Row =& $lo_Query->nextrow() )
					$this->ma_Options[ $la_Row[$ps_ValueField] ] = $la_Row[$ps_TextField];
				$lo_Query->close();
			}
		}
	}

	function CountOptions() {
		return count($this->ma_Options);
	}
	/* -------------------- end methods to access options -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetPresentation( $ps_Presentation ) {
		$this->ms_Presentation = $ps_Presentation;
	}

	function GetPresentation() {
		return $this->ms_Presentation;
	}

	function SetSeparator( $po_Separator ) {
		$this->mo_Separator = $po_Separator;
	}

	function GetSeparator() {
		return $this->mo_Separator;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetInputPresentation( $ps_ID=NULL ) 
	{
		$la_Attributes = $this->GetAttributes( $ps_ID );
	 	switch ($this->GetPresentation()) {
			case cc_SelectPresentation:
				$lo_Result   = new SelectElement( $la_Attributes );
				$ls_Selected = $this->GetValue();
				
				foreach( $this->GetOptions() as $ls_Key => $ls_Value ) 
				{
					$lo_Result->AppendToContent( new OptionElement( $ls_Key==$ls_Selected ? array( "value"=>$ls_Key,
									"selected"=>NULL ) : array( "value"=>$ls_Key ), $ls_Value ) );
				}
				
				return $lo_Result;
				break;
			case cc_RadioGroupPresentation:
				$lo_Result   = new CompoundElement();
				$ls_Selected = $this->GetValue();
				
				foreach( $this->GetOptions() as $ls_Key => $ls_Value ) 
				{
					$la_RadioAttributes          = $la_Attributes;
					$la_RadioAttributes["value"] = $ls_Key;
					$la_RadioAttributes["id"]    = $la_RadioAttributes['name'].'id_'.$ls_Key;
					
					if ($ls_Key == $ls_Selected) {
						$la_RadioAttributes["checked"]=NULL;
					}
           
					$loLabel = new TagWithEndElement('label', array('for' => $la_RadioAttributes["id"]));
				  $loLabel->AppendToContent($ls_Value);
					
					$lo_Result->AppendToContent(new InputRadioElement( $la_RadioAttributes ), 
					                             $loLabel,$this->GetSeparator() );
				}
				
				return $lo_Result;
				break;
		}
	}

	function GetOutputPresentation() {
		$ls_Value = $this->GetValue();
		$la_Options = $this->GetOptions();
		if (is_null($ls_Value)) $ls_Value = "";
		return new TextElement( array_key_exists( $ls_Value, $la_Options ) ? $la_Options[$ls_Value] : "" );
	}

	function GetHiddenPresentation( $ps_ID=NULL ) {
		return new InputHiddenElement( array( "name"=>$this->GetNameWithID( $ps_ID ), "value"=>$this->GetValue() ) );
	}
	/* -------------------- end definitions "abstract" methods -------------------- */

}
?>
