<?

include_once( dirname(__FILE__) . "/class.SetOfRowsData.php" );
include_once( dirname(__FILE__) . "/class.LinkDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.PagedInfoTable.php" );
include_once( dirname(__FILE__) . "/../html/class.PagedInputForm.php" );
include_once( dirname(__FILE__) . "/../../module.Genlib.php" );

class PagedSetOfRowsData extends SetOfRowsData  {
	
	var $mo_DataSource;
	var $mi_Start;
	var $mi_Step;
	var $mi_Total;
	var $ms_CookiePrefix;
	
	function PagedSetOfRowsData( $pm_DataSource, $ps_CookiePrefix=NULL ){
		$this->SetOfRowsData();
		$this->mo_DataSource = new LinkDataField("");
		$this->SetDataSource($pm_DataSource);
		$this->mi_Step=10;
		$this->mi_Start=0;
		$this->mi_Total=0;
		$this->SetCookiePrefix( $ps_CookiePrefix );
	}

	function SetCookiePrefix( $ps_CookiePrefix ) {
		$this->ms_CookiePrefix = $ps_CookiePrefix;
	}

	function GetCookiePrefix() {
		return $this->ms_CookiePrefix;
	}
	
	function &SetDataSource($pm_DataSource){
		$lo_DataSource=&$this->mo_DataSource;
		if(is_object($pm_DataSource)){
			$this->mo_DataSource=$pm_DataSource;
		}elseif(is_string($pm_DataSource)){
			$lo_DataSource->SetLink($pm_DataSource);
		}
		return $this->mo_DataSource;
	}
	
	function &GetDataSource(){
		return $this->mo_DataSource;
	}
	
	function GetStart(){
		return $this->mi_Start;	
	}
	function SetStart($pi_Start){
		if(is_numeric($pi_Start)){
			$this->mi_Start = $pi_Start;	
		}	
		return $this->mi_Start;
	}
	
	function GetTotal(){
		$this->mi_Total;	
	}
	function SetTotal($pi_Total){
		if(is_numeric($pi_Total)){
			$this->mi_Total = $pi_Total;	
		}	
		return $this->mi_Total;
	}
	
	function GetStep(){
		return $this->mi_Step;	
	}
	function SetStep($pi_Step){
		$this->mi_Step = $pi_Step;	
		return $this->mi_Step;
	}

	function SetDefault() {
		$ls_Prefix = $this->GetCookiePrefix();
		$ls_Step = ff_GetFromPostGet( "step" );
		if( strlen($ls_Step) )
			$ls_Step = (int)$ls_Step;
		else {
			if( array_key_exists( $ls_Prefix . "_ItemsPerPage", $_COOKIE ) )
				$ls_Step = (int)$_COOKIE[$ls_Prefix . "_ItemsPerPage"];
		}
		if( $ls_Step <= 0 )
			$ls_Step = 10;
		if ( !headers_sent() )
			setcookie( $ls_Prefix . "_ItemsPerPage", $ls_Step, time()+3600*24*365, "/" );
		$this->SetStep( $ls_Step );
		$ls_Start = (int)ff_GetFromPostGet("start");
		if( strlen(ff_GetFromPostGet("next")) )
			$ls_Start += $ls_Step;
		elseif( strlen(ff_GetFromPostGet("prev")) )
			$ls_Start -= $ls_Step;
		if( $ls_Start < 0 )
			$ls_Start = 0;
		$this->SetStart( $ls_Start );
	}
	
//--------------- Presentation -----------------------------------------------------------
	
	function GetOutputPresentation( $pm_Title, $pm_NoData=NULL ) {
		
		global $DEBUG;
		
		if( !is_null($pm_NoData) && !$this->GetHasData() )
			return is_object( $pm_NoData ) ? $pm_NoData : new HTMLElement( $pm_NoData );
		
		$lo_Result = new PagedInfoTable( $pm_Title, $this->mo_DataSource->GetHREF());

		foreach( $this->GetRows() as $lo_Row ) {
			
			$lo_Result->AppendRow( array(), $lo_Row->GetHeader() );
			foreach( $lo_Row->GetFields() as $lo_Field ) {
				$la_Attributes = $lo_Field->GetColSpan()==1 ? array() : array( "colspan"=>$lo_Field->GetColSpan() );
				$la_Attributes = array_merge($la_Attributes,$lo_Field->GetParentAttributes());
				if( $lo_Row->GetSpecial() ){
					$la_Attributes["class"] = "spaciallistitem";
				}	
				$lo_Result->AppendCell( $la_Attributes, $lo_Field->GetOutputPresentation() );
			}
		}
		
		$loPagedTable =& $lo_Result->GetPagedTable();
		$loPagedTable->SetParams($this->mi_Start,$this->mi_Step,$this->mi_Total);
		
		return $lo_Result;
	}

	function GetInputPresentation( $pa_FormAttributes, $pm_Title, $pm_NoData=NULL, $ps_FormFlags=cc_IncludeForm ) {
		if( !is_null($pm_NoData) && !$this->GetHasData() )
			return is_object( $pm_NoData ) ? $pm_NoData : new HTMLElement( $pm_NoData );
		
		$lo_Result = new PagedInputForm( $pa_FormAttributes, $pm_Title, $ps_FormFlags );
		
		foreach( $this->GetRows() as $lo_Row ) {
			$lo_Result->AppendRow( array(), $lo_Row->GetHeader() );
			foreach( $lo_Row->GetFields() as $lo_Field ) {
				$la_Attributes = $lo_Field->GetColSpan()==1 ? array() : array( "colspan"=>$lo_Field->GetColSpan() );
				$la_Attributes = array_merge( $la_Attributes, $lo_Field->GetParentAttributes() );
				if( $lo_Row->GetSpecial() )
					$la_Attributes["class"] = "spaciallistitem";
				$lo_Result->AppendCell( $la_Attributes, $lo_Field->GetInputPresentation($lo_Row->GetID()) );
			}
		}

		$loPagedTable =& $lo_Result->GetPagedTable();
		$loPagedTable->SetParams($this->mi_Start,$this->mi_Step,$this->mi_Total);
		
		foreach( $this->GetButtons() as $lo_Button )
			$lo_Result->AppendButton( $lo_Button->GetInputPresentation() );
		foreach( $this->GetHidden() as $lo_Hidden )
			$lo_Result->AppendHidden( $lo_Hidden->GetHiddenPresentation() );
		return $lo_Result;
	}
	
	// foreach( $this->GetButtons() as $lo_Button )
	// $lo_Result->AppendButton( $lo_Button->GetInputPresentation() );
	// foreach( $this->GetHidden() as $lo_Hidden )
	// $lo_Result->AppendHidden( $lo_Hidden->GetHiddenPresentation() );
	// return $lo_Result;

	function GetHiddenPresentation() {
		$lo_Result = new CompoundElement();
		foreach( $this->GetRows() as $lo_Row )
			foreach( $lo_Row->GetFields() as $lo_Field )
				$lo_Result->AppendToContent( $lo_Field->GetHiddenPresentation() );
		foreach( $this->GetHidden() as $lo_Hidden )
			$lo_Result->AppendHidden( $lo_Hidden->GetHiddenPresentation() );
		
		$lo_Result->AppendHidden(	new InputHiddenElement( array( "name"=>"start","value"=>$this->mi_Start)));
		$lo_Result->AppendHidden(	new InputHiddenElement( array( "name"=>"step","value"=>$this->mi_Step)));
		$lo_Result->AppendHidden(	new InputHiddenElement( array( "name"=>"total","value"=>$this->mi_Total)));
		
		return $lo_Result;
	}	
	
//----------------- End Presetnation ------------------------------------------------------	
}
?>
