<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.OneValueDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.InputHiddenElement.php" );
include_once( dirname(__FILE__) . "/../html/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/../html/class.InputRadioElement.php" );
include_once( dirname(__FILE__) . "/../html/class.HTMLElement.php" );





class ServiceDataField extends OneValueDataField {

	/* -------------------- Members -------------------- */
	var $ms_BoldNo; // if "no" text should be bold
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function ServiceDataField( $ps_Value, $ps_Name, $ps_BoldNo=FALSE ) {
		$this->OneValueDataField( $ps_Value, $ps_Name );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Get.../Set... -------------------- */
	function SetBoldNo( $ps_BoldNo ) {
		$this->ms_BoldNo = $ps_BoldNo;
	}

	function GetBoldNo() {
		return $this->ms_BoldNo;
	}
	/* -------------------- end Get.../Set... -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetInputPresentation( $ps_ID=NULL ) {
		$lo_Result = new CompoundElement();
		$ls_Value = $this->GetValue();
		$la_Attributes = $this->GetAttributes( $ps_ID );
		$la_Attributes["value"] = "1";
		if( $ls_Value )
			$la_Attributes["checked"] = NULL;
		$lo_Result->AppendToContent( new InputRadioElement( $la_Attributes ), ltext("g_yes") );
		$la_Attributes = $this->GetAttributes( $ps_ID );
		$la_Attributes["value"] = "0";
		if( !$ls_Value )
			$la_Attributes["checked"] = NULL;
		if( $this->GetBoldNo() )
			$lo_Result->AppendToContent( new InputRadioElement( $la_Attributes ), "<b>".ltext("g_no")."!</b>" );
		else
			$lo_Result->AppendToContent( new InputRadioElement( $la_Attributes ), ltext("g_no") );
		return $lo_Result;
	}

	function GetOutputPresentation() {
		return new HTMLElement( ltext( $this->GetValue() ? "ldf_activated" : "ldf_deactivated" ) );
	}

	function GetHiddenPresentation( $ps_ID=NULL ) {
		return new InputHiddenElement( array( "name"=>$this->GetNameWithID( $ps_ID ), "value"=>$this->GetValue() ) );
	}
	/* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
