<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.HTMLDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.SortElement.php" );
include_once( dirname(__FILE__) . "/../html/class.HTMLElement.php" );





class SortDataField extends DataField {

	/* -------------------- Members -------------------- */
	var $ms_HREF; // href for this data field
	var $ms_Current; // if list is sorted by this column currently
	var $ms_Reverse; // if sort order is reverse
	var $mo_Inner; // element inside of link
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function SortDataField( $pm_Inner, $ps_HREF, $ps_Current, $ps_Reverse ) {
		$this->DataField();
		$this->SetInner( $pm_Inner );
		$this->SetHREF( $ps_HREF );
		$this->SetCurrent( $ps_Current );
		$this->SetReverse( $ps_Reverse );
		$this->SetParentAttributes( array( "nowrap"=>NULL ) );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetInner( $pm_Inner ) {
		$this->mo_Inner = is_object($pm_Inner) ? $pm_Inner : new HTMLDataField( $pm_Inner );
	}

	function &GetInner() {
		return $this->mo_Inner;
	}

	function SetHREF( $ps_HREF ) {
		$this->ms_HREF = $ps_HREF;
	}

	function GetHREF() {
		return $this->ms_HREF;
	}

	function SetCurrent( $ps_Current ) {
		$this->ms_Current = $ps_Current;
	}

	function GetCurrent() {
		return $this->ms_Current;
	}

	function SetReverse( $ps_Reverse ) {
		$this->ms_Reverse = $ps_Reverse;
	}

	function GetReverse() {
		return $this->ms_Reverse;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function SetFromArray( $pa_Data ) {
		$lo_Inner =& $this->GetInner();
		$lo_Inner->SetFromArray( $pa_Data );
	}

	function GetInputPresentation() {
		$lo_Inner = $this->GetInner();
		return new SortElement( $lo_Inner->GetInputPresentation(), $this->GetHREF(), $this->GetCurrent(),
				$this->GetReverse() );
	}

	function GetOutputPresentation() {
		$lo_Inner = $this->GetInner();
		return new SortElement( $lo_Inner->GetOutputPresentation(), $this->GetHREF(), $this->GetCurrent(),
				$this->GetReverse() );
	}

	function GetHiddenPresentation() {
		return new HTMLElement( "" );
	}
	/* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
