<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.FormElement.php" );
include_once( dirname(__FILE__) . "/class.FieldsetElement.php" );
include_once( dirname(__FILE__) . "/class.LegendElement.php" );
include_once( dirname(__FILE__) . "/class.TableElement.php" );
include_once( dirname(__FILE__) . "/class.PathElement.php" );
include_once( dirname(__FILE__) . "/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/class.PElement.php" );





class FileTree extends FormElement {

	/* -------------------- Members -------------------- */
	var $ms_CurrentHeader; // if current row is a header row
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function FileTree( $pa_FormAttributes, $pm_Title, $ps_URL, $ps_Parameter, $ps_Path ) {
		$lo_Legend = new LegendElement( array(), $pm_Title );
		$lo_Path = new PathElement( $ps_URL, $ps_Parameter, $ps_Path );
		$lo_Table = new TableElement( array( "class"=>"FileTreeTable" ) );
		$lo_ButtonsArea = new PElement( array( "class"=>"ButtonsArea" ) );
		$lo_Help = new CompoundElement();
		$this->FormElement( $pa_FormAttributes, new FieldsetElement( array(), $lo_Legend, $lo_Path, $lo_Table,
					$lo_ButtonsArea, $lo_Help ) );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods for internal use only -------------------- */
	function &GetFieldset() {
		return $this->GetContent(0);
	}

	function &GetTable() {
		$lo_Fieldset =& $this->GetFieldset();
		return $lo_Fieldset->GetContent(2);
	}

	function &GetButtonsArea() {
		$lo_Fieldset =& $this->GetFieldset();
		return $lo_Fieldset->GetContent(3);
	}

	function &GetHelp() {
		$lo_Fieldset =& $this->GetFieldset();
		return $lo_Fieldset->GetContent(4);
	}
	/* -------------------- end methods for internal use only -------------------- */





	/* -------------------- add cells/rows to table -------------------- */
	function AppendRow( $pa_Attributes, $ps_Header = FALSE ) {
		$this->ms_CurrentHeader = $ps_Header;
		$lo_Table =& $this->GetTable();
		$lo_Table->AppendRow( $pa_Attributes );
	}

	function AppendCell( $pa_Attributes ) {
		$lo_Table =& $this->GetTable();
		$lo_Row =& $lo_Table->GetContent( cc_LastElement );
		$la_Arguments = func_get_args();
		array_splice( $la_Arguments, 1, 0, $this->ms_CurrentHeader );
		call_user_func_array( array( &$lo_Row, "AppendCell" ), $la_Arguments );
	}
	/* -------------------- end add cells/rows to table -------------------- */





	/* -------------------- add help -------------------- */
	function AppendHelp( $pm_Help ) {
		$lo_Help =& $this->GetHelp();
		foreach( func_get_args() as $lm_ToAdd )
			$lo_Help->AppendToContent( new PElement( array(), $lm_ToAdd ) );
	}
	/* -------------------- end add help -------------------- */





	/* -------------------- add buttons -------------------- */
	function AppendButton( $po_Button ) {
		$lo_ButtonsArea =& $this->GetButtonsArea();
		$lo_ButtonsArea->AppendToContent( $po_Button );
	}
	/* -------------------- end add buttons -------------------- */





	/* -------------------- add hidden fields -------------------- */
	function AppendHidden( $po_First ) {
		$la_Arguments = func_get_args();
		call_user_func_array( array( &$this, "AppendToContent" ), $la_Arguments );
	}
	/* -------------------- end add hidden fields -------------------- */

}
?>
