<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.FieldsetElement.php" );
include_once( dirname(__FILE__) . "/class.LegendElement.php" );
include_once( dirname(__FILE__) . "/class.PagedTableElement.php" );
include_once( dirname(__FILE__) . "/class.FormElement.php" );
include_once( dirname(__FILE__) . "/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/class.PElement.php" );





define( "cc_IncludeForm", 1 );





class PagedInputForm extends CompoundElement {

	/* -------------------- Members -------------------- */
	var $ms_CurrentHeader; // current row is a header
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function PagedInputForm( $pa_FormAttributes, $pm_Title, $ps_Flags=cc_IncludeForm ) {
		$lo_Legend = new LegendElement( array(), $pm_Title );
		$lo_Table = new PagedTableElement( "", $pa_FormAttributes, array( "class"=>"InfoTable" ) );
		$lo_ButtonsArea = new PElement( array( "class"=>"ButtonsArea" ) );
		$lo_Form = new PElement( array(), $lo_Table, $lo_ButtonsArea ); // the form is inside of PagedTableElement
		$lo_Help = new CompoundElement();
		$lo_Fieldset = new FieldsetElement( array(), $lo_Legend, $lo_Form, $lo_Help );
		$this->CompoundElement( $lo_Fieldset );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods for internal use only -------------------- */
	function &GetForm() {
		$lo_Fieldset =& $this->GetContent(0);
		return $lo_Fieldset->GetContent(1);
	}

	function &GetTable() {
		$loTable =& $this->GetPagedTable();
		return $loTable->GetTable();
	}
	
	function &GetPagedTable() {
		$lo_Form =& $this->GetForm();
		return $lo_Form->GetContent(0);
	}

	function &GetHelp() {
		$lo_Fieldset =& $this->GetContent(0);
		return $lo_Fieldset->GetContent(2);
	}

	function &GetTop() {
		$lo_Fieldset =& $this->GetContent(0);
		return $lo_Fieldset->GetContent(0);
	}

	function &GetButtonsArea() {
		$lo_Form =& $this->GetForm();
		return $lo_Form->GetContent(1);
	}
	/* -------------------- end methods for internal use only -------------------- */





	/* -------------------- SetNeedSearch -------------------- */
	function SetNeedSearch ( $ps_Need ) {
		$lo_Table =& $this->GetPagedTable();
		$lo_Table->SetNeedSearch( $ps_Need );
	}
	/* -------------------- end SetNeedSearch -------------------- */





	/* -------------------- add rows & cells -------------------- */
	function AppendRow( $pa_Attributes, $ps_Header = FALSE ) {
		$this->ms_CurrentHeader = $ps_Header;
		$lo_Table =& $this->GetTable();
		$la_Attributes = array_merge( $pa_Attributes, array( "class"=>"datacell" ) );
		$lo_Table->AppendRow( $la_Attributes );
	}

	function AppendCell( $pa_Attributes ) {
		$lo_Table =& $this->GetTable();
		$lo_Row =& $lo_Table->GetContent( $lo_Table->CountContent() - 1 );
		$la_Arguments = func_get_args();
		array_splice( $la_Arguments, 1, 0, $this->ms_CurrentHeader );
		if( !$lo_Row->CountContent() )
			$la_Arguments[0]["class"] = "datalabel";
		call_user_func_array( array( &$lo_Row, "AppendCell" ), $la_Arguments );
	}
	/* -------------------- end add rows & cells -------------------- */





	/* -------------------- add buttons -------------------- */
	function AppendButton( $po_Button ) {
		$lo_ButtonsArea =& $this->GetButtonsArea();
		$lo_ButtonsArea->AppendToContent( $po_Button );
	}
	/* -------------------- end add buttons -------------------- */





	/* -------------------- add hidden fields -------------------- */
	function AppendHidden( $po_First ) {
		$la_Arguments = func_get_args();
		$lo_Table =& $this->GetPagedTable();
		$lo_Form =& $lo_Table->GetMainForm();
		call_user_func_array( array( &$lo_Form, "AppendToContent" ), $la_Arguments );
	}
	/* -------------------- end add hidden fields -------------------- */





	/* -------------------- add help -------------------- */
	function AppendHelp( $pm_Text ) {
		$lo_Help =& $this->GetHelp();
		foreach( func_get_args() as $lm_Text )
			$lo_Help->AppendToContent( new PElement( array(), is_object($lm_Text) ? $lm_Text :
						new HTMLElement( $lm_Text ) ) );
	}
	/* -------------------- end add help -------------------- */
	




	/* -------------------- add to top -------------------- */
	function AppendTop( $pm_Text ) {
		$lo_Top =& $this->GetTop();
		$lo_Top->AppendToContent( new PElement( array(), $pm_Text ) );
	}
	/* -------------------- end add to top -------------------- */





	/* -------------------- SetWidths -------------------- */
	function SetWidths( $ps_First ){
		$lo_Table =& $this->GetTable();
		$lo_Row =& $lo_Table->GetContent(0);
		if( is_object($lo_Row) ) {
			$la_Widths = func_get_args();
			$la_Cells =& $lo_Row->GetContent();
			for ( $i=0; $i<count($la_Widths) && $i<count($la_Cells); $i++ )
				$la_Cells[$i]->AppendAttributes( array( "width"=>$la_Widths[$i] ) );
		}
	}
	/* -------------------- end SetWidths -------------------- */

}
?>
